/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.TrackingPageIsCorruptedException;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.GridUnsafe;
import org.jetbrains.annotations.Nullable;

public class TrackingPageIO
extends PageIO {
    public static final IOVersions<TrackingPageIO> VERSIONS = new IOVersions((PageIO[])new TrackingPageIO[]{new TrackingPageIO(1)});
    public static final long CORRUPT_FLAG_MASK = Long.MIN_VALUE;
    public static final long CORRUPT_FLAG_FILTER_MASK = Long.MAX_VALUE;
    public static final int LAST_SNAPSHOT_TAG_OFFSET = 40;
    public static final int SIZE_FIELD_OFFSET = 48;
    public static final int SIZE_FIELD_SIZE = 2;
    public static final int BITMAP_OFFSET = 50;
    public static final int COUNT_OF_EXTRA_PAGE = 1;

    protected TrackingPageIO(int ver) {
        super(15, ver);
    }

    public long markChanged(ByteBuffer buf, long pageId, long nextSnapshotTag, long lastSuccessfulSnapshotTag, int pageSize) {
        int updateTemplate;
        byte newVal;
        long tag = this.validateSnapshotTag(buf, nextSnapshotTag, lastSuccessfulSnapshotTag, pageSize);
        int cntOfPage = this.countOfPageToTrack(pageSize);
        int idxToUpdate = (PageIdUtils.pageIndex(pageId) - 1) % cntOfPage;
        int sizeOff = this.useLeftHalf(nextSnapshotTag) ? 48 : 50 + (cntOfPage >> 3);
        int idx = sizeOff + 2 + (idxToUpdate >> 3);
        byte byteToUpdate = buf.get(idx);
        if (byteToUpdate == (newVal = (byte)(byteToUpdate | (updateTemplate = 1 << (idxToUpdate & 7))))) {
            return tag;
        }
        buf.put(idx, newVal);
        short newSize = (short)(buf.getShort(sizeOff) + 1);
        buf.putShort(sizeOff, newSize);
        assert (newSize == this.countOfChangedPage(buf, nextSnapshotTag, pageSize));
        return tag;
    }

    private long validateSnapshotTag(ByteBuffer buf, long nextSnapshotTag, long lastSuccessfulSnapshotTag, int pageSize) {
        assert (nextSnapshotTag != lastSuccessfulSnapshotTag) : "nextSnapshotTag = " + nextSnapshotTag + ", lastSuccessfulSnapshotId = " + lastSuccessfulSnapshotTag;
        long last2 = this.getLastSnapshotTag(buf);
        if (last2 > nextSnapshotTag) {
            PageHandler.zeroMemory(buf, 40, buf.capacity() - 40);
            this.setLastSnasphotTag(buf, nextSnapshotTag | Long.MIN_VALUE);
            return last2;
        }
        if (nextSnapshotTag == last2) {
            return -1L;
        }
        int cntOfPage = this.countOfPageToTrack(pageSize);
        if (last2 <= lastSuccessfulSnapshotTag) {
            this.setLastSnasphotTag(buf, nextSnapshotTag);
            PageHandler.zeroMemory(buf, 48, buf.capacity() - 48);
        } else {
            int sizeOff2;
            int len = cntOfPage >> 3;
            int sizeOff = this.useLeftHalf(nextSnapshotTag) ? 48 : 50 + len;
            int n = sizeOff2 = !this.useLeftHalf(nextSnapshotTag) ? 48 : 50 + len;
            if (last2 - lastSuccessfulSnapshotTag == 1L) {
                if ((nextSnapshotTag - last2) % 2L == 0L) {
                    PageHandler.copyMemory(buf, (long)sizeOff, buf, (long)sizeOff2, (long)(len + 2));
                }
            } else {
                int i;
                int newSize = 0;
                for (i = 0; i < len - 8; i += 8) {
                    long newVal = buf.getLong(sizeOff + 2 + i) | buf.getLong(sizeOff2 + 2 + i);
                    newSize += Long.bitCount(newVal);
                    buf.putLong(sizeOff2 + 2 + i, newVal);
                }
                while (i < len) {
                    byte newVal = (byte)(buf.get(sizeOff + 2 + i) | buf.get(sizeOff2 + 2 + i));
                    newSize += Integer.bitCount(newVal & 0xFF);
                    buf.put(sizeOff2 + 2 + i, newVal);
                    ++i;
                }
                buf.putShort(sizeOff2, (short)newSize);
            }
            this.setLastSnasphotTag(buf, nextSnapshotTag);
            PageHandler.zeroMemory(buf, sizeOff, len + 2);
        }
        return -1L;
    }

    private void setLastSnasphotTag(ByteBuffer buf, long nextSnapshotTag) {
        if (this.isCorrupted(buf)) {
            nextSnapshotTag |= Long.MIN_VALUE;
        }
        buf.putLong(40, nextSnapshotTag);
    }

    private void setLastSnasphotTag0(ByteBuffer buf, long nextSnapshotTag) {
        buf.putLong(40, nextSnapshotTag);
    }

    private void setLastSnasphotTag0(long addr, long nextSnapshotTag) {
        GridUnsafe.putLong(addr + 40L, nextSnapshotTag);
    }

    private long getLastSnapshotTag(ByteBuffer buf) {
        return this.getLastSnapshotTag0(buf) & Long.MAX_VALUE;
    }

    private long getLastSnapshotTag0(ByteBuffer buf) {
        return buf.getLong(40);
    }

    private long getLastSnapshotTag(long addr) {
        return this.getLastSnapshotTag0(addr) & Long.MAX_VALUE;
    }

    private long getLastSnapshotTag0(long addr) {
        return GridUnsafe.getLong(addr + 40L);
    }

    public boolean isCorrupted(ByteBuffer buf) {
        return this.getLastSnapshotTag0(buf) < 0L;
    }

    public void resetCorruptFlag(ByteBuffer buf) {
        this.setLastSnasphotTag0(buf, this.getLastSnapshotTag(buf));
    }

    public void resetCorruptFlag(long addr) {
        this.setLastSnasphotTag0(addr, this.getLastSnapshotTag(addr));
    }

    public boolean wasChanged(ByteBuffer buf, long pageId, long curSnapshotTag, long lastSuccessfulSnapshotTag, int pageSize) throws TrackingPageIsCorruptedException {
        if (this.isCorrupted(buf)) {
            throw TrackingPageIsCorruptedException.INSTANCE;
        }
        long lastTag = this.validateSnapshotTag(buf, curSnapshotTag + 1L, lastSuccessfulSnapshotTag, pageSize);
        if (lastTag >= 0L) {
            throw new TrackingPageIsCorruptedException(lastTag, curSnapshotTag);
        }
        if (this.countOfChangedPage(buf, curSnapshotTag, pageSize) < 1) {
            return false;
        }
        int cntOfPage = this.countOfPageToTrack(pageSize);
        int idxToTest = (PageIdUtils.pageIndex(pageId) - 1) % cntOfPage;
        byte byteToTest = this.useLeftHalf(curSnapshotTag) ? buf.get(50 + (idxToTest >> 3)) : buf.get(52 + (idxToTest + cntOfPage >> 3));
        int testTemplate = 1 << (idxToTest & 7);
        return (byteToTest & testTemplate ^ testTemplate) == 0;
    }

    public short countOfChangedPage(ByteBuffer buf, long snapshotTag, int pageSize) {
        long dif = this.getLastSnapshotTag(buf) - snapshotTag;
        if (dif != 0L && dif != 1L) {
            return -1;
        }
        if (this.useLeftHalf(snapshotTag)) {
            return buf.getShort(48);
        }
        return buf.getShort(50 + (this.countOfPageToTrack(pageSize) >> 3));
    }

    private boolean useLeftHalf(long snapshotTag) {
        return (snapshotTag & 1L) == 0L;
    }

    public long trackingPageFor(long pageId, int pageSize) {
        assert (PageIdUtils.pageIndex(pageId) > 0);
        int pageIdx = (PageIdUtils.pageIndex(pageId) - 1) / this.countOfPageToTrack(pageSize) * this.countOfPageToTrack(pageSize) + 1;
        long trackingPageId = PageIdUtils.pageId(PageIdUtils.partId(pageId), PageIdUtils.flag(pageId), pageIdx);
        assert (PageIdUtils.pageIndex(trackingPageId) <= PageIdUtils.pageIndex(pageId));
        return trackingPageId;
    }

    public int countOfPageToTrack(int pageSize) {
        return (pageSize - 48) / 2 - 2 << 3;
    }

    @Nullable
    public Long findNextChangedPage(ByteBuffer buf, long start, long curSnapshotTag, long lastSuccessfulSnapshotTag, int pageSize) throws TrackingPageIsCorruptedException {
        int startIdx;
        if (this.isCorrupted(buf)) {
            throw TrackingPageIsCorruptedException.INSTANCE;
        }
        long lastTag = this.validateSnapshotTag(buf, curSnapshotTag + 1L, lastSuccessfulSnapshotTag, pageSize);
        if (lastTag >= 0L) {
            throw new TrackingPageIsCorruptedException(lastTag, curSnapshotTag);
        }
        int cntOfPage = this.countOfPageToTrack(pageSize);
        long trackingPage = this.trackingPageFor(start, pageSize);
        if (start == trackingPage) {
            return trackingPage;
        }
        if (this.countOfChangedPage(buf, curSnapshotTag, pageSize) <= 0) {
            return null;
        }
        int idxToStartTest = (PageIdUtils.pageIndex(start) - 1) % cntOfPage;
        int zeroIdx = this.useLeftHalf(curSnapshotTag) ? 50 : 52 + (cntOfPage >> 3);
        int stopIdx = zeroIdx + (cntOfPage >> 3);
        for (int idx = startIdx = zeroIdx + (idxToStartTest >> 3); idx < stopIdx; ++idx) {
            int foundSetBit;
            byte byteToTest = buf.get(idx);
            if (byteToTest == 0 || (foundSetBit = TrackingPageIO.foundSetBit(byteToTest, idx == startIdx ? idxToStartTest & 7 : 0)) == -1) continue;
            long foundPageId = PageIdUtils.pageId(PageIdUtils.partId(start), PageIdUtils.flag(start), PageIdUtils.pageIndex(trackingPage) + (idx - zeroIdx << 3) + foundSetBit);
            assert (this.wasChanged(buf, foundPageId, curSnapshotTag, lastSuccessfulSnapshotTag, pageSize));
            assert (this.trackingPageFor(foundPageId, pageSize) == trackingPage);
            return foundPageId;
        }
        return null;
    }

    private static int foundSetBit(byte byteToTest, int firstBitToTest) {
        assert (firstBitToTest < 8);
        for (int i = firstBitToTest; i < 8; ++i) {
            int testTemplate = 1 << i;
            if ((byteToTest & testTemplate ^ testTemplate) != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void printPage(long addr, int pageSize, GridStringBuilder sb) throws IgniteCheckedException {
        int i;
        sb.a("TrackingPage [\n\tlastSnapshotTag=").a(this.getLastSnapshotTag(addr)).a(",\n\tleftHalf={").a("\n\t\tsize=").a(GridUnsafe.getShort(addr + 48L)).a("\n\t\tdata={");
        for (i = 0; i < this.countOfPageToTrack(pageSize) >> 3; i += 2) {
            sb.appendHex(GridUnsafe.getShort(addr + 50L + (long)i));
        }
        sb.a("}\n\t},\n\trightHalf={").a("\n\t\tsize=").a(GridUnsafe.getShort(addr + 50L + (long)(this.countOfPageToTrack(pageSize) >> 3))).a("\n\t\tdata={");
        for (i = 0; i < this.countOfPageToTrack(pageSize) >> 3; i += 2) {
            sb.appendHex(GridUnsafe.getShort(addr + 50L + (long)(this.countOfPageToTrack(pageSize) >> 3) + 2L + (long)i));
        }
        sb.a("}\n\t}\n]");
    }
}

