/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageDataRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridStringBuilder;

public class SimpleDataPageIO
extends AbstractDataPageIO<MetastorageDataRow> {
    public static final IOVersions<SimpleDataPageIO> VERSIONS = new IOVersions((PageIO[])new SimpleDataPageIO[]{new SimpleDataPageIO(1)});

    public SimpleDataPageIO(int ver) {
        super(21, ver);
    }

    @Override
    protected void writeFragmentData(MetastorageDataRow row, ByteBuffer buf, int rowOff, int payloadSize) throws IgniteCheckedException {
        int written = this.writeSizeFragment(row, buf, rowOff, payloadSize);
        if (payloadSize == written) {
            return;
        }
        int start = rowOff > 4 ? rowOff - 4 : 0;
        int len = Math.min(row.value().length - start, payloadSize - written);
        if (len > 0) {
            buf.put(row.value(), start, len);
            written += len;
        }
        assert (written == payloadSize);
    }

    private int writeSizeFragment(MetastorageDataRow row, ByteBuffer buf, int rowOff, int payloadSize) {
        int size2 = 4;
        if (rowOff >= 4) {
            return 0;
        }
        if (rowOff == 0 && payloadSize >= 4) {
            buf.putInt(row.value().length);
            return 4;
        }
        ByteBuffer buf2 = ByteBuffer.allocate(4);
        buf2.order(buf.order());
        buf2.putInt(row.value().length);
        int len = Math.min(4 - rowOff, payloadSize);
        buf.put(buf2.array(), rowOff, len);
        return len;
    }

    @Override
    protected void writeRowData(long pageAddr, int dataOff, int payloadSize, MetastorageDataRow row, boolean newRow) throws IgniteCheckedException {
        long addr = pageAddr + (long)dataOff;
        if (newRow) {
            PageUtils.putShort(addr, 0, (short)payloadSize);
        }
        PageUtils.putInt(addr, 2, row.value().length);
        PageUtils.putBytes(addr, 6, row.value());
    }

    public static byte[] readPayload(long link) {
        int size2 = PageUtils.getInt(link, 0);
        return PageUtils.getBytes(link, 4, size2);
    }

    @Override
    protected void printPage(long addr, int pageSize, GridStringBuilder sb) throws IgniteCheckedException {
        sb.a("SimpleDataPageIO [\n");
        this.printPageLayout(addr, pageSize, sb);
        sb.a("\n]");
    }
}

