/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridStringBuilder;

public class BPlusMetaIO
extends PageIO {
    public static final IOVersions<BPlusMetaIO> VERSIONS = new IOVersions((PageIO[])new BPlusMetaIO[]{new BPlusMetaIO(1), new BPlusMetaIO(2)});
    private static final int LVLS_OFF = 40;
    private final int refsOff;
    private final int inlineSizeOff;

    private BPlusMetaIO(int ver) {
        super(2, ver);
        switch (ver) {
            case 1: {
                this.inlineSizeOff = -1;
                this.refsOff = 41;
                break;
            }
            case 2: {
                this.inlineSizeOff = 41;
                this.refsOff = this.inlineSizeOff + 2;
                break;
            }
            default: {
                throw new IgniteException("invalid IO version: " + ver);
            }
        }
    }

    public void initRoot(long pageAdrr, long rootId, int pageSize) {
        this.setLevelsCount(pageAdrr, 1, pageSize);
        this.setFirstPageId(pageAdrr, 0, rootId);
    }

    public int getLevelsCount(long pageAddr) {
        return Byte.toUnsignedInt(PageUtils.getByte(pageAddr, 40));
    }

    private int getMaxLevels(long pageAddr, int pageSize) {
        return (pageSize - this.refsOff) / 8;
    }

    private void setLevelsCount(long pageAddr, int lvls, int pageSize) {
        assert (lvls >= 0 && lvls <= this.getMaxLevels(pageAddr, pageSize)) : lvls;
        PageUtils.putByte(pageAddr, 40, (byte)lvls);
        assert (this.getLevelsCount(pageAddr) == lvls);
    }

    private int offset(int lvl) {
        return lvl * 8 + this.refsOff;
    }

    public long getFirstPageId(long pageAddr, int lvl) {
        return PageUtils.getLong(pageAddr, this.offset(lvl));
    }

    private void setFirstPageId(long pageAddr, int lvl, long pageId) {
        assert (lvl >= 0 && lvl < this.getLevelsCount(pageAddr)) : lvl;
        PageUtils.putLong(pageAddr, this.offset(lvl), pageId);
        assert (this.getFirstPageId(pageAddr, lvl) == pageId);
    }

    public int getRootLevel(long pageAddr) {
        int lvls = this.getLevelsCount(pageAddr);
        assert (lvls > 0) : lvls;
        return lvls - 1;
    }

    public void addRoot(long pageAddr, long rootPageId, int pageSize) {
        int lvl = this.getLevelsCount(pageAddr);
        this.setLevelsCount(pageAddr, lvl + 1, pageSize);
        this.setFirstPageId(pageAddr, lvl, rootPageId);
    }

    public void cutRoot(long pageAddr, int pageSize) {
        int lvl = this.getRootLevel(pageAddr);
        this.setLevelsCount(pageAddr, lvl, pageSize);
    }

    public void setInlineSize(long pageAddr, int size2) {
        if (this.getVersion() > 1) {
            PageUtils.putShort(pageAddr, this.inlineSizeOff, (short)size2);
        }
    }

    public int getInlineSize(long pageAddr) {
        return this.getVersion() > 1 ? (int)PageUtils.getShort(pageAddr, this.inlineSizeOff) : 0;
    }

    @Override
    protected void printPage(long addr, int pageSize, GridStringBuilder sb) throws IgniteCheckedException {
        sb.a("BPlusMeta [\n\tlevelsCnt=").a(this.getLevelsCount(addr)).a(",\n\trootLvl=").a(this.getRootLevel(addr)).a(",\n\tinlineSize=").a(this.getInlineSize(addr)).a("\n]");
    }
}

