/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.partstate;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PagesAllocationRange;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartitionAllocationMap {
    @GridToStringInclude
    private final Map<GroupPartitionId, PagesAllocationRange> writeMap = new ConcurrentHashMap<GroupPartitionId, PagesAllocationRange>();
    @GridToStringInclude
    private NavigableMap<GroupPartitionId, PagesAllocationRange> readMap;
    @GridToStringInclude
    private final Set<GroupPartitionId> skippedParts = new GridConcurrentHashSet<GroupPartitionId>();

    @Nullable
    public PagesAllocationRange get(GroupPartitionId key) {
        return (PagesAllocationRange)this.readMap.get(key);
    }

    @Nullable
    public PagesAllocationRange get(FullPageId fullPageId) {
        return (PagesAllocationRange)this.readMap.get(PartitionAllocationMap.createCachePartId(fullPageId));
    }

    @NotNull
    public static GroupPartitionId createCachePartId(@NotNull FullPageId fullId) {
        return new GroupPartitionId(fullId.groupId(), PageIdUtils.partId(fullId.pageId()));
    }

    public boolean isEmpty() {
        return this.readMap.isEmpty();
    }

    public int size() {
        return this.readMap.size();
    }

    public Set<GroupPartitionId> keySet() {
        return this.readMap.keySet();
    }

    public Iterable<PagesAllocationRange> values() {
        return this.readMap.values();
    }

    public GroupPartitionId firstKey() {
        return (GroupPartitionId)this.readMap.firstKey();
    }

    public boolean forceSkipIndexPartition(int grpId) {
        return this.skippedParts.add(new GroupPartitionId(grpId, 65535));
    }

    @Nullable
    public GroupPartitionId nextKey(@NotNull GroupPartitionId key) {
        return this.readMap.navigableKeySet().higher(key);
    }

    public Set<Map.Entry<GroupPartitionId, PagesAllocationRange>> entrySet() {
        return this.readMap.entrySet();
    }

    public boolean containsKey(GroupPartitionId key) {
        return this.readMap.containsKey(key);
    }

    public PagesAllocationRange put(GroupPartitionId key, PagesAllocationRange val) {
        return this.writeMap.put(key, val);
    }

    public void prepareForSnapshot() {
        if (this.readMap != null) {
            return;
        }
        this.readMap = new TreeMap<GroupPartitionId, PagesAllocationRange>();
        for (Map.Entry<GroupPartitionId, PagesAllocationRange> entry2 : this.writeMap.entrySet()) {
            if (this.skippedParts.contains(entry2.getKey())) continue;
            this.readMap.put(entry2.getKey(), entry2.getValue());
        }
        this.skippedParts.clear();
        this.writeMap.clear();
    }

    public String toString() {
        return S.toString(PartitionAllocationMap.class, this);
    }
}

