/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointLockStateChecker;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointWriteProgressSupplier;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.IntervalBasedMeasurement;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PagesWriteThrottlePolicy;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PagesWriteSpeedBasedThrottle
implements PagesWriteThrottlePolicy {
    private static final double MAX_DIRTY_PAGES = 0.75;
    private final PageMemoryImpl pageMemory;
    private final CheckpointWriteProgressSupplier cpProgress;
    private static final long STARTING_THROTTLE_NANOS = 4000L;
    private static final double BACKOFF_RATIO = 1.05;
    private static final double MIN_RATIO_NO_THROTTLE = 0.03;
    private final AtomicInteger exponentialBackoffCntr = new AtomicInteger(0);
    private final AtomicInteger lastObservedWritten = new AtomicInteger(0);
    private volatile double initDirtyRatioAtCpBegin = 0.03;
    private volatile double targetDirtyRatio;
    private volatile double currDirtyRatio;
    private final IntervalBasedMeasurement speedCpWrite = new IntervalBasedMeasurement();
    private volatile long speedForMarkAll;
    private final GridConcurrentHashSet<Long> threadIds = new GridConcurrentHashSet();
    private final IntervalBasedMeasurement speedMarkAndAvgParkTime = new IntervalBasedMeasurement(250, 3);
    private long totalPages;
    private CheckpointLockStateChecker cpLockStateChecker;
    private IgniteLogger log;
    private AtomicLong prevWarnTime = new AtomicLong();
    private static final long WARN_MIN_DELAY_NS = TimeUnit.SECONDS.toNanos(10L);
    static final double WARN_THRESHOLD = 0.2;

    public PagesWriteSpeedBasedThrottle(PageMemoryImpl pageMemory, CheckpointWriteProgressSupplier cpProgress, CheckpointLockStateChecker stateChecker, IgniteLogger log2) {
        this.pageMemory = pageMemory;
        this.cpProgress = cpProgress;
        this.totalPages = pageMemory.totalPages();
        this.cpLockStateChecker = stateChecker;
        this.log = log2;
    }

    @Override
    public void onMarkDirty(boolean isPageInCheckpoint) {
        assert (this.cpLockStateChecker.checkpointLockIsHeldByThread());
        AtomicInteger writtenPagesCntr = this.cpProgress.writtenPagesCounter();
        if (writtenPagesCntr == null) {
            this.speedForMarkAll = 0L;
            this.targetDirtyRatio = -1.0;
            this.currDirtyRatio = -1.0;
            return;
        }
        int cpWrittenPages = writtenPagesCntr.get();
        long fullyCompletedPages = (cpWrittenPages + this.cpSyncedPages()) / 2;
        long curNanoTime = System.nanoTime();
        this.speedCpWrite.setCounter(fullyCompletedPages, curNanoTime);
        long markDirtySpeed = this.speedMarkAndAvgParkTime.getSpeedOpsPerSec(curNanoTime);
        long curCpWriteSpeed = this.speedCpWrite.getSpeedOpsPerSec(curNanoTime);
        this.threadIds.add(Thread.currentThread().getId());
        ThrottleMode level = ThrottleMode.NO;
        if (isPageInCheckpoint) {
            int checkpointBufLimit = this.pageMemory.checkpointBufferPagesSize() * 2 / 3;
            if (this.pageMemory.checkpointBufferPagesCount() > checkpointBufLimit) {
                level = ThrottleMode.EXPONENTIAL;
            }
        }
        long throttleParkTimeNs = 0L;
        if (level == ThrottleMode.NO) {
            int nThreads = this.threadIds.size();
            int cpTotalPages = this.cpTotalPages();
            if (cpTotalPages == 0) {
                boolean throttleByCpSpeed;
                boolean bl = throttleByCpSpeed = curCpWriteSpeed > 0L && markDirtySpeed > curCpWriteSpeed;
                if (throttleByCpSpeed) {
                    throttleParkTimeNs = this.calcDelayTime(curCpWriteSpeed, nThreads, 1.0);
                    level = ThrottleMode.LIMITED;
                }
            } else {
                double dirtyPagesRatio;
                this.currDirtyRatio = dirtyPagesRatio = this.pageMemory.getDirtyPagesRatio();
                this.detectCpPagesWriteStart(cpWrittenPages, dirtyPagesRatio);
                if (dirtyPagesRatio >= 0.75) {
                    level = ThrottleMode.NO;
                } else {
                    int notEvictedPagesTotal = cpTotalPages - this.cpEvictedPages();
                    throttleParkTimeNs = this.getParkTime(dirtyPagesRatio, fullyCompletedPages, notEvictedPagesTotal < 0 ? 0 : notEvictedPagesTotal, nThreads, markDirtySpeed, curCpWriteSpeed);
                    ThrottleMode throttleMode = level = throttleParkTimeNs == 0L ? ThrottleMode.NO : ThrottleMode.LIMITED;
                }
            }
        }
        if (level == ThrottleMode.EXPONENTIAL) {
            int exponent2 = this.exponentialBackoffCntr.getAndIncrement();
            throttleParkTimeNs = (long)(4000.0 * Math.pow(1.05, exponent2));
        } else {
            if (isPageInCheckpoint) {
                this.exponentialBackoffCntr.set(0);
            }
            if (level == ThrottleMode.NO) {
                throttleParkTimeNs = 0L;
            }
        }
        if (throttleParkTimeNs > 0L) {
            this.recurrentLogIfNeed();
            this.doPark(throttleParkTimeNs);
        }
        this.speedMarkAndAvgParkTime.addMeasurementForAverageCalculation(throttleParkTimeNs);
    }

    protected void doPark(long throttleParkTimeNs) {
        if (throttleParkTimeNs > LOGGING_THRESHOLD) {
            U.warn(this.log, "Parking thread=" + Thread.currentThread().getName() + " for timeout(ms)=" + throttleParkTimeNs / 1000000L);
        }
        LockSupport.parkNanos(throttleParkTimeNs);
    }

    private int cpWrittenPages() {
        AtomicInteger writtenPagesCntr = this.cpProgress.writtenPagesCounter();
        return writtenPagesCntr == null ? 0 : writtenPagesCntr.get();
    }

    private int cpTotalPages() {
        return this.cpProgress.currentCheckpointPagesCount();
    }

    private int cpSyncedPages() {
        AtomicInteger syncedPagesCntr = this.cpProgress.syncedPagesCounter();
        return syncedPagesCntr == null ? 0 : syncedPagesCntr.get();
    }

    private int cpEvictedPages() {
        AtomicInteger evictedPagesCntr = this.cpProgress.evictedPagesCntr();
        return evictedPagesCntr == null ? 0 : evictedPagesCntr.get();
    }

    private void recurrentLogIfNeed() {
        long prevWarningNs = this.prevWarnTime.get();
        long curNs = System.nanoTime();
        if (prevWarningNs != 0L && curNs - prevWarningNs <= WARN_MIN_DELAY_NS) {
            return;
        }
        double weight = this.throttleWeight();
        if (weight <= 0.2) {
            return;
        }
        if (this.prevWarnTime.compareAndSet(prevWarningNs, curNs)) {
            String msg = String.format("Throttling is applied to page modifications [percentOfPartTime=%.2f, markDirty=%d pages/sec, checkpointWrite=%d pages/sec, estIdealMarkDirty=%d pages/sec, curDirty=%.2f, maxDirty=%.2f, avgParkTime=%d ns, pages: (total=%d, evicted=%d, written=%d, synced=%d, cpBufUsed=%d, cpBufTotal=%d)]", weight, this.getMarkDirtySpeed(), this.getCpWriteSpeed(), this.getLastEstimatedSpeedForMarkAll(), this.getCurrDirtyRatio(), this.getTargetDirtyRatio(), this.throttleParkTime(), this.cpTotalPages(), this.cpEvictedPages(), this.cpWrittenPages(), this.cpSyncedPages(), this.pageMemory.checkpointBufferPagesCount(), this.pageMemory.checkpointBufferPagesSize());
            this.log.info(msg);
        }
    }

    long getParkTime(double dirtyPagesRatio, long fullyCompletedPages, int cpTotalPages, int nThreads, long markDirtySpeed, long curCpWriteSpeed) {
        boolean throttleBySizeAndMarkSpeed;
        long speedForMarkAll = this.calcSpeedToMarkAllSpaceTillEndOfCp(dirtyPagesRatio, fullyCompletedPages, curCpWriteSpeed, cpTotalPages);
        double targetDirtyRatio = this.calcTargetDirtyRatio(fullyCompletedPages, cpTotalPages);
        this.speedForMarkAll = speedForMarkAll;
        this.targetDirtyRatio = targetDirtyRatio;
        boolean lowSpaceLeft = dirtyPagesRatio > targetDirtyRatio && dirtyPagesRatio + 0.05 > 0.75;
        int slowdown = lowSpaceLeft ? 3 : 1;
        double multiplierForSpeedForMarkAll = lowSpaceLeft ? 0.8 : 1.0;
        boolean markingTooFast = speedForMarkAll > 0L && (double)markDirtySpeed > multiplierForSpeedForMarkAll * (double)speedForMarkAll;
        boolean bl = throttleBySizeAndMarkSpeed = dirtyPagesRatio > targetDirtyRatio && markingTooFast;
        double allowWriteFasterThanCp = speedForMarkAll > 0L && markDirtySpeed > 0L && speedForMarkAll > markDirtySpeed ? 0.1 * (double)speedForMarkAll / (double)markDirtySpeed : (dirtyPagesRatio > targetDirtyRatio ? 0.0 : 0.1);
        double fasterThanCpWriteSpeed = lowSpaceLeft ? 1.0 : 1.0 + allowWriteFasterThanCp;
        boolean throttleByCpSpeed = curCpWriteSpeed > 0L && (double)markDirtySpeed > fasterThanCpWriteSpeed * (double)curCpWriteSpeed;
        long delayByCpWrite = throttleByCpSpeed ? this.calcDelayTime(curCpWriteSpeed, nThreads, slowdown) : 0L;
        long delayByMarkAllWrite = throttleBySizeAndMarkSpeed ? this.calcDelayTime(speedForMarkAll, nThreads, slowdown) : 0L;
        return Math.max(delayByCpWrite, delayByMarkAllWrite);
    }

    private long calcSpeedToMarkAllSpaceTillEndOfCp(double dirtyPagesRatio, long fullyCompletedPages, long curCpWriteSpeed, int cpTotalPages) {
        if (curCpWriteSpeed == 0L) {
            return 0L;
        }
        if (cpTotalPages <= 0) {
            return 0L;
        }
        if (dirtyPagesRatio >= 0.75) {
            return 0L;
        }
        double remainedClear = (0.75 - dirtyPagesRatio) * (double)this.totalPages;
        double timeRemainedSeconds = 1.0 * (double)((long)cpTotalPages - fullyCompletedPages) / (double)curCpWriteSpeed;
        return (long)(remainedClear / timeRemainedSeconds);
    }

    private double calcTargetDirtyRatio(long fullyCompletedPages, int cpTotalPages) {
        double cpProgress = (double)fullyCompletedPages / (double)cpTotalPages;
        double constStart = this.initDirtyRatioAtCpBegin;
        double throttleTotalWeight = 1.0 - constStart;
        return (cpProgress * throttleTotalWeight + constStart) * 0.75;
    }

    private long calcDelayTime(long baseSpeed, int nThreads, double coefficient) {
        if (coefficient <= 0.0) {
            return 0L;
        }
        if (baseSpeed <= 0L) {
            return 0L;
        }
        long updTimeNsForOnePage = TimeUnit.SECONDS.toNanos(1L) * (long)nThreads / baseSpeed;
        return (long)(coefficient * (double)updTimeNsForOnePage);
    }

    private void detectCpPagesWriteStart(int cpWrittenPages, double dirtyPagesRatio) {
        if (cpWrittenPages > 0 && this.lastObservedWritten.compareAndSet(0, cpWrittenPages)) {
            double newMinRatio = dirtyPagesRatio;
            if (newMinRatio < 0.03) {
                newMinRatio = 0.03;
            }
            if (newMinRatio > 1.0) {
                newMinRatio = 1.0;
            }
            this.initDirtyRatioAtCpBegin = newMinRatio;
        }
    }

    @Override
    public void onBeginCheckpoint() {
        this.speedCpWrite.setCounter(0L, System.nanoTime());
        this.initDirtyRatioAtCpBegin = 0.03;
        this.lastObservedWritten.set(0);
    }

    @Override
    public void onFinishCheckpoint() {
        this.exponentialBackoffCntr.set(0);
        this.speedCpWrite.finishInterval();
        this.speedMarkAndAvgParkTime.finishInterval();
        this.threadIds.clear();
    }

    public long throttleParkTime() {
        return this.speedMarkAndAvgParkTime.getAverage();
    }

    public double getTargetDirtyRatio() {
        return this.targetDirtyRatio;
    }

    public double getCurrDirtyRatio() {
        double ratio = this.currDirtyRatio;
        if (ratio >= 0.0) {
            return ratio;
        }
        return this.pageMemory.getDirtyPagesRatio();
    }

    public long getMarkDirtySpeed() {
        return this.speedMarkAndAvgParkTime.getSpeedOpsPerSec(System.nanoTime());
    }

    public long getCpWriteSpeed() {
        return this.speedCpWrite.getSpeedOpsPerSecReadOnly();
    }

    public long getLastEstimatedSpeedForMarkAll() {
        return this.speedForMarkAll;
    }

    public double throttleWeight() {
        long speed = this.speedMarkAndAvgParkTime.getSpeedOpsPerSec(System.nanoTime());
        if (speed <= 0L) {
            return 0.0;
        }
        long timeForOnePage = this.calcDelayTime(speed, this.threadIds.size(), 1.0);
        if (timeForOnePage == 0L) {
            return 0.0;
        }
        return 1.0 * (double)this.throttleParkTime() / (double)timeForOnePage;
    }

    private static enum ThrottleMode {
        NO,
        LIMITED,
        EXPONENTIAL;

    }
}

