/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.encryption.GridEncryptionManager;
import org.apache.ignite.internal.mem.DirectMemoryProvider;
import org.apache.ignite.internal.mem.DirectMemoryRegion;
import org.apache.ignite.internal.mem.IgniteOutOfMemoryException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.InitNewPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointLockStateChecker;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointWriteProgressSupplier;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.PageStoreWriter;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.CheckpointMetricsTracker;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.CheckpointPages;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.DelayedDirtyPageStoreWrite;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.DelayedPageReplacementTracker;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.FullPageIdTable;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.LoadedPagesMap;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PagesWriteSpeedBasedThrottle;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PagesWriteThrottle;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PagesWriteThrottlePolicy;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.ReplaceCandidate;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.RobinHoodBackwardShiftHashMap;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionCountersIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.TrackingPageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridMultiCollectionWrapper;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.OffheapReadWriteLock;
import org.apache.ignite.internal.util.future.CountDownFuture;
import org.apache.ignite.internal.util.lang.GridInClosure3X;
import org.apache.ignite.internal.util.offheap.GridOffHeapOutOfMemoryException;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.spi.encryption.noop.NoopEncryptionSpi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageMemoryImpl
implements PageMemoryEx {
    public static final long PAGE_MARKER = 1L;
    private static final long SEGMENT_INDEX_MASK = -1099511627776L;
    private static final long RELATIVE_PTR_MASK = 0xFFFFFFFFFFFFFFL;
    private static final long DIRTY_FLAG = 0x100000000000000L;
    private static final long INVALID_REL_PTR = 0xFFFFFFFFFFFFFFL;
    private static final long OUTDATED_REL_PTR = 0x100000000000000L;
    private static final long ADDRESS_MASK = 0xFFFFFFFFFFFFFFL;
    private static final long COUNTER_MASK = -72057594037927936L;
    private static final long COUNTER_INC = 0x100000000000000L;
    public static final int RELATIVE_PTR_OFFSET = 8;
    public static final int PAGE_ID_OFFSET = 16;
    public static final int PAGE_CACHE_ID_OFFSET = 24;
    public static final int PAGE_PIN_CNT_OFFSET = 28;
    public static final int PAGE_LOCK_OFFSET = 32;
    public static final int PAGE_TMP_BUF_OFFSET = 40;
    public static final int PAGE_OVERHEAD = 48;
    public static final int RANDOM_PAGES_EVICT_NUM = 5;
    public static final int TRY_AGAIN_TAG = -1;
    private static final TrackingPageIO trackingIO = TrackingPageIO.VERSIONS.latest();
    public static final String CHECKPOINT_POOL_OVERFLOW_ERROR_MSG = "Failed to allocate temporary buffer for checkpoint (increase checkpointPageBufferSize configuration property)";
    private final int sysPageSize;
    private final int encPageSize;
    private final GridCacheSharedContext<?, ?> ctx;
    private final CheckpointLockStateChecker stateChecker;
    private final AtomicInteger cpBufPagesCntr = new AtomicInteger(0);
    private final boolean useBackwardShiftMap = IgniteSystemProperties.getBoolean("IGNITE_LOADED_PAGES_BACKWARD_SHIFT_MAP", true);
    private ExecutorService asyncRunner = new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors(), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(Runtime.getRuntime().availableProcessors()));
    private IgnitePageStoreManager storeMgr;
    private IgniteWriteAheadLogManager walMgr;
    private final GridEncryptionManager encMgr;
    private final boolean encryptionDisabled;
    private final IgniteLogger log;
    private final DirectMemoryProvider directMemoryProvider;
    private Segment[] segments;
    private PagePool checkpointPool;
    private OffheapReadWriteLock rwLock;
    private final PageStoreWriter flushDirtyPage;
    @Nullable
    private final DelayedPageReplacementTracker delayedPageReplacementTracker;
    @Nullable
    private final GridInClosure3X<Long, FullPageId, PageMemoryEx> changeTracker;
    private PagesWriteThrottlePolicy writeThrottle;
    private ThrottlingPolicy throttlingPlc;
    @Nullable
    private final CheckpointWriteProgressSupplier cpProgressProvider;
    private volatile boolean pageReplacementWarned;
    private long[] sizes;
    private DataRegionMetricsImpl memMetrics;
    private volatile boolean stopped;

    public PageMemoryImpl(DirectMemoryProvider directMemoryProvider, long[] sizes, GridCacheSharedContext<?, ?> ctx, int pageSize, PageStoreWriter flushDirtyPage, @Nullable GridInClosure3X<Long, FullPageId, PageMemoryEx> changeTracker, CheckpointLockStateChecker stateChecker, DataRegionMetricsImpl memMetrics, @Nullable ThrottlingPolicy throttlingPlc, @NotNull CheckpointWriteProgressSupplier cpProgressProvider) {
        assert (ctx != null);
        assert (pageSize > 0);
        this.log = ctx.logger(PageMemoryImpl.class);
        this.ctx = ctx;
        this.directMemoryProvider = directMemoryProvider;
        this.sizes = sizes;
        this.flushDirtyPage = flushDirtyPage;
        this.delayedPageReplacementTracker = IgniteSystemProperties.getBoolean("IGNITE_DELAYED_REPLACED_PAGE_WRITE", true) ? new DelayedPageReplacementTracker(pageSize, flushDirtyPage, this.log, sizes.length - 1) : null;
        this.changeTracker = changeTracker;
        this.stateChecker = stateChecker;
        this.throttlingPlc = throttlingPlc != null ? throttlingPlc : ThrottlingPolicy.CHECKPOINT_BUFFER_ONLY;
        this.cpProgressProvider = cpProgressProvider;
        this.storeMgr = ctx.pageStore();
        this.walMgr = ctx.wal();
        this.encMgr = ctx.kernalContext().encryption();
        this.encryptionDisabled = ctx.gridConfig().getEncryptionSpi() instanceof NoopEncryptionSpi;
        assert (this.storeMgr != null);
        assert (this.walMgr != null);
        assert (this.encMgr != null);
        this.sysPageSize = pageSize + 48;
        this.encPageSize = CU.encryptedPageSize(pageSize, ctx.kernalContext().config().getEncryptionSpi());
        this.rwLock = new OffheapReadWriteLock(128);
        this.memMetrics = memMetrics;
    }

    @Override
    public void start() throws IgniteException {
        DirectMemoryRegion reg;
        this.stopped = false;
        this.directMemoryProvider.initialize(this.sizes);
        ArrayList<DirectMemoryRegion> regions = new ArrayList<DirectMemoryRegion>(this.sizes.length);
        while ((reg = this.directMemoryProvider.nextRegion()) != null) {
            regions.add(reg);
        }
        int regs = regions.size();
        this.segments = new Segment[regs - 1];
        DirectMemoryRegion cpReg = (DirectMemoryRegion)regions.get(regs - 1);
        this.checkpointPool = new PagePool(regs - 1, cpReg, this.cpBufPagesCntr);
        long checkpointBuf = cpReg.size();
        long totalAllocated = 0L;
        int pages = 0;
        long totalTblSize = 0L;
        for (int i = 0; i < regs - 1; ++i) {
            assert (i < this.segments.length);
            DirectMemoryRegion reg2 = (DirectMemoryRegion)regions.get(i);
            totalAllocated += reg2.size();
            this.segments[i] = new Segment(i, (DirectMemoryRegion)regions.get(i), this.checkpointPool.pages() / this.segments.length, this.throttlingPlc);
            pages += this.segments[i].pages();
            totalTblSize += this.segments[i].tableSize();
        }
        this.initWriteThrottle();
        if (this.log.isInfoEnabled()) {
            this.log.info("Started page memory [memoryAllocated=" + U.readableSize(totalAllocated, false) + ", pages=" + pages + ", tableSize=" + U.readableSize(totalTblSize, false) + ", checkpointBuffer=" + U.readableSize(checkpointBuf, false) + ']');
        }
    }

    private void initWriteThrottle() {
        if (this.throttlingPlc == ThrottlingPolicy.SPEED_BASED) {
            this.writeThrottle = new PagesWriteSpeedBasedThrottle(this, this.cpProgressProvider, this.stateChecker, this.log);
        } else if (this.throttlingPlc == ThrottlingPolicy.TARGET_RATIO_BASED) {
            this.writeThrottle = new PagesWriteThrottle(this, this.cpProgressProvider, this.stateChecker, false, this.log);
        } else if (this.throttlingPlc == ThrottlingPolicy.CHECKPOINT_BUFFER_ONLY) {
            this.writeThrottle = new PagesWriteThrottle(this, null, this.stateChecker, true, this.log);
        }
    }

    @Override
    public void stop(boolean deallocate) throws IgniteException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping page memory.");
        }
        U.shutdownNow(this.getClass(), this.asyncRunner, this.log);
        if (this.segments != null) {
            for (Segment seg : this.segments) {
                seg.close();
            }
        }
        this.stopped = true;
        this.directMemoryProvider.shutdown(deallocate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePage(int grpId, long pageId, long page) {
        assert (!this.stopped);
        Segment seg = this.segment(grpId, pageId);
        seg.readLock().lock();
        try {
            seg.releasePage(page);
        }
        finally {
            seg.readLock().unlock();
        }
    }

    @Override
    public long readLock(int grpId, long pageId, long page) {
        assert (!this.stopped);
        return this.readLockPage(page, new FullPageId(pageId, grpId), false);
    }

    @Override
    public void readUnlock(int grpId, long pageId, long page) {
        assert (!this.stopped);
        this.readUnlockPage(page);
    }

    @Override
    public long writeLock(int grpId, long pageId, long page) {
        assert (!this.stopped);
        return this.writeLock(grpId, pageId, page, false);
    }

    @Override
    public long writeLock(int grpId, long pageId, long page, boolean restore2) {
        assert (!this.stopped);
        return this.writeLockPage(page, new FullPageId(pageId, grpId), !restore2);
    }

    @Override
    public long tryWriteLock(int grpId, long pageId, long page) {
        assert (!this.stopped);
        return this.tryWriteLockPage(page, new FullPageId(pageId, grpId), true);
    }

    @Override
    public void writeUnlock(int grpId, long pageId, long page, Boolean walPlc, boolean dirtyFlag) {
        assert (!this.stopped);
        this.writeUnlock(grpId, pageId, page, walPlc, dirtyFlag, false);
    }

    @Override
    public void writeUnlock(int grpId, long pageId, long page, Boolean walPlc, boolean dirtyFlag, boolean restore2) {
        assert (!this.stopped);
        this.writeUnlockPage(page, new FullPageId(pageId, grpId), walPlc, dirtyFlag, restore2);
    }

    @Override
    public boolean isDirty(int grpId, long pageId, long page) {
        assert (!this.stopped);
        return this.isDirty(page);
    }

    @Override
    public long allocatePage(int grpId, int partId, byte flags) throws IgniteCheckedException {
        assert (flags == 1 && partId <= 65500 || flags == 2 && partId == 65535) : "flags = " + flags + ", partId = " + partId;
        assert (!this.stopped);
        assert (this.stateChecker.checkpointLockIsHeldByThread());
        if (this.isThrottlingEnabled()) {
            this.writeThrottle.onMarkDirty(false);
        }
        long pageId = this.storeMgr.allocatePage(grpId, partId, flags);
        assert (PageIdUtils.pageIndex(pageId) > 0);
        Segment seg = this.segment(grpId, pageId);
        DelayedDirtyPageStoreWrite delayedWriter = this.delayedPageReplacementTracker != null ? this.delayedPageReplacementTracker.delayedPageWrite() : null;
        FullPageId fullId = new FullPageId(pageId, grpId);
        seg.writeLock().lock();
        boolean isTrackingPage = this.changeTracker != null && trackingIO.trackingPageFor(pageId, this.realPageSize(grpId)) == pageId;
        try {
            long pageAddr;
            long relPtr = seg.loadedPages.get(grpId, PageIdUtils.effectivePageId(pageId), seg.partGeneration(grpId, partId), 0xFFFFFFFFFFFFFFL, 0x100000000000000L);
            if (relPtr == 0x100000000000000L) {
                relPtr = this.refreshOutdatedPage(seg, grpId, pageId, false);
            }
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                relPtr = seg.borrowOrAllocateFreePage(pageId);
            }
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                relPtr = seg.removePageForReplacement(delayedWriter == null ? this.flushDirtyPage : delayedWriter);
            }
            long absPtr = seg.absolute(relPtr);
            GridUnsafe.setMemory(absPtr + 48L, this.pageSize(), (byte)0);
            PageHeader.fullPageId(absPtr, fullId);
            PageHeader.writeTimestamp(absPtr, U.currentTimeMillis());
            this.rwLock.init(absPtr + 32L, PageIdUtils.tag(pageId));
            assert (GridUnsafe.getInt(absPtr + 48L + 4L) == 0);
            assert (!PageHeader.isAcquired(absPtr)) : "Pin counter must be 0 for a new page [relPtr=" + U.hexLong(relPtr) + ", absPtr=" + U.hexLong(absPtr) + ']';
            this.setDirty(fullId, absPtr, true, true);
            if (isTrackingPage && PageIO.getType(pageAddr = absPtr + 48L) == 0) {
                trackingIO.initNewPage(pageAddr, pageId, this.realPageSize(grpId));
                if (!this.ctx.wal().disabled(fullId.groupId())) {
                    if (!this.ctx.wal().isAlwaysWriteFullPages()) {
                        this.ctx.wal().log(new InitNewPageRecord(grpId, pageId, trackingIO.getType(), trackingIO.getVersion(), pageId));
                    } else {
                        this.ctx.wal().log(new PageSnapshot(fullId, absPtr + 48L, this.pageSize(), this.realPageSize(fullId.groupId())));
                    }
                }
            }
            seg.loadedPages.put(grpId, PageIdUtils.effectivePageId(pageId), relPtr, seg.partGeneration(grpId, partId));
        }
        catch (IgniteOutOfMemoryException oom) {
            DataRegionConfiguration dataRegionCfg = this.getDataRegionConfiguration();
            IgniteOutOfMemoryException e = new IgniteOutOfMemoryException("Out of memory in data region [name=" + dataRegionCfg.getName() + ", initSize=" + U.readableSize(dataRegionCfg.getInitialSize(), false) + ", maxSize=" + U.readableSize(dataRegionCfg.getMaxSize(), false) + ", persistenceEnabled=" + dataRegionCfg.isPersistenceEnabled() + "] Try the following:" + U.nl() + "  ^-- Increase maximum off-heap memory size (DataRegionConfiguration.maxSize)" + U.nl() + "  ^-- Enable Ignite persistence (DataRegionConfiguration.persistenceEnabled)" + U.nl() + "  ^-- Enable eviction or expiration policies");
            e.initCause(oom);
            this.ctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
        finally {
            seg.writeLock().unlock();
        }
        if (delayedWriter != null) {
            delayedWriter.finishReplacement();
        }
        return isTrackingPage ? this.allocatePage(grpId, partId, flags) : pageId;
    }

    private DataRegionConfiguration getDataRegionConfiguration() {
        DataStorageConfiguration memCfg = this.ctx.kernalContext().config().getDataStorageConfiguration();
        assert (memCfg != null);
        String dataRegionName = this.memMetrics.getName();
        if (memCfg.getDefaultDataRegionConfiguration().getName().equals(dataRegionName)) {
            return memCfg.getDefaultDataRegionConfiguration();
        }
        DataRegionConfiguration[] dataRegions = memCfg.getDataRegionConfigurations();
        if (dataRegions != null) {
            for (DataRegionConfiguration reg : dataRegions) {
                if (reg == null || !reg.getName().equals(dataRegionName)) continue;
                return reg;
            }
        }
        return null;
    }

    @Override
    public ByteBuffer pageBuffer(long pageAddr) {
        return GridUnsafe.wrapPointer(pageAddr, this.pageSize());
    }

    @Override
    public boolean freePage(int grpId, long pageId) throws IgniteCheckedException {
        assert (false) : "Free page should be never called directly when persistence is enabled.";
        return false;
    }

    @Override
    public long metaPageId(int grpId) throws IgniteCheckedException {
        assert (!this.stopped);
        return this.storeMgr.metaPageId(grpId);
    }

    @Override
    public long partitionMetaPageId(int grpId, int partId) throws IgniteCheckedException {
        assert (!this.stopped);
        return PageIdUtils.pageId(partId, (byte)1, 0);
    }

    @Override
    public long acquirePage(int grpId, long pageId) throws IgniteCheckedException {
        assert (!this.stopped);
        return this.acquirePage(grpId, pageId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long acquirePage(int grpId, long pageId, boolean restore2) throws IgniteCheckedException {
        long l;
        assert (!this.stopped);
        FullPageId fullId = new FullPageId(pageId, grpId);
        int partId = PageIdUtils.partId(pageId);
        Segment seg = this.segment(grpId, pageId);
        seg.readLock().lock();
        try {
            long relPtr = seg.loadedPages.get(grpId, PageIdUtils.effectivePageId(pageId), seg.partGeneration(grpId, partId), 0xFFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL);
            if (relPtr != 0xFFFFFFFFFFFFFFL) {
                long absPtr = seg.absolute(relPtr);
                seg.acquirePage(absPtr);
                long l2 = absPtr;
                return l2;
            }
        }
        finally {
            seg.readLock().unlock();
        }
        DelayedDirtyPageStoreWrite delayedWriter = this.delayedPageReplacementTracker != null ? this.delayedPageReplacementTracker.delayedPageWrite() : null;
        seg.writeLock().lock();
        long lockedPageAbsPtr = -1L;
        boolean readPageFromStore = false;
        try {
            long pageAddr;
            long absPtr;
            long relPtr = seg.loadedPages.get(grpId, PageIdUtils.effectivePageId(pageId), seg.partGeneration(grpId, partId), 0xFFFFFFFFFFFFFFL, 0x100000000000000L);
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                relPtr = seg.borrowOrAllocateFreePage(pageId);
                if (relPtr == 0xFFFFFFFFFFFFFFL) {
                    relPtr = seg.removePageForReplacement(delayedWriter == null ? this.flushDirtyPage : delayedWriter);
                }
                absPtr = seg.absolute(relPtr);
                PageHeader.fullPageId(absPtr, fullId);
                PageHeader.writeTimestamp(absPtr, U.currentTimeMillis());
                assert (!PageHeader.isAcquired(absPtr)) : "Pin counter must be 0 for a new page [relPtr=" + U.hexLong(relPtr) + ", absPtr=" + U.hexLong(absPtr) + ']';
                this.setDirty(fullId, absPtr, false, false);
                seg.loadedPages.put(grpId, PageIdUtils.effectivePageId(pageId), relPtr, seg.partGeneration(grpId, partId));
                pageAddr = absPtr + 48L;
                if (!restore2) {
                    if (this.delayedPageReplacementTracker != null) {
                        this.delayedPageReplacementTracker.waitUnlock(fullId);
                    }
                    readPageFromStore = true;
                } else {
                    GridUnsafe.setMemory(absPtr + 48L, this.pageSize(), (byte)0);
                    PageIO.setPageId(pageAddr, pageId);
                }
                this.rwLock.init(absPtr + 32L, PageIdUtils.tag(pageId));
                if (readPageFromStore) {
                    boolean locked = this.rwLock.writeLock(absPtr + 32L, -1);
                    assert (locked) : "Page ID " + fullId + " expected to be locked";
                    lockedPageAbsPtr = absPtr;
                }
            } else if (relPtr == 0x100000000000000L) {
                assert (PageIdUtils.pageIndex(pageId) == 0) : fullId;
                relPtr = this.refreshOutdatedPage(seg, grpId, pageId, false);
                absPtr = seg.absolute(relPtr);
                pageAddr = absPtr + 48L;
                GridUnsafe.setMemory(absPtr + 48L, this.pageSize(), (byte)0);
                PageHeader.fullPageId(absPtr, fullId);
                PageHeader.writeTimestamp(absPtr, U.currentTimeMillis());
                PageIO.setPageId(pageAddr, pageId);
                assert (!PageHeader.isAcquired(absPtr)) : "Pin counter must be 0 for a new page [relPtr=" + U.hexLong(relPtr) + ", absPtr=" + U.hexLong(absPtr) + ']';
                this.rwLock.init(absPtr + 32L, PageIdUtils.tag(pageId));
            } else {
                absPtr = seg.absolute(relPtr);
            }
            seg.acquirePage(absPtr);
            l = absPtr;
        }
        catch (IgniteOutOfMemoryException oom) {
            try {
                this.ctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, oom));
                throw oom;
            }
            catch (Throwable throwable2) {
                seg.writeLock().unlock();
                if (delayedWriter != null) {
                    delayedWriter.finishReplacement();
                }
                if (readPageFromStore) {
                    assert (lockedPageAbsPtr != -1L) : "Page is expected to have a valid address [pageId=" + fullId + ", lockedPageAbsPtr=" + U.hexLong(lockedPageAbsPtr) + ']';
                    assert (this.isPageWriteLocked(lockedPageAbsPtr)) : "Page is expected to be locked: [pageId=" + fullId + "]";
                    long pageAddr = lockedPageAbsPtr + 48L;
                    ByteBuffer buf = GridUnsafe.wrapPointer(pageAddr, this.pageSize());
                    long actualPageId = 0L;
                    try {
                        this.storeMgr.read(grpId, pageId, buf);
                        actualPageId = PageIO.getPageId(buf);
                        this.memMetrics.onPageRead();
                        this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                    }
                    catch (IgniteDataIntegrityViolationException ignore) {
                        try {
                            U.warn(this.log, "Failed to read page (data integrity violation encountered, will try to restore using existing WAL) [fullPageId=" + fullId + ']');
                            buf.rewind();
                            this.tryToRestorePage(fullId, buf);
                            this.memMetrics.onPageRead();
                            this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                        }
                        catch (Throwable throwable3) {
                            this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                            throw throwable3;
                        }
                    }
                }
                throw throwable2;
            }
        }
        seg.writeLock().unlock();
        if (delayedWriter != null) {
            delayedWriter.finishReplacement();
        }
        if (readPageFromStore) {
            assert (lockedPageAbsPtr != -1L) : "Page is expected to have a valid address [pageId=" + fullId + ", lockedPageAbsPtr=" + U.hexLong(lockedPageAbsPtr) + ']';
            assert (this.isPageWriteLocked(lockedPageAbsPtr)) : "Page is expected to be locked: [pageId=" + fullId + "]";
            long pageAddr = lockedPageAbsPtr + 48L;
            ByteBuffer buf = GridUnsafe.wrapPointer(pageAddr, this.pageSize());
            long actualPageId = 0L;
            try {
                this.storeMgr.read(grpId, pageId, buf);
                actualPageId = PageIO.getPageId(buf);
                this.memMetrics.onPageRead();
                this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
            }
            catch (IgniteDataIntegrityViolationException ignore) {
                try {
                    U.warn(this.log, "Failed to read page (data integrity violation encountered, will try to restore using existing WAL) [fullPageId=" + fullId + ']');
                    buf.rewind();
                    this.tryToRestorePage(fullId, buf);
                    this.memMetrics.onPageRead();
                    this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                }
                catch (Throwable throwable4) {
                    this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                    throw throwable4;
                }
            }
        }
        return l;
    }

    private long refreshOutdatedPage(Segment seg, int grpId, long pageId, boolean rmv) {
        CheckpointPages cpPages;
        assert (seg.writeLock().isHeldByCurrentThread());
        int tag = seg.partGeneration(grpId, PageIdUtils.partId(pageId));
        long relPtr = seg.loadedPages.refresh(grpId, PageIdUtils.effectivePageId(pageId), tag);
        long absPtr = seg.absolute(relPtr);
        GridUnsafe.setMemory(absPtr + 48L, this.pageSize(), (byte)0);
        PageHeader.dirty(absPtr, false);
        long tmpBufPtr = PageHeader.tempBufferPointer(absPtr);
        if (tmpBufPtr != 0xFFFFFFFFFFFFFFL) {
            GridUnsafe.setMemory(this.checkpointPool.absolute(tmpBufPtr) + 48L, this.pageSize(), (byte)0);
            PageHeader.tempBufferPointer(absPtr, 0xFFFFFFFFFFFFFFL);
            PageHeader.releasePage(absPtr);
            this.checkpointPool.releaseFreePage(tmpBufPtr);
        }
        if (rmv) {
            seg.loadedPages.remove(grpId, PageIdUtils.effectivePageId(pageId));
        }
        if ((cpPages = seg.checkpointPages) != null) {
            cpPages.markAsSaved(new FullPageId(pageId, grpId));
        }
        if (seg.dirtyPages != null) {
            seg.dirtyPages.remove(new FullPageId(pageId, grpId));
        }
        return relPtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToRestorePage(FullPageId fullId, ByteBuffer buf) throws IgniteCheckedException {
        Long tmpAddr = null;
        try {
            ByteBuffer restored;
            ByteBuffer curPage = null;
            ByteBuffer lastValidPage = null;
            try (WALIterator it = this.walMgr.replay(null);){
                block17: for (IgniteBiTuple tuple : it) {
                    switch (((WALRecord)tuple.getValue()).type()) {
                        case PAGE_RECORD: {
                            PageSnapshot snapshot2 = (PageSnapshot)tuple.getValue();
                            if (!snapshot2.fullPageId().equals(fullId)) continue block17;
                            if (tmpAddr == null) {
                                assert (snapshot2.pageData().length <= this.pageSize()) : snapshot2.pageData().length;
                                tmpAddr = GridUnsafe.allocateMemory(this.pageSize());
                            }
                            if (curPage == null) {
                                curPage = GridUnsafe.wrapPointer(tmpAddr, this.pageSize());
                            }
                            PageUtils.putBytes(tmpAddr, 0, snapshot2.pageData());
                            continue block17;
                        }
                        case CHECKPOINT_RECORD: {
                            CheckpointRecord rec = (CheckpointRecord)tuple.getValue();
                            assert (!rec.end());
                            if (curPage == null) continue block17;
                            lastValidPage = curPage;
                            curPage = null;
                            continue block17;
                        }
                        case MEMORY_RECOVERY: {
                            curPage = null;
                            continue block17;
                        }
                    }
                    if (!(tuple.getValue() instanceof PageDeltaRecord)) continue;
                    PageDeltaRecord deltaRecord = (PageDeltaRecord)tuple.getValue();
                    if (curPage == null || deltaRecord.pageId() != fullId.pageId() || deltaRecord.groupId() != fullId.groupId()) continue;
                    assert (tmpAddr != null);
                    deltaRecord.applyDelta(this, tmpAddr);
                }
            }
            ByteBuffer byteBuffer = restored = curPage == null ? lastValidPage : curPage;
            if (restored == null) {
                throw new StorageException(String.format("Page is broken. Can't restore it from WAL. (grpId = %d, pageId = %X).", fullId.groupId(), fullId.pageId()));
            }
            buf.put(restored);
        }
        finally {
            if (tmpAddr != null) {
                GridUnsafe.freeMemory(tmpAddr);
            }
        }
    }

    @Override
    public int pageSize() {
        return this.sysPageSize - 48;
    }

    @Override
    public int systemPageSize() {
        return this.sysPageSize;
    }

    @Override
    public int realPageSize(int grpId) {
        if (this.encryptionDisabled || this.encMgr.groupKey(grpId) == null) {
            return this.pageSize();
        }
        return this.encPageSize;
    }

    @Override
    public boolean safeToUpdate() {
        if (this.segments != null) {
            for (Segment segment : this.segments) {
                if (segment.safeToUpdate()) continue;
                return false;
            }
        }
        return true;
    }

    boolean shouldThrottle(double dirtyRatioThreshold) {
        for (Segment segment : this.segments) {
            if (!segment.shouldThrottle(dirtyRatioThreshold)) continue;
            return true;
        }
        return false;
    }

    double getDirtyPagesRatio() {
        double res = 0.0;
        for (Segment segment : this.segments) {
            res = Math.max(res, segment.getDirtyPagesRatio());
        }
        return res;
    }

    public long totalPages() {
        long res = 0L;
        for (Segment segment : this.segments) {
            res += (long)segment.pages();
        }
        return res;
    }

    @Override
    public GridMultiCollectionWrapper<FullPageId> beginCheckpoint(IgniteInternalFuture allowToReplace) throws IgniteException {
        if (this.segments == null) {
            return new GridMultiCollectionWrapper<FullPageId>(Collections.emptyList());
        }
        Collection[] collections = new Collection[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            Collection dirtyPages;
            Segment seg = this.segments[i];
            if (seg.checkpointPages != null) {
                throw new IgniteException("Failed to begin checkpoint (it is already in progress).");
            }
            collections[i] = dirtyPages = seg.dirtyPages;
            seg.checkpointPages = new CheckpointPages(dirtyPages, allowToReplace);
            seg.dirtyPages = new GridConcurrentHashSet();
        }
        this.memMetrics.resetDirtyPages();
        if (this.throttlingPlc != ThrottlingPolicy.DISABLED) {
            this.writeThrottle.onBeginCheckpoint();
        }
        return new GridMultiCollectionWrapper<FullPageId>(collections);
    }

    private boolean isThrottlingEnabled() {
        return this.throttlingPlc != ThrottlingPolicy.CHECKPOINT_BUFFER_ONLY && this.throttlingPlc != ThrottlingPolicy.DISABLED;
    }

    @Override
    public void finishCheckpoint() {
        if (this.segments == null) {
            return;
        }
        for (Segment seg : this.segments) {
            seg.checkpointPages = null;
        }
        if (this.throttlingPlc != ThrottlingPolicy.DISABLED) {
            this.writeThrottle.onFinishCheckpoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkpointWritePage(FullPageId fullId, ByteBuffer buf, PageStoreWriter pageStoreWriter, CheckpointMetricsTracker metricsTracker) throws IgniteCheckedException {
        long relPtr;
        int tag;
        assert (buf.remaining() == this.pageSize());
        Segment seg = this.segment(fullId.groupId(), fullId.pageId());
        long absPtr = 0L;
        boolean pageSingleAcquire = false;
        seg.readLock().lock();
        try {
            if (!this.isInCheckpoint(fullId)) {
                return;
            }
            tag = this.generationTag(seg, fullId);
            relPtr = this.resolveRelativePointer(seg, fullId, tag);
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                return;
            }
            if (relPtr != 0x100000000000000L) {
                absPtr = seg.absolute(relPtr);
                if (PageHeader.tempBufferPointer(absPtr) == 0xFFFFFFFFFFFFFFL) {
                    PageHeader.acquirePage(absPtr);
                } else {
                    pageSingleAcquire = true;
                }
            }
        }
        finally {
            seg.readLock().unlock();
        }
        if (relPtr == 0x100000000000000L) {
            seg.writeLock().lock();
            try {
                relPtr = this.resolveRelativePointer(seg, fullId, this.generationTag(seg, fullId));
                if (relPtr == 0xFFFFFFFFFFFFFFL) {
                    return;
                }
                if (relPtr == 0x100000000000000L) {
                    relPtr = this.refreshOutdatedPage(seg, fullId.groupId(), PageIdUtils.effectivePageId(fullId.pageId()), true);
                    seg.pool.releaseFreePage(relPtr);
                }
                return;
            }
            finally {
                seg.writeLock().unlock();
            }
        }
        this.copyPageForCheckpoint(absPtr, fullId, buf, tag, pageSingleAcquire, pageStoreWriter, metricsTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPageForCheckpoint(long absPtr, FullPageId fullId, ByteBuffer buf, Integer tag, boolean pageSingleAcquire, PageStoreWriter pageStoreWriter, CheckpointMetricsTracker tracker) throws IgniteCheckedException {
        assert (absPtr != 0L);
        assert (PageHeader.isAcquired(absPtr));
        boolean canWrite = false;
        boolean locked = this.rwLock.tryWriteLock(absPtr + 32L, -1);
        if (!locked) {
            if (!pageSingleAcquire) {
                PageHeader.releasePage(absPtr);
            }
            buf.clear();
            pageStoreWriter.writePage(fullId, buf, -1);
            return;
        }
        try {
            long tmpRelPtr = PageHeader.tempBufferPointer(absPtr);
            boolean success2 = this.clearCheckpoint(fullId);
            assert (success2) : "Page was pin when we resolve abs pointer, it can not be evicted";
            if (tmpRelPtr != 0xFFFFFFFFFFFFFFL) {
                PageHeader.tempBufferPointer(absPtr, 0xFFFFFFFFFFFFFFL);
                long tmpAbsPtr = this.checkpointPool.absolute(tmpRelPtr);
                this.copyInBuffer(tmpAbsPtr, buf);
                GridUnsafe.setMemory(tmpAbsPtr + 48L, this.pageSize(), (byte)0);
                if (tracker != null) {
                    tracker.onCowPageWritten();
                }
                this.checkpointPool.releaseFreePage(tmpRelPtr);
                if (!pageSingleAcquire) {
                    PageHeader.releasePage(absPtr);
                }
            } else {
                this.copyInBuffer(absPtr, buf);
                PageHeader.dirty(absPtr, false);
            }
            assert (PageIO.getType(buf) != 0) : "Invalid state. Type is 0! pageId = " + U.hexLong(fullId.pageId());
            assert (PageIO.getVersion(buf) != 0) : "Invalid state. Version is 0! pageId = " + U.hexLong(fullId.pageId());
            canWrite = true;
        }
        finally {
            this.rwLock.writeUnlock(absPtr + 32L, -1);
            if (canWrite) {
                buf.rewind();
                pageStoreWriter.writePage(fullId, buf, tag);
                this.memMetrics.onPageWritten();
                buf.rewind();
            }
            PageHeader.releasePage(absPtr);
        }
    }

    private void copyInBuffer(long absPtr, ByteBuffer buf) {
        if (buf.isDirect()) {
            long tmpPtr = GridUnsafe.bufferAddress(buf);
            GridUnsafe.copyMemory(absPtr + 48L, tmpPtr, this.pageSize());
            assert (GridUnsafe.getInt(absPtr + 48L + 4L) == 0);
            assert (GridUnsafe.getInt(tmpPtr + 4L) == 0);
        } else {
            byte[] arr = buf.array();
            assert (arr != null);
            assert (arr.length == this.pageSize());
            GridUnsafe.copyMemory(null, absPtr + 48L, arr, GridUnsafe.BYTE_ARR_OFF, this.pageSize());
        }
    }

    private int generationTag(Segment seg, FullPageId fullId) {
        return seg.partGeneration(fullId.groupId(), PageIdUtils.partId(fullId.pageId()));
    }

    private long resolveRelativePointer(Segment seg, FullPageId fullId, int reqVer) {
        return seg.loadedPages.get(fullId.groupId(), PageIdUtils.effectivePageId(fullId.pageId()), reqVer, 0xFFFFFFFFFFFFFFL, 0x100000000000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int invalidate(int grpId, int partId) {
        int tag = 0;
        for (Segment seg : this.segments) {
            seg.writeLock().lock();
            try {
                int newTag = seg.incrementPartGeneration(grpId, partId);
                if (tag == 0) {
                    tag = newTag;
                }
                if ($assertionsDisabled || tag == newTag) continue;
                throw new AssertionError();
            }
            finally {
                seg.writeLock().unlock();
            }
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCacheGroupDestroyed(int grpId) {
        for (Segment seg : this.segments) {
            seg.writeLock().lock();
            try {
                seg.resetGroupPartitionsGeneration(grpId);
            }
            finally {
                seg.writeLock().unlock();
            }
        }
    }

    @Override
    public IgniteInternalFuture<Void> clearAsync(LoadedPagesMap.KeyPredicate pred, boolean cleanDirty) {
        CountDownFuture completeFut = new CountDownFuture(this.segments.length);
        for (Segment seg : this.segments) {
            ClearSegmentRunnable clear2 = new ClearSegmentRunnable(seg, pred, cleanDirty, completeFut, this.pageSize());
            try {
                this.asyncRunner.execute(clear2);
            }
            catch (RejectedExecutionException ignore) {
                clear2.run();
            }
        }
        return completeFut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long loadedPages() {
        long total2 = 0L;
        Segment[] segments2 = this.segments;
        if (segments2 != null) {
            for (Segment seg : segments2) {
                if (seg == null) break;
                seg.readLock().lock();
                try {
                    if (seg.closed) continue;
                    total2 += (long)seg.loadedPages.size();
                }
                finally {
                    seg.readLock().unlock();
                }
            }
        }
        return total2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long acquiredPages() {
        long total2 = 0L;
        for (Segment seg : this.segments) {
            seg.readLock().lock();
            try {
                if (seg.closed) continue;
                total2 += (long)seg.acquiredPages();
            }
            finally {
                seg.readLock().unlock();
            }
        }
        return total2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLoadedPage(FullPageId fullPageId) {
        int grpId = fullPageId.groupId();
        long pageId = PageIdUtils.effectivePageId(fullPageId.pageId());
        int partId = PageIdUtils.partId(pageId);
        Segment seg = this.segment(grpId, pageId);
        seg.readLock().lock();
        try {
            long res = seg.loadedPages.get(grpId, pageId, seg.partGeneration(grpId, partId), 0xFFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL);
            boolean bl = res != 0xFFFFFFFFFFFFFFL;
            return bl;
        }
        finally {
            seg.readLock().unlock();
        }
    }

    private long readLockPage(long absPtr, FullPageId fullId, boolean force) {
        return this.readLockPage(absPtr, fullId, force, true);
    }

    private long readLockPage(long absPtr, FullPageId fullId, boolean force, boolean touch) {
        assert (!this.stopped);
        int tag = force ? -1 : PageIdUtils.tag(fullId.pageId());
        boolean locked = this.rwLock.readLock(absPtr + 32L, tag);
        if (!locked) {
            return 0L;
        }
        if (touch) {
            PageHeader.writeTimestamp(absPtr, U.currentTimeMillis());
        }
        assert (GridUnsafe.getInt(absPtr + 48L + 4L) == 0);
        return absPtr + 48L;
    }

    @Override
    public long readLockForce(int grpId, long pageId, long page) {
        assert (!this.stopped);
        return this.readLockPage(page, new FullPageId(pageId, grpId), true);
    }

    void readUnlockPage(long absPtr) {
        this.rwLock.readUnlock(absPtr + 32L);
    }

    public boolean hasTempCopy(long absPtr) {
        return PageHeader.tempBufferPointer(absPtr) != 0xFFFFFFFFFFFFFFL;
    }

    long tryWriteLockPage(long absPtr, FullPageId fullId, boolean checkTag) {
        int tag;
        int n = tag = checkTag ? PageIdUtils.tag(fullId.pageId()) : -1;
        if (!this.rwLock.tryWriteLock(absPtr + 32L, tag)) {
            return 0L;
        }
        return this.postWriteLockPage(absPtr, fullId);
    }

    private long writeLockPage(long absPtr, FullPageId fullId, boolean checkTag) {
        int tag = checkTag ? PageIdUtils.tag(fullId.pageId()) : -1;
        boolean locked = this.rwLock.writeLock(absPtr + 32L, tag);
        return locked ? this.postWriteLockPage(absPtr, fullId) : 0L;
    }

    private long postWriteLockPage(long absPtr, FullPageId fullId) {
        PageHeader.writeTimestamp(absPtr, U.currentTimeMillis());
        if (this.isInCheckpoint(fullId) && PageHeader.tempBufferPointer(absPtr) == 0xFFFFFFFFFFFFFFL) {
            long tmpRelPtr = this.checkpointPool.borrowOrAllocateFreePage(fullId.pageId());
            if (tmpRelPtr == 0xFFFFFFFFFFFFFFL) {
                this.rwLock.writeUnlock(absPtr + 32L, -1);
                throw new IgniteException("Failed to allocate temporary buffer for checkpoint (increase checkpointPageBufferSize configuration property): " + this.memMetrics.getName());
            }
            PageHeader.acquirePage(absPtr);
            long tmpAbsPtr = this.checkpointPool.absolute(tmpRelPtr);
            GridUnsafe.copyMemory(null, absPtr + 48L, null, tmpAbsPtr + 48L, this.pageSize());
            assert (PageIO.getType(tmpAbsPtr + 48L) != 0) : "Invalid state. Type is 0! pageId = " + U.hexLong(fullId.pageId());
            assert (PageIO.getVersion(tmpAbsPtr + 48L) != 0) : "Invalid state. Version is 0! pageId = " + U.hexLong(fullId.pageId());
            PageHeader.dirty(absPtr, false);
            PageHeader.tempBufferPointer(absPtr, tmpRelPtr);
            assert (GridUnsafe.getInt(absPtr + 48L + 4L) == 0);
            assert (GridUnsafe.getInt(tmpAbsPtr + 48L + 4L) == 0);
        }
        assert (GridUnsafe.getInt(absPtr + 48L + 4L) == 0);
        return absPtr + 48L;
    }

    private void writeUnlockPage(long page, FullPageId fullId, Boolean walPlc, boolean markDirty, boolean restore2) {
        boolean pageWalRec;
        boolean wasDirty = this.isDirty(page);
        if (!restore2 && markDirty && !wasDirty && this.changeTracker != null) {
            this.changeTracker.apply(page, fullId, this);
        }
        boolean bl = pageWalRec = markDirty && walPlc != Boolean.FALSE && (walPlc == Boolean.TRUE || !wasDirty);
        assert (GridUnsafe.getInt(page + 48L + 4L) == 0);
        if (markDirty) {
            this.setDirty(fullId, page, markDirty, false);
        }
        this.beforeReleaseWrite(fullId, page + 48L, pageWalRec);
        long pageId = PageIO.getPageId(page + 48L);
        assert (pageId != 0L) : U.hexLong(PageHeader.access$3300(page));
        assert (PageIO.getVersion(page + 48L) != 0) : this.dumpPage(pageId, fullId.groupId());
        assert (PageIO.getType(page + 48L) != 0) : U.hexLong(pageId);
        try {
            this.rwLock.writeUnlock(page + 32L, PageIdUtils.tag(pageId));
            if (this.throttlingPlc != ThrottlingPolicy.DISABLED && !restore2 && markDirty && !wasDirty) {
                this.writeThrottle.onMarkDirty(this.isInCheckpoint(fullId));
            }
        }
        catch (AssertionError ex) {
            U.error(this.log, "Failed to unlock page [fullPageId=" + fullId + ", binPage=" + U.toHexString(page, this.systemPageSize()) + ']');
            throw ex;
        }
    }

    @NotNull
    private String dumpPage(long pageId, int grpId) {
        int pageIdx = PageIdUtils.pageIndex(pageId);
        int partId = PageIdUtils.partId(pageId);
        long off = (long)(pageIdx + 1) * (long)this.pageSize();
        return U.hexLong(pageId) + " (grpId=" + grpId + ", pageIdx=" + pageIdx + ", partId=" + partId + ", offH=" + Long.toHexString(off) + ")";
    }

    boolean isPageWriteLocked(long absPtr) {
        return this.rwLock.isWriteLocked(absPtr + 32L);
    }

    boolean isPageReadLocked(long absPtr) {
        return this.rwLock.isReadLocked(absPtr + 32L);
    }

    boolean isInCheckpoint(FullPageId pageId) {
        Segment seg = this.segment(pageId.groupId(), pageId.pageId());
        CheckpointPages pages0 = seg.checkpointPages;
        return pages0 != null && pages0.contains(pageId);
    }

    boolean clearCheckpoint(FullPageId fullPageId) {
        Segment seg = this.segment(fullPageId.groupId(), fullPageId.pageId());
        CheckpointPages pages0 = seg.checkpointPages;
        assert (pages0 != null);
        return pages0.markAsSaved(fullPageId);
    }

    boolean isDirty(long absPtr) {
        return PageHeader.dirty(absPtr);
    }

    public int activePagesCount() {
        int total2 = 0;
        for (Segment seg : this.segments) {
            total2 += seg.acquiredPages();
        }
        return total2;
    }

    @Override
    public int checkpointBufferPagesCount() {
        return this.cpBufPagesCntr.get();
    }

    public int checkpointBufferPagesSize() {
        return this.checkpointPool.pages();
    }

    private void setDirty(FullPageId pageId, long absPtr, boolean dirty, boolean forceAdd) {
        boolean wasDirty = PageHeader.dirty(absPtr, dirty);
        if (dirty) {
            boolean added;
            assert (this.stateChecker.checkpointLockIsHeldByThread());
            if ((!wasDirty || forceAdd) && (added = this.segment(pageId.groupId(), pageId.pageId()).dirtyPages.add(pageId))) {
                this.memMetrics.incrementDirtyPages();
            }
        } else {
            boolean rmv = this.segment(pageId.groupId(), pageId.pageId()).dirtyPages.remove(pageId);
            if (rmv) {
                this.memMetrics.decrementDirtyPages();
            }
        }
    }

    void beforeReleaseWrite(FullPageId pageId, long ptr, boolean pageWalRec) {
        if (this.walMgr != null && (pageWalRec || this.walMgr.isAlwaysWriteFullPages()) && !this.walMgr.disabled(pageId.groupId())) {
            try {
                this.walMgr.log(new PageSnapshot(pageId, ptr, this.pageSize(), this.realPageSize(pageId.groupId())));
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
    }

    private Segment segment(int grpId, long pageId) {
        int idx = PageMemoryImpl.segmentIndex(grpId, pageId, this.segments.length);
        return this.segments[idx];
    }

    public static int segmentIndex(int grpId, long pageId, int segments2) {
        pageId = PageIdUtils.effectivePageId(pageId);
        int hash = U.hash(pageId * 65537L + (long)grpId);
        return U.safeAbs(hash) % segments2;
    }

    private static long requiredSegmentTableMemory(int pages) {
        return FullPageIdTable.requiredMemory(pages) + 8L;
    }

    private static int updateAtomicInt(long ptr, int delta) {
        int updated2;
        int old;
        while (!GridUnsafe.compareAndSwapInt(null, ptr, old = GridUnsafe.getInt(ptr), updated2 = old + delta)) {
        }
        return updated2;
    }

    private static long updateAtomicLong(long ptr, long delta) {
        long updated2;
        long old;
        while (!GridUnsafe.compareAndSwapLong(null, ptr, old = GridUnsafe.getLong(ptr), updated2 = old + delta)) {
        }
        return updated2;
    }

    public static enum ThrottlingPolicy {
        DISABLED,
        CHECKPOINT_BUFFER_ONLY,
        TARGET_RATIO_BASED,
        SPEED_BASED;

    }

    private static class ClearSegmentRunnable
    implements Runnable {
        private Segment seg;
        LoadedPagesMap.KeyPredicate clearPred;
        private CountDownFuture doneFut;
        private int pageSize;
        private boolean rmvDirty;

        private ClearSegmentRunnable(Segment seg, LoadedPagesMap.KeyPredicate clearPred, boolean rmvDirty, CountDownFuture doneFut, int pageSize) {
            this.seg = seg;
            this.clearPred = clearPred;
            this.rmvDirty = rmvDirty;
            this.doneFut = doneFut;
            this.pageSize = pageSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int cap = this.seg.loadedPages.capacity();
            int chunkSize = 1000;
            GridLongList ptrs = new GridLongList(chunkSize);
            try {
                int base = 0;
                while (base < cap) {
                    int boundary = Math.min(cap, base + chunkSize);
                    this.seg.writeLock().lock();
                    try {
                        GridLongList list2 = this.seg.loadedPages.removeIf(base, boundary, this.clearPred);
                        ptrs.addAll(list2);
                        base = boundary;
                    }
                    finally {
                        this.seg.writeLock().unlock();
                    }
                    for (int i = 0; i < ptrs.size(); ++i) {
                        long relPtr = ptrs.get(i);
                        long absPtr = this.seg.pool.absolute(relPtr);
                        if (this.rmvDirty) {
                            FullPageId fullId = PageHeader.fullPageId(absPtr);
                            this.seg.dirtyPages.remove(fullId);
                        }
                        GridUnsafe.setMemory(absPtr + 48L, this.pageSize, (byte)0);
                        this.seg.pool.releaseFreePage(relPtr);
                    }
                    ptrs.clear();
                }
                this.doneFut.onDone((Void)null);
            }
            catch (Throwable e) {
                this.doneFut.onDone(e);
            }
        }
    }

    private static class PageHeader {
        private PageHeader() {
        }

        private static void initNew(long absPtr, long relative) {
            PageHeader.relative(absPtr, relative);
            PageHeader.tempBufferPointer(absPtr, 0xFFFFFFFFFFFFFFL);
            GridUnsafe.putLong(absPtr, 1L);
            GridUnsafe.putInt(absPtr + 28L, 0);
        }

        private static boolean dirty(long absPtr) {
            return PageHeader.flag(absPtr, 0x100000000000000L);
        }

        private static boolean dirty(long absPtr, boolean dirty) {
            return PageHeader.flag(absPtr, 0x100000000000000L, dirty);
        }

        private static boolean flag(long absPtr, long flag) {
            assert ((flag & 0xFFFFFFFFFFFFFFL) == 0L);
            assert (Long.bitCount(flag) == 1);
            long relPtrWithFlags = GridUnsafe.getLong(absPtr + 8L);
            return (relPtrWithFlags & flag) != 0L;
        }

        private static boolean flag(long absPtr, long flag, boolean set) {
            boolean was;
            assert ((flag & 0xFFFFFFFFFFFFFFL) == 0L);
            assert (Long.bitCount(flag) == 1);
            long relPtrWithFlags = GridUnsafe.getLong(absPtr + 8L);
            boolean bl = was = (relPtrWithFlags & flag) != 0L;
            relPtrWithFlags = set ? (relPtrWithFlags |= flag) : (relPtrWithFlags &= flag ^ 0xFFFFFFFFFFFFFFFFL);
            GridUnsafe.putLong(absPtr + 8L, relPtrWithFlags);
            return was;
        }

        private static boolean isAcquired(long absPtr) {
            return GridUnsafe.getInt(absPtr + 28L) > 0;
        }

        private static void acquirePage(long absPtr) {
            PageMemoryImpl.updateAtomicInt(absPtr + 28L, 1);
        }

        private static int releasePage(long absPtr) {
            return PageMemoryImpl.updateAtomicInt(absPtr + 28L, -1);
        }

        private static long readRelative(long absPtr) {
            return GridUnsafe.getLong(absPtr + 8L) & 0xFFFFFFFFFFFFFFL;
        }

        private static void relative(long absPtr, long relPtr) {
            GridUnsafe.putLong(absPtr + 8L, relPtr & 0xFFFFFFFFFFFFFFL);
        }

        private static void writeTimestamp(long absPtr, long tstamp) {
            GridUnsafe.putLongVolatile(null, absPtr, (tstamp >>= 8) << 8 | 1L);
        }

        private static long readTimestamp(long absPtr) {
            long markerAndTs = GridUnsafe.getLong(absPtr);
            return markerAndTs & 0xFFFFFFFFFFFFFF00L;
        }

        private static void tempBufferPointer(long absPtr, long tmpRelPtr) {
            GridUnsafe.putLong(absPtr + 40L, tmpRelPtr);
        }

        private static long tempBufferPointer(long absPtr) {
            return GridUnsafe.getLong(absPtr + 40L);
        }

        private static long readPageId(long absPtr) {
            return GridUnsafe.getLong(absPtr + 16L);
        }

        private static void pageId(long absPtr, long pageId) {
            GridUnsafe.putLong(absPtr + 16L, pageId);
        }

        private static int readPageGroupId(long absPtr) {
            return GridUnsafe.getInt(absPtr + 24L);
        }

        private static void pageGroupId(long absPtr, int grpId) {
            GridUnsafe.putInt(absPtr + 24L, grpId);
        }

        private static FullPageId fullPageId(long absPtr) {
            return new FullPageId(PageHeader.readPageId(absPtr), PageHeader.readPageGroupId(absPtr));
        }

        private static void fullPageId(long absPtr, FullPageId fullPageId) {
            PageHeader.pageId(absPtr, fullPageId.pageId());
            PageHeader.pageGroupId(absPtr, fullPageId.groupId());
        }

        static /* synthetic */ long access$3300(long x0) {
            return PageHeader.readPageId(x0);
        }
    }

    private class Segment
    extends ReentrantReadWriteLock {
        private static final long serialVersionUID = 0L;
        private static final double FULL_SCAN_THRESHOLD = 0.4;
        private static final int ACQUIRED_PAGES_SIZEOF = 4;
        private static final int ACQUIRED_PAGES_PADDING = 4;
        private LoadedPagesMap loadedPages;
        private long acquiredPagesPtr;
        private PagePool pool;
        private long memPerTbl;
        private Collection<FullPageId> dirtyPages = new GridConcurrentHashSet<FullPageId>();
        private volatile CheckpointPages checkpointPages;
        private final int maxDirtyPages;
        private static final int INIT_PART_GENERATION = 1;
        private final Map<GroupPartitionId, Integer> partGenerationMap = new HashMap<GroupPartitionId, Integer>();
        private boolean closed;

        private Segment(int idx, DirectMemoryRegion region, int cpPoolPages, ThrottlingPolicy throttlingPlc) {
            long totalMemory = region.size();
            int pages = (int)(totalMemory / (long)PageMemoryImpl.this.sysPageSize);
            this.acquiredPagesPtr = region.address();
            GridUnsafe.putIntVolatile(null, this.acquiredPagesPtr, 0);
            int ldPagesMapOffInRegion = 8;
            long ldPagesAddr = region.address() + (long)ldPagesMapOffInRegion;
            this.memPerTbl = PageMemoryImpl.this.useBackwardShiftMap ? RobinHoodBackwardShiftHashMap.requiredMemory(pages) : PageMemoryImpl.requiredSegmentTableMemory(pages);
            this.loadedPages = PageMemoryImpl.this.useBackwardShiftMap ? new RobinHoodBackwardShiftHashMap(ldPagesAddr, this.memPerTbl) : new FullPageIdTable(ldPagesAddr, this.memPerTbl, true);
            DirectMemoryRegion poolRegion = region.slice(this.memPerTbl + (long)ldPagesMapOffInRegion);
            this.pool = new PagePool(idx, poolRegion, null);
            this.maxDirtyPages = throttlingPlc != ThrottlingPolicy.DISABLED ? this.pool.pages() * 3 / 4 : Math.min(this.pool.pages() * 2 / 3, cpPoolPages);
        }

        private void close() {
            this.writeLock().lock();
            try {
                this.closed = true;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        private boolean safeToUpdate() {
            return this.dirtyPages.size() < this.maxDirtyPages;
        }

        private boolean shouldThrottle(double dirtyRatioThreshold) {
            return this.getDirtyPagesRatio() > dirtyRatioThreshold;
        }

        private double getDirtyPagesRatio() {
            return (double)this.dirtyPages.size() / (double)this.pages();
        }

        private int pages() {
            return this.pool.pages();
        }

        private long tableSize() {
            return this.memPerTbl;
        }

        private void acquirePage(long absPtr) {
            PageHeader.acquirePage(absPtr);
            PageMemoryImpl.updateAtomicInt(this.acquiredPagesPtr, 1);
        }

        private void releasePage(long absPtr) {
            PageHeader.releasePage(absPtr);
            PageMemoryImpl.updateAtomicInt(this.acquiredPagesPtr, -1);
        }

        private int acquiredPages() {
            return GridUnsafe.getInt(this.acquiredPagesPtr);
        }

        private long borrowOrAllocateFreePage(long pageId) {
            return this.pool.borrowOrAllocateFreePage(pageId);
        }

        private boolean preparePageRemoval(FullPageId fullPageId, long absPtr, PageStoreWriter saveDirtyPage) throws IgniteCheckedException {
            assert (this.writeLock().isHeldByCurrentThread());
            if (fullPageId.pageId() == PageMemoryImpl.this.storeMgr.metaPageId(fullPageId.groupId())) {
                return false;
            }
            if (PageHeader.isAcquired(absPtr)) {
                return false;
            }
            this.clearRowCache(fullPageId, absPtr);
            if (PageMemoryImpl.this.isDirty(absPtr)) {
                CheckpointPages checkpointPages = this.checkpointPages;
                if (checkpointPages != null && checkpointPages.allowToSave(fullPageId)) {
                    assert (PageMemoryImpl.this.storeMgr != null);
                    PageMemoryImpl.this.memMetrics.updatePageReplaceRate(U.currentTimeMillis() - PageHeader.readTimestamp(absPtr));
                    saveDirtyPage.writePage(fullPageId, GridUnsafe.wrapPointer(absPtr + 48L, PageMemoryImpl.this.pageSize()), this.partGeneration(fullPageId.groupId(), PageIdUtils.partId(fullPageId.pageId())));
                    PageMemoryImpl.this.setDirty(fullPageId, absPtr, false, true);
                    checkpointPages.markAsSaved(fullPageId);
                    return true;
                }
                return false;
            }
            PageMemoryImpl.this.memMetrics.updatePageReplaceRate(U.currentTimeMillis() - PageHeader.readTimestamp(absPtr));
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearRowCache(FullPageId fullPageId, long absPtr) throws IgniteCheckedException {
            assert (this.writeLock().isHeldByCurrentThread());
            if (PageMemoryImpl.this.ctx.kernalContext().query() == null || !PageMemoryImpl.this.ctx.kernalContext().query().moduleEnabled()) {
                return;
            }
            long pageAddr = PageMemoryImpl.this.readLockPage(absPtr, fullPageId, true, false);
            try {
                if (PageIO.getType(pageAddr) != 1) {
                    return;
                }
                final GridQueryRowCacheCleaner cleaner = PageMemoryImpl.this.ctx.kernalContext().query().getIndexing().rowCacheCleaner(fullPageId.groupId());
                if (cleaner == null) {
                    return;
                }
                DataPageIO io = DataPageIO.VERSIONS.forPage(pageAddr);
                io.forAllItems(pageAddr, new AbstractDataPageIO.CC<Void>(){

                    @Override
                    public Void apply(long link) {
                        cleaner.remove(link);
                        return null;
                    }
                });
            }
            finally {
                PageMemoryImpl.this.readUnlockPage(absPtr);
            }
        }

        private long removePageForReplacement(PageStoreWriter saveDirtyPage) throws IgniteCheckedException {
            FullPageId fullPageId;
            long relRmvAddr;
            block16: {
                assert (this.getWriteHoldCount() > 0);
                if (!PageMemoryImpl.this.pageReplacementWarned) {
                    PageMemoryImpl.this.pageReplacementWarned = true;
                    U.warn(PageMemoryImpl.this.log, "Page replacements started, pages will be rotated with disk, this will affect storage performance (consider increasing DataRegionConfiguration#setMaxSize).");
                }
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                int cap = this.loadedPages.capacity();
                if (this.acquiredPages() >= this.loadedPages.size()) {
                    DataRegionConfiguration dataRegionCfg = PageMemoryImpl.this.getDataRegionConfiguration();
                    throw new IgniteOutOfMemoryException("Failed to evict page from segment (all pages are acquired)." + U.nl() + "Out of memory in data region [name=" + dataRegionCfg.getName() + ", initSize=" + U.readableSize(dataRegionCfg.getInitialSize(), false) + ", maxSize=" + U.readableSize(dataRegionCfg.getMaxSize(), false) + ", persistenceEnabled=" + dataRegionCfg.isPersistenceEnabled() + "] Try the following:" + U.nl() + "  ^-- Increase maximum off-heap memory size (DataRegionConfiguration.maxSize)" + U.nl() + "  ^-- Enable Ignite persistence (DataRegionConfiguration.persistenceEnabled)" + U.nl() + "  ^-- Enable eviction or expiration policies");
                }
                HashSet<Long> ignored = null;
                relRmvAddr = 0xFFFFFFFFFFFFFFL;
                int iterations = 0;
                do {
                    long cleanAddr = 0xFFFFFFFFFFFFFFL;
                    long cleanTs = Long.MAX_VALUE;
                    long dirtyAddr = 0xFFFFFFFFFFFFFFL;
                    long dirtyTs = Long.MAX_VALUE;
                    long metaAddr = 0xFFFFFFFFFFFFFFL;
                    long metaTs = Long.MAX_VALUE;
                    for (int i = 0; i < 5 && !((double)(++iterations) > (double)this.pool.pages() * 0.4); ++i) {
                        boolean skip;
                        boolean outdated;
                        ReplaceCandidate nearest = this.loadedPages.getNearestAt(rnd.nextInt(cap));
                        assert (nearest != null && nearest.relativePointer() != 0xFFFFFFFFFFFFFFL);
                        long rndAddr = nearest.relativePointer();
                        int partGen = nearest.generation();
                        long absPageAddr = this.absolute(rndAddr);
                        FullPageId fullId = PageHeader.fullPageId(absPageAddr);
                        assert (fullId.equals(nearest.fullId())) : "Invalid page mapping [tableId=" + nearest.fullId() + ", actual=" + fullId + ", nearest=" + nearest;
                        boolean bl = outdated = partGen < this.partGeneration(fullId.groupId(), PageIdUtils.partId(fullId.pageId()));
                        if (outdated) {
                            return PageMemoryImpl.this.refreshOutdatedPage(this, fullId.groupId(), fullId.pageId(), true);
                        }
                        boolean pinned = PageHeader.isAcquired(absPageAddr);
                        boolean bl2 = skip = ignored != null && ignored.contains(rndAddr);
                        if (relRmvAddr == rndAddr || pinned || skip) {
                            --i;
                            continue;
                        }
                        long pageTs = PageHeader.readTimestamp(absPageAddr);
                        boolean dirty = PageMemoryImpl.this.isDirty(absPageAddr);
                        boolean storMeta = this.isStoreMetadataPage(absPageAddr);
                        if (pageTs < cleanTs && !dirty && !storMeta) {
                            cleanAddr = rndAddr;
                            cleanTs = pageTs;
                        } else if (pageTs < dirtyTs && dirty && !storMeta) {
                            dirtyAddr = rndAddr;
                            dirtyTs = pageTs;
                        } else if (pageTs < metaTs && storMeta) {
                            metaAddr = rndAddr;
                            metaTs = pageTs;
                        }
                        relRmvAddr = cleanAddr != 0xFFFFFFFFFFFFFFL ? cleanAddr : (dirtyAddr != 0xFFFFFFFFFFFFFFL ? dirtyAddr : metaAddr);
                    }
                    if (relRmvAddr == 0xFFFFFFFFFFFFFFL) {
                        return this.tryToFindSequentially(cap, saveDirtyPage);
                    }
                    long absRmvAddr = this.absolute(relRmvAddr);
                    fullPageId = PageHeader.fullPageId(absRmvAddr);
                    if (this.preparePageRemoval(fullPageId, absRmvAddr, saveDirtyPage)) break block16;
                    if (iterations <= 10) continue;
                    if (ignored == null) {
                        ignored = new HashSet<Long>();
                    }
                    ignored.add(relRmvAddr);
                } while (!((double)iterations > (double)this.pool.pages() * 0.4));
                return this.tryToFindSequentially(cap, saveDirtyPage);
            }
            this.loadedPages.remove(fullPageId.groupId(), PageIdUtils.effectivePageId(fullPageId.pageId()));
            return relRmvAddr;
        }

        private boolean isStoreMetadataPage(long absPageAddr) {
            try {
                long dataAddr = absPageAddr + 48L;
                int type = PageIO.getType(dataAddr);
                int ver = PageIO.getVersion(dataAddr);
                Object io = PageIO.getPageIO(type, ver);
                return io instanceof PagePartitionMetaIO || io instanceof PagesListMetaIO || io instanceof PagePartitionCountersIO;
            }
            catch (IgniteCheckedException ignored) {
                return false;
            }
        }

        private long tryToFindSequentially(int cap, PageStoreWriter saveDirtyPage) throws IgniteCheckedException {
            assert (this.getWriteHoldCount() > 0);
            long prevAddr = 0xFFFFFFFFFFFFFFL;
            int pinnedCnt = 0;
            int failToPrepare = 0;
            for (int i = 0; i < cap; ++i) {
                long absPageAddr;
                FullPageId fullId;
                ReplaceCandidate nearest = this.loadedPages.getNearestAt(i);
                assert (nearest != null && nearest.relativePointer() != 0xFFFFFFFFFFFFFFL);
                long addr = nearest.relativePointer();
                int partGen = nearest.generation();
                if (partGen < this.partGeneration((fullId = PageHeader.fullPageId(absPageAddr = this.absolute(addr))).groupId(), PageIdUtils.partId(fullId.pageId()))) {
                    return PageMemoryImpl.this.refreshOutdatedPage(this, fullId.groupId(), fullId.pageId(), true);
                }
                boolean pinned = PageHeader.isAcquired(absPageAddr);
                if (pinned) {
                    ++pinnedCnt;
                }
                if (addr == prevAddr || pinned) continue;
                long absEvictAddr = this.absolute(addr);
                FullPageId fullPageId = PageHeader.fullPageId(absEvictAddr);
                if (this.preparePageRemoval(fullPageId, absEvictAddr, saveDirtyPage)) {
                    this.loadedPages.remove(fullPageId.groupId(), PageIdUtils.effectivePageId(fullPageId.pageId()));
                    return addr;
                }
                ++failToPrepare;
                prevAddr = addr;
            }
            DataRegionConfiguration dataRegionCfg = PageMemoryImpl.this.getDataRegionConfiguration();
            throw new IgniteOutOfMemoryException("Failed to find a page for eviction [segmentCapacity=" + cap + ", loaded=" + this.loadedPages.size() + ", maxDirtyPages=" + this.maxDirtyPages + ", dirtyPages=" + this.dirtyPages.size() + ", cpPages=" + (this.checkpointPages == null ? 0 : this.checkpointPages.size()) + ", pinnedInSegment=" + pinnedCnt + ", failedToPrepare=" + failToPrepare + ']' + U.nl() + "Out of memory in data region [name=" + dataRegionCfg.getName() + ", initSize=" + U.readableSize(dataRegionCfg.getInitialSize(), false) + ", maxSize=" + U.readableSize(dataRegionCfg.getMaxSize(), false) + ", persistenceEnabled=" + dataRegionCfg.isPersistenceEnabled() + "] Try the following:" + U.nl() + "  ^-- Increase maximum off-heap memory size (DataRegionConfiguration.maxSize)" + U.nl() + "  ^-- Enable Ignite persistence (DataRegionConfiguration.persistenceEnabled)" + U.nl() + "  ^-- Enable eviction or expiration policies");
        }

        private long absolute(long relPtr) {
            return this.pool.absolute(relPtr);
        }

        private int partGeneration(int grpId, int partId) {
            assert (this.getReadHoldCount() > 0 || this.getWriteHoldCount() > 0);
            Integer tag = this.partGenerationMap.get(new GroupPartitionId(grpId, partId));
            assert (tag == null || tag >= 0) : "Negative tag=" + tag;
            return tag == null ? 1 : tag;
        }

        private int incrementPartGeneration(int grpId, int partId) {
            assert (this.getWriteHoldCount() > 0);
            GroupPartitionId grpPart = new GroupPartitionId(grpId, partId);
            Integer gen = this.partGenerationMap.get(grpPart);
            if (gen == null) {
                gen = 1;
            }
            if (gen == Integer.MAX_VALUE) {
                U.warn(PageMemoryImpl.this.log, "Partition tag overflow [grpId=" + grpId + ", partId=" + partId + "]");
                this.partGenerationMap.put(grpPart, 0);
                return 0;
            }
            this.partGenerationMap.put(grpPart, gen + 1);
            return gen + 1;
        }

        private void resetGroupPartitionsGeneration(int grpId) {
            assert (this.getWriteHoldCount() > 0);
            this.partGenerationMap.keySet().removeIf(grpPart -> grpPart.getGroupId() == grpId);
        }
    }

    private class PagePool {
        protected final int idx;
        protected final DirectMemoryRegion region;
        protected final AtomicInteger pagesCntr;
        protected long lastAllocatedIdxPtr;
        protected long freePageListPtr;
        protected long pagesBase;

        protected PagePool(int idx, DirectMemoryRegion region, AtomicInteger pagesCntr) {
            long base;
            this.idx = idx;
            this.region = region;
            this.pagesCntr = pagesCntr;
            this.freePageListPtr = base = region.address() + 7L & 0xFFFFFFFFFFFFFFF8L;
            this.lastAllocatedIdxPtr = base += 8L;
            this.pagesBase = base += 8L;
            GridUnsafe.putLong(this.freePageListPtr, 0xFFFFFFFFFFFFFFL);
            GridUnsafe.putLong(this.lastAllocatedIdxPtr, 1L);
        }

        private long borrowOrAllocateFreePage(long pageId) throws GridOffHeapOutOfMemoryException {
            long relPtr;
            if (this.pagesCntr != null) {
                this.pagesCntr.getAndIncrement();
            }
            return (relPtr = this.borrowFreePage()) != 0xFFFFFFFFFFFFFFL ? relPtr : this.allocateFreePage(pageId);
        }

        private long borrowFreePage() {
            long freePageRelPtrMasked;
            long freePageRelPtr;
            while ((freePageRelPtr = (freePageRelPtrMasked = GridUnsafe.getLong(this.freePageListPtr)) & 0xFFFFFFFFFFFFFFL) != 0xFFFFFFFFFFFFFFL) {
                long cnt;
                long freePageAbsPtr = this.absolute(freePageRelPtr);
                long nextFreePageRelPtr = GridUnsafe.getLong(freePageAbsPtr) & 0xFFFFFFFFFFFFFFL;
                if (!GridUnsafe.compareAndSwapLong(null, this.freePageListPtr, freePageRelPtrMasked, nextFreePageRelPtr | (cnt = (freePageRelPtrMasked & 0xFF00000000000000L) + 0x100000000000000L & 0xFF00000000000000L))) continue;
                GridUnsafe.putLong(freePageAbsPtr, 1L);
                return freePageRelPtr;
            }
            return 0xFFFFFFFFFFFFFFL;
        }

        private long allocateFreePage(long pageId) throws GridOffHeapOutOfMemoryException {
            long lastIdx;
            long limit = this.region.address() + this.region.size();
            do {
                if (this.pagesBase + ((lastIdx = GridUnsafe.getLong(this.lastAllocatedIdxPtr)) + 1L) * (long)PageMemoryImpl.this.sysPageSize <= limit) continue;
                return 0xFFFFFFFFFFFFFFL;
            } while (!GridUnsafe.compareAndSwapLong(null, this.lastAllocatedIdxPtr, lastIdx, lastIdx + 1L));
            long absPtr = this.pagesBase + lastIdx * (long)PageMemoryImpl.this.sysPageSize;
            assert ((lastIdx & 0xFFFFFF0000000000L) == 0L);
            long relative = this.relative(lastIdx);
            assert (relative != 0xFFFFFFFFFFFFFFL);
            PageHeader.initNew(absPtr, relative);
            PageMemoryImpl.this.rwLock.init(absPtr + 32L, PageIdUtils.tag(pageId));
            return relative;
        }

        private void releaseFreePage(long relPtr) {
            long freePageRelPtrMasked;
            long absPtr = this.absolute(relPtr);
            assert (!PageHeader.isAcquired(absPtr)) : "Release pinned page: " + PageHeader.access$3800(absPtr);
            if (this.pagesCntr != null) {
                this.pagesCntr.getAndDecrement();
            }
            do {
                freePageRelPtrMasked = GridUnsafe.getLong(this.freePageListPtr);
                long freePageRelPtr = freePageRelPtrMasked & 0xFFFFFFFFFFFFFFL;
                GridUnsafe.putLong(absPtr, freePageRelPtr);
            } while (!GridUnsafe.compareAndSwapLong(null, this.freePageListPtr, freePageRelPtrMasked, relPtr));
        }

        long absolute(long relativePtr) {
            int segIdx = (int)(relativePtr >> 40 & 0xFFFFL);
            assert (segIdx == this.idx) : "expected=" + this.idx + ", actual=" + segIdx;
            long pageIdx = relativePtr & 0xFFFFFFFFFFL;
            long off = pageIdx * (long)PageMemoryImpl.this.sysPageSize;
            return this.pagesBase + off;
        }

        private long relative(long pageIdx) {
            return pageIdx | (long)this.idx << 40;
        }

        private int pages() {
            return (int)((this.region.size() - (this.pagesBase - this.region.address())) / (long)PageMemoryImpl.this.sysPageSize);
        }
    }
}

