/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IntervalBasedMeasurement {
    private static final long NANOS_IN_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private AtomicReference<MeasurementInterval> measurementIntervalAtomicRef = new AtomicReference();
    private final long intervalSwitchNanos;
    private final int maxMeasurements;
    private final ConcurrentLinkedQueue<MeasurementInterval> prevMeasurements = new ConcurrentLinkedQueue();

    IntervalBasedMeasurement() {
        this(-1, 3);
    }

    IntervalBasedMeasurement(int intervalSwitchMs, int maxMeasurements) {
        this.intervalSwitchNanos = intervalSwitchMs > 0 ? (long)intervalSwitchMs * TimeUnit.MILLISECONDS.toNanos(1L) : -1L;
        this.maxMeasurements = maxMeasurements;
    }

    long getSpeedOpsPerSec(long curNanoTime) {
        return this.calcSpeed(this.interval(curNanoTime), curNanoTime);
    }

    long getSpeedOpsPerSecReadOnly() {
        MeasurementInterval interval = this.measurementIntervalAtomicRef.get();
        long curNanoTime = System.nanoTime();
        return this.calcSpeed(interval, curNanoTime);
    }

    private long calcSpeed(@Nullable MeasurementInterval interval, long curNanoTime) {
        long nanosPassed = 0L;
        long opsDone = 0L;
        if (!this.isOutdated(interval, curNanoTime)) {
            nanosPassed += curNanoTime - interval.startNanoTime;
            opsDone += interval.cntr.get();
        }
        for (MeasurementInterval prevMeasurement : this.prevMeasurements) {
            if (this.isOutdated(prevMeasurement, curNanoTime)) continue;
            nanosPassed += prevMeasurement.endNanoTime - prevMeasurement.startNanoTime;
            opsDone += prevMeasurement.cntr.get();
        }
        return nanosPassed <= 0L ? 0L : opsDone * NANOS_IN_SECOND / nanosPassed;
    }

    private boolean isOutdated(@Nullable MeasurementInterval interval, long curNanoTime) {
        if (interval == null) {
            return true;
        }
        long elapsedNs = curNanoTime - interval.startNanoTime;
        if (elapsedNs <= 0L) {
            return true;
        }
        return this.intervalSwitchNanos > 0L && elapsedNs > (long)(this.maxMeasurements + 1) * this.intervalSwitchNanos;
    }

    @NotNull
    private MeasurementInterval interval(long curNanoTime) {
        MeasurementInterval interval;
        do {
            MeasurementInterval newInterval;
            if ((interval = this.measurementIntervalAtomicRef.get()) == null) {
                newInterval = new MeasurementInterval(curNanoTime);
                if (!this.measurementIntervalAtomicRef.compareAndSet(null, newInterval)) continue;
                interval = newInterval;
            }
            if (this.intervalSwitchNanos <= 0L || curNanoTime - interval.startNanoTime <= this.intervalSwitchNanos || !this.measurementIntervalAtomicRef.compareAndSet(interval, newInterval = new MeasurementInterval(curNanoTime))) continue;
            interval.endNanoTime = curNanoTime;
            this.pushToHistory(interval);
        } while (interval == null);
        return interval;
    }

    private void pushToHistory(MeasurementInterval interval) {
        this.prevMeasurements.offer(interval);
        if (this.prevMeasurements.size() > this.maxMeasurements) {
            this.prevMeasurements.remove();
        }
    }

    void setCounter(long val, long curNanoTime) {
        this.interval(curNanoTime).cntr.set(val);
    }

    void finishInterval() {
        MeasurementInterval interval;
        do {
            if ((interval = this.measurementIntervalAtomicRef.get()) != null) continue;
            return;
        } while (!this.measurementIntervalAtomicRef.compareAndSet(interval, null));
        interval.endNanoTime = System.nanoTime();
        this.pushToHistory(interval);
    }

    public long getAverage() {
        long time = System.nanoTime();
        return this.avgMeasurementWithHistorical(this.interval(time), time);
    }

    private long avgMeasurementWithHistorical(@Nullable MeasurementInterval interval, long curNanoTime) {
        long cnt = 0L;
        long sum2 = 0L;
        if (!this.isOutdated(interval, curNanoTime)) {
            cnt += interval.cntr.get();
            sum2 += interval.sum.get();
        }
        for (MeasurementInterval prevMeasurement : this.prevMeasurements) {
            if (this.isOutdated(prevMeasurement, curNanoTime)) continue;
            cnt += prevMeasurement.cntr.get();
            sum2 += prevMeasurement.sum.get();
        }
        return cnt <= 0L ? 0L : sum2 / cnt;
    }

    void addMeasurementForAverageCalculation(long val) {
        MeasurementInterval interval = this.interval(System.nanoTime());
        interval.cntr.incrementAndGet();
        interval.sum.addAndGet(val);
    }

    private static class MeasurementInterval {
        private AtomicLong cntr = new AtomicLong();
        private AtomicLong sum = new AtomicLong();
        private final long startNanoTime;
        private volatile long endNanoTime;

        MeasurementInterval(long startNanoTime) {
            this.startNanoTime = startNanoTime;
        }
    }
}

