/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.metastorage;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.MetastoreDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageInitRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IncompleteObject;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.DbCheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.freelist.AbstractFreeList;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageDataRow;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageRowStore;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageTree;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPagePayload;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.SimpleDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.jetbrains.annotations.NotNull;

public class MetaStorage
implements DbCheckpointListener,
ReadOnlyMetastorage,
ReadWriteMetastorage {
    public static final String METASTORAGE_CACHE_NAME = "MetaStorage";
    public static final int METASTORAGE_CACHE_ID = CU.cacheId("MetaStorage");
    private static final byte[] TOMBSTONE = new byte[0];
    private final IgniteWriteAheadLogManager wal;
    private final DataRegion dataRegion;
    private final IgniteLogger log;
    private MetastorageTree tree;
    private AtomicLong rmvId = new AtomicLong();
    private DataRegionMetricsImpl regionMetrics;
    private boolean readOnly;
    private boolean empty;
    private RootPage treeRoot;
    private RootPage reuseListRoot;
    private FreeListImpl freeList;
    private Map<String, byte[]> lastUpdates;
    private final Marshaller marshaller = new JdkMarshaller();
    private final FailureProcessor failureProcessor;

    public MetaStorage(GridCacheSharedContext cctx, DataRegion dataRegion, DataRegionMetricsImpl regionMetrics, boolean readOnly) {
        this.wal = cctx.wal();
        this.dataRegion = dataRegion;
        this.regionMetrics = regionMetrics;
        this.readOnly = readOnly;
        this.log = cctx.logger(this.getClass());
        this.failureProcessor = cctx.kernalContext().failure();
    }

    public MetaStorage(GridCacheSharedContext cctx, DataRegion memPlc, DataRegionMetricsImpl memMetrics) {
        this(cctx, memPlc, memMetrics, false);
    }

    public void init(IgniteCacheDatabaseSharedManager db) throws IgniteCheckedException {
        this.getOrAllocateMetas();
        if (!this.empty) {
            this.freeList = new FreeListImpl(METASTORAGE_CACHE_ID, "metastorage", this.regionMetrics, this.dataRegion, null, this.wal, this.reuseListRoot.pageId().pageId(), this.reuseListRoot.isAllocated());
            MetastorageRowStore rowStore = new MetastorageRowStore(this.freeList, db);
            this.tree = new MetastorageTree(METASTORAGE_CACHE_ID, this.dataRegion.pageMemory(), this.wal, this.rmvId, this.freeList, rowStore, this.treeRoot.pageId().pageId(), this.treeRoot.isAllocated(), this.failureProcessor);
            if (!this.readOnly) {
                ((GridCacheDatabaseSharedManager)db).addCheckpointListener(this);
            }
        }
    }

    @Override
    public Serializable read(String key) throws IgniteCheckedException {
        byte[] data = this.getData(key);
        Object result2 = null;
        if (data != null) {
            result2 = this.marshaller.unmarshal(data, this.getClass().getClassLoader());
        }
        return result2;
    }

    @Override
    public Map<String, ? extends Serializable> readForPredicate(IgnitePredicate<String> keyPred) throws IgniteCheckedException {
        Map<String, Serializable> res = null;
        if (this.readOnly) {
            if (this.empty) {
                return Collections.emptyMap();
            }
            if (this.lastUpdates != null) {
                for (Map.Entry<String, byte[]> lastUpdate : this.lastUpdates.entrySet()) {
                    byte[] valBytes;
                    if (!keyPred.apply(lastUpdate.getKey()) || (valBytes = lastUpdate.getValue()) == TOMBSTONE) continue;
                    if (res == null) {
                        res = new HashMap();
                    }
                    Serializable val = (Serializable)this.marshaller.unmarshal(valBytes, this.getClass().getClassLoader());
                    res.put(lastUpdate.getKey(), val);
                }
            }
        }
        GridCursor cur = this.tree.find(null, null);
        while (cur.next()) {
            MetastorageDataRow row = (MetastorageDataRow)cur.get();
            String key = row.key();
            byte[] valBytes = row.value();
            if (!keyPred.apply(key) || this.lastUpdates != null && this.lastUpdates.containsKey(key)) continue;
            if (res == null) {
                res = new HashMap();
            }
            Serializable val = (Serializable)this.marshaller.unmarshal(valBytes, this.getClass().getClassLoader());
            res.put(key, val);
        }
        if (res == null) {
            res = Collections.emptyMap();
        }
        return res;
    }

    @Override
    public void write(@NotNull String key, @NotNull Serializable val) throws IgniteCheckedException {
        assert (val != null);
        byte[] data = this.marshaller.marshal(val);
        this.putData(key, data);
    }

    @Override
    public void remove(@NotNull String key) throws IgniteCheckedException {
        this.removeData(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putData(String key, byte[] data) throws IgniteCheckedException {
        if (!this.readOnly) {
            WALPointer ptr = this.wal.log(new MetastoreDataRecord(key, data));
            this.wal.flush(ptr, false);
            MetaStorage metaStorage = this;
            synchronized (metaStorage) {
                MetastorageDataRow oldRow = (MetastorageDataRow)this.tree.findOne(new MetastorageDataRow(key, null));
                if (oldRow != null) {
                    this.tree.removex(oldRow);
                    this.tree.rowStore().removeRow(oldRow.link());
                }
                MetastorageDataRow row = new MetastorageDataRow(key, data);
                this.tree.rowStore().addRow(row);
                this.tree.put(row);
            }
        }
    }

    public byte[] getData(String key) throws IgniteCheckedException {
        MetastorageDataRow row;
        if (this.readOnly) {
            byte[] res;
            if (this.lastUpdates != null && (res = this.lastUpdates.get(key)) != null) {
                return (byte[])(res != TOMBSTONE ? res : null);
            }
            if (this.empty) {
                return null;
            }
        }
        if ((row = (MetastorageDataRow)this.tree.findOne(new MetastorageDataRow(key, null))) == null) {
            return null;
        }
        return row.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeData(String key) throws IgniteCheckedException {
        if (!this.readOnly) {
            WALPointer ptr = this.wal.log(new MetastoreDataRecord(key, null));
            this.wal.flush(ptr, false);
            MetaStorage metaStorage = this;
            synchronized (metaStorage) {
                MetastorageDataRow row = new MetastorageDataRow(key, null);
                MetastorageDataRow oldRow = (MetastorageDataRow)this.tree.findOne(row);
                if (oldRow != null) {
                    this.tree.removex(oldRow);
                    this.tree.rowStore().removeRow(oldRow.link());
                }
            }
        }
    }

    private void checkRootsPageIdFlag(long treeRoot, long reuseListRoot) throws StorageException {
        if (PageIdUtils.flag(treeRoot) != 1) {
            throw new StorageException("Wrong tree root page id flag: treeRoot=" + U.hexLong(treeRoot) + ", METASTORAGE_CACHE_ID=" + METASTORAGE_CACHE_ID);
        }
        if (PageIdUtils.flag(reuseListRoot) != 1) {
            throw new StorageException("Wrong reuse list root page id flag: reuseListRoot=" + U.hexLong(reuseListRoot) + ", METASTORAGE_CACHE_ID=" + METASTORAGE_CACHE_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getOrAllocateMetas() throws IgniteCheckedException {
        block18: {
            PageMemoryEx pageMem = (PageMemoryEx)this.dataRegion.pageMemory();
            int partId = 0;
            long partMetaId = pageMem.partitionMetaPageId(METASTORAGE_CACHE_ID, partId);
            long partMetaPage = pageMem.acquirePage(METASTORAGE_CACHE_ID, partMetaId);
            try {
                if (this.readOnly) {
                    long pageAddr = pageMem.readLock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
                    try {
                        if (PageIO.getType(pageAddr) != 14) {
                            this.empty = true;
                            return;
                        }
                        PagePartitionMetaIO io = (PagePartitionMetaIO)PageIO.getPageIO(pageAddr);
                        long treeRoot = io.getTreeRoot(pageAddr);
                        long reuseListRoot = io.getReuseListRoot(pageAddr);
                        this.checkRootsPageIdFlag(treeRoot, reuseListRoot);
                        this.treeRoot = new RootPage(new FullPageId(treeRoot, METASTORAGE_CACHE_ID), false);
                        this.reuseListRoot = new RootPage(new FullPageId(reuseListRoot, METASTORAGE_CACHE_ID), false);
                        this.rmvId.set(io.getGlobalRemoveId(pageAddr));
                        break block18;
                    }
                    finally {
                        pageMem.readUnlock(METASTORAGE_CACHE_ID, partId, partMetaPage);
                    }
                }
                boolean allocated = false;
                long pageAddr = pageMem.writeLock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
                try {
                    long reuseListRoot;
                    long treeRoot;
                    if (PageIO.getType(pageAddr) != 14) {
                        PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.latest();
                        io.initNewPage(pageAddr, partMetaId, pageMem.pageSize());
                        treeRoot = pageMem.allocatePage(METASTORAGE_CACHE_ID, partId, (byte)1);
                        reuseListRoot = pageMem.allocatePage(METASTORAGE_CACHE_ID, partId, (byte)1);
                        assert (PageIdUtils.flag(treeRoot) == 1);
                        assert (PageIdUtils.flag(reuseListRoot) == 1);
                        io.setTreeRoot(pageAddr, treeRoot);
                        io.setReuseListRoot(pageAddr, reuseListRoot);
                        if (PageHandler.isWalDeltaRecordNeeded(pageMem, METASTORAGE_CACHE_ID, partMetaId, partMetaPage, this.wal, null)) {
                            this.wal.log(new MetaPageInitRecord(METASTORAGE_CACHE_ID, partMetaId, io.getType(), io.getVersion(), treeRoot, reuseListRoot));
                        }
                        allocated = true;
                    } else {
                        PagePartitionMetaIO io = (PagePartitionMetaIO)PageIO.getPageIO(pageAddr);
                        treeRoot = io.getTreeRoot(pageAddr);
                        reuseListRoot = io.getReuseListRoot(pageAddr);
                        this.rmvId.set(io.getGlobalRemoveId(pageAddr));
                        this.checkRootsPageIdFlag(treeRoot, reuseListRoot);
                    }
                    this.treeRoot = new RootPage(new FullPageId(treeRoot, METASTORAGE_CACHE_ID), allocated);
                    this.reuseListRoot = new RootPage(new FullPageId(reuseListRoot, METASTORAGE_CACHE_ID), allocated);
                }
                finally {
                    pageMem.writeUnlock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage, null, allocated);
                }
            }
            finally {
                pageMem.releasePage(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
            }
        }
    }

    public PageMemory pageMemory() {
        return this.dataRegion.pageMemory();
    }

    @Override
    public void onCheckpointBegin(DbCheckpointListener.Context ctx) throws IgniteCheckedException {
        Executor executor = ctx.executor();
        if (executor == null) {
            this.freeList.saveMetadata();
            this.saveStoreMetadata();
        } else {
            executor.execute(() -> {
                try {
                    this.freeList.saveMetadata();
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            });
            executor.execute(() -> {
                try {
                    this.saveStoreMetadata();
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStoreMetadata() throws IgniteCheckedException {
        PageMemoryEx pageMem = (PageMemoryEx)this.pageMemory();
        int partId = 0;
        long partMetaId = pageMem.partitionMetaPageId(METASTORAGE_CACHE_ID, partId);
        long partMetaPage = pageMem.acquirePage(METASTORAGE_CACHE_ID, partMetaId);
        try {
            long partMetaPageAddr = pageMem.writeLock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
            if (partMetaPageAddr == 0L) {
                U.warn(this.log, "Failed to acquire write lock for meta page [metaPage=" + partMetaPage + ']');
                return;
            }
            boolean changed = false;
            try {
                PagePartitionMetaIO io = (PagePartitionMetaIO)PageIO.getPageIO(partMetaPageAddr);
                changed |= io.setGlobalRemoveId(partMetaPageAddr, this.rmvId.get());
            }
            finally {
                pageMem.writeUnlock(METASTORAGE_CACHE_ID, partMetaId, partMetaPage, null, changed);
            }
        }
        finally {
            pageMem.releasePage(METASTORAGE_CACHE_ID, partMetaId, partMetaPage);
        }
    }

    public void applyUpdate(String key, byte[] value2) throws IgniteCheckedException {
        if (this.readOnly) {
            if (this.lastUpdates == null) {
                this.lastUpdates = new HashMap<String, byte[]>();
            }
            this.lastUpdates.put(key, value2 != null ? value2 : TOMBSTONE);
        } else if (value2 != null) {
            this.putData(key, value2);
        } else {
            this.removeData(key);
        }
    }

    public static class FreeListImpl
    extends AbstractFreeList<MetastorageDataRow> {
        FreeListImpl(int cacheId, String name, DataRegionMetricsImpl regionMetrics, DataRegion dataRegion, ReuseList reuseList, IgniteWriteAheadLogManager wal, long metaPageId, boolean initNew) throws IgniteCheckedException {
            super(cacheId, name, regionMetrics, dataRegion, reuseList, wal, metaPageId, initNew);
        }

        @Override
        public IOVersions<? extends AbstractDataPageIO<MetastorageDataRow>> ioVersions() {
            return SimpleDataPageIO.VERSIONS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final MetastorageDataRow readRow(String key, long link) throws IgniteCheckedException {
            assert (link != 0L) : "link";
            long nextLink = link;
            IncompleteObject incomplete = null;
            int size2 = 0;
            boolean first = true;
            do {
                long pageId = PageIdUtils.pageId(nextLink);
                long page = this.pageMem.acquirePage(this.grpId, pageId);
                try {
                    long pageAddr = this.pageMem.readLock(this.grpId, pageId, page);
                    assert (pageAddr != 0L) : nextLink;
                    try {
                        SimpleDataPageIO io = (SimpleDataPageIO)this.ioVersions().forPage(pageAddr);
                        DataPagePayload data = io.readPayload(pageAddr, PageIdUtils.itemId(nextLink), this.pageMem.pageSize());
                        nextLink = data.nextLink();
                        if (first) {
                            if (nextLink == 0L) {
                                MetastorageDataRow metastorageDataRow = new MetastorageDataRow(link, key, SimpleDataPageIO.readPayload(pageAddr + (long)data.offset()));
                                return metastorageDataRow;
                            }
                            first = false;
                        }
                        ByteBuffer buf = this.pageMem.pageBuffer(pageAddr);
                        buf.position(data.offset());
                        buf.limit(data.offset() + data.payloadSize());
                        if (size2 == 0) {
                            if (buf.remaining() >= 4 && incomplete == null) {
                                size2 = buf.getInt();
                                incomplete = new IncompleteObject(new byte[size2]);
                            } else {
                                if (incomplete == null) {
                                    incomplete = new IncompleteObject(new byte[4]);
                                }
                                incomplete.readData(buf);
                                if (incomplete.isReady()) {
                                    size2 = ByteBuffer.wrap(incomplete.data()).order(buf.order()).getInt();
                                    incomplete = new IncompleteObject(new byte[size2]);
                                }
                            }
                        }
                        if (size2 != 0 && buf.remaining() > 0) {
                            incomplete.readData(buf);
                        }
                    }
                    finally {
                        this.pageMem.readUnlock(this.grpId, pageId, page);
                    }
                }
                finally {
                    this.pageMem.releasePage(this.grpId, pageId, page);
                }
            } while (nextLink != 0L);
            assert (incomplete.isReady());
            return new MetastorageDataRow(link, key, incomplete.data());
        }
    }
}

