/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.ignite.internal.processors.cache.persistence.file.AbstractFileIO;

public class UnzipFileIO
extends AbstractFileIO {
    private final ZipInputStream zis;
    private final byte[] arr = new byte[131072];
    private final long size;
    private long totalBytesRead = 0L;

    public UnzipFileIO(File zip2) throws IOException {
        this.zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip2)));
        ZipEntry entry2 = this.zis.getNextEntry();
        this.size = entry2.getSize();
    }

    @Override
    public long position() throws IOException {
        return this.totalBytesRead;
    }

    @Override
    public void position(long newPosition) throws IOException {
        int bytesToRead;
        if (newPosition == this.totalBytesRead) {
            return;
        }
        if (newPosition < this.totalBytesRead) {
            throw new UnsupportedOperationException("Seeking backwards is not supported.");
        }
        for (long bytesRemaining = newPosition - this.totalBytesRead; bytesRemaining > 0L; bytesRemaining -= (long)this.zis.read(this.arr, 0, bytesToRead)) {
            bytesToRead = bytesRemaining > (long)this.arr.length ? this.arr.length : (int)bytesRemaining;
        }
    }

    @Override
    public int read(ByteBuffer dstBuf) throws IOException {
        int bytesRead = this.zis.read(this.arr, 0, Math.min(dstBuf.remaining(), this.arr.length));
        if (bytesRead == -1) {
            return -1;
        }
        dstBuf.put(this.arr, 0, bytesRead);
        this.totalBytesRead += (long)bytesRead;
        return bytesRead;
    }

    @Override
    public int read(ByteBuffer dstBuf, long position2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int write(ByteBuffer srcBuf) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int write(ByteBuffer srcBuf, long position2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int write(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void force() throws IOException {
        this.force(false);
    }

    @Override
    public void force(boolean withMetadata) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long size() throws IOException {
        return this.size;
    }

    @Override
    public void clear() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MappedByteBuffer map(int sizeBytes) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.zis.close();
    }
}

