/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;

public class FileUploader {
    private static final int CHUNK_SIZE = 0x100000;
    private final Path path;

    public FileUploader(Path path2) {
        this.path = path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(SocketChannel writeChannel, GridFutureAdapter<Long> finishFut) {
        AbstractInterruptibleChannel readChannel = null;
        try {
            long written;
            File file = new File(this.path.toUri().getPath());
            if (!file.exists()) {
                finishFut.onDone(new IgniteCheckedException(new FileNotFoundException(file.getAbsolutePath())));
                return;
            }
            readChannel = FileChannel.open(this.path, StandardOpenOption.READ);
            long size2 = ((FileChannel)readChannel).size();
            for (written = 0L; written < size2; written += ((FileChannel)readChannel).transferTo(written, 0x100000L, writeChannel)) {
            }
            finishFut.onDone(written);
        }
        catch (IOException ex) {
            finishFut.onDone(ex);
        }
        finally {
            try {
                if (writeChannel != null) {
                    writeChannel.close();
                }
            }
            catch (IOException ex) {
                throw new IgniteException("Could not close socket.");
            }
            try {
                if (readChannel != null) {
                    readChannel.close();
                }
            }
            catch (IOException ex) {
                throw new IgniteException("Could not close file: " + this.path);
            }
        }
    }
}

