/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.apache.ignite.internal.managers.encryption.GridEncryptionManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.PureJavaCrc32;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.spi.encryption.EncryptionSpi;

public class EncryptedFileIO
implements FileIO {
    private final FileIO plainFileIO;
    private final int groupId;
    private final int pageSize;
    private final int headerSize;
    private final GridEncryptionManager encMgr;
    private final EncryptionSpi encSpi;
    private Serializable encKey;
    private final int encryptionOverhead;
    private final byte[] zeroes;

    EncryptedFileIO(FileIO plainFileIO, int groupId, int pageSize, int headerSize, GridEncryptionManager encMgr, EncryptionSpi encSpi) {
        this.plainFileIO = plainFileIO;
        this.groupId = groupId;
        this.pageSize = pageSize;
        this.headerSize = headerSize;
        this.encMgr = encMgr;
        this.encSpi = encSpi;
        this.encryptionOverhead = pageSize - CU.encryptedPageSize(pageSize, encSpi);
        this.zeroes = new byte[this.encryptionOverhead];
    }

    @Override
    public long position() throws IOException {
        return this.plainFileIO.position();
    }

    @Override
    public void position(long newPosition) throws IOException {
        this.plainFileIO.position(newPosition);
    }

    @Override
    public int read(ByteBuffer destBuf) throws IOException {
        assert (this.position() == 0L);
        return this.plainFileIO.read(destBuf);
    }

    @Override
    public int readFully(ByteBuffer destBuf) throws IOException {
        return this.read(destBuf);
    }

    @Override
    public int read(ByteBuffer destBuf, long position2) throws IOException {
        assert (destBuf.remaining() >= this.pageSize);
        assert (this.position() != 0L);
        ByteBuffer encrypted = ByteBuffer.allocate(this.pageSize);
        int res = this.plainFileIO.read(encrypted, position2);
        if (res < 0) {
            return res;
        }
        if (res != this.pageSize) {
            throw new IllegalStateException("Expecting to read whole page[" + this.pageSize + " bytes], but read only " + res + " bytes");
        }
        encrypted.rewind();
        this.decrypt(encrypted, destBuf);
        return res;
    }

    @Override
    public int readFully(ByteBuffer destBuf, long position2) throws IOException {
        assert (destBuf.capacity() == this.pageSize);
        assert (this.position() != 0L);
        ByteBuffer encrypted = ByteBuffer.allocate(this.pageSize);
        int res = this.plainFileIO.readFully(encrypted, position2);
        if (res < 0) {
            return res;
        }
        if (res != this.pageSize) {
            throw new IllegalStateException("Expecting to read whole page[" + this.pageSize + " bytes], but read only " + res + " bytes");
        }
        encrypted.rewind();
        this.decrypt(encrypted, destBuf);
        return res;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException("Encrypted File doesn't support this operation");
    }

    @Override
    public int readFully(byte[] buf, int off, int len) throws IOException {
        return this.read(buf, off, len);
    }

    @Override
    public int write(ByteBuffer srcBuf) throws IOException {
        assert (this.position() == 0L);
        assert (this.headerSize == srcBuf.capacity());
        return this.plainFileIO.write(srcBuf);
    }

    @Override
    public int writeFully(ByteBuffer srcBuf) throws IOException {
        return this.write(srcBuf);
    }

    @Override
    public int write(ByteBuffer srcBuf, long position2) throws IOException {
        ByteBuffer encrypted = ByteBuffer.allocate(this.pageSize);
        this.encrypt(srcBuf, encrypted);
        encrypted.rewind();
        return this.plainFileIO.write(encrypted, position2);
    }

    @Override
    public int writeFully(ByteBuffer srcBuf, long position2) throws IOException {
        ByteBuffer encrypted = ByteBuffer.allocate(this.pageSize);
        this.encrypt(srcBuf, encrypted);
        encrypted.rewind();
        return this.plainFileIO.writeFully(encrypted, position2);
    }

    private void encrypt(ByteBuffer srcBuf, ByteBuffer res) throws IOException {
        assert (this.position() != 0L);
        assert (srcBuf.remaining() >= this.pageSize);
        assert (this.tailIsEmpty(srcBuf, PageIO.getType(srcBuf)));
        int srcLimit = srcBuf.limit();
        srcBuf.limit(srcBuf.position() + this.plainDataSize());
        this.encSpi.encryptNoPadding(srcBuf, this.key(), res);
        res.rewind();
        this.storeCRC(res);
        srcBuf.limit(srcLimit);
        srcBuf.position(srcBuf.position() + this.encryptionOverhead);
    }

    private void decrypt(ByteBuffer encrypted, ByteBuffer destBuf) throws IOException {
        assert (encrypted.remaining() >= this.pageSize);
        assert (encrypted.limit() >= this.pageSize);
        this.checkCRC(encrypted);
        encrypted.limit(this.encryptedDataSize());
        this.encSpi.decryptNoPadding(encrypted, this.key(), destBuf);
        destBuf.put(this.zeroes);
    }

    private void storeCRC(ByteBuffer res) {
        int crc = PureJavaCrc32.calcCrc32(res, this.encryptedDataSize());
        res.put((byte)(crc >> 24));
        res.put((byte)(crc >> 16));
        res.put((byte)(crc >> 8));
        res.put((byte)crc);
    }

    private void checkCRC(ByteBuffer encrypted) throws IOException {
        int crc = PureJavaCrc32.calcCrc32(encrypted, this.encryptedDataSize());
        int storedCrc = 0;
        storedCrc |= encrypted.get() << 24;
        storedCrc |= (encrypted.get() & 0xFF) << 16;
        storedCrc |= (encrypted.get() & 0xFF) << 8;
        if (crc != (storedCrc |= encrypted.get() & 0xFF)) {
            throw new IOException("Content of encrypted page is broken. [StoredCrc=" + storedCrc + ", calculatedCrd=" + crc + "]");
        }
        encrypted.position(encrypted.position() - (this.encryptedDataSize() + 4));
    }

    private int encryptedDataSize() {
        return this.pageSize - this.encSpi.blockSize();
    }

    private int plainDataSize() {
        return this.pageSize - this.encryptionOverhead;
    }

    private boolean tailIsEmpty(ByteBuffer src, int pageType) {
        int srcPos = src.position();
        src.position(srcPos + this.plainDataSize());
        for (int i = 0; i < this.encryptionOverhead; ++i) {
            assert (src.get() == 0) : "Tail of src should be empty [i=" + i + ", pageType=" + pageType + "]";
        }
        src.position(srcPos);
        return true;
    }

    private Serializable key() {
        if (this.encKey == null) {
            this.encKey = this.encMgr.groupKey(this.groupId);
            return this.encKey;
        }
        return this.encKey;
    }

    @Override
    public int write(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException("Encrypted File doesn't support this operation");
    }

    @Override
    public int writeFully(byte[] buf, int off, int len) throws IOException {
        return this.write(buf, off, len);
    }

    @Override
    public MappedByteBuffer map(int sizeBytes) throws IOException {
        throw new UnsupportedOperationException("Encrypted File doesn't support this operation");
    }

    @Override
    public void force() throws IOException {
        this.plainFileIO.force();
    }

    @Override
    public void force(boolean withMetadata) throws IOException {
        this.plainFileIO.force(withMetadata);
    }

    @Override
    public long size() throws IOException {
        return this.plainFileIO.size();
    }

    @Override
    public void clear() throws IOException {
        this.plainFileIO.clear();
    }

    @Override
    public void close() throws IOException {
        this.plainFileIO.close();
    }
}

