/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageSupport;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageInitRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdateNextSnapshotId;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdatePartitionDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionDestroyRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManagerImpl;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteHistoricalIterator;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.DbCheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IndexStorage;
import org.apache.ignite.internal.processors.cache.persistence.IndexStorageImpl;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.RowStore;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.freelist.CacheFreeListImpl;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PagesAllocationRange;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PartitionAllocationMap;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionCountersIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIOV2;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseListImpl;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.tree.CacheDataRowStore;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.cache.tree.PendingEntriesTree;
import org.apache.ignite.internal.processors.cache.tree.PendingRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccUpdateResult;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccLinkAwareSearchRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class GridCacheOffheapManager
extends IgniteCacheOffheapManagerImpl
implements DbCheckpointListener {
    private IndexStorage indexStorage;
    private ReuseListImpl reuseList;
    public static final GridCursor<CacheDataRow> EMPTY_CURSOR = new GridCursor<CacheDataRow>(){

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public CacheDataRow get() {
            return null;
        }
    };

    @Override
    protected void initPendingTree(GridCacheContext cctx) throws IgniteCheckedException {
    }

    @Override
    protected void initDataStructures() throws IgniteCheckedException {
        assert (this.ctx.database().checkpointLockIsHeldByThread());
        Metas metas = this.getOrAllocateCacheMetas();
        RootPage reuseListRoot = metas.reuseListRoot;
        this.reuseList = new ReuseListImpl(this.grp.groupId(), this.grp.cacheOrGroupName(), this.grp.dataRegion().pageMemory(), this.ctx.wal(), reuseListRoot.pageId().pageId(), reuseListRoot.isAllocated());
        RootPage metastoreRoot = metas.treeRoot;
        this.indexStorage = new IndexStorageImpl(this.grp.dataRegion().pageMemory(), this.ctx.wal(), this.globalRemoveId(), this.grp.groupId(), 65535, 2, this.reuseList, metastoreRoot.pageId().pageId(), metastoreRoot.isAllocated(), this.ctx.kernalContext().failure());
        ((GridCacheDatabaseSharedManager)this.ctx.database()).addCheckpointListener(this);
    }

    public IndexStorage getIndexStorage() {
        return this.indexStorage;
    }

    @Override
    protected IgniteCacheOffheapManager.CacheDataStore createCacheDataStore0(int p) throws IgniteCheckedException {
        if (this.ctx.database() instanceof GridCacheDatabaseSharedManager) {
            ((GridCacheDatabaseSharedManager)this.ctx.database()).cancelOrWaitPartitionDestroy(this.grp.groupId(), p);
        }
        boolean exists2 = this.ctx.pageStore() != null && this.ctx.pageStore().exists(this.grp.groupId(), p);
        return new GridCacheDataStore(p, exists2);
    }

    @Override
    public void onCheckpointBegin(DbCheckpointListener.Context ctx) throws IgniteCheckedException {
        assert (this.grp.dataRegion().pageMemory() instanceof PageMemoryEx);
        Executor execSvc = ctx.executor();
        boolean needSnapshot = ctx.nextSnapshot() && ctx.needToSnapshot(this.grp.cacheOrGroupName());
        boolean hasNonEmptyGroups = false;
        for (IgniteCacheOffheapManager.CacheDataStore store : this.partDataStores.values()) {
            if (!this.notEmpty(store)) continue;
            hasNonEmptyGroups = true;
            break;
        }
        if (needSnapshot && hasNonEmptyGroups) {
            if (execSvc == null) {
                this.updateSnapshotTag(ctx);
            } else {
                execSvc.execute(() -> {
                    try {
                        this.updateSnapshotTag(ctx);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                });
            }
        }
        if (execSvc == null) {
            this.reuseList.saveMetadata();
            for (IgniteCacheOffheapManager.CacheDataStore store : this.partDataStores.values()) {
                this.saveStoreMetadata(store, ctx, false, needSnapshot);
            }
        } else {
            execSvc.execute(() -> {
                try {
                    this.reuseList.saveMetadata();
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            });
            for (IgniteCacheOffheapManager.CacheDataStore store : this.partDataStores.values()) {
                execSvc.execute(() -> {
                    try {
                        this.saveStoreMetadata(store, ctx, false, needSnapshot);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                });
            }
        }
    }

    private boolean notEmpty(IgniteCacheOffheapManager.CacheDataStore store) {
        return store.rowStore() != null && (store.fullSize() > 0L || store.updateCounter() > 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveStoreMetadata(IgniteCacheOffheapManager.CacheDataStore store, DbCheckpointListener.Context ctx, boolean beforeDestroy, boolean needSnapshot) throws IgniteCheckedException {
        RowStore rowStore0 = store.rowStore();
        if (rowStore0 != null) {
            CacheFreeListImpl freeList = (CacheFreeListImpl)rowStore0.freeList();
            freeList.saveMetadata();
            long updCntr = store.updateCounter();
            long size2 = store.fullSize();
            long rmvId = this.globalRemoveId().get();
            PageMemoryEx pageMem = (PageMemoryEx)this.grp.dataRegion().pageMemory();
            IgniteWriteAheadLogManager wal = this.ctx.wal();
            if (size2 > 0L || updCntr > 0L) {
                GridDhtPartitionState state = null;
                GridDhtLocalPartition part = null;
                if (!this.grp.isLocal()) {
                    if (beforeDestroy) {
                        state = GridDhtPartitionState.EVICTED;
                    } else {
                        part = this.getPartition(store);
                        if (part != null && part.state() != GridDhtPartitionState.EVICTED) {
                            state = part.state();
                        }
                    }
                    if (state == null) {
                        return;
                    }
                }
                int grpId = this.grp.groupId();
                long partMetaId = pageMem.partitionMetaPageId(grpId, store.partId());
                long partMetaPage = pageMem.acquirePage(grpId, partMetaId);
                try {
                    long partMetaPageAddr = pageMem.writeLock(grpId, partMetaId, partMetaPage);
                    if (partMetaPageAddr == 0L) {
                        U.warn(this.log, "Failed to acquire write lock for meta page [metaPage=" + partMetaPage + ", beforeDestroy=" + beforeDestroy + ", size=" + size2 + ", updCntr=" + updCntr + ", state=" + (Object)((Object)state) + ']');
                        return;
                    }
                    boolean changed = false;
                    try {
                        int pageCnt;
                        long cntrsPageId;
                        PagePartitionMetaIO io = (PagePartitionMetaIO)PageIO.getPageIO(partMetaPageAddr);
                        changed |= io.setUpdateCounter(partMetaPageAddr, updCntr);
                        changed |= io.setGlobalRemoveId(partMetaPageAddr, rmvId);
                        changed |= io.setSize(partMetaPageAddr, size2);
                        if (state != null) {
                            changed |= io.setPartitionState(partMetaPageAddr, (byte)state.ordinal());
                        } else assert (this.grp.isLocal()) : this.grp.cacheOrGroupName();
                        if (this.grp.sharedGroup()) {
                            long initCntrPageId = io.getCountersPageId(partMetaPageAddr);
                            Map<Integer, Long> newSizes = store.cacheSizes();
                            Map<Integer, Long> prevSizes = GridCacheOffheapManager.readSharedGroupCacheSizes(pageMem, grpId, initCntrPageId);
                            if (prevSizes != null && prevSizes.equals(newSizes)) {
                                cntrsPageId = initCntrPageId;
                            } else {
                                cntrsPageId = GridCacheOffheapManager.writeSharedGroupCacheSizes(pageMem, grpId, initCntrPageId, store.partId(), newSizes);
                                if (initCntrPageId == 0L && cntrsPageId != 0L) {
                                    io.setCountersPageId(partMetaPageAddr, cntrsPageId);
                                    changed = true;
                                }
                            }
                        } else {
                            cntrsPageId = 0L;
                        }
                        if (needSnapshot) {
                            pageCnt = this.ctx.pageStore().pages(grpId, store.partId());
                            io.setCandidatePageCount(partMetaPageAddr, size2 == 0L ? 0 : pageCnt);
                            if (state == GridDhtPartitionState.OWNING) {
                                assert (part != null);
                                if (!GridCacheOffheapManager.addPartition(part, ctx.partitionStatMap(), partMetaPageAddr, io, grpId, store.partId(), this.ctx.pageStore().pages(grpId, store.partId()), store.fullSize())) {
                                    U.warn(this.log, "Partition was concurrently evicted grpId=" + grpId + ", partitionId=" + part.id());
                                }
                            } else if ((state == GridDhtPartitionState.MOVING || state == GridDhtPartitionState.RENTING) && ctx.partitionStatMap().forceSkipIndexPartition(grpId) && this.log.isInfoEnabled()) {
                                this.log.info("Will not include SQL indexes to snapshot because there is a partition not in " + (Object)((Object)GridDhtPartitionState.OWNING) + " state [grp=" + this.grp.cacheOrGroupName() + ", partId=" + store.partId() + ", state=" + (Object)((Object)state) + ']');
                            }
                            changed = true;
                        } else {
                            pageCnt = io.getCandidatePageCount(partMetaPageAddr);
                        }
                        if (!PageHandler.isWalDeltaRecordNeeded(pageMem, grpId, partMetaId, partMetaPage, wal, null)) return;
                        wal.log(new MetaPageUpdatePartitionDataRecord(grpId, partMetaId, updCntr, rmvId, (int)size2, cntrsPageId, (byte)(state == null ? -1 : (byte)state.ordinal()), pageCnt));
                        return;
                    }
                    finally {
                        pageMem.writeUnlock(grpId, partMetaId, partMetaPage, null, changed);
                    }
                }
                finally {
                    pageMem.releasePage(grpId, partMetaId, partMetaPage);
                }
            } else {
                if (!needSnapshot) return;
                this.tryAddEmptyPartitionToSnapshot(store, ctx);
            }
            return;
        } else {
            if (!needSnapshot) return;
            this.tryAddEmptyPartitionToSnapshot(store, ctx);
        }
    }

    private void tryAddEmptyPartitionToSnapshot(IgniteCacheOffheapManager.CacheDataStore store, DbCheckpointListener.Context ctx) {
        if (this.getPartition(store).state() == GridDhtPartitionState.OWNING) {
            ctx.partitionStatMap().put(new GroupPartitionId(this.grp.groupId(), store.partId()), new PagesAllocationRange(0, 0));
        }
    }

    private GridDhtLocalPartition getPartition(IgniteCacheOffheapManager.CacheDataStore store) {
        return this.grp.topology().localPartition(store.partId(), AffinityTopologyVersion.NONE, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Map<Integer, Long> readSharedGroupCacheSizes(PageSupport pageMem, int grpId, long cntrsPageId) throws IgniteCheckedException {
        if (cntrsPageId == 0L) {
            return null;
        }
        HashMap<Integer, Long> cacheSizes = new HashMap<Integer, Long>();
        long nextId = cntrsPageId;
        while (true) {
            long curId = nextId;
            long curPage = pageMem.acquirePage(grpId, curId);
            try {
                long curAddr = pageMem.readLock(grpId, curId, curPage);
                assert (curAddr != 0L);
                try {
                    PagePartitionCountersIO cntrsIO = (PagePartitionCountersIO)PageIO.getPageIO(curAddr);
                    if (!cntrsIO.readCacheSizes(curAddr, cacheSizes)) {
                        nextId = cntrsIO.getNextCountersPageId(curAddr);
                        assert (nextId != 0L);
                        continue;
                    }
                }
                finally {
                    pageMem.readUnlock(grpId, curId, curPage);
                    continue;
                }
            }
            finally {
                pageMem.releasePage(grpId, curId, curPage);
                continue;
            }
            break;
        }
        return cacheSizes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long writeSharedGroupCacheSizes(PageMemory pageMem, int grpId, long cntrsPageId, int partId, Map<Integer, Long> sizes) throws IgniteCheckedException {
        boolean init2;
        byte[] data = PagePartitionCountersIO.VERSIONS.latest().serializeCacheSizes(sizes);
        int items = data.length / 12;
        boolean bl = init2 = cntrsPageId == 0L;
        if (init2 && !sizes.isEmpty()) {
            cntrsPageId = pageMem.allocatePage(grpId, partId, (byte)1);
        }
        long nextId = cntrsPageId;
        int written = 0;
        while (written != items) {
            long curId = nextId;
            long curPage = pageMem.acquirePage(grpId, curId);
            try {
                long curAddr = pageMem.writeLock(grpId, curId, curPage);
                assert (curAddr != 0L);
                try {
                    PagePartitionCountersIO partCntrIo;
                    if (init2) {
                        partCntrIo = PagePartitionCountersIO.VERSIONS.latest();
                        partCntrIo.initNewPage(curAddr, curId, pageMem.realPageSize(grpId));
                    } else {
                        partCntrIo = (PagePartitionCountersIO)PageIO.getPageIO(curAddr);
                    }
                    written += partCntrIo.writeCacheSizes(pageMem.realPageSize(grpId), curAddr, data, written);
                    nextId = partCntrIo.getNextCountersPageId(curAddr);
                    if (written == items || !(init2 = nextId == 0L)) continue;
                    nextId = pageMem.allocatePage(grpId, partId, (byte)1);
                    partCntrIo.setNextCountersPageId(curAddr, nextId);
                }
                finally {
                    pageMem.writeUnlock(grpId, curId, curPage, Boolean.TRUE, true);
                }
            }
            finally {
                pageMem.releasePage(grpId, curId, curPage);
            }
        }
        return cntrsPageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSnapshotTag(DbCheckpointListener.Context ctx) throws IgniteCheckedException {
        int grpId = this.grp.groupId();
        PageMemoryEx pageMem = (PageMemoryEx)this.grp.dataRegion().pageMemory();
        IgniteWriteAheadLogManager wal = this.ctx.wal();
        long metaPageId = pageMem.metaPageId(grpId);
        long metaPage = pageMem.acquirePage(grpId, metaPageId);
        try {
            long metaPageAddr = pageMem.writeLock(grpId, metaPageId, metaPage);
            try {
                PageMetaIO metaIo = (PageMetaIO)PageMetaIO.getPageIO(metaPageAddr);
                long nextSnapshotTag = metaIo.getNextSnapshotTag(metaPageAddr);
                metaIo.setNextSnapshotTag(metaPageAddr, nextSnapshotTag + 1L);
                if (this.log != null && this.log.isDebugEnabled()) {
                    this.log.debug("Save next snapshot before checkpoint start for grId = " + grpId + ", nextSnapshotTag = " + nextSnapshotTag);
                }
                if (PageHandler.isWalDeltaRecordNeeded(pageMem, grpId, metaPageId, metaPage, wal, null)) {
                    wal.log(new MetaPageUpdateNextSnapshotId(grpId, metaPageId, nextSnapshotTag + 1L));
                }
                GridCacheOffheapManager.addPartition(null, ctx.partitionStatMap(), metaPageAddr, metaIo, grpId, 65535, this.ctx.pageStore().pages(grpId, 65535), -1L);
            }
            finally {
                pageMem.writeUnlock(grpId, metaPageId, metaPage, null, true);
            }
        }
        finally {
            pageMem.releasePage(grpId, metaPageId, metaPage);
        }
    }

    private static boolean addPartition(GridDhtLocalPartition part, PartitionAllocationMap map2, long metaPageAddr, PageMetaIO io, int grpId, int partId, int currAllocatedPageCnt, long partSize) {
        if (part != null) {
            boolean reserved = part.reserve();
            if (!reserved) {
                return false;
            }
        } else assert (partId == 65535) : partId;
        assert (PageIO.getPageId(metaPageAddr) != 0L);
        int lastAllocatedPageCnt = io.getLastAllocatedPageCount(metaPageAddr);
        int curPageCnt = partSize == 0L ? 0 : currAllocatedPageCnt;
        map2.put(new GroupPartitionId(grpId, partId), new PagesAllocationRange(lastAllocatedPageCnt, curPageCnt));
        return true;
    }

    @Override
    protected void destroyCacheDataStore0(IgniteCacheOffheapManager.CacheDataStore store) throws IgniteCheckedException {
        assert (this.ctx.database() instanceof GridCacheDatabaseSharedManager) : "Destroying cache data store when persistence is not enabled: " + this.ctx.database();
        int partId = store.partId();
        this.ctx.database().checkpointReadLock();
        try {
            this.saveStoreMetadata(store, null, true, false);
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
        ((GridCacheDatabaseSharedManager)this.ctx.database()).schedulePartitionDestroy(this.grp.groupId(), partId);
    }

    public void destroyPartitionStore(int grpId, int partId) throws IgniteCheckedException {
        PageMemoryEx pageMemory = (PageMemoryEx)this.grp.dataRegion().pageMemory();
        int tag = pageMemory.invalidate(this.grp.groupId(), partId);
        if (this.grp.walEnabled()) {
            this.ctx.wal().log(new PartitionDestroyRecord(this.grp.groupId(), partId));
        }
        this.ctx.pageStore().onPartitionDestroyed(grpId, partId, tag);
    }

    @Override
    public void onPartitionCounterUpdated(int part, long cntr) {
        IgniteCacheOffheapManager.CacheDataStore store = (IgniteCacheOffheapManager.CacheDataStore)this.partDataStores.get(part);
        assert (store != null);
        long oldCnt = store.updateCounter();
        if (oldCnt < cntr) {
            store.updateCounter(cntr);
        }
    }

    @Override
    public void onPartitionInitialCounterUpdated(int part, long cntr) {
        IgniteCacheOffheapManager.CacheDataStore store = (IgniteCacheOffheapManager.CacheDataStore)this.partDataStores.get(part);
        assert (store != null);
        long oldCnt = store.initialUpdateCounter();
        if (oldCnt < cntr) {
            store.updateInitialCounter(cntr);
        }
    }

    @Override
    public long lastUpdatedPartitionCounter(int part) {
        return ((IgniteCacheOffheapManager.CacheDataStore)this.partDataStores.get(part)).updateCounter();
    }

    @Override
    public RootPage rootPageForIndex(int cacheId, String idxName) throws IgniteCheckedException {
        if (this.grp.sharedGroup()) {
            idxName = Integer.toString(cacheId) + "_" + idxName;
        }
        return this.indexStorage.getOrAllocateForTree(idxName);
    }

    @Override
    public void dropRootPageForIndex(int cacheId, String idxName) throws IgniteCheckedException {
        if (this.grp.sharedGroup()) {
            idxName = Integer.toString(cacheId) + "_" + idxName;
        }
        this.indexStorage.dropRootPage(idxName);
    }

    @Override
    public ReuseList reuseListForIndex(String idxName) {
        return this.reuseList;
    }

    @Override
    public void stop() {
        if (this.grp.affinityNode()) {
            ((GridCacheDatabaseSharedManager)this.ctx.database()).removeCheckpointListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Metas getOrAllocateCacheMetas() throws IgniteCheckedException {
        PageMemoryEx pageMem = (PageMemoryEx)this.grp.dataRegion().pageMemory();
        IgniteWriteAheadLogManager wal = this.ctx.wal();
        int grpId = this.grp.groupId();
        long metaId = pageMem.metaPageId(grpId);
        long metaPage = pageMem.acquirePage(grpId, metaId);
        try {
            Metas metas;
            long pageAddr = pageMem.writeLock(grpId, metaId, metaPage);
            boolean allocated = false;
            try {
                long reuseListRoot;
                long metastoreRoot;
                PageMetaIO pageIO;
                if (PageIO.getType(pageAddr) != 11) {
                    pageIO = PageMetaIO.VERSIONS.latest();
                    pageIO.initNewPage(pageAddr, metaId, pageMem.realPageSize(grpId));
                    metastoreRoot = pageMem.allocatePage(grpId, 65535, (byte)2);
                    reuseListRoot = pageMem.allocatePage(grpId, 65535, (byte)2);
                    pageIO.setTreeRoot(pageAddr, metastoreRoot);
                    pageIO.setReuseListRoot(pageAddr, reuseListRoot);
                    if (PageHandler.isWalDeltaRecordNeeded(pageMem, grpId, metaId, metaPage, wal, null)) {
                        wal.log(new MetaPageInitRecord(grpId, metaId, pageIO.getType(), pageIO.getVersion(), metastoreRoot, reuseListRoot));
                    }
                    allocated = true;
                } else {
                    pageIO = (PageMetaIO)PageIO.getPageIO(pageAddr);
                    metastoreRoot = pageIO.getTreeRoot(pageAddr);
                    reuseListRoot = pageIO.getReuseListRoot(pageAddr);
                    assert (reuseListRoot != 0L);
                }
                metas = new Metas(new RootPage(new FullPageId(metastoreRoot, grpId), allocated), new RootPage(new FullPageId(reuseListRoot, grpId), allocated), null);
            }
            catch (Throwable throwable2) {
                pageMem.writeUnlock(grpId, metaId, metaPage, null, allocated);
                throw throwable2;
            }
            pageMem.writeUnlock(grpId, metaId, metaPage, null, allocated);
            return metas;
        }
        finally {
            pageMem.releasePage(grpId, metaId, metaPage);
        }
    }

    @Override
    @Nullable
    protected IgniteHistoricalIterator historicalIterator(CachePartitionPartialCountersMap partCntrs, Set<Integer> missing) throws IgniteCheckedException {
        if (partCntrs == null || partCntrs.isEmpty()) {
            return null;
        }
        if (this.grp.mvccEnabled()) {
            return super.historicalIterator(partCntrs, missing);
        }
        GridCacheDatabaseSharedManager database = (GridCacheDatabaseSharedManager)this.grp.shared().database();
        FileWALPointer minPtr = null;
        for (int i = 0; i < partCntrs.size(); ++i) {
            int p = partCntrs.partitionAt(i);
            long initCntr = partCntrs.initialUpdateCounterAt(i);
            FileWALPointer startPtr = (FileWALPointer)database.checkpointHistory().searchPartitionCounter(this.grp.groupId(), p, initCntr);
            if (startPtr == null) {
                throw new IgniteCheckedException("Could not find start pointer for partition [part=" + p + ", partCntrSince=" + initCntr + "]");
            }
            if (minPtr != null && startPtr.compareTo(minPtr) >= 0) continue;
            minPtr = startPtr;
        }
        WALIterator it = this.grp.shared().wal().replay(minPtr);
        WALHistoricalIterator iterator2 = new WALHistoricalIterator(this.grp, partCntrs, it);
        missing.addAll(iterator2.missingParts);
        return iterator2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean expire(GridCacheContext cctx, IgniteInClosure2X<GridCacheEntryEx, GridCacheVersion> c, int amount) throws IgniteCheckedException {
        assert (!cctx.isNear()) : cctx.name();
        if (!this.hasPendingEntries || this.nextCleanTime > U.currentTimeMillis()) {
            return false;
        }
        if (!this.busyLock.enterBusy()) {
            return false;
        }
        try {
            int cleared = 0;
            for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
                cleared += ((GridCacheDataStore)store).purgeExpired(cctx, c, amount - cleared);
                if (amount == -1 || cleared < amount) continue;
                boolean bl = true;
                return bl;
            }
            if (cleared < amount) {
                this.nextCleanTime = U.currentTimeMillis() + UNWIND_THROTTLING_TIMEOUT;
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
        return false;
    }

    @Override
    public long expiredSize() throws IgniteCheckedException {
        long size2 = 0L;
        for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
            size2 += ((GridCacheDataStore)store).expiredSize();
        }
        return size2;
    }

    long freeSpace() {
        long freeSpace = 0L;
        for (IgniteCacheOffheapManager.CacheDataStore store : this.partDataStores.values()) {
            assert (store instanceof GridCacheDataStore);
            CacheFreeListImpl freeList = ((GridCacheDataStore)store).freeList;
            if (freeList == null) continue;
            freeSpace += freeList.freeSpace();
        }
        return freeSpace;
    }

    static /* synthetic */ CacheGroupContext access$4200(GridCacheOffheapManager x0) {
        return x0.grp;
    }

    static /* synthetic */ GridCacheSharedContext access$4300(GridCacheOffheapManager x0) {
        return x0.ctx;
    }

    public class GridCacheDataStore
    implements IgniteCacheOffheapManager.CacheDataStore {
        private final int partId;
        private String name;
        private volatile CacheFreeListImpl freeList;
        private PendingEntriesTree pendingTree;
        private volatile IgniteCacheOffheapManager.CacheDataStore delegate;
        private volatile long nextStoreCleanTime;
        private final boolean exists;
        private final AtomicBoolean init = new AtomicBoolean();
        private final CountDownLatch latch = new CountDownLatch(1);

        private GridCacheDataStore(int partId, boolean exists2) {
            this.partId = partId;
            this.exists = exists2;
            this.name = GridCacheOffheapManager.this.treeName(partId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IgniteCacheOffheapManager.CacheDataStore init0(boolean checkExists) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate0 = this.delegate;
            if (delegate0 != null) {
                return delegate0;
            }
            if (checkExists && !this.exists) {
                return null;
            }
            if (this.init.compareAndSet(false, true)) {
                IgniteCacheDatabaseSharedManager dbMgr = GridCacheOffheapManager.this.ctx.database();
                dbMgr.checkpointReadLock();
                try {
                    Metas metas = this.getOrAllocatePartitionMetas();
                    RootPage reuseRoot = metas.reuseListRoot;
                    this.freeList = new CacheFreeListImpl(GridCacheOffheapManager.this.grp.groupId(), GridCacheOffheapManager.this.grp.cacheOrGroupName() + "-" + this.partId, GridCacheOffheapManager.this.grp.dataRegion().memoryMetrics(), GridCacheOffheapManager.this.grp.dataRegion(), null, GridCacheOffheapManager.this.ctx.wal(), reuseRoot.pageId().pageId(), reuseRoot.isAllocated()){

                        @Override
                        protected long allocatePageNoReuse() throws IgniteCheckedException {
                            assert (GridCacheOffheapManager.this.grp.shared().database().checkpointLockIsHeldByThread());
                            return this.pageMem.allocatePage(this.grpId, GridCacheDataStore.this.partId, (byte)1);
                        }
                    };
                    CacheDataRowStore rowStore = new CacheDataRowStore(GridCacheOffheapManager.this.grp, this.freeList, this.partId);
                    RootPage treeRoot = metas.treeRoot;
                    CacheDataTree dataTree = new CacheDataTree(GridCacheOffheapManager.this.grp, this.name, this.freeList, rowStore, treeRoot.pageId().pageId(), treeRoot.isAllocated()){

                        @Override
                        protected long allocatePageNoReuse() throws IgniteCheckedException {
                            assert (GridCacheOffheapManager.this.grp.shared().database().checkpointLockIsHeldByThread());
                            return this.pageMem.allocatePage(this.grpId, GridCacheDataStore.this.partId, (byte)1);
                        }
                    };
                    RootPage pendingTreeRoot = metas.pendingTreeRoot;
                    final PendingEntriesTree pendingTree0 = new PendingEntriesTree(GridCacheOffheapManager.this.grp, "PendingEntries-" + this.partId, GridCacheOffheapManager.this.grp.dataRegion().pageMemory(), pendingTreeRoot.pageId().pageId(), this.freeList, pendingTreeRoot.isAllocated()){

                        @Override
                        protected long allocatePageNoReuse() throws IgniteCheckedException {
                            assert (GridCacheOffheapManager.this.grp.shared().database().checkpointLockIsHeldByThread());
                            return this.pageMem.allocatePage(this.grpId, GridCacheDataStore.this.partId, (byte)1);
                        }
                    };
                    PageMemoryEx pageMem = (PageMemoryEx)GridCacheOffheapManager.this.grp.dataRegion().pageMemory();
                    delegate0 = new IgniteCacheOffheapManagerImpl.CacheDataStoreImpl(this.partId, this.name, rowStore, dataTree){

                        @Override
                        public PendingEntriesTree pendingTree() {
                            return pendingTree0;
                        }
                    };
                    this.pendingTree = pendingTree0;
                    if (!GridCacheOffheapManager.this.hasPendingEntries && pendingTree0.size() > 0L) {
                        GridCacheOffheapManager.this.hasPendingEntries = true;
                    }
                    int grpId = GridCacheOffheapManager.this.grp.groupId();
                    long partMetaId = pageMem.partitionMetaPageId(grpId, this.partId);
                    long partMetaPage = pageMem.acquirePage(grpId, partMetaId);
                    try {
                        long pageAddr = pageMem.readLock(grpId, partMetaId, partMetaPage);
                        try {
                            if (PageIO.getType(pageAddr) != 0) {
                                PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.latest();
                                Map cacheSizes = null;
                                if (GridCacheOffheapManager.this.grp.sharedGroup()) {
                                    cacheSizes = GridCacheOffheapManager.readSharedGroupCacheSizes(pageMem, grpId, io.getCountersPageId(pageAddr));
                                }
                                delegate0.init(io.getSize(pageAddr), io.getUpdateCounter(pageAddr), cacheSizes);
                                GridCacheOffheapManager.this.globalRemoveId().setIfGreater(io.getGlobalRemoveId(pageAddr));
                            }
                        }
                        finally {
                            pageMem.readUnlock(grpId, partMetaId, partMetaPage);
                        }
                    }
                    finally {
                        pageMem.releasePage(grpId, partMetaId, partMetaPage);
                    }
                    this.delegate = delegate0;
                }
                catch (Throwable ex) {
                    U.error(GridCacheOffheapManager.this.log, "Unhandled exception during page store initialization. All further operations will be failed and local node will be stopped.", ex);
                    GridCacheOffheapManager.this.ctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, ex));
                    throw ex;
                }
                finally {
                    this.latch.countDown();
                    dbMgr.checkpointReadUnlock();
                }
            }
            U.await(this.latch);
            delegate0 = this.delegate;
            if (delegate0 == null) {
                throw new IgniteCheckedException("Cache store initialization failed.");
            }
            return delegate0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Metas getOrAllocatePartitionMetas() throws IgniteCheckedException {
            PageMemoryEx pageMem = (PageMemoryEx)GridCacheOffheapManager.this.grp.dataRegion().pageMemory();
            IgniteWriteAheadLogManager wal = GridCacheOffheapManager.this.ctx.wal();
            int grpId = GridCacheOffheapManager.this.grp.groupId();
            long partMetaId = pageMem.partitionMetaPageId(grpId, this.partId);
            long partMetaPage = pageMem.acquirePage(grpId, partMetaId);
            try {
                Metas metas;
                boolean allocated = false;
                boolean pendingTreeAllocated = false;
                long pageAddr = pageMem.writeLock(grpId, partMetaId, partMetaPage);
                try {
                    long pendingTreeRoot;
                    long reuseListRoot;
                    long treeRoot;
                    PagePartitionMetaIO io;
                    if (PageIO.getType(pageAddr) != 14) {
                        io = PagePartitionMetaIO.VERSIONS.latest();
                        io.initNewPage(pageAddr, partMetaId, pageMem.realPageSize(grpId));
                        treeRoot = pageMem.allocatePage(grpId, this.partId, (byte)1);
                        reuseListRoot = pageMem.allocatePage(grpId, this.partId, (byte)1);
                        pendingTreeRoot = pageMem.allocatePage(grpId, this.partId, (byte)1);
                        assert (PageIdUtils.flag(treeRoot) == 1);
                        assert (PageIdUtils.flag(reuseListRoot) == 1);
                        assert (PageIdUtils.flag(pendingTreeRoot) == 1);
                        io.setTreeRoot(pageAddr, treeRoot);
                        io.setReuseListRoot(pageAddr, reuseListRoot);
                        io.setPendingTreeRoot(pageAddr, pendingTreeRoot);
                        if (PageHandler.isWalDeltaRecordNeeded(pageMem, grpId, partMetaId, partMetaPage, wal, null)) {
                            wal.log(new PageSnapshot(new FullPageId(partMetaId, grpId), pageAddr, pageMem.pageSize(), pageMem.realPageSize(grpId)));
                        }
                        allocated = true;
                    } else {
                        io = (PagePartitionMetaIO)PageIO.getPageIO(pageAddr);
                        treeRoot = io.getTreeRoot(pageAddr);
                        reuseListRoot = io.getReuseListRoot(pageAddr);
                        int pageVersion = PagePartitionMetaIO.getVersion(pageAddr);
                        if (pageVersion < 2) {
                            assert (pageVersion == 1);
                            if (GridCacheOffheapManager.this.log.isDebugEnabled()) {
                                GridCacheOffheapManager.this.log.info("Upgrade partition meta page version: [part=" + this.partId + ", grpId=" + grpId + ", oldVer=" + pageVersion + ", newVer=" + io.getVersion());
                            }
                            io = PagePartitionMetaIO.VERSIONS.latest();
                            ((PagePartitionMetaIOV2)io).upgradePage(pageAddr);
                            pendingTreeRoot = pageMem.allocatePage(grpId, this.partId, (byte)1);
                            io.setPendingTreeRoot(pageAddr, pendingTreeRoot);
                            if (PageHandler.isWalDeltaRecordNeeded(pageMem, grpId, partMetaId, partMetaPage, wal, null)) {
                                wal.log(new PageSnapshot(new FullPageId(partMetaId, grpId), pageAddr, pageMem.pageSize(), pageMem.realPageSize(grpId)));
                            }
                            pendingTreeAllocated = true;
                        } else {
                            pendingTreeRoot = io.getPendingTreeRoot(pageAddr);
                        }
                        if (PageIdUtils.flag(treeRoot) != 1) {
                            throw new StorageException("Wrong tree root page id flag: treeRoot=" + U.hexLong(treeRoot) + ", part=" + this.partId + ", grpId=" + grpId);
                        }
                        if (PageIdUtils.flag(reuseListRoot) != 1) {
                            throw new StorageException("Wrong reuse list root page id flag: reuseListRoot=" + U.hexLong(reuseListRoot) + ", part=" + this.partId + ", grpId=" + grpId);
                        }
                        if (PageIdUtils.flag(pendingTreeRoot) != 1) {
                            throw new StorageException("Wrong pending tree root page id flag: reuseListRoot=" + U.hexLong(reuseListRoot) + ", part=" + this.partId + ", grpId=" + grpId);
                        }
                    }
                    metas = new Metas(new RootPage(new FullPageId(treeRoot, grpId), allocated), new RootPage(new FullPageId(reuseListRoot, grpId), allocated), new RootPage(new FullPageId(pendingTreeRoot, grpId), allocated || pendingTreeAllocated));
                    pageMem.writeUnlock(grpId, partMetaId, partMetaPage, null, allocated || pendingTreeAllocated);
                }
                catch (Throwable throwable2) {
                    pageMem.writeUnlock(grpId, partMetaId, partMetaPage, null, allocated || pendingTreeAllocated);
                    throw throwable2;
                }
                return metas;
            }
            finally {
                pageMem.releasePage(grpId, partMetaId, partMetaPage);
            }
        }

        @Override
        public int partId() {
            return this.partId;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public RowStore rowStore() {
            IgniteCacheOffheapManager.CacheDataStore delegate0 = this.delegate;
            return delegate0 == null ? null : delegate0.rowStore();
        }

        @Override
        public long fullSize() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? 0L : delegate0.fullSize();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public long cacheSize(int cacheId) {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? 0L : delegate0.cacheSize(cacheId);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public Map<Integer, Long> cacheSizes() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? null : delegate0.cacheSizes();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void updateSize(int cacheId, long delta) {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(false);
                if (delegate0 != null) {
                    delegate0.updateSize(cacheId, delta);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public long updateCounter() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? 0L : delegate0.updateCounter();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public long getAndIncrementUpdateCounter(long delta) {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? 0L : delegate0.getAndIncrementUpdateCounter(delta);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void init(long size2, long updCntr, @Nullable Map<Integer, Long> cacheSizes) {
            throw new IllegalStateException("Should be never called.");
        }

        @Override
        public void updateCounter(long val) {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(false);
                if (delegate0 != null) {
                    delegate0.updateCounter(val);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void updateCounter(long start, long delta) {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(false);
                if (delegate0 != null) {
                    delegate0.updateCounter(start, delta);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void finalizeUpdateCountres() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                if (delegate0 != null) {
                    delegate0.finalizeUpdateCountres();
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public long nextUpdateCounter() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(false);
                return delegate0 == null ? 0L : delegate0.nextUpdateCounter();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public long initialUpdateCounter() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? 0L : delegate0.initialUpdateCounter();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void updateInitialCounter(long cntr) {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                if (delegate0 != null) {
                    delegate0.updateInitialCounter(cntr);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void setRowCacheCleaner(GridQueryRowCacheCleaner rowCacheCleaner) {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                if (delegate0 != null) {
                    delegate0.setRowCacheCleaner(rowCacheCleaner);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void update(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            assert (GridCacheOffheapManager.this.ctx.database().checkpointLockIsHeldByThread());
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            delegate.update(cctx, key, val, ver, expireTime, oldRow);
        }

        @Override
        public boolean mvccInitialValue(GridCacheContext cctx, KeyCacheObject key, @Nullable CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer, MvccVersion newMvccVer) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.mvccInitialValue(cctx, key, val, ver, expireTime, mvccVer, newMvccVer);
        }

        @Override
        public boolean mvccInitialValueIfAbsent(GridCacheContext cctx, KeyCacheObject key, @Nullable CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer, MvccVersion newMvccVer, byte txState, byte newTxState) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.mvccInitialValueIfAbsent(cctx, key, val, ver, expireTime, mvccVer, newMvccVer, txState, newTxState);
        }

        @Override
        public boolean mvccUpdateRowWithPreloadInfo(GridCacheContext cctx, KeyCacheObject key, @Nullable CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer, MvccVersion newMvccVer, byte mvccTxState, byte newMvccTxState) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.mvccUpdateRowWithPreloadInfo(cctx, key, val, ver, expireTime, mvccVer, newMvccVer, mvccTxState, newMvccTxState);
        }

        @Override
        public MvccUpdateResult mvccUpdate(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, MvccSnapshot mvccVer, CacheEntryPredicate filter2, EntryProcessor entryProc, Object[] invokeArgs, boolean primary, boolean needHistory, boolean noCreate, boolean needOldVal, boolean retVal) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.mvccUpdate(cctx, key, val, ver, expireTime, mvccVer, filter2, entryProc, invokeArgs, primary, needHistory, noCreate, needOldVal, retVal);
        }

        @Override
        public MvccUpdateResult mvccRemove(GridCacheContext cctx, KeyCacheObject key, MvccSnapshot mvccVer, CacheEntryPredicate filter2, boolean primary, boolean needHistory, boolean needOldVal, boolean retVal) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.mvccRemove(cctx, key, mvccVer, filter2, primary, needHistory, needOldVal, retVal);
        }

        @Override
        public MvccUpdateResult mvccLock(GridCacheContext cctx, KeyCacheObject key, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.mvccLock(cctx, key, mvccSnapshot);
        }

        @Override
        public GridLongList mvccUpdateNative(GridCacheContext cctx, boolean primary, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.mvccUpdateNative(cctx, primary, key, val, ver, expireTime, mvccSnapshot);
        }

        @Override
        public GridLongList mvccRemoveNative(GridCacheContext cctx, boolean primary, KeyCacheObject key, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.mvccRemoveNative(cctx, primary, key, mvccSnapshot);
        }

        @Override
        public void mvccRemoveAll(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            delegate.mvccRemoveAll(cctx, key);
        }

        @Override
        public void mvccApplyUpdate(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, MvccVersion mvccVer) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            delegate.mvccApplyUpdate(cctx, key, val, ver, expireTime, mvccVer);
        }

        @Override
        public CacheDataRow createRow(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            assert (GridCacheOffheapManager.this.ctx.database().checkpointLockIsHeldByThread());
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.createRow(cctx, key, val, ver, expireTime, oldRow);
        }

        @Override
        public int cleanup(GridCacheContext cctx, @Nullable List<MvccLinkAwareSearchRow> cleanupRows) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            return delegate.cleanup(cctx, cleanupRows);
        }

        @Override
        public void updateTxState(GridCacheContext cctx, CacheSearchRow row) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            delegate.updateTxState(cctx, row);
        }

        @Override
        public void invoke(GridCacheContext cctx, KeyCacheObject key, IgniteCacheOffheapManager.OffheapInvokeClosure c) throws IgniteCheckedException {
            assert (GridCacheOffheapManager.this.ctx.database().checkpointLockIsHeldByThread());
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            delegate.invoke(cctx, key, c);
        }

        @Override
        public void remove(GridCacheContext cctx, KeyCacheObject key, int partId) throws IgniteCheckedException {
            assert (GridCacheOffheapManager.this.ctx.database().checkpointLockIsHeldByThread());
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(false);
            delegate.remove(cctx, key, partId);
        }

        @Override
        public CacheDataRow find(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.find(cctx, key);
            }
            return null;
        }

        @Override
        public CacheDataRow mvccFind(GridCacheContext cctx, KeyCacheObject key, MvccSnapshot snapshot2) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.mvccFind(cctx, key, snapshot2);
            }
            return null;
        }

        @Override
        public List<IgniteBiTuple<Object, MvccVersion>> mvccFindAllVersions(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.mvccFindAllVersions(cctx, key);
            }
            return Collections.emptyList();
        }

        @Override
        public GridCursor<CacheDataRow> mvccAllVersionsCursor(GridCacheContext cctx, KeyCacheObject key, Object x) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.mvccAllVersionsCursor(cctx, key, x);
            }
            return EMPTY_CURSOR;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor() throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor();
            }
            return EMPTY_CURSOR;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(Object x) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(x);
            }
            return EMPTY_CURSOR;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(mvccSnapshot);
            }
            return EMPTY_CURSOR;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, KeyCacheObject lower, KeyCacheObject upper) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(cacheId, lower, upper);
            }
            return EMPTY_CURSOR;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, KeyCacheObject lower, KeyCacheObject upper, Object x) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(cacheId, lower, upper, x);
            }
            return EMPTY_CURSOR;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, KeyCacheObject lower, KeyCacheObject upper, Object x, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(cacheId, lower, upper, x, mvccSnapshot);
            }
            return EMPTY_CURSOR;
        }

        @Override
        public void destroy() throws IgniteCheckedException {
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(cacheId);
            }
            return EMPTY_CURSOR;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, MvccSnapshot mvccSnapshot) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate = this.init0(true);
            if (delegate != null) {
                return delegate.cursor(cacheId, mvccSnapshot);
            }
            return EMPTY_CURSOR;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear(int cacheId) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
            if (delegate0 == null) {
                return;
            }
            GridCacheOffheapManager.this.ctx.database().checkpointReadLock();
            try {
                if (this.pendingTree != null) {
                    PendingRow row = new PendingRow(cacheId);
                    GridCursor cursor = this.pendingTree.find(row, row, PendingEntriesTree.WITHOUT_KEY);
                    while (cursor.next()) {
                        PendingRow row0 = (PendingRow)cursor.get();
                        assert (row0.link != 0L) : row;
                        boolean res = this.pendingTree.removex(row0);
                        assert (res);
                    }
                }
                delegate0.clear(cacheId);
            }
            finally {
                GridCacheOffheapManager.this.ctx.database().checkpointReadUnlock();
            }
        }

        public long expiredSize() throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
            return delegate0 == null ? 0L : this.pendingTree.size();
        }

        public int purgeExpired(GridCacheContext cctx, IgniteInClosure2X<GridCacheEntryEx, GridCacheVersion> c, int amount) throws IgniteCheckedException {
            IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
            long now = U.currentTimeMillis();
            if (delegate0 == null || this.nextStoreCleanTime > now) {
                return 0;
            }
            assert (this.pendingTree != null) : "Partition data store was not initialized.";
            int cleared = this.purgeExpiredInternal(cctx, c, amount);
            if (cleared < amount) {
                this.nextStoreCleanTime = now + IgniteCacheOffheapManagerImpl.UNWIND_THROTTLING_TIMEOUT;
            }
            return cleared;
        }

        /*
         * Exception decompiling
         */
        private int purgeExpiredInternal(GridCacheContext cctx, IgniteInClosure2X<GridCacheEntryEx, GridCacheVersion> c, int amount) throws IgniteCheckedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[DOLOOP]], but top level block is 8[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public PendingEntriesTree pendingTree() {
            try {
                IgniteCacheOffheapManager.CacheDataStore delegate0 = this.init0(true);
                return delegate0 == null ? null : this.pendingTree;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
    }

    private static class Metas {
        @GridToStringInclude
        private final RootPage reuseListRoot;
        @GridToStringInclude
        private final RootPage treeRoot;
        @GridToStringInclude
        private final RootPage pendingTreeRoot;

        Metas(RootPage treeRoot, RootPage reuseListRoot, RootPage pendingTreeRoot) {
            this.treeRoot = treeRoot;
            this.reuseListRoot = reuseListRoot;
            this.pendingTreeRoot = pendingTreeRoot;
        }

        public String toString() {
            return S.toString(Metas.class, this);
        }
    }

    private static class DataEntryRow
    implements CacheDataRow {
        private final DataEntry entry;

        private DataEntryRow(DataEntry entry2) {
            this.entry = entry2;
        }

        @Override
        public KeyCacheObject key() {
            return this.entry.key();
        }

        @Override
        public void key(KeyCacheObject key) {
            throw new IllegalStateException();
        }

        @Override
        public CacheObject value() {
            return this.entry.value();
        }

        @Override
        public GridCacheVersion version() {
            return this.entry.writeVersion();
        }

        @Override
        public long expireTime() {
            return this.entry.expireTime();
        }

        @Override
        public int partition() {
            return this.entry.partitionId();
        }

        @Override
        public int size() throws IgniteCheckedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int headerSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long link() {
            return 0L;
        }

        @Override
        public void link(long link) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hash() {
            return this.entry.key().hashCode();
        }

        @Override
        public int cacheId() {
            return this.entry.cacheId();
        }

        @Override
        public long mvccCoordinatorVersion() {
            return 0L;
        }

        @Override
        public long mvccCounter() {
            return 0L;
        }

        @Override
        public int mvccOperationCounter() {
            return 0;
        }

        @Override
        public long newMvccCoordinatorVersion() {
            return 0L;
        }

        @Override
        public long newMvccCounter() {
            return 0L;
        }

        @Override
        public int newMvccOperationCounter() {
            return 0;
        }

        @Override
        public byte mvccTxState() {
            return 0;
        }

        @Override
        public byte newMvccTxState() {
            return 0;
        }
    }

    private static class WALHistoricalIterator
    implements IgniteHistoricalIterator {
        private static final long serialVersionUID = 0L;
        private final CacheGroupContext grp;
        private final CachePartitionPartialCountersMap partMap;
        private final Set<Integer> missingParts = new HashSet<Integer>();
        private final Set<Integer> doneParts = new HashSet<Integer>();
        private final Set<Integer> cacheIds;
        private WALIterator walIt;
        private Iterator<DataEntry> entryIt;
        private DataEntry next;
        private boolean reachedPartitionEnd;
        private boolean doneAllPartitions;

        private WALHistoricalIterator(CacheGroupContext grp, CachePartitionPartialCountersMap partMap, WALIterator walIt) {
            this.grp = grp;
            this.partMap = partMap;
            this.walIt = walIt;
            this.cacheIds = grp.cacheIds();
            this.reservePartitions();
            this.advance();
        }

        @Override
        public boolean contains(int partId) {
            return this.partMap.contains(partId);
        }

        @Override
        public boolean isDone(int partId) {
            return this.doneParts.contains(partId);
        }

        @Override
        public void close() throws IgniteCheckedException {
            this.walIt.close();
            this.releasePartitions();
        }

        @Override
        public boolean isClosed() {
            return this.walIt.isClosed();
        }

        @Override
        public boolean hasNextX() {
            return this.hasNext();
        }

        @Override
        public CacheDataRow nextX() throws IgniteCheckedException {
            return this.next();
        }

        @Override
        public void removeX() throws IgniteCheckedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<CacheDataRow> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public CacheDataRow next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            DataEntryRow val = new DataEntryRow(this.next);
            if (this.reachedPartitionEnd) {
                this.doneParts.add(this.next.partitionId());
                this.reachedPartitionEnd = false;
                if (this.doneParts.size() == this.partMap.size()) {
                    this.doneAllPartitions = true;
                }
            }
            this.advance();
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void reservePartitions() {
            for (int i = 0; i < this.partMap.size(); ++i) {
                int p = this.partMap.partitionAt(i);
                GridDhtLocalPartition part = this.grp.topology().localPartition(p);
                if (part == null || !part.reserve()) {
                    this.missingParts.add(p);
                    continue;
                }
                if (part.state() == GridDhtPartitionState.OWNING) continue;
                part.release();
                this.missingParts.add(p);
            }
        }

        private void releasePartitions() {
            for (int i = 0; i < this.partMap.size(); ++i) {
                int p = this.partMap.partitionAt(i);
                if (this.missingParts.contains(p)) continue;
                GridDhtLocalPartition part = this.grp.topology().localPartition(p);
                assert (part != null && part.state() == GridDhtPartitionState.OWNING && part.reservations() > 0) : "Partition should in OWNING state and has at least 1 reservation";
                part.release();
            }
        }

        private void advance() {
            this.next = null;
            if (this.doneAllPartitions) {
                return;
            }
            block0: do {
                if (this.entryIt != null) {
                    while (this.entryIt.hasNext()) {
                        int idx;
                        DataEntry entry2 = this.entryIt.next();
                        if (!this.cacheIds.contains(entry2.cacheId()) || (idx = this.partMap.partitionIndex(entry2.partitionId())) < 0 || this.missingParts.contains(idx)) continue;
                        long from2 = this.partMap.initialUpdateCounterAt(idx);
                        long to2 = this.partMap.updateCounterAt(idx);
                        if (entry2.partitionCounter() <= from2 || entry2.partitionCounter() > to2) continue;
                        if (entry2.partitionCounter() == to2) {
                            this.reachedPartitionEnd = true;
                        }
                        this.next = entry2;
                        return;
                    }
                }
                this.entryIt = null;
                while (this.walIt.hasNext()) {
                    IgniteBiTuple rec = (IgniteBiTuple)this.walIt.next();
                    if (!(rec.get2() instanceof DataRecord)) continue;
                    DataRecord data = (DataRecord)rec.get2();
                    this.entryIt = data.writeEntries().iterator();
                    continue block0;
                }
            } while (this.entryIt != null);
        }
    }
}

