/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.CacheGroupMetricsMXBeanImpl;
import org.apache.ignite.internal.processors.cache.persistence.AllocatedPageTracker;
import org.apache.ignite.internal.processors.cache.ratemetrics.HitRateMetrics;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteOutClosure;
import org.jetbrains.annotations.Nullable;

public class DataRegionMetricsImpl
implements DataRegionMetrics,
AllocatedPageTracker {
    private final IgniteOutClosure<Long> freeSpaceProvider;
    private final LongAdder totalAllocatedPages = new LongAdder();
    private final ConcurrentMap<Integer, CacheGroupMetricsMXBeanImpl.GroupAllocationTracker> grpAllocationTrackers = new ConcurrentHashMap<Integer, CacheGroupMetricsMXBeanImpl.GroupAllocationTracker>();
    private final LongAdder largeEntriesPages = new LongAdder();
    private final LongAdder dirtyPages = new LongAdder();
    private final LongAdder readPages = new LongAdder();
    private final LongAdder writtenPages = new LongAdder();
    private final LongAdder replacedPages = new LongAdder();
    private final AtomicLong offHeapSize = new AtomicLong();
    private final AtomicLong checkpointBufferSize = new AtomicLong();
    private volatile boolean metricsEnabled;
    private boolean persistenceEnabled;
    private volatile int subInts;
    private volatile HitRateMetrics allocRate = new HitRateMetrics(60000, 5);
    private volatile HitRateMetrics evictRate = new HitRateMetrics(60000, 5);
    private volatile HitRateMetrics pageReplaceRate = new HitRateMetrics(60000, 5);
    private volatile HitRateMetrics pageReplaceAge = new HitRateMetrics(60000, 5);
    private final DataRegionConfiguration memPlcCfg;
    private PageMemory pageMem;
    private volatile long rateTimeInterval;

    public DataRegionMetricsImpl(DataRegionConfiguration memPlcCfg) {
        this(memPlcCfg, null);
    }

    public DataRegionMetricsImpl(DataRegionConfiguration memPlcCfg, @Nullable IgniteOutClosure<Long> freeSpaceProvider) {
        this.memPlcCfg = memPlcCfg;
        this.freeSpaceProvider = freeSpaceProvider;
        this.metricsEnabled = memPlcCfg.isMetricsEnabled();
        this.rateTimeInterval = memPlcCfg.getMetricsRateTimeInterval();
        this.subInts = memPlcCfg.getMetricsSubIntervalCount();
    }

    @Override
    public String getName() {
        return U.maskName(this.memPlcCfg.getName());
    }

    @Override
    public long getTotalAllocatedPages() {
        return this.totalAllocatedPages.longValue();
    }

    @Override
    public long getTotalAllocatedSize() {
        assert (this.pageMem != null);
        return this.getTotalAllocatedPages() * (long)(this.persistenceEnabled ? this.pageMem.pageSize() : this.pageMem.systemPageSize());
    }

    @Override
    public float getAllocationRate() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        return (float)this.allocRate.getRate() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public float getEvictionRate() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        return (float)this.evictRate.getRate() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public float getLargeEntriesPagesPercentage() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        return this.totalAllocatedPages.longValue() != 0L ? (float)this.largeEntriesPages.doubleValue() / (float)this.totalAllocatedPages.longValue() : 0.0f;
    }

    @Override
    public float getPagesFillFactor() {
        if (!this.metricsEnabled || this.freeSpaceProvider == null) {
            return 0.0f;
        }
        long freeSpace = this.freeSpaceProvider.apply();
        long totalAllocated = (long)this.getPageSize() * this.totalAllocatedPages.longValue();
        return totalAllocated != 0L ? (float)(totalAllocated - freeSpace) / (float)totalAllocated : 0.0f;
    }

    @Override
    public long getDirtyPages() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0L;
        }
        return this.dirtyPages.longValue();
    }

    @Override
    public float getPagesReplaceRate() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0.0f;
        }
        return (float)this.pageReplaceRate.getRate() * 1000.0f / (float)this.rateTimeInterval;
    }

    @Override
    public float getPagesReplaceAge() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0.0f;
        }
        long rep2 = this.pageReplaceRate.getRate();
        return rep2 == 0L ? 0.0f : (float)this.pageReplaceAge.getRate() / (float)rep2;
    }

    @Override
    public long getPhysicalMemoryPages() {
        if (!this.persistenceEnabled) {
            return this.getTotalAllocatedPages();
        }
        if (!this.metricsEnabled) {
            return 0L;
        }
        assert (this.pageMem != null);
        return this.pageMem.loadedPages();
    }

    @Override
    public long getPhysicalMemorySize() {
        return this.getPhysicalMemoryPages() * (long)this.pageMem.systemPageSize();
    }

    @Override
    public long getUsedCheckpointBufferPages() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0L;
        }
        assert (this.pageMem != null);
        return this.pageMem.checkpointBufferPagesCount();
    }

    @Override
    public long getUsedCheckpointBufferSize() {
        return this.getUsedCheckpointBufferPages() * (long)this.pageMem.systemPageSize();
    }

    @Override
    public long getCheckpointBufferSize() {
        if (!this.metricsEnabled || !this.persistenceEnabled) {
            return 0L;
        }
        return this.checkpointBufferSize.get();
    }

    @Override
    public int getPageSize() {
        if (!this.metricsEnabled) {
            return 0;
        }
        assert (this.pageMem != null);
        return this.pageMem.pageSize();
    }

    @Override
    public long getPagesRead() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.readPages.longValue();
    }

    @Override
    public long getPagesWritten() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.writtenPages.longValue();
    }

    @Override
    public long getPagesReplaced() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.replacedPages.longValue();
    }

    @Override
    public long getOffHeapSize() {
        return this.offHeapSize.get();
    }

    @Override
    public long getOffheapUsedSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        return this.pageMem.loadedPages() * (long)this.pageMem.systemPageSize();
    }

    public void updateOffHeapSize(long size2) {
        this.offHeapSize.addAndGet(size2);
    }

    public void updateCheckpointBufferSize(long size2) {
        this.checkpointBufferSize.addAndGet(size2);
    }

    public void updatePageReplaceRate(long pageAge) {
        if (this.metricsEnabled) {
            this.pageReplaceRate.onHit();
            this.pageReplaceAge.onHits(pageAge);
            this.replacedPages.increment();
        }
    }

    public void onPageRead() {
        if (this.metricsEnabled) {
            this.readPages.increment();
        }
    }

    public void onPageWritten() {
        if (this.metricsEnabled) {
            this.writtenPages.increment();
        }
    }

    public void incrementDirtyPages() {
        if (this.metricsEnabled) {
            this.dirtyPages.increment();
        }
    }

    public void decrementDirtyPages() {
        if (this.metricsEnabled) {
            this.dirtyPages.decrement();
        }
    }

    public void resetDirtyPages() {
        if (this.metricsEnabled) {
            this.dirtyPages.reset();
        }
    }

    @Override
    public void updateTotalAllocatedPages(long delta) {
        this.totalAllocatedPages.add(delta);
        if (this.metricsEnabled && delta > 0L) {
            this.updateAllocationRateMetrics(delta);
        }
    }

    public CacheGroupMetricsMXBeanImpl.GroupAllocationTracker getOrAllocateGroupPageAllocationTracker(int grpId) {
        CacheGroupMetricsMXBeanImpl.GroupAllocationTracker tracker = (CacheGroupMetricsMXBeanImpl.GroupAllocationTracker)this.grpAllocationTrackers.get(grpId);
        if (tracker == null) {
            tracker = new CacheGroupMetricsMXBeanImpl.GroupAllocationTracker(this);
            CacheGroupMetricsMXBeanImpl.GroupAllocationTracker old = this.grpAllocationTrackers.putIfAbsent(grpId, tracker);
            if (old != null) {
                return old;
            }
        }
        return tracker;
    }

    private void updateAllocationRateMetrics(long hits) {
        this.allocRate.onHits(hits);
    }

    public void updateEvictionRate() {
        if (this.metricsEnabled) {
            this.evictRate.onHit();
        }
    }

    private long subInt(int intervalNum) {
        return this.rateTimeInterval * (long)intervalNum / (long)this.subInts;
    }

    public void incrementLargeEntriesPages() {
        if (this.metricsEnabled) {
            this.largeEntriesPages.increment();
        }
    }

    public void decrementLargeEntriesPages() {
        if (this.metricsEnabled) {
            this.largeEntriesPages.decrement();
        }
    }

    public void enableMetrics() {
        this.metricsEnabled = true;
    }

    public void disableMetrics() {
        this.metricsEnabled = false;
    }

    public void persistenceEnabled(boolean persistenceEnabled) {
        this.persistenceEnabled = persistenceEnabled;
    }

    public void pageMemory(PageMemory pageMem) {
        this.pageMem = pageMem;
    }

    public void rateTimeInterval(long rateTimeInterval) {
        this.rateTimeInterval = rateTimeInterval;
        this.allocRate = new HitRateMetrics((int)rateTimeInterval, this.subInts);
        this.evictRate = new HitRateMetrics((int)rateTimeInterval, this.subInts);
        this.pageReplaceRate = new HitRateMetrics((int)rateTimeInterval, this.subInts);
        this.pageReplaceAge = new HitRateMetrics((int)rateTimeInterval, this.subInts);
    }

    public void subIntervals(int subInts) {
        assert (subInts > 0);
        if (this.subInts == subInts) {
            return;
        }
        if (this.rateTimeInterval / (long)subInts < 10L) {
            subInts = (int)this.rateTimeInterval / 10;
        }
        this.allocRate = new HitRateMetrics((int)this.rateTimeInterval, subInts);
        this.evictRate = new HitRateMetrics((int)this.rateTimeInterval, subInts);
        this.pageReplaceRate = new HitRateMetrics((int)this.rateTimeInterval, subInts);
        this.pageReplaceAge = new HitRateMetrics((int)this.rateTimeInterval, subInts);
    }
}

