/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinator;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotResponseListener;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.jetbrains.annotations.NotNull;

public class StaticMvccQueryTracker
implements MvccQueryTracker {
    private final MvccSnapshot snapshot;
    private final GridCacheContext cctx;

    public StaticMvccQueryTracker(GridCacheContext cctx, MvccSnapshot snapshot2) {
        this.snapshot = snapshot2;
        this.cctx = cctx;
    }

    @Override
    public MvccSnapshot snapshot() {
        assert (this.snapshot != null) : this;
        return this.snapshot;
    }

    @Override
    public GridCacheContext context() {
        return this.cctx;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return AffinityTopologyVersion.NONE;
    }

    @Override
    public IgniteInternalFuture<MvccSnapshot> requestSnapshot() {
        return new GridFinishedFuture<MvccSnapshot>(this.snapshot);
    }

    @Override
    public IgniteInternalFuture<MvccSnapshot> requestSnapshot(@NotNull AffinityTopologyVersion topVer) {
        return new GridFinishedFuture<MvccSnapshot>(this.snapshot);
    }

    @Override
    public void requestSnapshot(@NotNull AffinityTopologyVersion topVer, @NotNull MvccSnapshotResponseListener lsnr) {
        lsnr.onResponse(this.snapshot);
    }

    @Override
    public void onDone() {
    }

    @Override
    public IgniteInternalFuture<Void> onDone(@NotNull GridNearTxLocal tx, boolean commit2) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    public long onMvccCoordinatorChange(MvccCoordinator newCrd) {
        return -1L;
    }

    @Override
    public long id() {
        return -1L;
    }
}

