/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.PartitionUpdateCountersMessage;
import org.apache.ignite.internal.processors.cache.mvcc.MvccTxEntry;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxKey;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryListener;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.TxCounters;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class MvccCachingManager
extends GridCacheSharedManagerAdapter {
    public static final int TX_SIZE_THRESHOLD = IgniteSystemProperties.getInteger("IGNITE_MVCC_TX_SIZE_CACHING_THRESHOLD", 20000);
    private final Map<GridCacheVersion, EnlistBuffer> enlistCache = new ConcurrentHashMap<GridCacheVersion, EnlistBuffer>();
    private final Map<TxKey, AtomicInteger> cntrs = new ConcurrentHashMap<TxKey, AtomicInteger>();

    public void addEnlisted(KeyCacheObject key, @Nullable CacheObject val, long ttl, long expireTime, GridCacheVersion ver, CacheObject oldVal, boolean primary, AffinityTopologyVersion topVer, MvccVersion mvccVer, int cacheId, IgniteInternalTx tx, IgniteUuid futId, int batchNum) throws IgniteCheckedException {
        GridCacheContext ctx0;
        assert (key != null);
        assert (mvccVer != null);
        assert (tx != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Added entry to mvcc cache: [key=" + key + ", val=" + val + ", oldVal=" + oldVal + ", primary=" + primary + ", mvccVer=" + mvccVer + ", cacheId=" + cacheId + ", ver=" + ver + ']');
        }
        if (!this.needDrReplicate(ctx0 = this.cctx.cacheContext(cacheId), key) && F.isEmpty(this.continuousQueryListeners(ctx0, tx, key)) && !ctx0.group().hasContinuousQueryCaches()) {
            return;
        }
        AtomicInteger cntr = this.cntrs.computeIfAbsent(new TxKey(mvccVer.coordinatorVersion(), mvccVer.counter()), v -> new AtomicInteger());
        if (cntr.incrementAndGet() > TX_SIZE_THRESHOLD) {
            throw new IgniteCheckedException("Transaction is too large. Consider reducing transaction size or turning off continuous queries and datacenter replication [size=" + cntr.get() + ", txXid=" + ver + ']');
        }
        MvccTxEntry e = new MvccTxEntry(key, val, ttl, expireTime, ver, oldVal, primary, topVer, mvccVer, cacheId);
        EnlistBuffer cached = this.enlistCache.computeIfAbsent(ver, v -> new EnlistBuffer());
        cached.add(primary ? null : futId, primary ? -1 : batchNum, key, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTxFinished(IgniteInternalTx tx, boolean commit2) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Transaction finished: [commit=" + commit2 + ", tx=" + tx + ']');
        }
        if (tx.system() || tx.internal() || tx.mvccSnapshot() == null) {
            return;
        }
        this.cntrs.remove(new TxKey(tx.mvccSnapshot().coordinatorVersion(), tx.mvccSnapshot().counter()));
        EnlistBuffer buf = this.enlistCache.remove(tx.xidVersion());
        if (buf == null) {
            return;
        }
        Map<KeyCacheObject, MvccTxEntry> cached = buf.getCached();
        if (F.isEmpty(cached) || !commit2) {
            return;
        }
        TxCounters txCntrs = tx.txCounters(false);
        assert (txCntrs != null);
        Collection<PartitionUpdateCountersMessage> cntrsColl = txCntrs.updateCounters();
        assert (!F.isEmpty(cntrsColl)) : cntrsColl;
        HashMap<Integer, Map> cntrsMap = new HashMap<Integer, Map>();
        for (PartitionUpdateCountersMessage partitionUpdateCountersMessage : cntrsColl) {
            for (int i = 0; i < partitionUpdateCountersMessage.size(); ++i) {
                Map cntrPerPart = cntrsMap.computeIfAbsent(partitionUpdateCountersMessage.cacheId(), k -> new HashMap());
                T2<AtomicLong, Long> prev = cntrPerPart.put(partitionUpdateCountersMessage.partition(i), new T2<AtomicLong, Long>(new AtomicLong(partitionUpdateCountersMessage.initialCounter(i)), partitionUpdateCountersMessage.initialCounter(i) + partitionUpdateCountersMessage.updatesCount(i)));
                assert (prev == null);
            }
        }
        for (Map.Entry entry2 : cached.entrySet()) {
            MvccTxEntry e = (MvccTxEntry)entry2.getValue();
            assert (e.key().partition() != -1);
            Map cntrPerCache = (Map)cntrsMap.get(e.cacheId());
            GridCacheContext ctx0 = this.cctx.cacheContext(e.cacheId());
            assert (ctx0 != null && cntrPerCache != null);
            T2 cntr = (T2)cntrPerCache.get(e.key().partition());
            long resCntr = ((AtomicLong)cntr.getKey()).incrementAndGet();
            assert (resCntr <= (Long)cntr.getValue());
            e.updateCounter(resCntr);
            if (ctx0.group().sharedGroup()) {
                ctx0.group().onPartitionCounterUpdate(ctx0.cacheId(), e.key().partition(), resCntr, tx.topologyVersion(), tx.local());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Process cached entry:" + e);
            }
            if (ctx0.isDrEnabled()) {
                ctx0.dr().replicate(e.key(), e.value(), e.ttl(), e.expireTime(), e.version(), tx.local() ? GridDrType.DR_PRIMARY : GridDrType.DR_BACKUP, e.topologyVersion());
            }
            CacheContinuousQueryManager contQryMgr = ctx0.continuousQueries();
            if (!ctx0.continuousQueries().notifyContinuousQueries(tx)) continue;
            contQryMgr.getListenerReadLock().lock();
            try {
                Map<UUID, CacheContinuousQueryListener> lsnrCol = this.continuousQueryListeners(ctx0, tx, e.key());
                if (F.isEmpty(lsnrCol)) continue;
                contQryMgr.onEntryUpdated(lsnrCol, e.key(), e.value(), e.oldValue(), false, e.key().partition(), tx.local(), false, e.updateCounter(), null, e.topologyVersion());
            }
            finally {
                contQryMgr.getListenerReadLock().unlock();
            }
        }
    }

    public boolean needDrReplicate(GridCacheContext ctx0, KeyCacheObject key) {
        return ctx0.isDrEnabled() && !key.internal();
    }

    public Map<UUID, CacheContinuousQueryListener> continuousQueryListeners(GridCacheContext ctx0, @Nullable IgniteInternalTx tx, KeyCacheObject key) {
        boolean internal = key.internal() || !ctx0.userCache();
        return ctx0.continuousQueries().notifyContinuousQueries(tx) ? ctx0.continuousQueries().updateListeners(internal, false) : null;
    }

    private static class EnlistBuffer {
        private IgniteUuid lastFutId;
        private Map<KeyCacheObject, MvccTxEntry> cached = new LinkedHashMap<KeyCacheObject, MvccTxEntry>();
        private SortedMap<Integer, Map<KeyCacheObject, MvccTxEntry>> pending;

        private EnlistBuffer() {
        }

        synchronized void add(IgniteUuid futId, int batchNum, KeyCacheObject key, MvccTxEntry e) {
            if (batchNum >= 0) {
                MvccTxEntry prev;
                if (this.lastFutId != null && !this.lastFutId.equals(futId)) {
                    this.lastFutId = futId;
                    this.flushPending();
                }
                if (this.pending == null) {
                    this.pending = new TreeMap<Integer, Map<KeyCacheObject, MvccTxEntry>>();
                }
                if ((prev = this.pending.computeIfAbsent(batchNum, k -> new LinkedHashMap()).put(key, e)) != null && prev.oldValue() != null) {
                    e.oldValue(prev.oldValue());
                }
            } else {
                assert (batchNum == -1);
                MvccTxEntry prev = this.cached.put(key, e);
                if (prev != null && prev.oldValue() != null) {
                    e.oldValue(prev.oldValue());
                }
            }
        }

        synchronized Map<KeyCacheObject, MvccTxEntry> getCached() {
            this.flushPending();
            return this.cached;
        }

        private void flushPending() {
            if (F.isEmpty(this.pending)) {
                return;
            }
            for (Map.Entry<Integer, Map<KeyCacheObject, MvccTxEntry>> entry2 : this.pending.entrySet()) {
                Map<KeyCacheObject, MvccTxEntry> vals = entry2.getValue();
                this.cached.putAll(vals);
            }
            this.pending.clear();
        }
    }
}

