/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.local.atomic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheInvokeResult;
import org.apache.ignite.internal.processors.cache.CacheLazyEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.CachePartialUpdateCheckedException;
import org.apache.ignite.internal.processors.cache.CacheStorePartialUpdateException;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.GridCachePreloaderAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.local.GridLocalCache;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.resource.GridResourceIoc;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridLocalAtomicCache<K, V>
extends GridLocalCache<K, V> {
    private static final long serialVersionUID = 0L;
    private GridCachePreloader preldr;

    public GridLocalAtomicCache() {
    }

    public GridLocalAtomicCache(GridCacheContext<K, V> ctx) {
        super(ctx);
        this.preldr = new GridCachePreloaderAdapter(ctx.group());
    }

    @Override
    protected void checkJta() throws IgniteCheckedException {
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public GridCachePreloader preloader() {
        return this.preldr;
    }

    @Override
    protected V getAndPut0(K key, V val, @Nullable CacheEntryPredicate filter2) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        return (V)this.updateAllInternal(GridCacheOperation.UPDATE, Collections.singleton(key), Collections.singleton(val), null, this.expiryPerCall(), true, false, filter2, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
    }

    @Override
    protected boolean put0(K key, V val, CacheEntryPredicate filter2) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        Boolean res = (Boolean)this.updateAllInternal(GridCacheOperation.UPDATE, Collections.singleton(key), Collections.singleton(val), null, this.expiryPerCall(), false, false, filter2, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
        assert (res != null);
        return res;
    }

    @Override
    public IgniteInternalFuture<V> getAndPutAsync0(K key, V val, @Nullable CacheEntryPredicate filter2) {
        return this.updateAllAsync0(F0.asMap(key, val), null, null, true, false, filter2);
    }

    @Override
    public IgniteInternalFuture<Boolean> putAsync0(K key, V val, @Nullable CacheEntryPredicate filter2) {
        return this.updateAllAsync0(F0.asMap(key, val), null, null, false, false, filter2);
    }

    @Override
    protected void putAll0(Map<? extends K, ? extends V> m) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        this.updateAllInternal(GridCacheOperation.UPDATE, m.keySet(), m.values(), null, this.expiryPerCall(), false, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
    }

    @Override
    public IgniteInternalFuture<?> putAllAsync0(Map<? extends K, ? extends V> m) {
        return this.updateAllAsync0(m, null, null, false, false, null).chain(RET2NULL);
    }

    @Override
    protected V getAndRemove0(K key) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        return (V)this.updateAllInternal(GridCacheOperation.DELETE, Collections.singleton(key), null, null, this.expiryPerCall(), true, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
    }

    @Override
    public IgniteInternalFuture<V> getAndRemoveAsync0(K key) {
        return this.removeAllAsync0(Collections.singletonList(key), true, false, null);
    }

    @Override
    public void removeAll0(Collection<? extends K> keys) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        this.updateAllInternal(GridCacheOperation.DELETE, keys, null, null, this.expiryPerCall(), false, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
    }

    @Override
    public IgniteInternalFuture<Object> removeAllAsync0(Collection<? extends K> keys) {
        return this.removeAllAsync0(keys, false, false, null).chain(RET2NULL);
    }

    @Override
    public boolean remove0(K key, CacheEntryPredicate filter2) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        Boolean rmv = (Boolean)this.updateAllInternal(GridCacheOperation.DELETE, Collections.singleton(key), null, null, this.expiryPerCall(), false, false, filter2, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
        assert (rmv != null);
        return rmv;
    }

    @Override
    public IgniteInternalFuture<Boolean> removeAsync0(K key, @Nullable CacheEntryPredicate filter2) {
        return this.removeAllAsync0(Collections.singletonList(key), false, false, filter2);
    }

    @Override
    public IgniteInternalFuture<?> removeAllAsync() {
        return this.ctx.closures().callLocalSafe(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GridLocalAtomicCache.this.removeAll();
                return null;
            }
        });
    }

    @Override
    protected V get0(K key, String taskName, boolean deserializeBinary, boolean needVer) throws IgniteCheckedException {
        Map<K, V> m = this.getAllInternal(Collections.singleton(key), this.ctx.readThrough(), taskName, deserializeBinary, false, needVer);
        assert (m.isEmpty() || m.size() == 1) : m.size();
        return F.firstValue(m);
    }

    @Override
    public final Map<K, V> getAll0(Collection<? extends K> keys, boolean deserializeBinary, boolean needVer) throws IgniteCheckedException {
        A.notNull(keys, "keys");
        String taskName = this.ctx.kernalContext().job().currentTaskName();
        return this.getAllInternal(keys, this.ctx.readThrough(), taskName, deserializeBinary, false, needVer);
    }

    @Override
    public IgniteInternalFuture<Map<K, V>> getAllAsync(final @Nullable Collection<? extends K> keys, boolean forcePrimary, boolean skipTx, @Nullable UUID subjId, final String taskName, final boolean deserializeBinary, boolean recovery, final boolean skipVals, final boolean needVer) {
        A.notNull(keys, "keys");
        final boolean storeEnabled = this.ctx.readThrough();
        return this.asyncOp(new Callable<Map<K, V>>(){

            @Override
            public Map<K, V> call() throws Exception {
                return GridLocalAtomicCache.this.getAllInternal(keys, storeEnabled, taskName, deserializeBinary, skipVals, needVer);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, V> getAllInternal(@Nullable Collection<? extends K> keys, boolean storeEnabled, String taskName, boolean deserializeBinary, boolean skipVals, boolean needVer) throws IgniteCheckedException {
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        if (F.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        UUID subjId = this.ctx.subjectIdPerCall(null, opCtx);
        HashMap vals = U.newHashMap(keys.size());
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        IgniteCacheExpiryPolicy expiry = this.expiryPolicy(opCtx != null ? opCtx.expiry() : null);
        boolean success2 = true;
        boolean readNoEntry = this.ctx.readNoEntry(expiry, false);
        boolean evt = !skipVals;
        for (K key : keys) {
            if (key == null) {
                throw new NullPointerException("Null key.");
            }
            KeyCacheObject cacheKey = this.ctx.toCacheKeyObject(key);
            boolean skipEntry = readNoEntry;
            if (readNoEntry) {
                CacheDataRow row = this.ctx.offheap().read(this.ctx, cacheKey);
                if (row != null) {
                    long expireTime = row.expireTime();
                    if (expireTime == 0L || expireTime > U.currentTimeMillis()) {
                        this.ctx.addResult(vals, cacheKey, row.value(), skipVals, false, deserializeBinary, true, null, row.version(), 0L, 0L, needVer);
                        if (this.ctx.statisticsEnabled() && !skipVals) {
                            this.metrics0().onRead(true);
                        }
                        if (evt) {
                            this.ctx.events().readEvent(cacheKey, null, row.value(), subjId, taskName, !deserializeBinary);
                        }
                    } else {
                        skipEntry = false;
                    }
                } else {
                    success2 = false;
                }
            }
            if (!skipEntry) {
                GridCacheEntryEx entry2 = null;
                do {
                    try {
                        entry2 = this.entryEx(cacheKey);
                        if (entry2 == null) break;
                        if (needVer) {
                            EntryGetResult res = entry2.innerGetVersioned(null, null, false, evt, subjId, null, taskName, expiry, !deserializeBinary, null, null);
                            if (res != null) {
                                this.ctx.addResult(vals, cacheKey, res, skipVals, false, deserializeBinary, true, needVer);
                                break;
                            }
                            success2 = false;
                            break;
                        }
                        CacheObject v = entry2.innerGet(null, null, false, true, evt, subjId, null, taskName, expiry, !deserializeBinary, null);
                        if (v != null) {
                            this.ctx.addResult(vals, cacheKey, v, skipVals, false, deserializeBinary, true, null, 0L, 0L);
                            break;
                        }
                        success2 = false;
                        break;
                    }
                    catch (GridCacheEntryRemovedException gridCacheEntryRemovedException) {
                    }
                    finally {
                        if (entry2 != null) {
                            entry2.touch(this.ctx.affinity().affinityTopologyVersion());
                        }
                    }
                } while (success2 || !storeEnabled);
            }
            if (success2 || storeEnabled || !this.ctx.statisticsEnabled() || skipVals) continue;
            this.metrics0().onRead(false);
        }
        if (success2 || !storeEnabled) {
            return vals;
        }
        return this.getAllAsync(keys, null, opCtx == null || !opCtx.skipStore(), false, subjId, taskName, deserializeBinary, opCtx != null && opCtx.recovery(), false, expiry, skipVals, needVer).get();
    }

    @Override
    public <T> EntryProcessorResult<T> invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args2) throws IgniteCheckedException {
        return this.invokeAsync(key, entryProcessor, args2).get();
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, final EntryProcessor<K, V, T> entryProcessor, Object ... args2) throws IgniteCheckedException {
        boolean statsEnabled;
        A.notNull(keys, "keys", entryProcessor, "entryProcessor");
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        long start = (statsEnabled = this.ctx.statisticsEnabled()) ? System.nanoTime() : 0L;
        Map invokeMap = F.viewAsMap(keys, new C1<K, EntryProcessor>(){

            @Override
            public EntryProcessor apply(K k) {
                return entryProcessor;
            }
        }, new IgnitePredicate[0]);
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        Map entryProcessorRes = (Map)this.updateAllInternal(GridCacheOperation.TRANSFORM, invokeMap.keySet(), invokeMap.values(), args2, this.expiryPerCall(), false, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), keepBinary);
        if (statsEnabled) {
            this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
        }
        return entryProcessorRes;
    }

    @Override
    public <T> IgniteInternalFuture<EntryProcessorResult<T>> invokeAsync(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args2) throws EntryProcessorException {
        boolean statsEnabled;
        A.notNull(key, "key", entryProcessor, "entryProcessor");
        if (this.keyCheck) {
            this.validateCacheKey(key);
        }
        final long start = (statsEnabled = this.ctx.statisticsEnabled()) ? System.nanoTime() : 0L;
        Map<K, EntryProcessor<K, V, T>> invokeMap = Collections.singletonMap(key, entryProcessor);
        IgniteInternalFuture fut = this.updateAllAsync0(null, invokeMap, args2, false, false, null);
        return fut.chain(new CX1<IgniteInternalFuture<Map<K, EntryProcessorResult<T>>>, EntryProcessorResult<T>>(){

            @Override
            public EntryProcessorResult<T> applyx(IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> fut) throws IgniteCheckedException {
                Map resMap = fut.get();
                if (statsEnabled) {
                    GridLocalAtomicCache.this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
                }
                if (resMap != null) {
                    assert (resMap.isEmpty() || resMap.size() == 1) : resMap.size();
                    return resMap.isEmpty() ? new CacheInvokeResult() : resMap.values().iterator().next();
                }
                return new CacheInvokeResult();
            }
        });
    }

    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Set<? extends K> keys, final EntryProcessor<K, V, T> entryProcessor, Object ... args2) {
        boolean statsEnabled;
        A.notNull(keys, "keys", entryProcessor, "entryProcessor");
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        long start = (statsEnabled = this.ctx.statisticsEnabled()) ? System.nanoTime() : 0L;
        Map invokeMap = F.viewAsMap(keys, new C1<K, EntryProcessor>(){

            @Override
            public EntryProcessor apply(K k) {
                return entryProcessor;
            }
        }, new IgnitePredicate[0]);
        IgniteInternalFuture fut = this.updateAllAsync0(null, invokeMap, args2, true, false, null);
        if (statsEnabled) {
            fut.listen(new GridCacheAdapter.InvokeAllTimeStatClosure(this.metrics0(), start));
        }
        return fut;
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Map<? extends K, ? extends EntryProcessor<K, V, T>> map2, Object ... args2) throws IgniteCheckedException {
        boolean statsEnabled;
        A.notNull(map2, "map");
        if (this.keyCheck) {
            this.validateCacheKeys(map2.keySet());
        }
        long start = (statsEnabled = this.ctx.statisticsEnabled()) ? System.nanoTime() : 0L;
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        Map entryProcessorResult = (Map)this.updateAllInternal(GridCacheOperation.TRANSFORM, map2.keySet(), map2.values(), args2, this.expiryPerCall(), false, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
        if (statsEnabled) {
            this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
        }
        return entryProcessorResult;
    }

    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Map<? extends K, ? extends EntryProcessor<K, V, T>> map2, Object ... args2) {
        boolean statsEnabled;
        A.notNull(map2, "map");
        if (this.keyCheck) {
            this.validateCacheKeys(map2.keySet());
        }
        long start = (statsEnabled = this.ctx.statisticsEnabled()) ? System.nanoTime() : 0L;
        IgniteInternalFuture fut = this.updateAllAsync0(null, map2, args2, true, false, null);
        if (statsEnabled) {
            fut.listen(new GridCacheAdapter.InvokeAllTimeStatClosure(this.metrics0(), start));
        }
        return fut;
    }

    private IgniteInternalFuture updateAllAsync0(@Nullable Map<? extends K, ? extends V> map2, @Nullable Map<? extends K, ? extends EntryProcessor> invokeMap, final @Nullable Object[] invokeArgs, final boolean retval, final boolean rawRetval, final @Nullable CacheEntryPredicate filter2) {
        Set<K> keys;
        GridCacheOperation op;
        GridCacheOperation gridCacheOperation = op = invokeMap != null ? GridCacheOperation.TRANSFORM : GridCacheOperation.UPDATE;
        Set<Object> set = map2 != null ? map2.keySet() : (keys = invokeMap != null ? invokeMap.keySet() : null);
        final Collection<? extends V> vals = map2 != null ? map2.values() : (invokeMap != null ? invokeMap.values() : null);
        final boolean writeThrough = this.ctx.writeThrough();
        final boolean readThrough = this.ctx.readThrough();
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        final ExpiryPolicy expiry = this.expiryPerCall();
        final boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        return this.asyncOp(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return GridLocalAtomicCache.this.updateAllInternal(op, keys, vals, invokeArgs, expiry, retval, rawRetval, filter2, writeThrough, readThrough, keepBinary);
            }
        });
    }

    private IgniteInternalFuture removeAllAsync0(final @Nullable Collection<? extends K> keys, final boolean retval, final boolean rawRetval, final @Nullable CacheEntryPredicate filter2) {
        final boolean writeThrough = this.ctx.writeThrough();
        final boolean readThrough = this.ctx.readThrough();
        final ExpiryPolicy expiryPlc = this.expiryPerCall();
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        final boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        return this.asyncOp(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return GridLocalAtomicCache.this.updateAllInternal(GridCacheOperation.DELETE, keys, null, null, expiryPlc, retval, rawRetval, filter2, writeThrough, readThrough, keepBinary);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object updateAllInternal(GridCacheOperation op, Collection<? extends K> keys, @Nullable Iterable<?> vals, @Nullable Object[] invokeArgs, @Nullable ExpiryPolicy expiryPlc, boolean retval, boolean rawRetval, CacheEntryPredicate filter2, boolean writeThrough, boolean readThrough, boolean keepBinary) throws IgniteCheckedException {
        Object ret;
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        if (op == GridCacheOperation.DELETE) {
            this.ctx.checkSecurity(SecurityPermission.CACHE_REMOVE);
        } else {
            this.ctx.checkSecurity(SecurityPermission.CACHE_PUT);
        }
        String taskName = this.ctx.kernalContext().job().currentTaskName();
        GridCacheVersion ver = this.ctx.versions().next();
        UUID subjId = this.ctx.subjectIdPerCall(null);
        CacheEntryPredicate[] filters = CU.filterArray(filter2);
        IgniteBiTuple res = null;
        CachePartialUpdateCheckedException err2 = null;
        this.ctx.shared().database().checkpointReadLock();
        try {
            this.ctx.shared().database().ensureFreeSpace(this.ctx.dataRegion());
            if (writeThrough && keys.size() > 1) {
                Map<? extends K, EntryProcessorResult> map2 = this.updateWithBatch(op, keys, vals, invokeArgs, expiryPlc, ver, filters, keepBinary, subjId, taskName);
                return map2;
            }
            Iterator<?> valsIter = vals != null ? vals.iterator() : null;
            boolean intercept = this.ctx.config().getInterceptor() != null;
            block11: for (K key : keys) {
                CacheObject val;
                if (key == null) {
                    throw new NullPointerException("Null key.");
                }
                CacheObject cacheObject = val = valsIter != null ? (CacheObject)valsIter.next() : null;
                if (val == null && op != GridCacheOperation.DELETE) {
                    throw new NullPointerException("Null value.");
                }
                KeyCacheObject cacheKey = this.ctx.toCacheKeyObject(key);
                if (op == GridCacheOperation.UPDATE) {
                    val = this.ctx.toCacheObject(val);
                    this.ctx.validateKeyAndValue(cacheKey, val);
                } else if (op == GridCacheOperation.TRANSFORM) {
                    this.ctx.kernalContext().resource().inject((Object)val, GridResourceIoc.AnnotationSet.ENTRY_PROCESSOR, this.ctx.name());
                }
                while (true) {
                    GridCacheEntryEx entry2 = null;
                    try {
                        entry2 = this.entryEx(cacheKey);
                        GridTuple3<Boolean, Object, EntryProcessorResult<Object>> t = entry2.innerUpdateLocal(ver, val == null ? GridCacheOperation.DELETE : op, val, invokeArgs, writeThrough, readThrough, retval, keepBinary, expiryPlc, true, true, filters, intercept, subjId, taskName, false);
                        if (op == GridCacheOperation.TRANSFORM) {
                            Map<K, EntryProcessorResult<Object>> computedMap;
                            if (t.get3() == null) continue block11;
                            if (res == null) {
                                computedMap = U.newHashMap(keys.size());
                                res = new IgniteBiTuple(true, computedMap);
                            } else {
                                computedMap = (Map)res.get2();
                            }
                            computedMap.put(key, t.get3());
                            continue block11;
                        }
                        if (res != null) continue block11;
                        res = new T2<Boolean, Object>(t.get1(), t.get2());
                        continue block11;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Got removed entry while updating (will retry): " + key);
                        }
                        entry2 = null;
                        continue;
                    }
                    catch (IgniteCheckedException e) {
                        if (err2 == null) {
                            err2 = GridLocalAtomicCache.partialUpdateException();
                        }
                        err2.add(F.asList(key), e);
                        U.error(this.log, "Failed to update key : " + key, e);
                        continue block11;
                    }
                    finally {
                        if (entry2 == null) continue;
                        entry2.touch(this.ctx.affinity().affinityTopologyVersion());
                        continue;
                    }
                    break;
                }
            }
        }
        finally {
            this.ctx.shared().database().checkpointReadUnlock();
        }
        if (err2 != null) {
            throw err2;
        }
        Object object = res == null ? null : (rawRetval ? new GridCacheReturn(this.ctx, true, keepBinary, res.get2(), (Boolean)res.get1()) : (ret = retval || op == GridCacheOperation.TRANSFORM ? res.get2() : res.get1()));
        if (op == GridCacheOperation.TRANSFORM && ret == null) {
            ret = Collections.emptyMap();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, EntryProcessorResult> updateWithBatch(GridCacheOperation op, Collection<? extends K> keys, @Nullable Iterable<?> vals, @Nullable Object[] invokeArgs, @Nullable ExpiryPolicy expiryPlc, GridCacheVersion ver, @Nullable CacheEntryPredicate[] filter2, boolean keepBinary, UUID subjId, String taskName) throws IgniteCheckedException {
        List<GridCacheEntryEx> locked = this.lockEntries(keys);
        try {
            int size2 = locked.size();
            LinkedHashMap<KeyCacheObject, CacheObject> putMap = null;
            ArrayList<KeyCacheObject> rmvKeys = null;
            ArrayList<CacheObject> writeVals = null;
            HashMap invokeResMap = op == GridCacheOperation.TRANSFORM ? U.newHashMap(size2) : null;
            ArrayList<GridCacheEntryEx> filtered2 = new ArrayList<GridCacheEntryEx>(size2);
            CachePartialUpdateCheckedException err2 = null;
            Iterator<?> valsIter = vals != null ? vals.iterator() : null;
            boolean intercept = this.ctx.config().getInterceptor() != null;
            for (int i = 0; i < size2; ++i) {
                Object val;
                GridCacheEntryEx entry2 = locked.get(i);
                Object v = val = valsIter != null ? (Object)valsIter.next() : null;
                if (val == null && op != GridCacheOperation.DELETE) {
                    throw new NullPointerException("Null value.");
                }
                try {
                    CacheObject old;
                    block45: {
                        try {
                            if (!this.ctx.isAllLocked(entry2, filter2)) {
                                if (!this.log.isDebugEnabled()) continue;
                                this.log.debug("Entry did not pass the filter (will skip write) [entry=" + entry2 + ", filter=" + Arrays.toString(filter2) + ']');
                            }
                            break block45;
                        }
                        catch (IgniteCheckedException e) {
                            if (err2 == null) {
                                err2 = GridLocalAtomicCache.partialUpdateException();
                            }
                            err2.add(F.asList(entry2.key()), e);
                        }
                        continue;
                    }
                    if (op == GridCacheOperation.TRANSFORM) {
                        CacheObject updated2;
                        this.ctx.kernalContext().resource().inject(val, GridResourceIoc.AnnotationSet.ENTRY_PROCESSOR, this.ctx.name());
                        EntryProcessor entryProcessor = (EntryProcessor)val;
                        old = entry2.innerGet(null, null, true, true, true, subjId, entryProcessor, taskName, null, keepBinary, null);
                        Object oldVal = null;
                        CacheInvokeEntry invokeEntry = new CacheInvokeEntry(entry2.key(), old, entry2.version(), keepBinary, entry2);
                        Object updatedVal = null;
                        CacheInvokeResult invokeRes = null;
                        boolean validation = false;
                        IgniteThread.onEntryProcessorEntered(false);
                        try {
                            Object computed = entryProcessor.process(invokeEntry, invokeArgs);
                            updatedVal = this.ctx.unwrapTemporary(invokeEntry.getValue());
                            updated2 = this.ctx.toCacheObject(updatedVal);
                            if (computed != null) {
                                invokeRes = CacheInvokeResult.fromResult(this.ctx.unwrapTemporary(computed));
                            }
                            if (invokeEntry.modified() && updated2 != null) {
                                validation = true;
                                this.ctx.validateKeyAndValue(entry2.key(), updated2);
                            } else if (this.ctx.statisticsEnabled() && !invokeEntry.modified()) {
                                this.ctx.cache().metrics0().onReadOnlyInvoke(old != null);
                            }
                        }
                        catch (Exception e) {
                            invokeRes = CacheInvokeResult.fromError(e);
                            updated2 = old;
                            if (validation) {
                                invokeResMap.put(entry2.key().value(this.ctx.cacheObjectContext(), false), invokeRes);
                                continue;
                            }
                        }
                        finally {
                            IgniteThread.onEntryProcessorLeft();
                        }
                        if (invokeRes != null) {
                            invokeResMap.put(entry2.key().value(this.ctx.cacheObjectContext(), false), invokeRes);
                        }
                        if (updated2 == null) {
                            IgniteBiTuple<Boolean, Object> interceptorRes;
                            if (intercept && this.ctx.cancelRemove(interceptorRes = this.ctx.config().getInterceptor().onBeforeRemove(new CacheLazyEntry(this.ctx, entry2.key(), invokeEntry.key(), old, oldVal, keepBinary)))) continue;
                            if (putMap != null) {
                                err2 = this.updatePartialBatch(filtered2, ver, writeVals, putMap, null, expiryPlc, keepBinary, err2, subjId, taskName, true);
                                putMap = null;
                                writeVals = null;
                                filtered2 = new ArrayList();
                            }
                            if (rmvKeys == null) {
                                rmvKeys = new ArrayList(size2);
                            }
                            rmvKeys.add(entry2.key());
                        } else {
                            if (intercept) {
                                Object interceptorVal = this.ctx.config().getInterceptor().onBeforePut(new CacheLazyEntry(this.ctx, entry2.key(), invokeEntry.getKey(), old, oldVal, keepBinary), updatedVal);
                                if (interceptorVal == null) continue;
                                updated2 = this.ctx.toCacheObject(this.ctx.unwrapTemporary(interceptorVal));
                            }
                            if (rmvKeys != null) {
                                err2 = this.updatePartialBatch(filtered2, ver, null, null, rmvKeys, expiryPlc, keepBinary, err2, subjId, taskName, true);
                                rmvKeys = null;
                                filtered2 = new ArrayList();
                            }
                            if (putMap == null) {
                                putMap = new LinkedHashMap(size2, 1.0f);
                                writeVals = new ArrayList(size2);
                            }
                            putMap.put(entry2.key(), updated2);
                            writeVals.add(updated2);
                        }
                    } else if (op == GridCacheOperation.UPDATE) {
                        CacheObject cacheVal = this.ctx.toCacheObject(val);
                        if (intercept) {
                            old = entry2.innerGet(null, null, this.ctx.loadPreviousValue(), true, true, subjId, null, taskName, null, keepBinary, null);
                            Object interceptorVal = this.ctx.config().getInterceptor().onBeforePut(new CacheLazyEntry(this.ctx, entry2.key(), old, keepBinary), (CacheObject)val);
                            if (interceptorVal == null) continue;
                            cacheVal = this.ctx.toCacheObject(this.ctx.unwrapTemporary(interceptorVal));
                        }
                        this.ctx.validateKeyAndValue(entry2.key(), cacheVal);
                        if (putMap == null) {
                            putMap = new LinkedHashMap<KeyCacheObject, CacheObject>(size2, 1.0f);
                            writeVals = new ArrayList<CacheObject>(size2);
                        }
                        putMap.put(entry2.key(), cacheVal);
                        writeVals.add(cacheVal);
                    } else {
                        assert (op == GridCacheOperation.DELETE);
                        if (intercept) {
                            CacheObject old2 = entry2.innerGet(null, null, this.ctx.loadPreviousValue(), true, true, subjId, null, taskName, null, keepBinary, null);
                            IgniteBiTuple<Boolean, CacheObject> interceptorRes = this.ctx.config().getInterceptor().onBeforeRemove(new CacheLazyEntry(this.ctx, entry2.key(), old2, keepBinary));
                            if (this.ctx.cancelRemove(interceptorRes)) continue;
                        }
                        if (rmvKeys == null) {
                            rmvKeys = new ArrayList<KeyCacheObject>(size2);
                        }
                        rmvKeys.add(entry2.key());
                    }
                    filtered2.add(entry2);
                    continue;
                }
                catch (IgniteCheckedException e) {
                    if (err2 == null) {
                        err2 = GridLocalAtomicCache.partialUpdateException();
                    }
                    err2.add(F.asList(entry2.key()), e);
                    continue;
                }
                catch (GridCacheEntryRemovedException ignore) {
                    assert (false) : "Entry cannot become obsolete while holding lock.";
                    continue;
                }
            }
            if (putMap != null || rmvKeys != null) {
                err2 = this.updatePartialBatch(filtered2, ver, writeVals, putMap, rmvKeys, expiryPlc, keepBinary, err2, subjId, taskName, op == GridCacheOperation.TRANSFORM);
            } else assert (filtered2.isEmpty());
            if (err2 != null) {
                throw err2;
            }
            HashMap hashMap = invokeResMap;
            return hashMap;
        }
        finally {
            this.unlockEntries(locked);
        }
    }

    @Nullable
    private CachePartialUpdateCheckedException updatePartialBatch(List<GridCacheEntryEx> entries, final GridCacheVersion ver, @Nullable List<CacheObject> writeVals, @Nullable Map<KeyCacheObject, CacheObject> putMap, @Nullable Collection<KeyCacheObject> rmvKeys, @Nullable ExpiryPolicy expiryPlc, boolean keepBinary, @Nullable CachePartialUpdateCheckedException err2, UUID subjId, String taskName, boolean transformed) {
        GridCacheOperation op;
        CacheStorePartialUpdateException storeErr;
        block18: {
            assert (putMap == null ^ rmvKeys == null);
            storeErr = null;
            try {
                if (putMap != null) {
                    try {
                        Map<KeyCacheObject, IgniteBiTuple<? extends CacheObject, GridCacheVersion>> view = F.viewReadOnly(putMap, new C1<CacheObject, IgniteBiTuple<? extends CacheObject, GridCacheVersion>>(){

                            @Override
                            public IgniteBiTuple<? extends CacheObject, GridCacheVersion> apply(CacheObject val) {
                                return F.t(val, ver);
                            }
                        }, new IgnitePredicate[0]);
                        this.ctx.store().putAll(null, view);
                    }
                    catch (CacheStorePartialUpdateException e) {
                        storeErr = e;
                    }
                    op = GridCacheOperation.UPDATE;
                    break block18;
                }
                try {
                    this.ctx.store().removeAll(null, rmvKeys);
                }
                catch (CacheStorePartialUpdateException e) {
                    storeErr = e;
                }
                op = GridCacheOperation.DELETE;
            }
            catch (IgniteCheckedException e) {
                if (err2 == null) {
                    err2 = GridLocalAtomicCache.partialUpdateException();
                }
                err2.add(putMap != null ? putMap.keySet() : rmvKeys, e);
                return err2;
            }
        }
        boolean intercept = this.ctx.config().getInterceptor() != null;
        for (int i = 0; i < entries.size(); ++i) {
            GridCacheEntryEx entry2 = entries.get(i);
            assert (entry2.lockedByCurrentThread());
            if (entry2.obsolete() || storeErr != null && storeErr.failedKeys().contains(entry2.key().value(this.ctx.cacheObjectContext(), false))) continue;
            try {
                CacheObject writeVal;
                CacheObject cacheObject = writeVal = op == GridCacheOperation.UPDATE ? writeVals.get(i) : null;
                assert (writeVal != null || op == GridCacheOperation.DELETE) : "null write value found.";
                GridTuple3<Boolean, Object, EntryProcessorResult<Object>> t = entry2.innerUpdateLocal(ver, op, writeVal, null, false, false, false, keepBinary, expiryPlc, true, true, null, false, subjId, taskName, transformed);
                if (!intercept) continue;
                if (op == GridCacheOperation.UPDATE) {
                    this.ctx.config().getInterceptor().onAfterPut(new CacheLazyEntry(this.ctx, entry2.key(), writeVal, keepBinary));
                    continue;
                }
                this.ctx.config().getInterceptor().onAfterRemove(new CacheLazyEntry(this.ctx, entry2.key(), t.get2(), keepBinary));
                continue;
            }
            catch (GridCacheEntryRemovedException ignore) {
                assert (false) : "Entry cannot become obsolete while holding lock.";
                continue;
            }
            catch (IgniteCheckedException e) {
                if (err2 == null) {
                    err2 = GridLocalAtomicCache.partialUpdateException();
                }
                err2.add(Collections.singleton(entry2.key()), e);
            }
        }
        return err2;
    }

    private List<GridCacheEntryEx> lockEntries(Collection<? extends K> keys) {
        boolean nullKeys;
        ArrayList<GridCacheEntryEx> locked;
        block7: {
            locked = new ArrayList<GridCacheEntryEx>(keys.size());
            nullKeys = false;
            block0: do {
                for (K key : keys) {
                    if (key == null) {
                        nullKeys = true;
                        break;
                    }
                    GridCacheEntryEx entry2 = this.entryEx(this.ctx.toCacheKeyObject(key));
                    locked.add(entry2);
                }
                if (nullKeys) break block7;
                for (int i = 0; i < locked.size(); ++i) {
                    GridCacheEntryEx entry3 = (GridCacheEntryEx)locked.get(i);
                    entry3.lockEntry();
                    if (!entry3.obsolete()) continue;
                    for (int j = 0; j <= i; ++j) {
                        ((GridCacheEntryEx)locked.get(j)).unlockEntry();
                    }
                    locked.clear();
                    continue block0;
                }
            } while (locked.isEmpty());
            return locked;
        }
        assert (nullKeys);
        AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
        for (GridCacheEntryEx entry2 : locked) {
            entry2.touch(topVer);
        }
        throw new NullPointerException("Null key.");
    }

    private void unlockEntries(Iterable<GridCacheEntryEx> locked) {
        for (GridCacheEntryEx entry2 : locked) {
            entry2.unlockEntry();
        }
        AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
        for (GridCacheEntryEx entry3 : locked) {
            entry3.touch(topVer);
        }
    }

    private static CachePartialUpdateCheckedException partialUpdateException() {
        return new CachePartialUpdateCheckedException("Failed to update keys (retry update if possible).");
    }

    @Override
    public IgniteInternalFuture<Boolean> txLockAsync(Collection<KeyCacheObject> keys, long timeout, IgniteTxLocalEx tx, boolean isRead, boolean retval, TransactionIsolation isolation, boolean invalidate2, long createTtl, long accessTtl) {
        return new GridFinishedFuture<Boolean>(new UnsupportedOperationException("Locks are not supported for CacheAtomicityMode.ATOMIC mode (use CacheAtomicityMode.TRANSACTIONAL instead)"));
    }

    @Override
    public IgniteInternalFuture<Boolean> lockAllAsync(@Nullable Collection<? extends K> keys, long timeout) {
        return new GridFinishedFuture<Boolean>(new UnsupportedOperationException("Locks are not supported for CacheAtomicityMode.ATOMIC mode (use CacheAtomicityMode.TRANSACTIONAL instead)"));
    }

    @Override
    public void unlockAll(@Nullable Collection<? extends K> keys) throws IgniteCheckedException {
        throw new UnsupportedOperationException("Locks are not supported for CacheAtomicityMode.ATOMIC mode (use CacheAtomicityMode.TRANSACTIONAL instead)");
    }

    @Nullable
    private ExpiryPolicy expiryPerCall() {
        ExpiryPolicy expiry;
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        ExpiryPolicy expiryPolicy = expiry = opCtx != null ? opCtx.expiry() : null;
        if (expiry == null) {
            expiry = this.ctx.expiry();
        }
        return expiry;
    }

    private IgniteInternalFuture asyncOp(Callable<?> op) {
        IgniteInternalFuture fail2 = this.asyncOpAcquire(false);
        if (fail2 != null) {
            return fail2;
        }
        IgniteInternalFuture<?> f2 = this.ctx.closures().callLocalSafe(op);
        f2.listen(new CI1<IgniteInternalFuture<?>>(){

            @Override
            public void apply(IgniteInternalFuture<?> f2) {
                GridLocalAtomicCache.this.asyncOpRelease(false);
            }
        });
        return f2;
    }

    @Override
    public void onDeferredDelete(GridCacheEntryEx entry2, GridCacheVersion ver) {
        assert (false) : "Should not be called";
    }
}

