/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxQueryEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.NearTxQueryEnlistResultHandler;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxQueryAbstractEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxQueryEnlistRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxQueryEnlistResponse;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridNearTxQueryEnlistFuture
extends GridNearTxQueryAbstractEnlistFuture {
    private final int[] cacheIds;
    private final int[] parts;
    private final String schema;
    private final String qry;
    private final Object[] params;
    private final int flags;
    private final int pageSize;

    protected GridNearTxQueryEnlistFuture(GridCacheContext<?, ?> cctx, GridNearTxLocal tx, int[] cacheIds, int[] parts, String schema, String qry, Object[] params2, int flags, int pageSize, long timeout) {
        super(cctx, tx, timeout);
        this.cacheIds = cacheIds;
        this.parts = parts;
        this.schema = schema;
        this.qry = qry;
        this.params = params2;
        this.flags = flags;
        this.pageSize = pageSize;
    }

    @Override
    protected void map(boolean topLocked) {
        block14: {
            MiniFuture mini = null;
            try {
                boolean locallyMapped;
                Set<ClusterNode> primary;
                AffinityAssignment assignment = this.cctx.affinity().assignment(this.topVer);
                if (this.parts != null) {
                    primary = U.newHashSet(this.parts.length);
                    for (int i = 0; i < this.parts.length; ++i) {
                        ClusterNode pNode = assignment.get(this.parts[i]).get(0);
                        primary.add(pNode);
                        this.updateMappings(pNode);
                    }
                } else {
                    primary = assignment.primaryPartitionNodes();
                    for (ClusterNode pNode : primary) {
                        this.updateMappings(pNode);
                    }
                }
                if (locallyMapped = primary.contains(this.cctx.localNode())) {
                    this.add(new MiniFuture(this.cctx.localNode()));
                }
                int idx = locallyMapped ? 1 : 0;
                boolean first = true;
                boolean clientFirst = false;
                if (!topLocked && this.cctx.topology().holdsLock()) {
                    this.cctx.topology().readUnlock();
                }
                for (ClusterNode node : F.view(primary, F.remoteNodes(this.cctx.localNodeId()))) {
                    mini = new MiniFuture(node);
                    this.add(mini);
                    if (first) {
                        clientFirst = this.cctx.localNode().isClient() && !topLocked && !this.tx.hasRemoteLocks();
                        first = false;
                    }
                    GridNearTxQueryEnlistRequest req = new GridNearTxQueryEnlistRequest(this.cctx.cacheId(), this.threadId, this.futId, ++idx, this.tx.subjectId(), this.topVer, this.lockVer, this.mvccSnapshot, this.cacheIds, this.parts, this.schema, this.qry, this.params, this.flags, this.pageSize, this.remainingTime(), this.tx.remainingTime(), this.tx.taskNameHash(), clientFirst);
                    this.sendRequest(req, node.id(), mini);
                }
                if (locallyMapped) {
                    final MiniFuture localMini = mini = this.miniFuture(-1);
                    assert (localMini != null);
                    GridDhtTxQueryEnlistFuture fut = new GridDhtTxQueryEnlistFuture(this.cctx.localNode().id(), this.lockVer, this.mvccSnapshot, this.threadId, this.futId, -1, this.tx, this.cacheIds, this.parts, this.schema, this.qry, this.params, this.flags, this.pageSize, this.remainingTime(), this.cctx);
                    this.updateLocalFuture(fut);
                    fut.listen(new CI1<IgniteInternalFuture<Long>>(){

                        @Override
                        public void apply(IgniteInternalFuture<Long> fut) {
                            assert (fut.error() != null || fut.result() != null) : fut;
                            try {
                                GridNearTxQueryEnlistFuture.this.clearLocalFuture((GridDhtTxQueryEnlistFuture)fut);
                                GridNearTxQueryEnlistResponse res = fut.error() == null ? (GridNearTxQueryEnlistResponse)NearTxQueryEnlistResultHandler.createResponse(fut) : null;
                                localMini.onResult(res, fut.error());
                            }
                            catch (IgniteCheckedException e) {
                                localMini.onResult(null, e);
                            }
                            finally {
                                CU.unwindEvicts(GridNearTxQueryEnlistFuture.this.cctx);
                            }
                        }
                    });
                    fut.init();
                }
            }
            catch (Throwable e) {
                if (mini != null) {
                    mini.onResult(null, e);
                } else {
                    this.onDone(e);
                }
                if (!(e instanceof Error)) break block14;
                throw (Error)e;
            }
        }
        this.markInitialized();
    }

    private void sendRequest(final GridCacheMessage req, final UUID nodeId, final MiniFuture fut) throws IgniteCheckedException {
        IgniteInternalFuture<?> txSync = this.cctx.tm().awaitFinishAckAsync(nodeId, this.tx.threadId());
        if (txSync == null || txSync.isDone()) {
            this.cctx.io().send(nodeId, req, this.cctx.ioPolicy());
        } else {
            txSync.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> f2) {
                    try {
                        GridNearTxQueryEnlistFuture.this.cctx.io().send(nodeId, req, GridNearTxQueryEnlistFuture.this.cctx.ioPolicy());
                    }
                    catch (IgniteCheckedException e) {
                        fut.onResult(null, e);
                    }
                }
            });
        }
    }

    @Override
    public synchronized boolean onNodeLeft(UUID nodeId) {
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f2 = (MiniFuture)fut;
            if (!f2.node.id().equals(nodeId)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Found mini-future for left node [nodeId=" + nodeId + ", mini=" + f2 + ", fut=" + this + ']');
            }
            return f2.onResult(null, this.newTopologyException(nodeId));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Future does not have mapping for left node (ignoring) [nodeId=" + nodeId + ", fut=" + this + ']');
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(int miniId) {
        GridNearTxQueryEnlistFuture gridNearTxQueryEnlistFuture = this;
        synchronized (gridNearTxQueryEnlistFuture) {
            int idx = Math.abs(miniId) - 1;
            assert (idx >= 0 && idx < this.futuresCountNoLock());
            IgniteInternalFuture fut = this.future(idx);
            if (!fut.isDone()) {
                return (MiniFuture)fut;
            }
        }
        return null;
    }

    private ClusterTopologyCheckedException newTopologyException(UUID nodeId) {
        ClusterTopologyCheckedException topEx = new ClusterTopologyCheckedException("Failed to enlist keys (primary node left grid, retry transaction if possible) [node=" + nodeId + ']');
        topEx.retryReadyFuture(this.cctx.shared().nextAffinityReadyFuture(this.topVer));
        return topEx;
    }

    public void onResult(UUID nodeId, GridNearTxQueryEnlistResponse res) {
        MiniFuture mini = this.miniFuture(res.miniId());
        if (mini != null) {
            mini.onResult(res, null);
        }
    }

    @Override
    public String toString() {
        return S.toString(GridNearTxQueryEnlistFuture.class, this, super.toString());
    }

    private class MiniFuture
    extends GridFutureAdapter<Long> {
        private boolean completed;
        @GridToStringExclude
        private final ClusterNode node;

        private MiniFuture(ClusterNode node) {
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onResult(GridNearTxQueryEnlistResponse res, Throwable err2) {
            assert (res != null || err2 != null) : this;
            if (err2 == null && res.error() != null) {
                err2 = res.error();
            }
            MiniFuture miniFuture = this;
            synchronized (miniFuture) {
                if (this.completed) {
                    return false;
                }
                this.completed = true;
            }
            if (res != null && res.removeMapping()) {
                GridDistributedTxMapping m = GridNearTxQueryEnlistFuture.this.tx.mappings().get(this.node.id());
                assert (m != null && m.empty());
                GridNearTxQueryEnlistFuture.this.tx.removeMapping(this.node.id());
                if (this.node.isLocal()) {
                    GridNearTxQueryEnlistFuture.this.tx.colocatedLocallyMapped(false);
                }
            } else if (res != null) {
                GridNearTxQueryEnlistFuture.this.tx.mappings().get(this.node.id()).addBackups(res.newDhtNodes());
                if (res.result() > 0L && !this.node.isLocal()) {
                    GridNearTxQueryEnlistFuture.this.tx.hasRemoteLocks(true);
                }
            }
            return err2 != null ? this.onDone(err2) : this.onDone(res.result(), res.error());
        }
    }
}

