/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxFinishRequest;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridNearTxFinishRequest
extends GridDistributedTxFinishRequest {
    private static final long serialVersionUID = 0L;
    private int miniId;
    private MvccSnapshot mvccSnapshot;

    public GridNearTxFinishRequest() {
    }

    public GridNearTxFinishRequest(IgniteUuid futId, GridCacheVersion xidVer, long threadId, boolean commit2, boolean invalidate2, boolean sys, byte plc, CacheWriteSynchronizationMode syncMode, boolean explicitLock, boolean storeEnabled, @NotNull AffinityTopologyVersion topVer, GridCacheVersion baseVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers, int txSize, @Nullable UUID subjId, int taskNameHash, MvccSnapshot mvccSnapshot, boolean addDepInfo) {
        super(xidVer, futId, topVer, null, threadId, commit2, invalidate2, sys, plc, syncMode, baseVer, committedVers, rolledbackVers, subjId, taskNameHash, txSize, addDepInfo);
        this.explicitLock(explicitLock);
        this.storeEnabled(storeEnabled);
        this.mvccSnapshot = mvccSnapshot;
    }

    @Nullable
    public MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    public boolean explicitLock() {
        return this.isFlag(16);
    }

    private void explicitLock(boolean explicitLock) {
        this.setFlag(explicitLock, 16);
    }

    public boolean storeEnabled() {
        return this.isFlag(32);
    }

    private void storeEnabled(boolean storeEnabled) {
        this.setFlag(storeEnabled, 32);
    }

    public int miniId() {
        return this.miniId;
    }

    public void miniId(int miniId) {
        assert (miniId > 0);
        this.miniId = miniId;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 21: {
                if (!writer.writeInt("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 22: {
                if (!writer.writeMessage("mvccSnapshot", this.mvccSnapshot)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 21: {
                this.miniId = reader.readInt("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 22: {
                this.mvccSnapshot = (MvccSnapshot)reader.readMessage("mvccSnapshot");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearTxFinishRequest.class);
    }

    @Override
    public short directType() {
        return 53;
    }

    @Override
    public byte fieldsCount() {
        return 23;
    }

    @Override
    public int partition() {
        return U.safeAbs(this.version().hashCode());
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(GridNearTxFinishRequest.class, this, "super", super.toString());
    }
}

