/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundIdentityFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheReturnCompletableWrapper;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheVersionedFuture;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteTxMappings;
import org.apache.ignite.internal.processors.cache.distributed.near.NearTxFinishFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinator;
import org.apache.ignite.internal.processors.cache.mvcc.MvccFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.transactions.IgniteTxHeuristicCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionRollbackException;
import org.apache.ignite.transactions.TransactionState;

public final class GridNearTxFinishFuture<K, V>
extends GridCacheCompoundIdentityFuture<IgniteInternalTx>
implements GridCacheFuture<IgniteInternalTx>,
NearTxFinishFuture {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    protected static IgniteLogger msgLog;
    private GridCacheSharedContext<K, V> cctx;
    private final IgniteUuid futId;
    @GridToStringInclude
    private GridNearTxLocal tx;
    private boolean commit;
    private IgniteTxMappings mappings;
    private boolean trackable = true;
    private boolean finishOnePhaseCalled;

    public GridNearTxFinishFuture(GridCacheSharedContext<K, V> cctx, GridNearTxLocal tx, boolean commit2) {
        super(F.identityReducer(tx));
        this.cctx = cctx;
        this.tx = tx;
        this.commit = commit2;
        this.ignoreInterrupts();
        this.mappings = tx.mappings();
        this.futId = IgniteUuid.randomUuid();
        if (tx.explicitLock()) {
            tx.syncMode(CacheWriteSynchronizationMode.FULL_SYNC);
        }
        if (log == null) {
            msgLog = cctx.txFinishMessageLogger();
            log = U.logger(cctx.kernalContext(), logRef, GridNearTxFinishFuture.class);
        }
    }

    @Override
    public boolean commit() {
        return this.commit;
    }

    GridCacheSharedContext<K, V> context() {
        return this.cctx;
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MinFuture f2;
            if (!this.isMini(fut) || !(f2 = (MinFuture)fut).onNodeLeft(nodeId, true)) continue;
            this.mappings.remove(nodeId);
            found = true;
        }
        return found;
    }

    @Override
    public GridNearTxLocal tx() {
        return this.tx;
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
        this.trackable = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResult(UUID nodeId, GridNearTxFinishResponse res) {
        if (!this.isDone()) {
            FinishMiniFuture finishFut = null;
            GridNearTxFinishFuture gridNearTxFinishFuture = this;
            synchronized (gridNearTxFinishFuture) {
                int size2 = this.futuresCountNoLock();
                for (int i = 0; i < size2; ++i) {
                    FinishMiniFuture f2;
                    IgniteInternalFuture fut = this.future(i);
                    if (fut.getClass() != FinishMiniFuture.class || (f2 = (FinishMiniFuture)fut).futureId() != res.miniId()) continue;
                    assert (f2.primary().id().equals(nodeId));
                    finishFut = f2;
                    break;
                }
            }
            if (finishFut != null) {
                finishFut.onNearFinishResponse(res);
            } else if (msgLog.isDebugEnabled()) {
                msgLog.debug("Near finish fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("Near finish fut, response for finished future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    public void onResult(UUID nodeId, GridDhtTxFinishResponse res) {
        if (!this.isDone()) {
            boolean found = false;
            for (IgniteInternalFuture fut : this.futures()) {
                MinFuture f2;
                if (fut.getClass() == CheckBackupMiniFuture.class) {
                    f2 = (CheckBackupMiniFuture)fut;
                    if (f2.futureId() != res.miniId()) continue;
                    found = true;
                    assert (((CheckBackupMiniFuture)f2).node().id().equals(nodeId));
                    if (res.returnValue() != null) {
                        this.tx.implicitSingleResult(res.returnValue());
                    }
                    ((CheckBackupMiniFuture)f2).onDhtFinishResponse(res);
                    continue;
                }
                if (fut.getClass() != CheckRemoteTxMiniFuture.class || (f2 = (CheckRemoteTxMiniFuture)fut).futureId() != res.miniId()) continue;
                ((CheckRemoteTxMiniFuture)f2).onDhtFinishResponse(nodeId, false);
            }
            if (!found && msgLog.isDebugEnabled()) {
                msgLog.debug("Near finish fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("Near finish fut, response for finished future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    void forceFinish() {
        super.onDone(this.tx, (Throwable)null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onDone(IgniteInternalTx tx0, Throwable err2) {
        if (this.isDone()) {
            return false;
        }
        GridNearTxFinishFuture gridNearTxFinishFuture = this;
        synchronized (gridNearTxFinishFuture) {
            if (this.isDone()) {
                return false;
            }
            boolean nodeStop = false;
            if (err2 != null) {
                this.tx.setRollbackOnly();
                nodeStop = err2 instanceof NodeStoppingException;
            }
            if (this.commit) {
                if (this.tx.commitError() != null) {
                    err2 = this.tx.commitError();
                } else if (err2 != null) {
                    this.tx.commitError(err2);
                }
            }
            if (this.initialized() || err2 != null) {
                block26: {
                    if (this.tx.needCheckBackup()) {
                        assert (this.tx.onePhaseCommit());
                        if (err2 != null) {
                            err2 = new TransactionRollbackException("Failed to commit transaction.", err2);
                        }
                        try {
                            this.tx.localFinish(err2 == null, true);
                        }
                        catch (IgniteCheckedException e) {
                            if (err2 != null) {
                                err2.addSuppressed(e);
                            }
                            err2 = e;
                        }
                    }
                    if (this.tx.onePhaseCommit()) {
                        boolean commit2;
                        boolean bl = commit2 = this.commit && err2 == null;
                        if (!nodeStop) {
                            this.finishOnePhase(commit2);
                        }
                        try {
                            this.tx.tmFinish(commit2, nodeStop, true);
                        }
                        catch (IgniteCheckedException e) {
                            U.error(log, "Failed to finish tx: " + this.tx, e);
                            if (err2 != null) break block26;
                            err2 = e;
                        }
                    }
                }
                if (super.onDone(tx0, err2)) {
                    if (this.error() instanceof IgniteTxHeuristicCheckedException && !nodeStop) {
                        AffinityTopologyVersion topVer = this.tx.topologyVersion();
                        for (IgniteTxEntry e : this.tx.writeMap().values()) {
                            GridCacheContext<?, ?> cacheCtx = e.context();
                            try {
                                GridCacheEntryEx entry2;
                                if (e.op() == GridCacheOperation.NOOP || cacheCtx.affinity().keyLocalNode(e.key(), topVer) || (entry2 = cacheCtx.cache().peekEx(e.key())) == null) continue;
                                entry2.invalidate(this.tx.xidVersion());
                            }
                            catch (Throwable t) {
                                U.error(log, "Failed to invalidate entry.", t);
                                if (!(t instanceof Error)) continue;
                                throw (Error)t;
                            }
                        }
                    }
                    this.cctx.mvcc().removeFuture(this.futId);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isMini(IgniteInternalFuture<?> fut) {
        return fut.getClass() == FinishMiniFuture.class || fut.getClass() == CheckBackupMiniFuture.class || fut.getClass() == CheckRemoteTxMiniFuture.class;
    }

    @Override
    public void finish(boolean commit2, boolean clearThreadMap, boolean onTimeout) {
        if (!this.cctx.mvcc().addFuture(this, this.futureId())) {
            return;
        }
        if (this.tx.onNeedCheckBackup()) {
            assert (this.tx.onePhaseCommit());
            this.checkBackup();
            this.markInitialized();
            return;
        }
        if (!commit2 && !clearThreadMap) {
            this.rollbackAsyncSafe(onTimeout);
        } else {
            this.doFinish(commit2, clearThreadMap);
        }
    }

    private void rollbackAsyncSafe(final boolean onTimeout) {
        IgniteInternalFuture<?> curFut = this.tx.tryRollbackAsync();
        if (curFut == null) {
            this.doFinish(false, false);
            return;
        }
        if (curFut instanceof GridCacheVersionedFuture && !onTimeout) {
            try {
                curFut.cancel();
            }
            catch (IgniteCheckedException e) {
                log.error("Failed to cancel lock for the transaction: " + CU.txString(this.tx), e);
            }
        }
        curFut.listen(new IgniteInClosure<IgniteInternalFuture<?>>(){

            @Override
            public void apply(IgniteInternalFuture<?> fut) {
                try {
                    fut.get();
                    GridNearTxFinishFuture.this.rollbackAsyncSafe(onTimeout);
                }
                catch (IgniteCheckedException e) {
                    GridNearTxFinishFuture.this.doFinish(false, false);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFinish(boolean commit2, boolean clearThreadMap) {
        try {
            if (this.tx.localFinish(commit2, clearThreadMap) || !commit2 && this.tx.state() == TransactionState.UNKNOWN) {
                GridLongList waitTxs = this.tx.mvccWaitTransactions();
                if (waitTxs != null) {
                    MvccSnapshot snapshot2 = this.tx.mvccSnapshot();
                    MvccCoordinator crd = this.cctx.coordinators().currentCoordinator();
                    assert (snapshot2 != null);
                    if (snapshot2.coordinatorVersion() == crd.coordinatorVersion()) {
                        IgniteInternalFuture<Void> fut = this.cctx.coordinators().waitTxsFuture(this.cctx.coordinators().currentCoordinatorId(), waitTxs);
                        this.add(fut);
                    }
                }
                if (this.tx.onePhaseCommit() && this.needFinishOnePhase(commit2) || !this.tx.onePhaseCommit() && this.mappings != null) {
                    if (this.mappings.single()) {
                        GridDistributedTxMapping mapping = this.mappings.singleMapping();
                        if (mapping != null) {
                            assert (!this.hasFutures() || waitTxs != null) : this.futures();
                            this.finish(1, mapping, commit2, !clearThreadMap);
                        }
                    } else {
                        assert (!this.hasFutures() || waitTxs != null) : this.futures();
                        this.finish(this.mappings.mappings(), commit2, !clearThreadMap);
                    }
                }
                this.markInitialized();
            } else {
                this.onDone(new IgniteCheckedException("Failed to " + (commit2 ? "commit" : "rollback") + " transaction: " + CU.txString(this.tx)));
            }
        }
        catch (Error | RuntimeException e) {
            this.onDone(e);
            throw e;
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
        }
        finally {
            if (commit2 && this.tx.onePhaseCommit() && !this.tx.writeMap().isEmpty()) {
                this.ackBackup();
            }
        }
    }

    @Override
    public void onNodeStop(IgniteCheckedException e) {
        super.onDone(this.tx, e);
    }

    private void ackBackup() {
        if (this.mappings.empty()) {
            return;
        }
        if (!this.tx.needReturnValue() || !this.tx.implicit()) {
            return;
        }
        GridDistributedTxMapping mapping = this.mappings.singleMapping();
        if (mapping != null) {
            UUID nodeId = mapping.primary().id();
            Collection<UUID> backups = this.tx.transactionNodes().get(nodeId);
            if (!F.isEmpty(backups)) {
                assert (backups.size() == 1) : backups;
                UUID backupId = F.first(backups);
                ClusterNode backup = this.cctx.discovery().node(backupId);
                if (backup != null) {
                    if (backup.isLocal()) {
                        this.cctx.tm().removeTxReturn(this.tx.xidVersion());
                    } else {
                        this.cctx.tm().sendDeferredAckResponse(backupId, this.tx.xidVersion());
                    }
                }
            }
        }
    }

    private void checkBackup() {
        assert (!this.hasFutures()) : this.futures();
        GridDistributedTxMapping mapping = this.mappings.singleMapping();
        if (mapping != null) {
            UUID nodeId = mapping.primary().id();
            Collection<UUID> backups = this.tx.transactionNodes().get(nodeId);
            if (!F.isEmpty(backups)) {
                assert (backups.size() == 1);
                UUID backupId = F.first(backups);
                ClusterNode backup = this.cctx.discovery().node(backupId);
                if (backup == null) {
                    this.readyNearMappingFromBackup(mapping);
                    ClusterTopologyCheckedException cause = new ClusterTopologyCheckedException("Backup node left grid: " + backupId);
                    cause.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
                    this.onDone(new IgniteTxRollbackCheckedException("Failed to commit transaction (backup has left grid): " + this.tx.xidVersion(), cause));
                } else {
                    final CheckBackupMiniFuture mini = new CheckBackupMiniFuture(1, backup, mapping);
                    this.add(mini);
                    if (backup.isLocal()) {
                        boolean committed = !this.cctx.tm().addRolledbackTx(this.tx);
                        this.readyNearMappingFromBackup(mapping);
                        if (committed) {
                            try {
                                if (this.tx.needReturnValue() && this.tx.implicit()) {
                                    GridCacheReturnCompletableWrapper wrapper = this.cctx.tm().getCommittedTxReturn(this.tx.xidVersion());
                                    assert (wrapper != null) : this.tx.xidVersion();
                                    GridCacheReturn retVal = wrapper.fut().get();
                                    assert (retVal != null);
                                    this.tx.implicitSingleResult(retVal);
                                }
                                if (this.tx.syncMode() == CacheWriteSynchronizationMode.FULL_SYNC) {
                                    GridCacheVersion nearXidVer = this.tx.nearXidVersion();
                                    assert (nearXidVer != null) : this.tx;
                                    IgniteInternalFuture<?> fut = this.cctx.tm().remoteTxFinishFuture(nearXidVer);
                                    fut.listen(new CI1<IgniteInternalFuture<?>>(){

                                        @Override
                                        public void apply(IgniteInternalFuture<?> fut) {
                                            mini.onDone(GridNearTxFinishFuture.this.tx);
                                        }
                                    });
                                    return;
                                }
                                mini.onDone(this.tx);
                            }
                            catch (IgniteCheckedException e) {
                                if (msgLog.isDebugEnabled()) {
                                    msgLog.debug("Near finish fut, failed to finish [txId=" + this.tx.nearXidVersion() + ", node=" + backup.id() + ", err=" + e + ']');
                                }
                                mini.onDone(e);
                            }
                        } else {
                            ClusterTopologyCheckedException cause = new ClusterTopologyCheckedException("Primary node left grid: " + nodeId);
                            cause.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
                            mini.onDone(new IgniteTxRollbackCheckedException("Failed to commit transaction (transaction has been rolled back on backup node): " + this.tx.xidVersion(), cause));
                        }
                    } else {
                        GridDhtTxFinishRequest finishReq = this.checkCommittedRequest(mini.futureId(), false);
                        try {
                            this.cctx.io().send(backup, (GridCacheMessage)finishReq, this.tx.ioPolicy());
                            if (msgLog.isDebugEnabled()) {
                                msgLog.debug("Near finish fut, sent check committed request [txId=" + this.tx.nearXidVersion() + ", node=" + backup.id() + ']');
                            }
                        }
                        catch (ClusterTopologyCheckedException ignored) {
                            mini.onNodeLeft(backupId, false);
                        }
                        catch (IgniteCheckedException e) {
                            if (msgLog.isDebugEnabled()) {
                                msgLog.debug("Near finish fut, failed to send check committed request [txId=" + this.tx.nearXidVersion() + ", node=" + backup.id() + ", err=" + e + ']');
                            }
                            mini.onDone(e);
                        }
                    }
                }
            } else {
                this.readyNearMappingFromBackup(mapping);
            }
        }
    }

    private boolean needFinishOnePhase(boolean commit2) {
        assert (this.tx.onePhaseCommit());
        if (this.tx.mappings().empty()) {
            return false;
        }
        if (!commit2) {
            return true;
        }
        GridDistributedTxMapping mapping = this.tx.mappings().singleMapping();
        assert (mapping != null);
        return mapping.hasNearCacheEntries();
    }

    private void finishOnePhase(boolean commit2) {
        IgniteInternalFuture<IgniteInternalTx> fut;
        assert (Thread.holdsLock(this));
        if (this.finishOnePhaseCalled) {
            return;
        }
        this.finishOnePhaseCalled = true;
        GridDistributedTxMapping locMapping = this.mappings.localMapping();
        if (locMapping != null && (fut = this.cctx.tm().txHandler().finishColocatedLocal(commit2, this.tx)) != null) {
            this.add(fut);
        }
    }

    private void readyNearMappingFromBackup(GridDistributedTxMapping mapping) {
        if (mapping.hasNearCacheEntries()) {
            GridCacheVersion xidVer = this.tx.xidVersion();
            mapping.dhtVersion(xidVer, xidVer);
            this.tx.readyNearLocks(mapping, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
    }

    private void finish(Iterable<GridDistributedTxMapping> mappings, boolean commit2, boolean useCompletedVer) {
        int miniId = 0;
        for (GridDistributedTxMapping m : mappings) {
            this.finish(++miniId, m, commit2, useCompletedVer);
        }
    }

    private void finish(int miniId, GridDistributedTxMapping m, boolean commit2, boolean useCompletedVer) {
        ClusterNode n = m.primary();
        assert (!m.empty() || m.queryUpdate()) : m + " " + (Object)((Object)this.tx.state());
        CacheWriteSynchronizationMode syncMode = this.tx.syncMode();
        if (m.explicitLock() || m.queryUpdate()) {
            syncMode = CacheWriteSynchronizationMode.FULL_SYNC;
        }
        GridNearTxFinishRequest req = new GridNearTxFinishRequest(this.futId, this.tx.xidVersion(), this.tx.threadId(), commit2, this.tx.isInvalidate(), this.tx.system(), this.tx.ioPolicy(), syncMode, m.explicitLock(), this.tx.storeEnabled(), this.tx.topologyVersion(), null, null, null, this.tx.size(), this.tx.subjectId(), this.tx.taskNameHash(), this.tx.mvccSnapshot(), this.tx.activeCachesDeploymentEnabled());
        if (n.isLocal()) {
            req.miniId(miniId);
            IgniteInternalFuture<IgniteInternalTx> fut = this.cctx.tm().txHandler().finish(n.id(), this.tx, req);
            if (fut != null && syncMode == CacheWriteSynchronizationMode.FULL_SYNC) {
                this.add(fut);
            }
        } else {
            FinishMiniFuture fut = new FinishMiniFuture(miniId, m);
            req.miniId(fut.futureId());
            this.add(fut);
            if (this.tx.pessimistic() && !useCompletedVer) {
                this.cctx.tm().beforeFinishRemote(n.id(), this.tx.threadId());
            }
            try {
                boolean wait;
                this.cctx.io().send(n, (GridCacheMessage)req, this.tx.ioPolicy());
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near finish fut, sent request [txId=" + this.tx.nearXidVersion() + ", node=" + n.id() + ']');
                }
                boolean bl = wait = syncMode != CacheWriteSynchronizationMode.FULL_ASYNC;
                if (!wait) {
                    fut.onDone();
                }
            }
            catch (ClusterTopologyCheckedException ignored) {
                this.mappings.remove(m.primary().id());
                fut.onNodeLeft(n.id(), false);
            }
            catch (IgniteCheckedException e) {
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near finish fut, failed to send request [txId=" + this.tx.nearXidVersion() + ", node=" + n.id() + ", err=" + e + ']');
                }
                fut.onDone(e);
            }
        }
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f2) {
                if (f2.getClass() == FinishMiniFuture.class) {
                    FinishMiniFuture fut = (FinishMiniFuture)f2;
                    ClusterNode node = fut.primary();
                    if (node != null) {
                        return "FinishFuture[node=" + node.id() + ", loc=" + node.isLocal() + ", done=" + fut.isDone() + ']';
                    }
                    return "FinishFuture[node=null, done=" + fut.isDone() + ']';
                }
                if (f2.getClass() == CheckBackupMiniFuture.class) {
                    CheckBackupMiniFuture fut = (CheckBackupMiniFuture)f2;
                    ClusterNode node = fut.node();
                    if (node != null) {
                        return "CheckBackupFuture[node=" + node.id() + ", loc=" + node.isLocal() + ", done=" + f2.isDone() + "]";
                    }
                    return "CheckBackupFuture[node=null, done=" + f2.isDone() + "]";
                }
                if (f2.getClass() == CheckRemoteTxMiniFuture.class) {
                    CheckRemoteTxMiniFuture fut = (CheckRemoteTxMiniFuture)f2;
                    return "CheckRemoteTxMiniFuture[nodes=" + fut.nodes() + ", done=" + f2.isDone() + "]";
                }
                if (f2 instanceof MvccFuture) {
                    MvccFuture fut = (MvccFuture)f2;
                    return "WaitPreviousTxsFut[mvccCrd=" + fut.coordinatorNodeId() + ", done=" + f2.isDone() + "]";
                }
                return "[loc=true, done=" + f2.isDone() + "]";
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridNearTxFinishFuture.class, this, "innerFuts", futs, "super", super.toString());
    }

    private GridDhtTxFinishRequest checkCommittedRequest(int miniId, boolean waitRemoteTxs) {
        GridDhtTxFinishRequest finishReq = new GridDhtTxFinishRequest(this.cctx.localNodeId(), this.futureId(), miniId, this.tx.topologyVersion(), this.tx.xidVersion(), this.tx.commitVersion(), this.tx.threadId(), this.tx.isolation(), true, false, this.tx.system(), this.tx.ioPolicy(), false, this.tx.syncMode(), null, null, null, null, 0, null, 0, this.tx.activeCachesDeploymentEnabled(), !waitRemoteTxs && this.tx.needReturnValue() && this.tx.implicit(), waitRemoteTxs, null, null);
        finishReq.checkCommitted(true);
        return finishReq;
    }

    private class CheckRemoteTxMiniFuture
    extends MinFuture {
        private Set<UUID> nodes;

        CheckRemoteTxMiniFuture(int futId, Set<UUID> nodes2) {
            super(futId);
            this.nodes = nodes2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<UUID> nodes() {
            CheckRemoteTxMiniFuture checkRemoteTxMiniFuture = this;
            synchronized (checkRemoteTxMiniFuture) {
                return new HashSet<UUID>(this.nodes);
            }
        }

        @Override
        boolean onNodeLeft(UUID nodeId, boolean discoThread) {
            return this.onResponse(nodeId);
        }

        void onDhtFinishResponse(UUID nodeId, boolean discoThread) {
            this.onResponse(nodeId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean onResponse(UUID nodeId) {
            boolean done;
            boolean ret;
            CheckRemoteTxMiniFuture checkRemoteTxMiniFuture = this;
            synchronized (checkRemoteTxMiniFuture) {
                ret = this.nodes.remove(nodeId);
                done = this.nodes.isEmpty();
            }
            if (done) {
                this.onDone(GridNearTxFinishFuture.this.tx);
            }
            return ret;
        }

        @Override
        public String toString() {
            return S.toString(CheckRemoteTxMiniFuture.class, this);
        }
    }

    private class CheckBackupMiniFuture
    extends MinFuture {
        @GridToStringInclude
        private GridDistributedTxMapping m;
        private ClusterNode backup;

        CheckBackupMiniFuture(int futId, ClusterNode backup, GridDistributedTxMapping m) {
            super(futId);
            this.backup = backup;
            this.m = m;
        }

        public ClusterNode node() {
            return this.backup;
        }

        @Override
        boolean onNodeLeft(UUID nodeId, boolean discoThread) {
            if (nodeId.equals(this.backup.id())) {
                GridNearTxFinishFuture.this.readyNearMappingFromBackup(this.m);
                this.onDone(new ClusterTopologyCheckedException("Remote node left grid: " + nodeId));
                return true;
            }
            return false;
        }

        void onDhtFinishResponse(GridDhtTxFinishResponse res) {
            GridNearTxFinishFuture.this.readyNearMappingFromBackup(this.m);
            Throwable err2 = res.checkCommittedError();
            if (err2 != null) {
                ClusterTopologyCheckedException cause;
                if (err2 instanceof IgniteCheckedException && (cause = ((IgniteCheckedException)err2).getCause(ClusterTopologyCheckedException.class)) != null) {
                    cause.retryReadyFuture(GridNearTxFinishFuture.this.cctx.nextAffinityReadyFuture(GridNearTxFinishFuture.this.tx.topologyVersion()));
                }
                this.onDone(err2);
            } else {
                this.onDone(GridNearTxFinishFuture.this.tx);
            }
        }
    }

    private class FinishMiniFuture
    extends MinFuture {
        @GridToStringInclude
        private GridDistributedTxMapping m;

        FinishMiniFuture(int futId, GridDistributedTxMapping m) {
            super(futId);
            this.m = m;
        }

        ClusterNode primary() {
            return this.m.primary();
        }

        public GridDistributedTxMapping mapping() {
            return this.m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean onNodeLeft(UUID nodeId, boolean discoThread) {
            if (nodeId.equals(this.m.primary().id())) {
                Collection<UUID> backups;
                Map<UUID, Collection<UUID>> txNodes;
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near finish fut, mini future node left [txId=" + GridNearTxFinishFuture.this.tx.nearXidVersion() + ", node=" + this.m.primary().id() + ']');
                }
                if (GridNearTxFinishFuture.this.tx.syncMode() == CacheWriteSynchronizationMode.FULL_SYNC && (txNodes = GridNearTxFinishFuture.this.tx.transactionNodes()) != null && !F.isEmpty(backups = txNodes.get(nodeId))) {
                    CheckRemoteTxMiniFuture mini;
                    GridNearTxFinishFuture gridNearTxFinishFuture = GridNearTxFinishFuture.this;
                    synchronized (gridNearTxFinishFuture) {
                        int futId = Integer.MIN_VALUE + GridNearTxFinishFuture.this.futuresCountNoLock();
                        mini = new CheckRemoteTxMiniFuture(futId, new HashSet<UUID>(backups));
                        GridNearTxFinishFuture.this.add(mini);
                    }
                    GridDhtTxFinishRequest req = GridNearTxFinishFuture.this.checkCommittedRequest(mini.futureId(), true);
                    for (UUID backupId : backups) {
                        ClusterNode backup = GridNearTxFinishFuture.this.cctx.discovery().node(backupId);
                        if (backup != null) {
                            if (backup.isLocal()) {
                                IgniteInternalFuture<?> fut = GridNearTxFinishFuture.this.cctx.tm().remoteTxFinishFuture(GridNearTxFinishFuture.this.tx.nearXidVersion());
                                fut.listen(new CI1<IgniteInternalFuture<?>>(){

                                    @Override
                                    public void apply(IgniteInternalFuture<?> fut) {
                                        mini.onDhtFinishResponse(GridNearTxFinishFuture.this.cctx.localNodeId(), true);
                                    }
                                });
                                continue;
                            }
                            try {
                                GridNearTxFinishFuture.this.cctx.io().send(backup, (GridCacheMessage)req, GridNearTxFinishFuture.this.tx.ioPolicy());
                            }
                            catch (ClusterTopologyCheckedException ignored) {
                                mini.onNodeLeft(backupId, discoThread);
                            }
                            catch (IgniteCheckedException e) {
                                mini.onDone(e);
                            }
                            continue;
                        }
                        mini.onDhtFinishResponse(backupId, true);
                    }
                }
                this.onDone(GridNearTxFinishFuture.this.tx);
                return true;
            }
            return false;
        }

        void onNearFinishResponse(GridNearTxFinishResponse res) {
            if (res.error() != null) {
                if (res.error() instanceof IgniteTxRollbackCheckedException) {
                    if (log.isDebugEnabled()) {
                        log.debug("Transaction was rolled back: " + GridNearTxFinishFuture.this.tx);
                    }
                    this.onDone(GridNearTxFinishFuture.this.tx);
                } else {
                    this.onDone(res.error());
                }
            } else {
                this.onDone(GridNearTxFinishFuture.this.tx);
            }
        }

        @Override
        public String toString() {
            return S.toString(FinishMiniFuture.class, this, "done", (Object)this.isDone(), "cancelled", this.isCancelled(), "err", this.error());
        }
    }

    private abstract class MinFuture
    extends GridFutureAdapter<IgniteInternalTx> {
        private final int futId;

        MinFuture(int futId) {
            this.futId = futId;
        }

        abstract boolean onNodeLeft(UUID var1, boolean var2);

        final int futureId() {
            return this.futId;
        }
    }
}

