/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinator;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotResponseListener;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class GridNearPessimisticTxPrepareFuture
extends GridNearTxPrepareFutureAdapter {
    private static final long serialVersionUID = 4014479758215810181L;

    public GridNearPessimisticTxPrepareFuture(GridCacheSharedContext cctx, GridNearTxLocal tx) {
        super(cctx, tx);
        assert (tx.pessimistic()) : tx;
    }

    @Override
    public void onNearTxLocalTimeout() {
    }

    @Override
    protected boolean ignoreFailure(Throwable err2) {
        return IgniteCheckedException.class.isAssignableFrom(err2.getClass());
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f2;
            if (!(fut instanceof MiniFuture) || !(f2 = (MiniFuture)fut).primary().id().equals(nodeId)) continue;
            ClusterTopologyCheckedException e = new ClusterTopologyCheckedException("Remote node left grid: " + nodeId);
            e.retryReadyFuture(this.cctx.nextAffinityReadyFuture(this.tx.topologyVersion()));
            f2.onNodeLeft(e);
            found = true;
        }
        return found;
    }

    @Override
    public void onResult(UUID nodeId, GridNearTxPrepareResponse res) {
        if (!this.isDone()) {
            assert (res.clientRemapVersion() == null) : res;
            MiniFuture f2 = this.miniFuture(res.miniId());
            if (f2 != null) {
                assert (f2.primary().id().equals(nodeId));
                f2.onResult(res, true);
            } else if (msgLog.isDebugEnabled()) {
                msgLog.debug("Near pessimistic prepare, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("Near pessimistic prepare, response for finished future [txId=" + this.tx.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(int miniId) {
        GridNearPessimisticTxPrepareFuture gridNearPessimisticTxPrepareFuture = this;
        synchronized (gridNearPessimisticTxPrepareFuture) {
            int size2 = this.futuresCountNoLock();
            for (int i = 0; i < size2; ++i) {
                MiniFuture mini;
                IgniteInternalFuture fut = this.future(i);
                if (!(fut instanceof MiniFuture) || (mini = (MiniFuture)fut).futureId() != miniId) continue;
                if (!mini.isDone()) {
                    return mini;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void prepare() {
        if (!this.tx.state(TransactionState.PREPARING)) {
            if (this.tx.isRollbackOnly() || this.tx.setRollbackOnly()) {
                if (this.tx.remainingTime() == -1L) {
                    this.onDone(this.tx.timeoutException());
                } else {
                    this.onDone(this.tx.rollbackException());
                }
            } else {
                this.onDone(new IgniteCheckedException("Invalid transaction state for prepare [state=" + (Object)((Object)this.tx.state()) + ", tx=" + this + ']'));
            }
            return;
        }
        try {
            this.tx.userPrepare(Collections.emptyList());
            this.cctx.mvcc().addFuture(this);
            this.preparePessimistic();
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
        }
    }

    private GridNearTxPrepareRequest createRequest(Map<UUID, Collection<UUID>> txNodes, GridDistributedTxMapping m, long timeout, Collection<IgniteTxEntry> reads, Collection<IgniteTxEntry> writes) {
        GridNearTxPrepareRequest req = new GridNearTxPrepareRequest(this.futId, this.tx.topologyVersion(), this.tx, timeout, reads, writes, m.hasNearCacheEntries(), txNodes, true, this.tx.onePhaseCommit(), this.tx.needReturnValue() && this.tx.implicit(), this.tx.implicitSingle(), m.explicitLock(), this.tx.subjectId(), this.tx.taskNameHash(), false, true, this.tx.activeCachesDeploymentEnabled());
        req.queryUpdate(m.queryUpdate());
        for (IgniteTxEntry txEntry : writes) {
            if (txEntry.op() != GridCacheOperation.TRANSFORM) continue;
            req.addDhtVersion(txEntry.txKey(), null);
        }
        return req;
    }

    private void prepareLocal(GridNearTxPrepareRequest req, GridDistributedTxMapping m, int miniId, final boolean nearEntries) {
        final MiniFuture fut = new MiniFuture(m, miniId);
        req.miniId(fut.futureId());
        this.add(fut);
        IgniteInternalFuture<GridNearTxPrepareResponse> prepFut = nearEntries ? this.cctx.tm().txHandler().prepareNearTxLocal(req) : this.cctx.tm().txHandler().prepareColocatedTx(this.tx, req);
        prepFut.listen((IgniteInClosure<IgniteInternalFuture<GridNearTxPrepareResponse>>)new CI1<IgniteInternalFuture<GridNearTxPrepareResponse>>(){

            @Override
            public void apply(IgniteInternalFuture<GridNearTxPrepareResponse> prepFut) {
                try {
                    fut.onResult(prepFut.get(), nearEntries);
                }
                catch (IgniteCheckedException e) {
                    fut.onError(e);
                }
            }
        });
    }

    private void preparePessimistic() {
        long timeout;
        ClusterNode primary;
        HashMap<UUID, Collection<UUID>> txNodes;
        assert (!this.tx.implicitSingle() || this.tx.queryEnlisted());
        HashMap<UUID, GridDistributedTxMapping> mappings = new HashMap<UUID, GridDistributedTxMapping>();
        AffinityTopologyVersion topVer = this.tx.topologyVersion();
        MvccCoordinator mvccCrd = null;
        boolean hasNearCache = false;
        if (this.tx.txState().mvccEnabled()) {
            Collection<GridDistributedTxMapping> mvccMappings = this.tx.implicitSingle() ? Collections.singleton(this.tx.mappings().singleMapping()) : this.tx.mappings().mappings();
            txNodes = new HashMap(mvccMappings.size());
            for (GridDistributedTxMapping m : mvccMappings) {
                mappings.put(m.primary().id(), m);
                txNodes.put(m.primary().id(), m.backups());
            }
        } else {
            GridDhtTxMapping txMapping = new GridDhtTxMapping();
            for (IgniteTxEntry txEntry : this.tx.allEntries()) {
                List<ClusterNode> nodes2;
                txEntry.clearEntryReadVersion();
                GridCacheContext<?, ?> cacheCtx = txEntry.context();
                if (cacheCtx.isNear()) {
                    hasNearCache = true;
                }
                if (!cacheCtx.isLocal()) {
                    GridDhtPartitionTopology top = cacheCtx.topology();
                    nodes2 = top.nodes(cacheCtx.affinity().partition(txEntry.key()), topVer);
                } else {
                    nodes2 = cacheCtx.affinity().nodesByKey(txEntry.key(), topVer);
                }
                if (this.tx.mvccSnapshot() == null && mvccCrd == null && cacheCtx.mvccEnabled() && (mvccCrd = cacheCtx.affinity().mvccCoordinator(topVer)) == null) {
                    this.onDone(MvccUtils.noCoordinatorError(topVer));
                    return;
                }
                if (F.isEmpty(nodes2)) {
                    this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys to nodes (partition is not mapped to any node) [key=" + txEntry.key() + ", partition=" + cacheCtx.affinity().partition(txEntry.key()) + ", topVer=" + topVer + ']'));
                    return;
                }
                primary = nodes2.get(0);
                GridDistributedTxMapping nodeMapping = (GridDistributedTxMapping)mappings.get(primary.id());
                if (nodeMapping == null) {
                    nodeMapping = new GridDistributedTxMapping(primary);
                    mappings.put(primary.id(), nodeMapping);
                }
                txEntry.nodeId(primary.id());
                nodeMapping.add(txEntry);
                txMapping.addMapping(nodes2);
            }
            txNodes = txMapping.transactionNodes();
        }
        assert (!this.tx.txState().mvccEnabled() || this.tx.mvccSnapshot() != null || mvccCrd != null);
        this.tx.transactionNodes(txNodes);
        if (!hasNearCache) {
            this.checkOnePhase(txNodes);
        }
        if ((timeout = this.tx.remainingTime()) == -1L) {
            this.onDone(new IgniteTxTimeoutCheckedException("Transaction timed out and was rolled back: " + this.tx));
            return;
        }
        int miniId = 0;
        for (GridDistributedTxMapping m : mappings.values()) {
            GridNearTxPrepareRequest req;
            primary = m.primary();
            boolean needCntr = false;
            if (mvccCrd != null && (this.tx.onePhaseCommit() || mvccCrd.nodeId().equals(primary.id()))) {
                needCntr = true;
                mvccCrd = null;
            }
            if (primary.isLocal()) {
                if (m.hasNearCacheEntries() && m.hasColocatedCacheEntries()) {
                    GridNearTxPrepareRequest nearReq = this.createRequest(txNodes, m, timeout, m.nearEntriesReads(), m.nearEntriesWrites());
                    nearReq.requestMvccCounter(needCntr);
                    this.prepareLocal(nearReq, m, ++miniId, true);
                    GridNearTxPrepareRequest colocatedReq = this.createRequest(txNodes, m, timeout, m.colocatedEntriesReads(), m.colocatedEntriesWrites());
                    this.prepareLocal(colocatedReq, m, ++miniId, false);
                    continue;
                }
                req = this.createRequest(txNodes, m, timeout, m.reads(), m.writes());
                req.requestMvccCounter(needCntr);
                this.prepareLocal(req, m, ++miniId, m.hasNearCacheEntries());
                continue;
            }
            req = this.createRequest(txNodes, m, timeout, m.reads(), m.writes());
            req.requestMvccCounter(needCntr);
            MiniFuture fut = new MiniFuture(m, ++miniId);
            req.miniId(fut.futureId());
            this.add(fut);
            try {
                this.cctx.io().send(primary, (GridCacheMessage)req, this.tx.ioPolicy());
                if (!msgLog.isDebugEnabled()) continue;
                msgLog.debug("Near pessimistic prepare, sent request [txId=" + this.tx.nearXidVersion() + ", node=" + primary.id() + ']');
            }
            catch (ClusterTopologyCheckedException e) {
                e.retryReadyFuture(this.cctx.nextAffinityReadyFuture(topVer));
                fut.onNodeLeft(e);
            }
            catch (IgniteCheckedException e) {
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("Near pessimistic prepare, failed send request [txId=" + this.tx.nearXidVersion() + ", node=" + primary.id() + ", err=" + e + ']');
                }
                fut.onError(e);
                break;
            }
        }
        if (mvccCrd != null) {
            assert (!this.tx.onePhaseCommit());
            MvccSnapshotFutureExt fut = new MvccSnapshotFutureExt();
            this.cctx.coordinators().requestSnapshotAsync(this.tx, fut);
            this.add(fut);
        }
        this.markInitialized();
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry2, GridCacheMvccCandidate owner2) {
        return false;
    }

    @Override
    public boolean onDone(@Nullable IgniteInternalTx res, @Nullable Throwable err2) {
        if (err2 != null) {
            ERR_UPD.compareAndSet(this, null, err2);
        }
        if ((err2 = this.err) == null || this.tx.needCheckBackup()) {
            this.tx.state(TransactionState.PREPARED);
        }
        if (super.onDone(this.tx, err2)) {
            this.cctx.mvcc().removeVersionedFuture(this);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f2) {
                if (f2 instanceof MiniFuture) {
                    return "[node=" + ((MiniFuture)f2).primary().id() + ", loc=" + ((MiniFuture)f2).primary().isLocal() + ", done=" + f2.isDone() + "]";
                }
                return f2.toString();
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridNearPessimisticTxPrepareFuture.class, this, "innerFuts", futs, "txId", this.tx.nearXidVersion(), "super", super.toString());
    }

    private class MiniFuture
    extends GridFutureAdapter<GridNearTxPrepareResponse> {
        private final int futId;
        private GridDistributedTxMapping m;

        MiniFuture(GridDistributedTxMapping m, int futId) {
            this.m = m;
            this.futId = futId;
        }

        int futureId() {
            return this.futId;
        }

        public ClusterNode primary() {
            return this.m.primary();
        }

        void onResult(GridNearTxPrepareResponse res, boolean updateMapping) {
            if (res.error() != null) {
                this.onError(res.error());
            } else {
                if (res.mvccSnapshot() != null) {
                    GridNearPessimisticTxPrepareFuture.this.tx.mvccSnapshot(res.mvccSnapshot());
                }
                GridNearPessimisticTxPrepareFuture.this.onPrepareResponse(this.m, res, updateMapping);
                this.onDone(res);
            }
        }

        void onNodeLeft(ClusterTopologyCheckedException e) {
            if (GridNearTxPrepareFutureAdapter.msgLog.isDebugEnabled()) {
                GridNearTxPrepareFutureAdapter.msgLog.debug("Near pessimistic prepare, mini future node left [txId=" + GridNearPessimisticTxPrepareFuture.this.tx.nearXidVersion() + ", nodeId=" + this.m.primary().id() + ']');
            }
            if (GridNearPessimisticTxPrepareFuture.this.tx.onePhaseCommit()) {
                GridNearPessimisticTxPrepareFuture.this.tx.markForBackupCheck();
                this.onDone((GridNearTxPrepareResponse)null);
            }
            this.onError(e);
        }

        void onError(Throwable e) {
            if (this.isDone()) {
                U.warn(GridNearTxPrepareFutureAdapter.log, "Received error when future is done [fut=" + this + ", err=" + e + ", tx=" + GridNearPessimisticTxPrepareFuture.this.tx + ']');
                return;
            }
            if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                GridNearTxPrepareFutureAdapter.log.debug("Error on tx prepare [fut=" + this + ", err=" + e + ", tx=" + GridNearPessimisticTxPrepareFuture.this.tx + ']');
            }
            if (GridNearTxPrepareFutureAdapter.ERR_UPD.compareAndSet(GridNearPessimisticTxPrepareFuture.this, null, e)) {
                GridNearPessimisticTxPrepareFuture.this.tx.setRollbackOnly();
            }
            this.onDone(e);
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "done", (Object)this.isDone(), "cancelled", this.isCancelled(), "err", this.error());
        }
    }

    private class MvccSnapshotFutureExt
    extends GridFutureAdapter<Void>
    implements MvccSnapshotResponseListener {
        private MvccSnapshotFutureExt() {
        }

        @Override
        public void onResponse(MvccSnapshot res) {
            GridNearPessimisticTxPrepareFuture.this.tx.mvccSnapshot(res);
            this.onDone();
        }

        @Override
        public void onError(IgniteCheckedException e) {
            if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                GridNearTxPrepareFutureAdapter.log.debug("Error on tx prepare [fut=" + this + ", err=" + e + ", tx=" + GridNearPessimisticTxPrepareFuture.this.tx + ']');
            }
            if (GridNearTxPrepareFutureAdapter.ERR_UPD.compareAndSet(GridNearPessimisticTxPrepareFuture.this, null, e)) {
                GridNearPessimisticTxPrepareFuture.this.tx.setRollbackOnly();
            }
            this.onDone(e);
        }

        @Override
        public String toString() {
            return S.toString(MvccSnapshotFutureExt.class, this, super.toString());
        }
    }
}

