/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotResponseListener;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public abstract class GridNearOptimisticTxPrepareFutureAdapter
extends GridNearTxPrepareFutureAdapter {
    private static final long serialVersionUID = 7460376140787916619L;
    private static final AtomicIntegerFieldUpdater<MvccSnapshotFutureExt> LOCK_CNT_UPD = AtomicIntegerFieldUpdater.newUpdater(MvccSnapshotFutureExt.class, "lockCnt");
    @GridToStringExclude
    protected KeyLockFuture keyLockFut;
    @GridToStringExclude
    protected MvccSnapshotFutureExt mvccVerFut;

    protected GridNearOptimisticTxPrepareFutureAdapter(GridCacheSharedContext cctx, GridNearTxLocal tx) {
        super(cctx, tx);
        assert (tx.optimistic()) : tx;
        if (tx.timeout() > 0L) {
            for (IgniteTxEntry e : tx.writeEntries()) {
                if (!e.context().isNear() && !e.context().isLocal()) continue;
                this.keyLockFut = new KeyLockFuture();
                break;
            }
            if (tx.serializable() && this.keyLockFut == null) {
                for (IgniteTxEntry e : tx.readEntries()) {
                    if (!e.context().isNear() && !e.context().isLocal()) continue;
                    this.keyLockFut = new KeyLockFuture();
                    break;
                }
            }
            if (this.keyLockFut != null) {
                this.add(this.keyLockFut);
            }
        }
    }

    @Override
    public final void onNearTxLocalTimeout() {
        if (this.keyLockFut != null && !this.keyLockFut.isDone()) {
            ERR_UPD.compareAndSet(this, null, new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + this.tx.timeout() + ", tx=" + this.tx + ']'));
            this.keyLockFut.onDone();
        }
    }

    @Override
    public final void prepare() {
        long threadId = Thread.currentThread().getId();
        AffinityTopologyVersion topVer = this.cctx.mvcc().lastExplicitLockTopologyVersion(threadId);
        if (topVer == null && this.tx.system() && (topVer = this.cctx.tm().lockedTopologyVersion(threadId, this.tx)) == null) {
            topVer = this.tx.topologyVersionSnapshot();
        }
        if (topVer != null) {
            this.tx.topologyVersion(topVer);
            this.cctx.mvcc().addFuture(this);
            this.prepare0(false, true);
            return;
        }
        this.prepareOnTopology(false, null);
    }

    protected final GridDhtTopologyFuture topologyReadLock() {
        return this.tx.txState().topologyReadLock(this.cctx, this);
    }

    protected final void topologyReadUnlock() {
        this.tx.txState().topologyReadUnlock(this.cctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void prepareOnTopology(boolean remap, @Nullable Runnable c) {
        GridDhtTopologyFuture topFut = this.topologyReadLock();
        AffinityTopologyVersion topVer = null;
        try {
            if (topFut == null) {
                assert (this.isDone());
                return;
            }
            if (topFut.isDone()) {
                topVer = topFut.topologyVersion();
                if (remap) {
                    this.tx.onRemap(topVer);
                } else {
                    this.tx.topologyVersion(topVer);
                }
                if (!remap) {
                    this.cctx.mvcc().addFuture(this);
                }
            }
        }
        finally {
            this.topologyReadUnlock();
        }
        if (topVer != null) {
            IgniteCheckedException err2 = this.tx.txState().validateTopology(this.cctx, this.tx.writeMap().isEmpty(), topFut);
            if (err2 != null) {
                this.onDone(err2);
                return;
            }
            this.prepare0(remap, false);
            if (c != null) {
                c.run();
            }
        } else {
            this.cctx.time().waitAsync(topFut, this.tx.remainingTime(), (e, timedOut) -> {
                if (this.errorOrTimeoutOnTopologyVersion((IgniteCheckedException)e, (boolean)timedOut)) {
                    return;
                }
                try {
                    this.prepareOnTopology(remap, c);
                }
                finally {
                    this.cctx.txContextReset();
                }
            });
        }
    }

    protected abstract void prepare0(boolean var1, boolean var2);

    final void initMvccVersionFuture(int lockCnt, boolean remap) {
        if (!remap) {
            this.mvccVerFut = new MvccSnapshotFutureExt();
            this.mvccVerFut.init(lockCnt);
            if (this.keyLockFut != null) {
                this.keyLockFut.listen(this.mvccVerFut);
            }
            this.add(this.mvccVerFut);
        } else {
            assert (this.mvccVerFut != null);
            this.mvccVerFut.init(lockCnt);
        }
    }

    protected boolean errorOrTimeoutOnTopologyVersion(IgniteCheckedException e, boolean timedOut) {
        if (e != null || timedOut) {
            if (timedOut) {
                e = this.tx.timeoutException();
            }
            ERR_UPD.compareAndSet(this, null, e);
            this.onDone(e);
            return true;
        }
        return false;
    }

    class MvccSnapshotFutureExt
    extends GridFutureAdapter<Void>
    implements MvccSnapshotResponseListener,
    IgniteInClosure<IgniteInternalFuture<Void>> {
        private static final long serialVersionUID = 5883078648683911226L;
        volatile int lockCnt;

        MvccSnapshotFutureExt() {
        }

        @Override
        public void apply(IgniteInternalFuture<Void> keyLockFut) {
            block2: {
                try {
                    keyLockFut.get();
                    this.onLockReceived();
                }
                catch (IgniteCheckedException e) {
                    if (!GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) break block2;
                    GridNearTxPrepareFutureAdapter.log.debug("MvccSnapshotFutureExt ignores key lock future failure: " + e);
                }
            }
        }

        void init(int lockCnt) {
            assert (lockCnt > 0);
            this.lockCnt = lockCnt;
            assert (!this.isDone());
        }

        void onLockReceived() {
            int remaining = LOCK_CNT_UPD.decrementAndGet(this);
            assert (remaining >= 0) : remaining;
            if (remaining == 0) {
                try {
                    MvccSnapshot snapshot2 = GridNearOptimisticTxPrepareFutureAdapter.this.cctx.coordinators().tryRequestSnapshotLocal(GridNearOptimisticTxPrepareFutureAdapter.this.tx);
                    if (snapshot2 != null) {
                        this.onResponse(snapshot2);
                    } else {
                        GridNearOptimisticTxPrepareFutureAdapter.this.cctx.coordinators().requestSnapshotAsync(GridNearOptimisticTxPrepareFutureAdapter.this.tx, this);
                    }
                }
                catch (ClusterTopologyCheckedException e) {
                    this.onError(e);
                }
            }
        }

        @Override
        public void onResponse(MvccSnapshot res) {
            GridNearOptimisticTxPrepareFutureAdapter.this.tx.mvccSnapshot(res);
            this.onDone();
        }

        @Override
        public void onError(IgniteCheckedException e) {
            if (e instanceof ClusterTopologyCheckedException) {
                ((ClusterTopologyCheckedException)e).retryReadyFuture(GridNearOptimisticTxPrepareFutureAdapter.this.cctx.nextAffinityReadyFuture(GridNearOptimisticTxPrepareFutureAdapter.this.tx.topologyVersion()));
            }
            GridNearTxPrepareFutureAdapter.ERR_UPD.compareAndSet(GridNearOptimisticTxPrepareFutureAdapter.this, null, e);
            this.onDone();
        }

        @Override
        public String toString() {
            return S.toString(MvccSnapshotFutureExt.class, this, super.toString());
        }
    }

    protected static class KeyLockFuture
    extends GridFutureAdapter<Void> {
        @GridToStringInclude
        protected Collection<IgniteTxKey> lockKeys = new GridConcurrentHashSet<IgniteTxKey>();
        protected volatile boolean allKeysAdded;

        protected KeyLockFuture() {
        }

        protected void addLockKey(IgniteTxKey key) {
            assert (!this.allKeysAdded);
            this.lockKeys.add(key);
        }

        protected void onKeyLocked(IgniteTxKey key) {
            this.lockKeys.remove(key);
            this.checkLocks();
        }

        protected void onAllKeysAdded() {
            this.allKeysAdded = true;
            this.checkLocks();
        }

        private void checkLocks() {
            boolean locked = this.lockKeys.isEmpty();
            if (locked && this.allKeysAdded) {
                if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                    GridNearTxPrepareFutureAdapter.log.debug("All locks are acquired for near prepare future: " + this);
                }
                this.onDone((Void)null);
            } else if (GridNearTxPrepareFutureAdapter.log.isDebugEnabled()) {
                GridNearTxPrepareFutureAdapter.log.debug("Still waiting for locks [fut=" + this + ", keys=" + this.lockKeys + ']');
            }
        }

        @Override
        public String toString() {
            return S.toString(KeyLockFuture.class, this, super.toString());
        }
    }
}

