/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockResponse;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridNearLockResponse
extends GridDistributedLockResponse {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectCollection(value=GridCacheVersion.class)
    private Collection<GridCacheVersion> pending;
    private int miniId;
    @GridToStringInclude
    private GridCacheVersion[] dhtVers;
    @GridToStringInclude
    private GridCacheVersion[] mappedVers;
    private boolean[] filterRes;
    private AffinityTopologyVersion clientRemapVer;

    public GridNearLockResponse() {
    }

    public GridNearLockResponse(int cacheId, GridCacheVersion lockVer, IgniteUuid futId, int miniId, boolean filterRes, int cnt, Throwable err2, AffinityTopologyVersion clientRemapVer, boolean addDepInfo) {
        super(cacheId, lockVer, futId, cnt, err2, addDepInfo);
        assert (miniId != 0);
        this.miniId = miniId;
        this.clientRemapVer = clientRemapVer;
        this.dhtVers = new GridCacheVersion[cnt];
        this.mappedVers = new GridCacheVersion[cnt];
        if (filterRes) {
            this.filterRes = new boolean[cnt];
        }
    }

    @Nullable
    public AffinityTopologyVersion clientRemapVersion() {
        return this.clientRemapVer;
    }

    public Collection<GridCacheVersion> pending() {
        return this.pending;
    }

    public void pending(Collection<GridCacheVersion> pending) {
        this.pending = pending;
    }

    public int miniId() {
        return this.miniId;
    }

    public GridCacheVersion dhtVersion(int idx) {
        return this.dhtVers == null ? null : this.dhtVers[idx];
    }

    public GridCacheVersion mappedVersion(int idx) {
        return this.mappedVers == null ? null : this.mappedVers[idx];
    }

    public boolean filterResult(int idx) {
        assert (this.filterRes != null) : "Should not call filterResult for non-fast-commit transactions.";
        return this.filterRes[idx];
    }

    public void addValueBytes(@Nullable CacheObject val, boolean filterPassed, @Nullable GridCacheVersion dhtVer, @Nullable GridCacheVersion mappedVer) throws IgniteCheckedException {
        int idx = this.valuesSize();
        this.dhtVers[idx] = dhtVer;
        this.mappedVers[idx] = mappedVer;
        if (this.filterRes != null) {
            this.filterRes[idx] = filterPassed;
        }
        this.addValue(val);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 10: {
                if (!writer.writeMessage("clientRemapVer", this.clientRemapVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeObjectArray("dhtVers", this.dhtVers, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeBooleanArray("filterRes", this.filterRes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeObjectArray("mappedVers", this.mappedVers, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeInt("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeCollection("pending", this.pending, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 10: {
                this.clientRemapVer = (AffinityTopologyVersion)reader.readMessage("clientRemapVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.dhtVers = reader.readObjectArray("dhtVers", MessageCollectionItemType.MSG, GridCacheVersion.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.filterRes = reader.readBooleanArray("filterRes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.mappedVers = reader.readObjectArray("mappedVers", MessageCollectionItemType.MSG, GridCacheVersion.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.miniId = reader.readInt("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.pending = reader.readCollection("pending", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearLockResponse.class);
    }

    @Override
    public short directType() {
        return 52;
    }

    @Override
    public byte fieldsCount() {
        return 16;
    }

    @Override
    public String toString() {
        return S.toString(GridNearLockResponse.class, this, super.toString());
    }
}

