/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.CacheDistributedGetFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public final class GridNearGetFuture<K, V>
extends CacheDistributedGetFutureAdapter<K, V> {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private IgniteTxLocalEx tx;
    private GridCacheVersion ver;

    public GridNearGetFuture(GridCacheContext<K, V> cctx, Collection<KeyCacheObject> keys, boolean readThrough, boolean forcePrimary, @Nullable IgniteTxLocalEx tx, @Nullable UUID subjId, String taskName, boolean deserializeBinary, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObjects, boolean recovery) {
        super(cctx, keys, readThrough, forcePrimary, subjId, taskName, deserializeBinary, expiryPlc, skipVals, needVer, keepCacheObjects, recovery);
        assert (!F.isEmpty(keys));
        this.tx = tx;
        this.futId = IgniteUuid.randomUuid();
        GridCacheVersion gridCacheVersion = this.ver = tx == null ? cctx.versions().next() : tx.xidVersion();
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridNearGetFuture.class);
        }
    }

    public void init(@Nullable AffinityTopologyVersion topVer) {
        AffinityTopologyVersion lockedTopVer = this.cctx.shared().lockedTopologyVersion(null);
        if (lockedTopVer != null) {
            this.canRemap = false;
            this.map(this.keys, Collections.emptyMap(), lockedTopVer);
        } else {
            AffinityTopologyVersion mapTopVer = topVer;
            if (mapTopVer == null) {
                mapTopVer = this.tx == null ? (this.canRemap ? this.cctx.affinity().affinityTopologyVersion() : this.cctx.shared().exchange().readyAffinityVersion()) : this.tx.topologyVersion();
            }
            this.map(this.keys, Collections.emptyMap(), mapTopVer);
        }
        this.markInitialized();
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f2;
            if (!this.isMini(fut) || !(f2 = (MiniFuture)fut).node().id().equals(nodeId)) continue;
            found = true;
            f2.onNodeLeft();
        }
        return found;
    }

    @Override
    public void onResult(UUID nodeId, GridNearGetResponse res) {
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f2;
            if (!this.isMini(fut) || !(f2 = (MiniFuture)fut).futureId().equals(res.miniId())) continue;
            assert (f2.node().id().equals(nodeId));
            f2.onResult(res);
        }
    }

    @Override
    public boolean onDone(Map<K, V> res, Throwable err2) {
        if (super.onDone(res, err2)) {
            if (this.trackable) {
                this.cctx.mvcc().removeFuture(this.futId);
            }
            this.cache().dht().sendTtlUpdateRequest(this.expiryPlc);
            return true;
        }
        return false;
    }

    private boolean isMini(IgniteInternalFuture<?> f2) {
        return f2.getClass().equals(MiniFuture.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void map(Collection<KeyCacheObject> keys, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mapped, final AffinityTopologyVersion topVer) {
        Collection<ClusterNode> affNodes = CU.affinityNodes(this.cctx, topVer);
        if (affNodes.isEmpty()) {
            assert (!this.cctx.affinityNode());
            this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys for near-only cache (all partition nodes left the grid)."));
            return;
        }
        HashMap<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mappings = U.newHashMap(affNodes.size());
        Map<KeyCacheObject, GridNearCacheEntry> savedEntries = null;
        boolean success2 = false;
        try {
            for (KeyCacheObject key : keys) {
                savedEntries = this.map(key, mappings, topVer, mapped, savedEntries);
            }
            success2 = true;
        }
        finally {
            if (!success2) {
                GridCacheVersion obsolete = this.cctx.versions().next(topVer);
                if (savedEntries != null) {
                    for (GridNearCacheEntry gridNearCacheEntry : savedEntries.values()) {
                        gridNearCacheEntry.releaseEviction();
                        if (!gridNearCacheEntry.markObsolete(obsolete)) continue;
                        gridNearCacheEntry.context().cache().removeEntry(gridNearCacheEntry);
                    }
                }
            }
        }
        if (this.isDone()) {
            return;
        }
        final Map<KeyCacheObject, GridNearCacheEntry> saved = savedEntries != null ? savedEntries : Collections.emptyMap();
        int keysSize = keys.size();
        for (Map.Entry entry2 : mappings.entrySet()) {
            IgniteInternalFuture fut;
            final ClusterNode n = (ClusterNode)entry2.getKey();
            final LinkedHashMap mappedKeys = (LinkedHashMap)entry2.getValue();
            assert (!mappedKeys.isEmpty());
            if (n.isLocal()) {
                fut = this.dht().getDhtAsync(n.id(), -1L, mappedKeys, false, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc, this.skipVals, this.recovery, null);
                Collection<Integer> invalidParts = fut.invalidPartitions();
                if (!F.isEmpty(invalidParts)) {
                    ArrayList<KeyCacheObject> remapKeys = new ArrayList<KeyCacheObject>(keysSize);
                    for (KeyCacheObject key : keys) {
                        if (key == null || !invalidParts.contains(this.cctx.affinity().partition(key))) continue;
                        remapKeys.add(key);
                    }
                    AffinityTopologyVersion updTopVer = this.cctx.shared().exchange().readyAffinityVersion();
                    assert (updTopVer.compareTo(topVer) > 0) : "Got invalid partitions for local node but topology version did not change [topVer=" + topVer + ", updTopVer=" + updTopVer + ", invalidParts=" + invalidParts + ']';
                    this.map(remapKeys, mappings, updTopVer);
                }
                this.add(fut.chain(new C1<IgniteInternalFuture<Collection<GridCacheEntryInfo>>, Map<K, V>>(){

                    @Override
                    public Map<K, V> apply(IgniteInternalFuture<Collection<GridCacheEntryInfo>> fut) {
                        try {
                            return GridNearGetFuture.this.loadEntries(n.id(), mappedKeys.keySet(), fut.get(), saved, topVer);
                        }
                        catch (Exception e) {
                            U.error(log, "Failed to get values from dht cache [fut=" + fut + "]", e);
                            GridNearGetFuture.this.onDone(e);
                            return Collections.emptyMap();
                        }
                    }
                }));
                continue;
            }
            if (!this.trackable) {
                this.trackable = true;
                this.cctx.mvcc().addFuture(this, this.futId);
            }
            fut = new MiniFuture(n, mappedKeys, saved, topVer, CU.createBackupPostProcessingClosure(topVer, log, this.cctx, null, this.expiryPlc, this.readThrough, this.skipVals));
            GridNearGetRequest req = new GridNearGetRequest(this.cctx.cacheId(), this.futId, ((MiniFuture)fut).futureId(), this.ver, mappedKeys, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc != null ? this.expiryPlc.forCreate() : -1L, this.expiryPlc != null ? this.expiryPlc.forAccess() : -1L, true, this.skipVals, this.cctx.deploymentEnabled(), this.recovery, null);
            this.add(fut);
            try {
                this.cctx.io().send(n, (GridCacheMessage)req, this.cctx.ioPolicy());
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    ((MiniFuture)fut).onNodeLeft();
                    continue;
                }
                ((MiniFuture)fut).onResult(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<KeyCacheObject, GridNearCacheEntry> map(KeyCacheObject key, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mappings, AffinityTopologyVersion topVer, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mapped, Map<KeyCacheObject, GridNearCacheEntry> saved) {
        int part = this.cctx.affinity().partition(key);
        List<ClusterNode> affNodes = this.cctx.affinity().nodesByPartition(part, topVer);
        if (affNodes.isEmpty()) {
            this.onDone(this.serverNotFoundError(topVer));
            return null;
        }
        GridNearCacheAdapter<K, V> near = this.cache();
        boolean allowLocRead = !this.forcePrimary || this.cctx.localNode().equals(affNodes.get(0));
        while (true) {
            GridNearCacheEntry entry2 = allowLocRead ? (GridNearCacheEntry)near.peekEx(key) : null;
            try {
                boolean isNear;
                CacheObject v = null;
                GridCacheVersion ver = null;
                boolean bl = isNear = entry2 != null;
                if (isNear) {
                    if (this.needVer) {
                        EntryGetResult res = entry2.innerGetVersioned(null, null, true, !this.skipVals, this.subjId, null, this.taskName, this.expiryPlc, !this.deserializeBinary, null, null);
                        if (res != null) {
                            v = (CacheObject)res.value();
                            ver = res.version();
                        }
                    } else {
                        v = entry2.innerGet(null, this.tx, false, true, !this.skipVals, this.subjId, null, this.taskName, this.expiryPlc, !this.deserializeBinary, null);
                    }
                }
                if (v == null) {
                    LinkedHashMap<KeyCacheObject, Boolean> old;
                    boolean addRdr;
                    LinkedHashMap<KeyCacheObject, Boolean> keys;
                    ClusterNode affNode;
                    boolean fastLocGet;
                    boolean bl2 = fastLocGet = allowLocRead && this.cctx.reserveForFastLocalGet(part, topVer);
                    if (fastLocGet) {
                        try {
                            if (this.localDhtGet(key, part, topVer, isNear)) {
                                break;
                            }
                        }
                        finally {
                            this.cctx.releaseForFastLocalGet(part, topVer);
                        }
                    }
                    if ((affNode = this.cctx.selectAffinityNodeBalanced(affNodes, this.canRemap)) == null) {
                        this.onDone(this.serverNotFoundError(topVer));
                        Map<KeyCacheObject, GridNearCacheEntry> map2 = saved;
                        return map2;
                    }
                    if (this.cctx.statisticsEnabled() && !this.skipVals && !affNode.isLocal() && !isNear) {
                        this.cache().metrics0().onRead(false);
                    }
                    if ((keys = mapped.get(affNode)) != null && keys.containsKey(key) && REMAP_CNT_UPD.incrementAndGet(this) > MAX_REMAP_CNT) {
                        this.onDone(new ClusterTopologyCheckedException("Failed to remap key to a new node after " + MAX_REMAP_CNT + " attempts (key got remapped to the same node) [key=" + key + ", node=" + U.toShortString(affNode) + ", mappings=" + mapped + ']'));
                        Map<KeyCacheObject, GridNearCacheEntry> map3 = saved;
                        return map3;
                    }
                    if (!affNodes.contains(this.cctx.localNode())) {
                        GridNearCacheEntry nearEntry = entry2 != null ? entry2 : near.entryExx(key, topVer);
                        nearEntry.reserveEviction();
                        entry2 = null;
                        if (saved == null) {
                            saved = U.newHashMap(3);
                        }
                        saved.put(key, nearEntry);
                    }
                    boolean bl3 = addRdr = this.tx == null || this.tx.optimistic();
                    if (!addRdr && this.tx.readCommitted() && !this.tx.writeSet().contains(this.cctx.txKey(key))) {
                        addRdr = true;
                    }
                    if ((old = mappings.get(affNode)) == null) {
                        old = new LinkedHashMap(3, 1.0f);
                        mappings.put(affNode, old);
                    }
                    old.put(key, addRdr);
                    break;
                }
                this.addResult(key, v, ver);
                break;
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
                break;
            }
            catch (GridCacheEntryRemovedException gridCacheEntryRemovedException) {}
            continue;
            finally {
                if (entry2 == null || this.tx != null) continue;
                entry2.touch(topVer);
                continue;
            }
            break;
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean localDhtGet(KeyCacheObject key, int part, AffinityTopologyVersion topVer, boolean nearRead) {
        GridDhtCacheAdapter<K, V> dht = this.cache().dht();
        assert (dht.context().affinityNode()) : this;
        while (true) {
            boolean bl;
            GridCacheEntryEx dhtEntry = null;
            try {
                boolean isNew;
                dhtEntry = dht.entryEx(key);
                CacheObject v = null;
                if (dhtEntry != null) {
                    boolean bl2 = isNew = dhtEntry.isNewLocked() || !dhtEntry.valid(topVer);
                    if (this.needVer) {
                        EntryGetResult res = dhtEntry.innerGetVersioned(null, null, false, !nearRead && !this.skipVals, this.subjId, null, this.taskName, this.expiryPlc, !this.deserializeBinary, null, null);
                        if (res != null) {
                            v = (CacheObject)res.value();
                            this.ver = res.version();
                        }
                    } else {
                        v = dhtEntry.innerGet(null, this.tx, false, false, !nearRead && !this.skipVals, this.subjId, null, this.taskName, this.expiryPlc, !this.deserializeBinary, null);
                    }
                    if (v == null && isNew && dhtEntry.markObsoleteIfEmpty(this.ver)) {
                        dht.removeEntry(dhtEntry);
                    }
                }
                if (v != null) {
                    if (this.cctx.statisticsEnabled() && !this.skipVals) {
                        this.cache().metrics0().onRead(true);
                    }
                    this.addResult(key, v, this.ver);
                    isNew = true;
                    return isNew;
                }
                boolean topStable = this.cctx.isReplicated() || topVer.equals(this.cctx.topology().lastTopologyChangeVersion());
                boolean bl3 = !this.cctx.readThroughConfigured() && (topStable || this.partitionOwned(part));
                return bl3;
            }
            catch (GridCacheEntryRemovedException v) {
                continue;
            }
            catch (GridDhtInvalidPartitionException ignored) {
                bl = false;
                return bl;
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
                bl = false;
                return bl;
            }
            finally {
                if (dhtEntry == null) continue;
                dhtEntry.touch(topVer);
                continue;
            }
            break;
        }
    }

    private void addResult(KeyCacheObject key, CacheObject v, GridCacheVersion ver) {
        if (this.keepCacheObjects) {
            KeyCacheObject key0 = key;
            Object val0 = this.needVer ? new EntryGetResult(this.skipVals ? Boolean.valueOf(true) : v, ver) : (this.skipVals ? Boolean.valueOf(true) : v);
            this.add(new GridFinishedFuture<Map<KeyCacheObject, Object>>(Collections.singletonMap(key0, val0)));
        } else {
            Object key0 = this.cctx.unwrapBinaryIfNeeded(key, !this.deserializeBinary, false);
            Object val0 = this.needVer ? new EntryGetResult(!this.skipVals ? this.cctx.unwrapBinaryIfNeeded(v, !this.deserializeBinary, false) : Boolean.TRUE, ver) : (!this.skipVals ? this.cctx.unwrapBinaryIfNeeded(v, !this.deserializeBinary, false) : Boolean.TRUE);
            this.add(new GridFinishedFuture<Map<Object, Object>>(Collections.singletonMap(key0, val0)));
        }
    }

    private GridNearCacheAdapter<K, V> cache() {
        return (GridNearCacheAdapter)this.cctx.cache();
    }

    private GridDhtCacheAdapter<K, V> dht() {
        return this.cache().dht();
    }

    private Map<K, V> loadEntries(UUID nodeId, Collection<KeyCacheObject> keys, Collection<GridCacheEntryInfo> infos, Map<KeyCacheObject, GridNearCacheEntry> savedEntries, AffinityTopologyVersion topVer) {
        GridLeanMap map2;
        boolean empty = F.isEmpty(keys);
        GridLeanMap gridLeanMap = map2 = empty ? Collections.emptyMap() : new GridLeanMap(keys.size());
        if (!empty) {
            boolean atomic = this.cctx.atomic();
            GridCacheVersion ver = atomic ? null : (F.isEmpty(infos) ? null : this.cctx.versions().next());
            for (GridCacheEntryInfo info2 : infos) {
                try {
                    info2.unmarshalValue(this.cctx, this.cctx.deploy().globalLoader());
                    if (!this.cctx.affinity().keyLocalNode(info2.key(), this.cctx.affinity().affinityTopologyVersion())) {
                        GridNearCacheEntry entry2 = savedEntries.get(info2.key());
                        if (entry2 == null) {
                            entry2 = this.cache().entryExx(info2.key(), topVer);
                        }
                        entry2.loadedValue(this.tx, nodeId, info2.value(), atomic ? info2.version() : ver, info2.version(), info2.ttl(), info2.expireTime(), true, !this.deserializeBinary, topVer, this.subjId);
                    }
                    CacheObject val = info2.value();
                    KeyCacheObject key = info2.key();
                    assert (this.skipVals == (info2.value() == null));
                    this.cctx.addResult(map2, key, val, this.skipVals, this.keepCacheObjects, this.deserializeBinary, false, this.needVer ? info2.version() : null, 0L, 0L);
                }
                catch (GridCacheEntryRemovedException ignore) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Got removed entry while processing get response (will not retry).");
                }
                catch (Exception e) {
                    this.onDone(e);
                    return Collections.emptyMap();
                }
            }
        }
        return map2;
    }

    private void releaseEvictions(Collection<KeyCacheObject> keys, Map<KeyCacheObject, GridNearCacheEntry> saved, AffinityTopologyVersion topVer) {
        for (KeyCacheObject key : keys) {
            GridNearCacheEntry entry2 = saved.get(key);
            if (entry2 == null) continue;
            entry2.releaseEviction();
            if (this.tx != null) continue;
            entry2.touch(topVer);
        }
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f2) {
                if (GridNearGetFuture.this.isMini(f2)) {
                    return "[node=" + ((MiniFuture)f2).node().id() + ", loc=" + ((MiniFuture)f2).node().isLocal() + ", done=" + f2.isDone() + "]";
                }
                return "[loc=true, done=" + f2.isDone() + "]";
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridNearGetFuture.class, this, "innerFuts", futs, "super", super.toString());
    }

    private class MiniFuture
    extends GridFutureAdapter<Map<K, V>> {
        private final IgniteUuid futId = IgniteUuid.randomUuid();
        private ClusterNode node;
        @GridToStringInclude
        private LinkedHashMap<KeyCacheObject, Boolean> keys;
        private Map<KeyCacheObject, GridNearCacheEntry> savedEntries;
        private AffinityTopologyVersion topVer;
        private final GridCacheUtils.BackupPostProcessingClosure postProcessingClos;
        private boolean remapped;

        MiniFuture(ClusterNode node, LinkedHashMap<KeyCacheObject, Boolean> keys, Map<KeyCacheObject, GridNearCacheEntry> savedEntries, AffinityTopologyVersion topVer, GridCacheUtils.BackupPostProcessingClosure postProcessingClos) {
            this.node = node;
            this.keys = keys;
            this.savedEntries = savedEntries;
            this.topVer = topVer;
            this.postProcessingClos = postProcessingClos;
        }

        IgniteUuid futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.node;
        }

        public Collection<KeyCacheObject> keys() {
            return this.keys.keySet();
        }

        void onResult(Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get future result [fut=" + this + ", err=" + e + ']');
            }
            this.onDone(e);
        }

        @Override
        public boolean onDone(@Nullable Map<K, V> res, @Nullable Throwable err2) {
            if (super.onDone(res, err2)) {
                GridNearGetFuture.this.releaseEvictions(this.keys.keySet(), this.savedEntries, this.topVer);
                return true;
            }
            return false;
        }

        synchronized void onNodeLeft() {
            if (this.remapped) {
                return;
            }
            this.remapped = true;
            if (log.isDebugEnabled()) {
                log.debug("Remote node left grid while sending or waiting for reply (will retry): " + this);
            }
            if (!GridNearGetFuture.this.canRemap) {
                GridNearGetFuture.this.map(this.keys.keySet(), F.t(this.node, this.keys), this.topVer);
                this.onDone(Collections.emptyMap());
            } else {
                AffinityTopologyVersion updTopVer = new AffinityTopologyVersion(Math.max(this.topVer.topologyVersion() + 1L, GridNearGetFuture.this.cctx.discovery().topologyVersion()));
                GridNearGetFuture.this.cctx.shared().exchange().affinityReadyFuture(updTopVer).listen(f2 -> {
                    try {
                        GridNearGetFuture.this.map(this.keys.keySet(), F.t(this.node, this.keys), (AffinityTopologyVersion)f2.get());
                        this.onDone(Collections.emptyMap());
                    }
                    catch (IgniteCheckedException e) {
                        GridNearGetFuture.this.onDone(e);
                    }
                });
            }
        }

        void onResult(final GridNearGetResponse res) {
            final Collection<Integer> invalidParts = res.invalidPartitions();
            if (res.error() != null) {
                this.onDone(res.error());
                return;
            }
            if (!F.isEmpty(invalidParts)) {
                AffinityTopologyVersion rmtTopVer = res.topologyVersion();
                assert (rmtTopVer.topologyVersion() != 0L);
                if (rmtTopVer.compareTo(this.topVer) <= 0) {
                    this.onDone(new IgniteCheckedException("Failed to process invalid partitions response (remote node reported invalid partitions but remote topology version does not differ from local) [topVer=" + this.topVer + ", rmtTopVer=" + rmtTopVer + ", invalidParts=" + invalidParts + ", nodeId=" + this.node.id() + ']'));
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Remapping mini get future [invalidParts=" + invalidParts + ", fut=" + this + ']');
                }
                if (!GridNearGetFuture.this.canRemap) {
                    GridNearGetFuture.this.map(F.view(this.keys.keySet(), new P1<KeyCacheObject>(){

                        @Override
                        public boolean apply(KeyCacheObject key) {
                            return invalidParts.contains(GridNearGetFuture.this.cctx.affinity().partition(key));
                        }
                    }), F.t(this.node, this.keys), this.topVer);
                    this.postProcessResultAndDone(res);
                    return;
                }
                IgniteInternalFuture<AffinityTopologyVersion> topFut = GridNearGetFuture.this.cctx.shared().exchange().affinityReadyFuture(rmtTopVer);
                topFut.listen((IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>)new CIX1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                    @Override
                    public void applyx(IgniteInternalFuture<AffinityTopologyVersion> fut) throws IgniteCheckedException {
                        AffinityTopologyVersion readyTopVer = fut.get();
                        GridNearGetFuture.this.map(F.view(MiniFuture.this.keys.keySet(), new P1<KeyCacheObject>(){

                            @Override
                            public boolean apply(KeyCacheObject key) {
                                return invalidParts.contains(GridNearGetFuture.this.cctx.affinity().partition(key));
                            }
                        }), F.t(MiniFuture.this.node, MiniFuture.this.keys), readyTopVer);
                        MiniFuture.this.postProcessResultAndDone(res);
                    }
                });
            } else {
                this.postProcessResultAndDone(res);
            }
        }

        private void postProcessResultAndDone(GridNearGetResponse res) {
            try {
                this.postProcessResult(res);
                this.onDone(GridNearGetFuture.this.loadEntries(this.node.id(), this.keys.keySet(), res.entries(), this.savedEntries, this.topVer));
            }
            catch (Exception ex) {
                this.onDone(ex);
            }
        }

        private void postProcessResult(GridNearGetResponse res) {
            if (this.postProcessingClos != null) {
                this.postProcessingClos.apply(res.entries());
            }
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this);
        }
    }
}

