/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheLockCandidates;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class GridNearCacheEntry
extends GridDistributedCacheEntry {
    private static final int NEAR_SIZE_OVERHEAD = 52;
    private volatile AffinityTopologyVersion topVer = AffinityTopologyVersion.NONE;
    private GridCacheVersion dhtVer;
    private int part;
    private short evictReservations;

    public GridNearCacheEntry(GridCacheContext ctx, KeyCacheObject key) {
        super(ctx, key);
        this.part = ctx.affinity().partition(key);
    }

    @Override
    public int memorySize() throws IgniteCheckedException {
        return super.memorySize() + 52;
    }

    @Override
    public int partition() {
        return this.part;
    }

    @Override
    public boolean isNear() {
        return true;
    }

    @Override
    public boolean valid(AffinityTopologyVersion topVer) {
        assert (topVer.topologyVersion() > 0L) : "Topology version is invalid: " + topVer;
        AffinityTopologyVersion topVer0 = this.topVer;
        if (topVer0.equals(topVer)) {
            return true;
        }
        if (topVer0.equals(AffinityTopologyVersion.NONE) || topVer.compareTo(topVer0) < 0) {
            return false;
        }
        try {
            if (this.cctx.affinity().primaryChanged(this.partition(), topVer0, topVer)) {
                this.topVer = AffinityTopologyVersion.NONE;
                return false;
            }
            if (this.cctx.affinity().backupByPartition(this.cctx.localNode(), this.part, topVer)) {
                this.topVer = AffinityTopologyVersion.NONE;
                return false;
            }
            this.topVer = topVer;
            return true;
        }
        catch (IllegalStateException ignore) {
            this.topVer = AffinityTopologyVersion.NONE;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFromDht(AffinityTopologyVersion topVer) throws GridCacheEntryRemovedException {
        GridCacheEntryInfo e;
        GridDhtCacheEntry entry2 = this.cctx.near().dht().peekExx(this.key);
        if (entry2 != null && (e = entry2.info()) != null) {
            GridCacheVersion enqueueVer = null;
            try {
                ClusterNode primaryNode = this.cctx.affinity().primaryByKey(this.key, topVer);
                this.lockEntry();
                try {
                    this.checkObsolete();
                    if (this.isNew() || !this.valid(topVer)) {
                        this.update(e.value(), e.expireTime(), e.ttl(), e.isNew() ? this.ver : e.version(), true);
                        if (this.cctx.deferredDelete() && !this.isNew() && !this.isInternal()) {
                            boolean deleted;
                            boolean bl = deleted = this.val == null;
                            if (deleted != this.deletedUnlocked()) {
                                this.deletedUnlocked(deleted);
                                if (deleted) {
                                    enqueueVer = e.version();
                                }
                            }
                        }
                        if (primaryNode == null) {
                            this.topVer = AffinityTopologyVersion.NONE;
                        } else {
                            this.recordNodeId(primaryNode.id(), topVer);
                        }
                        this.dhtVer = e.isNew() || e.isDeleted() ? null : e.version();
                    }
                }
                finally {
                    this.unlockEntry();
                }
            }
            finally {
                if (enqueueVer != null) {
                    this.cctx.onDeferredDelete(this, enqueueVer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetFromPrimary(CacheObject val, GridCacheVersion ver, GridCacheVersion dhtVer, UUID primaryNodeId, AffinityTopologyVersion topVer) throws GridCacheEntryRemovedException {
        assert (dhtVer != null);
        this.cctx.versions().onReceived(primaryNodeId, dhtVer);
        this.lockEntry();
        try {
            this.checkObsolete();
            this.primaryNode(primaryNodeId, topVer);
            if (!F.eq(this.dhtVer, dhtVer)) {
                this.value(val);
                this.ver = ver;
                this.dhtVer = dhtVer;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.unlockEntry();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrEvict(GridCacheVersion dhtVer, @Nullable CacheObject val, long expireTime, long ttl, UUID primaryNodeId, AffinityTopologyVersion topVer) {
        assert (dhtVer != null);
        this.cctx.versions().onReceived(primaryNodeId, dhtVer);
        this.lockEntry();
        try {
            if (!this.obsolete()) {
                if (F.eq(this.dhtVer, dhtVer)) {
                    this.dhtVer = null;
                }
                if (this.dhtVer == null && !this.markObsolete(this.cctx.versions().next())) {
                    this.value(val);
                    this.ttlAndExpireTimeExtras((int)ttl, expireTime);
                    this.primaryNode(primaryNodeId, topVer);
                }
            }
        }
        finally {
            this.unlockEntry();
        }
    }

    @Nullable
    public GridCacheVersion dhtVersion() throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            GridCacheVersion gridCacheVersion = this.dhtVer;
            return gridCacheVersion;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Nullable
    public IgniteBiTuple<GridCacheVersion, CacheObject> versionedValue() throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            if (this.dhtVer == null) {
                IgniteBiTuple<GridCacheVersion, CacheObject> igniteBiTuple = null;
                return igniteBiTuple;
            }
            CacheObject val0 = this.val;
            IgniteBiTuple<GridCacheVersion, CacheObject> igniteBiTuple = F.t(this.dhtVer, val0);
            return igniteBiTuple;
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    protected void recordNodeId(UUID primaryNodeId, AffinityTopologyVersion topVer) {
        assert (this.lockedByCurrentThread());
        assert (topVer.compareTo(this.cctx.affinity().affinityTopologyVersion()) <= 0) : "Affinity not ready [topVer=" + topVer + ", readyVer=" + this.cctx.affinity().affinityTopologyVersion() + ", cache=" + this.cctx.name() + ']';
        this.primaryNode(primaryNodeId, topVer);
    }

    public final boolean recordDhtVersion(GridCacheVersion dhtVer) {
        assert (dhtVer != null);
        assert (this.lockedByCurrentThread());
        if (this.dhtVer == null || this.dhtVer.compareTo(dhtVer) <= 0) {
            this.dhtVer = dhtVer;
            return true;
        }
        return false;
    }

    @Override
    protected Object readThrough(IgniteInternalTx tx, KeyCacheObject key, boolean reload2, UUID subjId, String taskName) throws IgniteCheckedException {
        return this.cctx.near().loadAsync(tx, F.asList(key), false, subjId, taskName, true, false, null, false, false, false).get().get(this.keyValue(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadedValue(@Nullable IgniteInternalTx tx, UUID primaryNodeId, CacheObject val, GridCacheVersion ver, GridCacheVersion dhtVer, long ttl, long expireTime, boolean evt, boolean keepBinary, AffinityTopologyVersion topVer, UUID subjId) throws IgniteCheckedException, GridCacheEntryRemovedException {
        assert (dhtVer != null);
        GridCacheVersion enqueueVer = null;
        this.lockEntry();
        try {
            this.checkObsolete();
            if (this.cctx.statisticsEnabled()) {
                this.cctx.cache().metrics0().onRead(false);
            }
            boolean ret = false;
            CacheObject old = this.val;
            boolean hasVal = this.hasValueUnlocked();
            if (this.dhtVer == null || this.dhtVer.compareTo(dhtVer) < 0 || !this.valid(topVer)) {
                this.primaryNode(primaryNodeId, topVer);
                this.update(val, expireTime, ttl, ver, true);
                if (this.cctx.deferredDelete() && !this.isInternal()) {
                    boolean deleted;
                    boolean bl = deleted = val == null;
                    if (deleted != this.deletedUnlocked()) {
                        this.deletedUnlocked(deleted);
                        if (deleted) {
                            enqueueVer = ver;
                        }
                    }
                }
                this.dhtVer = dhtVer;
                ret = true;
            }
            if (evt && this.cctx.events().isRecordable(64)) {
                this.cctx.events().addEvent(this.partition(), this.key, tx, null, 64, val, val != null, old, hasVal, subjId, null, null, keepBinary);
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.unlockEntry();
            if (enqueueVer != null) {
                this.cctx.onDeferredDelete(this, enqueueVer);
            }
        }
    }

    @Override
    protected boolean storeValue(CacheObject val, long expireTime, GridCacheVersion ver) {
        return false;
    }

    @Override
    protected void removeValue() {
    }

    @Override
    protected void logUpdate(GridCacheOperation op, CacheObject val, GridCacheVersion ver, long expireTime, long updCntr) throws IgniteCheckedException {
    }

    @Override
    protected WALPointer logTxUpdate(IgniteInternalTx tx, CacheObject val, long expireTime, long updCntr) throws IgniteCheckedException {
        return null;
    }

    @Override
    @Nullable
    public CacheDataRow unswap(CacheDataRow row, boolean checkExpire) {
        return null;
    }

    @Override
    public GridCacheMvccCandidate addLocal(long threadId, GridCacheVersion ver, AffinityTopologyVersion topVer, long timeout, boolean reenter, boolean tx, boolean implicitSingle, boolean read) throws GridCacheEntryRemovedException {
        return this.addNearLocal(null, threadId, ver, topVer, timeout, reenter, tx, implicitSingle, read);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    GridCacheMvccCandidate addNearLocal(@Nullable UUID dhtNodeId, long threadId, GridCacheVersion ver, AffinityTopologyVersion topVer, long timeout, boolean reenter, boolean tx, boolean implicitSingle, boolean read) throws GridCacheEntryRemovedException {
        CacheObject val;
        GridCacheMvccCandidate cand;
        CacheLockCandidates prev;
        CacheLockCandidates owner2 = null;
        UUID locId = this.cctx.nodeId();
        this.lockEntry();
        try {
            GridCacheMvccCandidate c;
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc == null) {
                mvcc = new GridCacheMvcc(this.cctx);
                this.mvccExtras(mvcc);
            }
            if ((c = mvcc.localCandidate(locId, threadId)) != null) {
                GridCacheMvccCandidate gridCacheMvccCandidate = reenter ? c.reenter() : null;
                return gridCacheMvccCandidate;
            }
            prev = mvcc.allOwners();
            boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
            if (timeout < 0L && !emptyBefore) {
                GridCacheMvccCandidate gridCacheMvccCandidate = null;
                return gridCacheMvccCandidate;
            }
            cand = mvcc.addNearLocal(this, locId, dhtNodeId, threadId, ver, tx, implicitSingle, read);
            cand.topologyVersion(topVer);
            boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
            this.checkCallbacks(emptyBefore, emptyAfter);
            val = this.val;
            if (emptyAfter) {
                this.mvccExtras(null);
            } else {
                owner2 = mvcc.allOwners();
            }
        }
        finally {
            this.unlockEntry();
        }
        this.checkOwnerChanged(prev, owner2, val);
        return cand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridCacheMvccCandidate dhtNodeId(GridCacheVersion ver, UUID dhtNodeId) throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            GridCacheMvccCandidate cand;
            this.checkObsolete();
            GridCacheMvcc mvcc = this.mvccExtras();
            GridCacheMvccCandidate gridCacheMvccCandidate = cand = mvcc == null ? null : mvcc.candidate(ver);
            if (cand == null) {
                GridCacheMvccCandidate gridCacheMvccCandidate2 = null;
                return gridCacheMvccCandidate2;
            }
            cand.otherNodeId(dhtNodeId);
            GridCacheMvccCandidate gridCacheMvccCandidate3 = cand;
            return gridCacheMvccCandidate3;
        }
        finally {
            this.unlockEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GridCacheMvccCandidate removeLock() {
        CacheObject val;
        CacheLockCandidates prev = null;
        CacheLockCandidates owner2 = null;
        UUID locId = this.cctx.nodeId();
        GridCacheMvccCandidate cand = null;
        this.lockEntry();
        try {
            GridCacheMvcc mvcc = this.mvccExtras();
            if (mvcc != null) {
                prev = mvcc.allOwners();
                boolean emptyBefore = mvcc.isEmpty(new GridCacheVersion[0]);
                cand = mvcc.localCandidate(locId, Thread.currentThread().getId());
                assert (cand == null || cand.nearLocal());
                if (cand != null && cand.owner()) {
                    GridCacheMvccCandidate reentry = cand.unenter();
                    if (reentry != null) {
                        assert (reentry.reentry());
                        GridCacheMvccCandidate gridCacheMvccCandidate = reentry;
                        return gridCacheMvccCandidate;
                    }
                } else {
                    GridCacheMvccCandidate reentry = null;
                    return reentry;
                }
                mvcc.remove(cand.version());
                owner2 = mvcc.allOwners();
                boolean emptyAfter = mvcc.isEmpty(new GridCacheVersion[0]);
                this.checkCallbacks(emptyBefore, emptyAfter);
                if (emptyAfter) {
                    this.mvccExtras(null);
                }
            }
            val = this.val;
        }
        finally {
            this.unlockEntry();
        }
        assert (cand != null);
        assert (owner2 != prev);
        if (log.isDebugEnabled()) {
            log.debug("Released local candidate from entry [owner=" + owner2 + ", prev=" + prev + ", entry=" + this + ']');
        }
        this.cctx.mvcc().removeExplicitLock(cand);
        this.checkThreadChain(cand);
        this.checkOwnerChanged(prev, owner2, val);
        return cand;
    }

    @Override
    protected void onInvalidate() {
        this.topVer = AffinityTopologyVersion.NONE;
        this.dhtVer = null;
    }

    void reserveEviction() throws GridCacheEntryRemovedException {
        this.lockEntry();
        try {
            this.checkObsolete();
            this.evictReservations = (short)(this.evictReservations + 1);
        }
        finally {
            this.unlockEntry();
        }
    }

    void releaseEviction() {
        this.lockEntry();
        try {
            assert (this.evictReservations > 0) : this;
            assert (!this.obsolete()) : this;
            this.evictReservations = (short)(this.evictReservations - 1);
        }
        finally {
            this.unlockEntry();
        }
    }

    @Override
    protected boolean evictionDisabled() {
        assert (this.lockedByCurrentThread());
        return this.evictReservations > 0;
    }

    private void primaryNode(UUID nodeId, AffinityTopologyVersion topVer) {
        assert (this.lockedByCurrentThread());
        assert (nodeId != null);
        ClusterNode primary = null;
        try {
            primary = this.cctx.affinity().primaryByPartition(this.part, topVer);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (primary == null || !nodeId.equals(primary.id())) {
            this.topVer = AffinityTopologyVersion.NONE;
            return;
        }
        if (topVer.compareTo(this.topVer) > 0) {
            this.topVer = topVer;
        }
    }

    @Override
    public String toString() {
        this.lockEntry();
        try {
            String string2 = S.toString(GridNearCacheEntry.class, this, "super", super.toString());
            return string2;
        }
        finally {
            this.unlockEntry();
        }
    }
}

