/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.topology;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.lang.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

public class GridDhtPartitionsStateValidator {
    private static final IgniteProductVersion SIZES_VALIDATION_AVAILABLE_SINCE = IgniteProductVersion.fromString("2.5.0");
    private final GridCacheSharedContext<?, ?> cctx;

    public GridDhtPartitionsStateValidator(GridCacheSharedContext<?, ?> cctx) {
        this.cctx = cctx;
    }

    public void validatePartitionCountersAndSizes(GridDhtPartitionsExchangeFuture fut, GridDhtPartitionTopology top, Map<UUID, GridDhtPartitionsSingleMessage> messages2) throws IgniteCheckedException {
        HashSet<UUID> ignoringNodes = new HashSet<UUID>();
        for (DiscoveryEvent evt : fut.events().events()) {
            if (evt.type() != 10) continue;
            ignoringNodes.add(evt.eventNode().id());
        }
        AffinityTopologyVersion topVer = fut.context().events().topologyVersion();
        Map<Integer, Map<UUID, Long>> result2 = this.validatePartitionsUpdateCounters(top, messages2, ignoringNodes);
        if (!result2.isEmpty()) {
            throw new IgniteCheckedException("Partitions update counters are inconsistent for " + this.fold(topVer, result2));
        }
        for (UUID id : messages2.keySet()) {
            ClusterNode node = this.cctx.discovery().node(id);
            if (node == null || node.version().compareTo(SIZES_VALIDATION_AVAILABLE_SINCE) >= 0) continue;
            ignoringNodes.add(id);
        }
        if (!MvccUtils.mvccEnabled(this.cctx.kernalContext()) && !(result2 = this.validatePartitionsSizes(top, messages2, ignoringNodes)).isEmpty()) {
            throw new IgniteCheckedException("Partitions cache sizes are inconsistent for " + this.fold(topVer, result2));
        }
    }

    @Nullable
    private Set<Integer> shouldIgnore(GridDhtPartitionTopology top, UUID nodeId, GridDhtPartitionsSingleMessage singleMsg) {
        CachePartitionPartialCountersMap countersMap = singleMsg.partitionUpdateCounters(top.groupId(), top.partitions());
        Map<Integer, Long> sizesMap = singleMsg.partitionSizes(top.groupId());
        HashSet<Integer> ignore = null;
        for (int p = 0; p < top.partitions(); ++p) {
            long size2;
            if (top.partitionState(nodeId, p) != GridDhtPartitionState.OWNING) {
                if (ignore == null) {
                    ignore = new HashSet<Integer>();
                }
                ignore.add(p);
                continue;
            }
            int partIdx = countersMap.partitionIndex(p);
            long updateCounter = partIdx >= 0 ? countersMap.updateCounterAt(partIdx) : 0L;
            long l = size2 = sizesMap.containsKey(p) ? sizesMap.get(p) : 0L;
            if (updateCounter != 0L || size2 != 0L) continue;
            if (ignore == null) {
                ignore = new HashSet();
            }
            ignore.add(p);
        }
        return ignore;
    }

    public Map<Integer, Map<UUID, Long>> validatePartitionsUpdateCounters(GridDhtPartitionTopology top, Map<UUID, GridDhtPartitionsSingleMessage> messages2, Set<UUID> ignoringNodes) {
        HashMap<Integer, Map<UUID, Long>> invalidPartitions = new HashMap<Integer, Map<UUID, Long>>();
        HashMap<Integer, T2<UUID, Long>> updateCountersAndNodesByPartitions = new HashMap<Integer, T2<UUID, Long>>();
        for (GridDhtLocalPartition part : top.currentLocalPartitions()) {
            if (part.state() != GridDhtPartitionState.OWNING || part.updateCounter() == 0L && part.fullSize() == 0L) continue;
            updateCountersAndNodesByPartitions.put(part.id(), new T2<UUID, Long>(this.cctx.localNodeId(), part.updateCounter()));
        }
        int partitions = top.partitions();
        for (Map.Entry<UUID, GridDhtPartitionsSingleMessage> e : messages2.entrySet()) {
            UUID nodeId = e.getKey();
            if (ignoringNodes.contains(nodeId)) continue;
            CachePartitionPartialCountersMap countersMap = e.getValue().partitionUpdateCounters(top.groupId(), partitions);
            Set<Integer> ignorePartitions = this.shouldIgnore(top, nodeId, e.getValue());
            for (int part = 0; part < partitions; ++part) {
                if (ignorePartitions != null && ignorePartitions.contains(part)) continue;
                int partIdx = countersMap.partitionIndex(part);
                long currentCounter = partIdx >= 0 ? countersMap.updateCounterAt(partIdx) : 0L;
                this.process(invalidPartitions, updateCountersAndNodesByPartitions, part, nodeId, currentCounter);
            }
        }
        return invalidPartitions;
    }

    public Map<Integer, Map<UUID, Long>> validatePartitionsSizes(GridDhtPartitionTopology top, Map<UUID, GridDhtPartitionsSingleMessage> messages2, Set<UUID> ignoringNodes) {
        HashMap<Integer, Map<UUID, Long>> invalidPartitions = new HashMap<Integer, Map<UUID, Long>>();
        HashMap<Integer, T2<UUID, Long>> sizesAndNodesByPartitions = new HashMap<Integer, T2<UUID, Long>>();
        for (GridDhtLocalPartition part : top.currentLocalPartitions()) {
            if (part.state() != GridDhtPartitionState.OWNING || part.updateCounter() == 0L && part.fullSize() == 0L) continue;
            sizesAndNodesByPartitions.put(part.id(), new T2<UUID, Long>(this.cctx.localNodeId(), part.fullSize()));
        }
        int partitions = top.partitions();
        for (Map.Entry<UUID, GridDhtPartitionsSingleMessage> e : messages2.entrySet()) {
            UUID nodeId = e.getKey();
            if (ignoringNodes.contains(nodeId)) continue;
            Map<Integer, Long> sizesMap = e.getValue().partitionSizes(top.groupId());
            Set<Integer> ignorePartitions = this.shouldIgnore(top, nodeId, e.getValue());
            for (int part = 0; part < partitions; ++part) {
                if (ignorePartitions != null && ignorePartitions.contains(part)) continue;
                long currentSize = sizesMap.containsKey(part) ? sizesMap.get(part) : 0L;
                this.process(invalidPartitions, sizesAndNodesByPartitions, part, nodeId, currentSize);
            }
        }
        return invalidPartitions;
    }

    private void process(Map<Integer, Map<UUID, Long>> invalidPartitions, Map<Integer, T2<UUID, Long>> countersAndNodes, int part, UUID node, long counter) {
        T2<UUID, Long> existingData = countersAndNodes.get(part);
        if (existingData == null) {
            countersAndNodes.put(part, new T2<UUID, Long>(node, counter));
        }
        if (existingData != null && counter != (Long)existingData.get2()) {
            if (!invalidPartitions.containsKey(part)) {
                HashMap map2 = new HashMap();
                map2.put(existingData.get1(), existingData.get2());
                invalidPartitions.put(part, map2);
            }
            invalidPartitions.get(part).put(node, counter);
        }
    }

    private String fold(AffinityTopologyVersion topVer, Map<Integer, Map<UUID, Long>> invalidPartitions) {
        SB sb = new SB();
        TreeMap<Integer, Map<UUID, Long>> sortedPartitions = new TreeMap<Integer, Map<UUID, Long>>(invalidPartitions);
        for (Map.Entry p : sortedPartitions.entrySet()) {
            sb.a("Part ").a(p.getKey()).a(": [");
            for (Map.Entry e : ((Map)p.getValue()).entrySet()) {
                Object consistentId = this.cctx.discovery().node(topVer, (UUID)e.getKey()).consistentId();
                sb.a(consistentId).a("=").a(e.getValue()).a(" ");
            }
            sb.a("] ");
        }
        return sb.toString();
    }
}

