/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.topology;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;

public class GridDhtPartitionsReservation
implements GridReservable {
    private static final GridDhtLocalPartition[] EMPTY = new GridDhtLocalPartition[0];
    private static final CI1<GridDhtPartitionsReservation> NO_OP = new CI1<GridDhtPartitionsReservation>(){

        @Override
        public void apply(GridDhtPartitionsReservation gridDhtPartitionsReservation) {
            throw new IllegalStateException();
        }
    };
    private final Object appKey;
    private final GridCacheContext<?, ?> cctx;
    private final AffinityTopologyVersion topVer;
    private final AtomicReference<GridDhtLocalPartition[]> parts = new AtomicReference();
    private final AtomicReference<CI1<GridDhtPartitionsReservation>> unpublish = new AtomicReference();
    private final AtomicInteger reservations = new AtomicInteger();

    public GridDhtPartitionsReservation(AffinityTopologyVersion topVer, GridCacheContext<?, ?> cctx, Object appKey) {
        assert (topVer != null);
        assert (cctx != null);
        assert (appKey != null);
        this.topVer = topVer;
        this.cctx = cctx;
        this.appKey = appKey;
    }

    public boolean register(Collection<? extends GridReservable> parts) {
        assert (!F.isEmpty(parts)) : "empty partitions list";
        Object[] arr = new GridDhtLocalPartition[parts.size()];
        int i = 0;
        int prevPart = -1;
        boolean sorted2 = true;
        for (GridReservable gridReservable : parts) {
            arr[i] = (GridDhtLocalPartition)gridReservable;
            if (sorted2) {
                int id = ((GridDhtLocalPartition)arr[i]).id();
                if (id <= prevPart) {
                    sorted2 = false;
                }
                prevPart = id;
            }
            ++i;
        }
        if (!sorted2) {
            Arrays.sort(arr);
        }
        i = 0;
        prevPart = -1;
        for (Object part : arr) {
            if (prevPart == ((GridDhtLocalPartition)part).id()) {
                throw new IllegalStateException("Duplicated partitions.");
            }
            prevPart = ((GridDhtLocalPartition)part).id();
            if (!((GridDhtLocalPartition)part).addReservation(this)) {
                if (i != 0) {
                    throw new IllegalStateException("Trying to reserve different sets of partitions for the same topology version.");
                }
                return false;
            }
            ++i;
        }
        if (!this.parts.compareAndSet(null, (GridDhtLocalPartition[])arr)) {
            throw new IllegalStateException("Partitions can be registered only once.");
        }
        assert (this.reservations.get() != -1) : "all the partitions must be reserved before register, we can't be invalidated";
        return true;
    }

    public void onPublish(CI1<GridDhtPartitionsReservation> unpublish) {
        assert (unpublish != null);
        if (!this.unpublish.compareAndSet(null, unpublish)) {
            throw new IllegalStateException("Unpublishing closure can be set only once.");
        }
        if (this.reservations.get() == -1) {
            this.unregister();
        }
    }

    @Override
    public boolean reserve() {
        int r;
        assert (this.parts.get() != null) : "partitions must be registered before the first reserve attempt";
        do {
            if ((r = this.reservations.get()) == -1) {
                return false;
            }
            assert (r >= 0) : r;
        } while (!this.reservations.compareAndSet(r, r + 1));
        return true;
    }

    private static void tryEvict(GridDhtLocalPartition[] parts) {
        if (parts == null) {
            return;
        }
        for (GridDhtLocalPartition part : parts) {
            GridDhtPartitionsReservation.tryEvict(part);
        }
    }

    private static void tryEvict(GridDhtLocalPartition part) {
        if (part.state() == GridDhtPartitionState.RENTING && part.reservations() == 0) {
            part.tryContinueClearing();
        }
    }

    @Override
    public void release() {
        int r;
        do {
            if ((r = this.reservations.get()) > 0) continue;
            throw new IllegalStateException("Method 'reserve' must be called before 'release'.");
        } while (!this.reservations.compareAndSet(r, r - 1));
        if (r == 1 && !this.cctx.kernalContext().isStopping() && !this.topVer.equals(this.cctx.topology().lastTopologyChangeVersion())) {
            GridDhtPartitionsReservation.tryEvict(this.parts.get());
        }
    }

    private void unregister() {
        CI1<GridDhtPartitionsReservation> u;
        GridDhtLocalPartition[] arr = this.parts.get();
        if (!F.isEmpty(arr) && this.parts.compareAndSet(arr, EMPTY)) {
            for (int i = arr.length - 1; i >= 0; --i) {
                GridDhtLocalPartition part = arr[i];
                part.removeReservation(this);
            }
        }
        if ((u = this.unpublish.get()) != null && u != NO_OP && this.unpublish.compareAndSet(u, NO_OP)) {
            u.apply(this);
        }
    }

    public boolean invalidate() {
        assert (this.parts.get() != null) : "all parts must be reserved before registration";
        int r = this.reservations.get();
        assert (r >= -1) : r;
        if (r != 0) {
            return r == -1;
        }
        if (this.reservations.compareAndSet(0, -1)) {
            this.unregister();
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridDhtPartitionsReservation that = (GridDhtPartitionsReservation)o;
        return this.cctx == that.cctx && this.topVer.equals(that.topVer) && this.appKey.equals(that.appKey);
    }

    public int hashCode() {
        String name = this.cctx.name();
        int result2 = name == null ? 0 : name.hashCode();
        result2 = 31 * result2 + this.appKey.hashCode();
        result2 = 31 * result2 + this.topVer.hashCode();
        return result2;
    }
}

