/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.topology;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionMetaStateRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMapImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntryFactory;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloader;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.EvictionContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionsReservation;
import org.apache.ignite.internal.processors.cache.extras.GridCacheObsoleteEntryExtras;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.util.deque.FastSizeDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDhtLocalPartition
extends GridCacheConcurrentMapImpl
implements Comparable<GridDhtLocalPartition>,
GridReservable {
    private static final GridCacheMapEntryFactory ENTRY_FACTORY = new GridCacheMapEntryFactory(){

        @Override
        public GridCacheMapEntry create(GridCacheContext ctx, AffinityTopologyVersion topVer, KeyCacheObject key) {
            return new GridDhtCacheEntry(ctx, topVer, key);
        }
    };
    public static final int MAX_DELETE_QUEUE_SIZE = Integer.getInteger("IGNITE_ATOMIC_CACHE_DELETE_HISTORY_SIZE", 200000);
    private static boolean forceTestCheckpointOnEviction = IgniteSystemProperties.getBoolean("TEST_CHECKPOINT_ON_EVICTION", false);
    static volatile Integer partWhereTestCheckpointEnforced;
    private final int rmvQueueMaxSize;
    private final long rmvdEntryTtl;
    private static final AtomicReference<IgniteLogger> logRef;
    private static volatile IgniteLogger log;
    private final int id;
    @GridToStringExclude
    private final AtomicLong state = new AtomicLong((long)GridDhtPartitionState.MOVING.ordinal() << 32);
    @GridToStringExclude
    private final AtomicInteger evictGuard = new AtomicInteger();
    @GridToStringExclude
    private final GridFutureAdapter<?> rent;
    @GridToStringExclude
    private final ClearFuture clearFuture;
    @GridToStringExclude
    private final GridCacheSharedContext ctx;
    @GridToStringExclude
    private final CacheGroupContext grp;
    @GridToStringExclude
    private final long createTime = U.currentTimeMillis();
    @GridToStringExclude
    private final ReentrantLock lock = new ReentrantLock();
    @GridToStringExclude
    private final ConcurrentMap<Integer, GridCacheConcurrentMap.CacheMapHolder> cacheMaps;
    @GridToStringExclude
    private final GridCacheConcurrentMap.CacheMapHolder singleCacheEntryMap;
    @GridToStringExclude
    private final FastSizeDeque<RemovedEntryHolder> rmvQueue = new FastSizeDeque(new ConcurrentLinkedDeque());
    @GridToStringExclude
    private final CopyOnWriteArrayList<GridDhtPartitionsReservation> reservations = new CopyOnWriteArrayList();
    @GridToStringExclude
    private volatile IgniteCacheOffheapManager.CacheDataStore store;
    private volatile boolean delayedRenting;
    private volatile boolean clear;
    private boolean updateSeqOnDestroy;

    public GridDhtLocalPartition(GridCacheSharedContext ctx, CacheGroupContext grp, int id) {
        super(ENTRY_FACTORY);
        this.id = id;
        this.ctx = ctx;
        this.grp = grp;
        log = U.logger(ctx.kernalContext(), logRef, this);
        if (grp.sharedGroup()) {
            this.singleCacheEntryMap = null;
            this.cacheMaps = new ConcurrentHashMap<Integer, GridCacheConcurrentMap.CacheMapHolder>();
        } else {
            this.singleCacheEntryMap = new GridCacheConcurrentMap.CacheMapHolder(grp.singleCacheContext(), this.createEntriesMap());
            this.cacheMaps = null;
        }
        this.rent = new GridFutureAdapter<Object>(){

            @Override
            public String toString() {
                return "PartitionRentFuture [part=" + GridDhtLocalPartition.this + ']';
            }
        };
        this.clearFuture = new ClearFuture();
        int delQueueSize = grp.systemCache() ? 100 : Math.max(MAX_DELETE_QUEUE_SIZE / grp.affinity().partitions(), 20);
        this.rmvQueueMaxSize = U.ceilPow2(delQueueSize);
        this.rmvdEntryTtl = Long.getLong("IGNITE_CACHE_REMOVED_ENTRIES_TTL", 10000L);
        try {
            this.store = grp.offheap().createCacheDataStore(id);
            if (grp.walEnabled()) {
                ctx.wal().log(new PartitionMetaStateRecord(grp.groupId(), id, this.state(), this.updateCounter()));
            }
            if (ctx.kernalContext().query().moduleEnabled()) {
                GridQueryRowCacheCleaner cleaner = ctx.kernalContext().query().getIndexing().rowCacheCleaner(grp.groupId());
                if (this.store != null && cleaner != null) {
                    this.store.setRowCacheCleaner(cleaner);
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Partition has been created [grp=" + grp.cacheOrGroupName() + ", p=" + id + ", state=" + (Object)((Object)this.state()) + "]");
        }
    }

    private ConcurrentMap<KeyCacheObject, GridCacheMapEntry> createEntriesMap() {
        return new ConcurrentHashMap<KeyCacheObject, GridCacheMapEntry>(Math.max(10, GridCacheAdapter.DFLT_START_CACHE_SIZE / this.grp.affinity().partitions()), 0.75f, Runtime.getRuntime().availableProcessors() * 2);
    }

    @Override
    public int internalSize() {
        if (this.grp.sharedGroup()) {
            int size2 = 0;
            for (GridCacheConcurrentMap.CacheMapHolder hld : this.cacheMaps.values()) {
                size2 += hld.map.size();
            }
            return size2;
        }
        return this.singleCacheEntryMap.map.size();
    }

    @Override
    protected GridCacheConcurrentMap.CacheMapHolder entriesMap(GridCacheContext cctx) {
        if (this.grp.sharedGroup()) {
            return this.cacheMapHolder(cctx);
        }
        return this.singleCacheEntryMap;
    }

    @Override
    @Nullable
    protected GridCacheConcurrentMap.CacheMapHolder entriesMapIfExists(Integer cacheId) {
        return this.grp.sharedGroup() ? (GridCacheConcurrentMap.CacheMapHolder)this.cacheMaps.get(cacheId) : this.singleCacheEntryMap;
    }

    private GridCacheConcurrentMap.CacheMapHolder cacheMapHolder(GridCacheContext cctx) {
        assert (this.grp.sharedGroup());
        GridCacheConcurrentMap.CacheMapHolder hld = (GridCacheConcurrentMap.CacheMapHolder)this.cacheMaps.get(cctx.cacheIdBoxed());
        if (hld != null) {
            return hld;
        }
        hld = new GridCacheConcurrentMap.CacheMapHolder(cctx, this.createEntriesMap());
        GridCacheConcurrentMap.CacheMapHolder old = this.cacheMaps.putIfAbsent(cctx.cacheIdBoxed(), hld);
        if (old != null) {
            hld = old;
        }
        return hld;
    }

    public IgniteCacheOffheapManager.CacheDataStore dataStore() {
        return this.store;
    }

    public boolean addReservation(GridDhtPartitionsReservation r) {
        assert (GridDhtLocalPartition.getPartState(this.state.get()) != GridDhtPartitionState.EVICTED) : "we can reserve only active partitions";
        assert (GridDhtLocalPartition.getReservations(this.state.get()) != 0) : "partition must be already reserved before adding group reservation";
        return this.reservations.addIfAbsent(r);
    }

    public void removeReservation(GridDhtPartitionsReservation r) {
        if (!this.reservations.remove(r)) {
            throw new IllegalStateException("Reservation was already removed.");
        }
    }

    public int id() {
        return this.id;
    }

    public long createTime() {
        return this.createTime;
    }

    public GridDhtPartitionState state() {
        return GridDhtLocalPartition.getPartState(this.state.get());
    }

    public int reservations() {
        return GridDhtLocalPartition.getReservations(this.state.get());
    }

    public boolean isEmpty() {
        return this.store.fullSize() == 0L && this.internalSize() == 0;
    }

    public boolean valid() {
        GridDhtPartitionState state = this.state();
        return state == GridDhtPartitionState.MOVING || state == GridDhtPartitionState.OWNING || state == GridDhtPartitionState.RENTING;
    }

    public void onRemoved(GridDhtCacheEntry entry2) {
        assert (entry2.obsolete()) : entry2;
        this.removeEntry(entry2);
        this.tryContinueClearing();
    }

    private void removeVersionedEntry(int cacheId, KeyCacheObject key, GridCacheVersion ver) {
        GridCacheMapEntry entry2;
        GridCacheConcurrentMap.CacheMapHolder hld = this.grp.sharedGroup() ? (GridCacheConcurrentMap.CacheMapHolder)this.cacheMaps.get(cacheId) : this.singleCacheEntryMap;
        GridCacheMapEntry gridCacheMapEntry = entry2 = hld != null ? (GridCacheMapEntry)hld.map.get(key) : null;
        if (entry2 != null && entry2.markObsoleteVersion(ver)) {
            this.removeEntry(entry2);
        }
    }

    public void cleanupRemoveQueue() {
        RemovedEntryHolder item;
        while (this.rmvQueue.sizex() >= this.rmvQueueMaxSize) {
            item = this.rmvQueue.pollFirst();
            if (item == null) continue;
            this.removeVersionedEntry(item.cacheId(), item.key(), item.version());
        }
        if (!this.grp.isDrEnabled()) {
            item = this.rmvQueue.peekFirst();
            while (item != null && item.expireTime() < U.currentTimeMillis() && (item = this.rmvQueue.pollFirst()) != null) {
                this.removeVersionedEntry(item.cacheId(), item.key(), item.version());
                item = this.rmvQueue.peekFirst();
            }
        }
    }

    public void onDeferredDelete(int cacheId, KeyCacheObject key, GridCacheVersion ver) {
        this.cleanupRemoveQueue();
        this.rmvQueue.add(new RemovedEntryHolder(cacheId, key, ver, this.rmvdEntryTtl));
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public boolean reserve() {
        long newState;
        long state;
        do {
            if (GridDhtLocalPartition.getPartState(state = this.state.get()) != GridDhtPartitionState.EVICTED) continue;
            return false;
        } while (!this.state.compareAndSet(state, newState = GridDhtLocalPartition.setReservations(state, GridDhtLocalPartition.getReservations(state) + 1)));
        return true;
    }

    @Override
    public void release() {
        this.release0(0);
    }

    @Override
    protected void release(int sizeChange, GridCacheConcurrentMap.CacheMapHolder hld, GridCacheEntryEx e) {
        if (this.grp.sharedGroup() && sizeChange != 0) {
            hld.size.addAndGet(sizeChange);
        }
        this.release0(sizeChange);
    }

    private void release0(int sizeChange) {
        block6: {
            int reservations;
            long newState;
            long state;
            do {
                if ((reservations = GridDhtLocalPartition.getReservations(state = this.state.get())) == 0) {
                    return;
                }
                assert (GridDhtLocalPartition.getPartState(state) != GridDhtPartitionState.EVICTED) : GridDhtLocalPartition.getPartState(state);
                newState = GridDhtLocalPartition.setReservations(state, --reservations);
                newState = GridDhtLocalPartition.setSize(newState, GridDhtLocalPartition.getSize(newState) + sizeChange);
                assert (GridDhtLocalPartition.getSize(newState) == GridDhtLocalPartition.getSize(state) + sizeChange);
            } while (!this.state.compareAndSet(state, newState));
            if (reservations != 0) break block6;
            if (this.delayedRenting) {
                this.rent(true);
            } else {
                this.tryContinueClearing();
            }
        }
    }

    public void restoreState(GridDhtPartitionState stateToRestore) {
        this.state.set(GridDhtLocalPartition.setPartState(this.state.get(), stateToRestore));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(GridDhtPartitionState toState) {
        if (this.grp.persistenceEnabled() && this.grp.walEnabled()) {
            GridDhtLocalPartition gridDhtLocalPartition = this;
            synchronized (gridDhtLocalPartition) {
                long state0 = this.state.get();
                this.state.compareAndSet(state0, GridDhtLocalPartition.setPartState(state0, toState));
                try {
                    this.ctx.wal().log(new PartitionMetaStateRecord(this.grp.groupId(), this.id, toState, this.updateCounter()));
                }
                catch (IgniteCheckedException e) {
                    U.error(log, "Error while writing to log", e);
                }
            }
        }
        this.restoreState(toState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean casState(long state, GridDhtPartitionState toState) {
        if (this.grp.persistenceEnabled() && this.grp.walEnabled()) {
            GridDhtLocalPartition gridDhtLocalPartition = this;
            synchronized (gridDhtLocalPartition) {
                GridDhtPartitionState prevState = this.state();
                boolean update2 = this.state.compareAndSet(state, GridDhtLocalPartition.setPartState(state, toState));
                if (update2) {
                    try {
                        this.ctx.wal().log(new PartitionMetaStateRecord(this.grp.groupId(), this.id, toState, this.updateCounter()));
                    }
                    catch (IgniteCheckedException e) {
                        U.error(log, "Failed to log partition state change to WAL.", e);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Partition changed state [grp=" + this.grp.cacheOrGroupName() + ", p=" + this.id + ", prev=" + (Object)((Object)prevState) + ", to=" + (Object)((Object)toState) + "]");
                    }
                }
                return update2;
            }
        }
        GridDhtPartitionState prevState = this.state();
        boolean update3 = this.state.compareAndSet(state, GridDhtLocalPartition.setPartState(state, toState));
        if (update3 && log.isDebugEnabled()) {
            log.debug("Partition changed state [grp=" + this.grp.cacheOrGroupName() + ", p=" + this.id + ", prev=" + (Object)((Object)prevState) + ", to=" + (Object)((Object)toState) + "]");
        }
        return update3;
    }

    public boolean own() {
        long state;
        do {
            GridDhtPartitionState partState;
            if ((partState = GridDhtLocalPartition.getPartState(state = this.state.get())) == GridDhtPartitionState.RENTING || partState == GridDhtPartitionState.EVICTED) {
                return false;
            }
            if (partState == GridDhtPartitionState.OWNING) {
                return true;
            }
            assert (partState == GridDhtPartitionState.MOVING || partState == GridDhtPartitionState.LOST);
        } while (!this.casState(state, GridDhtPartitionState.OWNING));
        return true;
    }

    public void moving() {
        long state;
        do {
            state = this.state.get();
            GridDhtPartitionState partState = GridDhtLocalPartition.getPartState(state);
            assert (partState == GridDhtPartitionState.OWNING || partState == GridDhtPartitionState.RENTING) : "Only partitions in state OWNING or RENTING can be moved to MOVING state";
        } while (!this.casState(state, GridDhtPartitionState.MOVING));
    }

    public boolean markLost() {
        long state;
        do {
            GridDhtPartitionState partState;
            if ((partState = GridDhtLocalPartition.getPartState(state = this.state.get())) != GridDhtPartitionState.LOST) continue;
            return false;
        } while (!this.casState(state, GridDhtPartitionState.LOST));
        return true;
    }

    public IgniteInternalFuture<?> rent(boolean updateSeq) {
        long state0 = this.state.get();
        GridDhtPartitionState partState = GridDhtLocalPartition.getPartState(state0);
        if (partState == GridDhtPartitionState.RENTING || partState == GridDhtPartitionState.EVICTED) {
            return this.rent;
        }
        this.delayedRenting = true;
        if (GridDhtLocalPartition.getReservations(state0) == 0 && this.casState(state0, GridDhtPartitionState.RENTING)) {
            this.delayedRenting = false;
            this.clearAsync0(updateSeq);
        }
        return this.rent;
    }

    private void clearAsync0(boolean updateSeq) {
        boolean clearingRequested;
        long state = this.state.get();
        GridDhtPartitionState partState = GridDhtLocalPartition.getPartState(state);
        boolean evictionRequested = partState == GridDhtPartitionState.RENTING || this.delayedRenting;
        boolean bl = clearingRequested = partState == GridDhtPartitionState.MOVING && this.clear;
        if (!evictionRequested && !clearingRequested) {
            return;
        }
        boolean reinitialized = this.clearFuture.initialize(updateSeq, evictionRequested);
        if (!reinitialized) {
            return;
        }
        if (this.freeAndEmpty(state) && !this.grp.queriesEnabled() && !this.groupReserved() && (partState == GridDhtPartitionState.RENTING && this.casState(state, GridDhtPartitionState.EVICTED) || clearingRequested)) {
            this.clearFuture.finish();
            if (this.state() == GridDhtPartitionState.EVICTED && this.markForDestroy()) {
                this.updateSeqOnDestroy = updateSeq;
                this.destroy();
            }
            if (log.isDebugEnabled()) {
                log.debug("Partition has been fast evicted [grp=" + this.grp.cacheOrGroupName() + ", p=" + this.id + ", state=" + (Object)((Object)this.state()) + "]");
            }
            return;
        }
        this.ctx.evict().evictPartitionAsync(this.grp, this);
    }

    public void clearAsync() {
        GridDhtPartitionState state0 = this.state();
        if (state0 != GridDhtPartitionState.MOVING && state0 != GridDhtPartitionState.RENTING) {
            return;
        }
        this.clear = true;
        this.clearAsync0(false);
    }

    public void tryContinueClearing() {
        this.clearAsync0(true);
    }

    private boolean groupReserved() {
        for (GridDhtPartitionsReservation reservation : this.reservations) {
            if (reservation.invalidate()) continue;
            return true;
        }
        return false;
    }

    private boolean freeAndEmpty(long state) {
        return this.isEmpty() && GridDhtLocalPartition.getSize(state) == 0 && GridDhtLocalPartition.getReservations(state) == 0;
    }

    private boolean addEvicting() {
        int cnt;
        do {
            if ((cnt = this.evictGuard.get()) == 0) continue;
            return false;
        } while (!this.evictGuard.compareAndSet(cnt, cnt + 1));
        return true;
    }

    private boolean clearEvicting() {
        int cnt;
        do {
            cnt = this.evictGuard.get();
            assert (cnt > 0);
        } while (!this.evictGuard.compareAndSet(cnt, cnt - 1));
        boolean free = cnt == 1;
        return free;
    }

    public boolean markForDestroy() {
        do {
            int cnt;
            if ((cnt = this.evictGuard.get()) == 0) continue;
            return false;
        } while (!this.evictGuard.compareAndSet(0, -1));
        return true;
    }

    private void finishEviction(boolean updateSeq) {
        long state0 = this.state.get();
        GridDhtPartitionState state = GridDhtLocalPartition.getPartState(state0);
        if (state == GridDhtPartitionState.EVICTED || this.freeAndEmpty(state0) && state == GridDhtPartitionState.RENTING && this.casState(state0, GridDhtPartitionState.EVICTED)) {
            this.updateSeqOnDestroy = updateSeq;
        }
    }

    public void destroy() {
        assert (this.state() == GridDhtPartitionState.EVICTED) : this;
        assert (this.evictGuard.get() == -1);
        this.grp.onPartitionEvicted(this.id);
        this.destroyCacheDataStore();
        this.rent.onDone();
        ((GridDhtPreloader)this.grp.preloader()).onPartitionEvicted(this, this.updateSeqOnDestroy);
        this.clearDeferredDeletes();
    }

    public void awaitDestroy() {
        if (this.state() != GridDhtPartitionState.EVICTED) {
            return;
        }
        long timeout = 10000L;
        while (true) {
            try {
                this.rent.get(10000L);
            }
            catch (IgniteFutureTimeoutCheckedException ignored) {
                U.warn(log, "Failed to await partition destroy within timeout " + this);
                continue;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to await partition destroy " + this, e);
            }
            break;
        }
    }

    public void onClearFinished(IgniteInClosure<? super IgniteInternalFuture<?>> lsnr) {
        this.clearFuture.listen(lsnr);
    }

    public boolean isClearing() {
        return !this.clearFuture.isDone();
    }

    public boolean tryClear(EvictionContext evictionCtx) throws NodeStoppingException {
        if (this.clearFuture.isDone()) {
            return true;
        }
        long state = this.state.get();
        if (GridDhtLocalPartition.getReservations(state) != 0 || this.groupReserved()) {
            return false;
        }
        if (this.addEvicting()) {
            try {
                long clearedEntities = this.clearAll(evictionCtx);
                if (log.isDebugEnabled()) {
                    log.debug("Partition has been cleared [grp=" + this.grp.cacheOrGroupName() + ", p=" + this.id + ", state=" + (Object)((Object)this.state()) + ", clearedCnt=" + clearedEntities + "]");
                }
            }
            catch (NodeStoppingException e) {
                this.clearFuture.finish(e);
                throw e;
            }
            finally {
                boolean free = this.clearEvicting();
                if (free) {
                    this.clearFuture.finish();
                }
            }
        }
        return true;
    }

    private void destroyCacheDataStore() {
        try {
            this.grp.offheap().destroyCacheDataStore(this.dataStore());
        }
        catch (IgniteCheckedException e) {
            log.error("Unable to destroy cache data store on partition eviction [id=" + this.id + "]", e);
        }
    }

    public void onUnlock() {
        this.tryContinueClearing();
    }

    public boolean primary(AffinityTopologyVersion topVer) {
        List<ClusterNode> nodes2 = this.grp.affinity().cachedAffinity(topVer).get(this.id);
        return !nodes2.isEmpty() && this.ctx.localNode().equals(nodes2.get(0));
    }

    public boolean backup(AffinityTopologyVersion topVer) {
        List<ClusterNode> nodes2 = this.grp.affinity().cachedAffinity(topVer).get(this.id);
        return nodes2.indexOf(this.ctx.localNode()) > 0;
    }

    public long nextUpdateCounter(int cacheId, AffinityTopologyVersion topVer, boolean primary, @Nullable Long primaryCntr) {
        long nextCntr = this.store.nextUpdateCounter();
        if (this.grp.sharedGroup()) {
            this.grp.onPartitionCounterUpdate(cacheId, this.id, primaryCntr != null ? primaryCntr : nextCntr, topVer, primary);
        }
        return nextCntr;
    }

    public long updateCounter() {
        return this.store.updateCounter();
    }

    public void updateCounter(long val) {
        this.store.updateCounter(val);
    }

    public long initialUpdateCounter() {
        return this.store.initialUpdateCounter();
    }

    public void initialUpdateCounter(long val) {
        this.store.updateInitialCounter(val);
    }

    public long getAndIncrementUpdateCounter(long delta) {
        return this.store.getAndIncrementUpdateCounter(delta);
    }

    public void updateCounter(long start, long delta) {
        this.store.updateCounter(start, delta);
    }

    public long fullSize() {
        return this.store.fullSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long clearAll(EvictionContext evictionCtx) throws NodeStoppingException {
        GridCacheVersion clearVer = this.ctx.versions().next();
        GridCacheObsoleteEntryExtras extras2 = new GridCacheObsoleteEntryExtras(clearVer);
        boolean rec = this.grp.eventRecordable(85);
        if (this.grp.sharedGroup()) {
            for (GridCacheConcurrentMap.CacheMapHolder hld : this.cacheMaps.values()) {
                this.clear(hld.map, extras2, rec);
            }
        } else {
            this.clear(this.singleCacheEntryMap.map, extras2, rec);
        }
        long cleared = 0L;
        int stopCheckingFreq = 1000;
        GridCacheConcurrentMap.CacheMapHolder hld = this.grp.sharedGroup() ? null : this.singleCacheEntryMap;
        try {
            GridIterator<CacheDataRow> it0 = this.grp.offheap().partitionIterator(this.id);
            while (it0.hasNext()) {
                this.ctx.database().checkpointReadLock();
                try {
                    CacheDataRow row = (CacheDataRow)it0.next();
                    if (row.version().compareTo(clearVer) >= 0 && this.state() == GridDhtPartitionState.MOVING && this.clear) continue;
                    if (this.grp.sharedGroup() && (hld == null || hld.cctx.cacheId() != row.cacheId())) {
                        hld = this.cacheMapHolder(this.ctx.cacheContext(row.cacheId()));
                    }
                    assert (hld != null);
                    GridCacheMapEntry cached = this.putEntryIfObsoleteOrAbsent(hld, hld.cctx, this.grp.affinity().lastVersion(), row.key(), true, false);
                    if (cached instanceof GridDhtCacheEntry && ((GridDhtCacheEntry)cached).clearInternal(clearVer, extras2)) {
                        this.removeEntry(cached);
                        if (rec && !hld.cctx.config().isEventsDisabled().booleanValue()) {
                            hld.cctx.events().addEvent(cached.partition(), cached.key(), this.ctx.localNodeId(), (IgniteUuid)null, null, 85, null, false, cached.rawGet(), cached.hasValue(), null, null, null, false);
                        }
                        ++cleared;
                    }
                    if (cleared % 1000L != 0L || !evictionCtx.shouldStop()) continue;
                    long l = cleared;
                    return l;
                }
                catch (GridDhtInvalidPartitionException e) {
                    if ($assertionsDisabled) break;
                    if (!this.isEmpty()) throw new AssertionError((Object)("Invalid error [e=" + e + ", part=" + this + ']'));
                    if (this.state() != GridDhtPartitionState.EVICTED) {
                        throw new AssertionError((Object)("Invalid error [e=" + e + ", part=" + this + ']'));
                    }
                    break;
                }
                finally {
                    this.ctx.database().checkpointReadUnlock();
                }
            }
            if (!forceTestCheckpointOnEviction) return cleared;
            if (partWhereTestCheckpointEnforced != null) return cleared;
            if (cleared < this.fullSize()) return cleared;
            this.ctx.database().forceCheckpoint("test").finishFuture().get();
            log.warning("Forced checkpoint by test reasons for partition: " + this);
            partWhereTestCheckpointEnforced = this.id;
            return cleared;
        }
        catch (NodeStoppingException e) {
            if (!log.isDebugEnabled()) throw e;
            log.debug("Failed to get iterator for evicted partition: " + this.id);
            throw e;
        }
        catch (IgniteCheckedException e) {
            U.error(log, "Failed to get iterator for evicted partition: " + this.id, e);
        }
        return cleared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(ConcurrentMap<KeyCacheObject, GridCacheMapEntry> map2, GridCacheObsoleteEntryExtras extras2, boolean evt) throws NodeStoppingException {
        Iterator it = map2.values().iterator();
        while (it.hasNext()) {
            GridCacheMapEntry cached = null;
            this.ctx.database().checkpointReadLock();
            try {
                cached = (GridCacheMapEntry)it.next();
                if (!(cached instanceof GridDhtCacheEntry) || !((GridDhtCacheEntry)cached).clearInternal(extras2.obsoleteVersion(), extras2)) continue;
                this.removeEntry(cached);
                if (cached.isInternal() || !evt) continue;
                this.grp.addCacheEvent(cached.partition(), cached.key(), this.ctx.localNodeId(), 85, null, false, cached.rawGet(), cached.hasValue(), false);
            }
            catch (GridDhtInvalidPartitionException e) {
                assert (this.isEmpty() && this.state() == GridDhtPartitionState.EVICTED) : "Invalid error [e=" + e + ", part=" + this + ']';
                break;
            }
            catch (NodeStoppingException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to clear cache entry for evicted partition: " + cached.partition());
                }
                throw e;
            }
            catch (IgniteCheckedException e) {
                U.error(log, "Failed to clear cache entry for evicted partition: " + cached, e);
            }
            finally {
                this.ctx.database().checkpointReadUnlock();
            }
        }
    }

    private void clearDeferredDeletes() {
        for (RemovedEntryHolder e : this.rmvQueue) {
            this.removeVersionedEntry(e.cacheId(), e.key(), e.version());
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return obj instanceof GridDhtLocalPartition && (obj == this || ((GridDhtLocalPartition)obj).id() == this.id);
    }

    @Override
    public int compareTo(@NotNull GridDhtLocalPartition part) {
        if (part == null) {
            return 1;
        }
        return Integer.compare(this.id, part.id());
    }

    public String toString() {
        return S.toString(GridDhtLocalPartition.class, this, "grp", this.grp.cacheOrGroupName(), "state", (Object)this.state(), "reservations", this.reservations(), "empty", this.isEmpty(), "createTime", U.format(this.createTime));
    }

    @Override
    public int publicSize(int cacheId) {
        if (this.grp.sharedGroup()) {
            GridCacheConcurrentMap.CacheMapHolder hld = (GridCacheConcurrentMap.CacheMapHolder)this.cacheMaps.get(cacheId);
            return hld != null ? hld.size.get() : 0;
        }
        return GridDhtLocalPartition.getSize(this.state.get());
    }

    @Override
    public void incrementPublicSize(@Nullable GridCacheConcurrentMap.CacheMapHolder hld, GridCacheEntryEx e) {
        long state;
        if (this.grp.sharedGroup()) {
            if (hld == null) {
                hld = this.cacheMapHolder(e.context());
            }
            hld.size.incrementAndGet();
        }
        while (!this.state.compareAndSet(state = this.state.get(), GridDhtLocalPartition.setSize(state, GridDhtLocalPartition.getSize(state) + 1))) {
        }
    }

    @Override
    public void decrementPublicSize(@Nullable GridCacheConcurrentMap.CacheMapHolder hld, GridCacheEntryEx e) {
        long state;
        if (this.grp.sharedGroup()) {
            if (hld == null) {
                hld = this.cacheMapHolder(e.context());
            }
            hld.size.decrementAndGet();
        }
        do {
            state = this.state.get();
            assert (GridDhtLocalPartition.getPartState(state) != GridDhtPartitionState.EVICTED);
        } while (!this.state.compareAndSet(state, GridDhtLocalPartition.setSize(state, GridDhtLocalPartition.getSize(state) - 1)));
    }

    public CacheGroupContext group() {
        return this.grp;
    }

    public void onCacheStopped(int cacheId) {
        assert (this.grp.sharedGroup()) : this.grp.cacheOrGroupName();
        Iterator<RemovedEntryHolder> it = this.rmvQueue.iterator();
        while (it.hasNext()) {
            RemovedEntryHolder e = it.next();
            if (e.cacheId() != cacheId) continue;
            it.remove();
        }
        this.cacheMaps.remove(cacheId);
    }

    private static GridDhtPartitionState getPartState(long state) {
        return GridDhtPartitionState.fromOrdinal((int)(state & 7L));
    }

    private static long setPartState(long state, GridDhtPartitionState partState) {
        return state & 0xFFFFFFFFFFFFFFF8L | (long)partState.ordinal();
    }

    private static int getReservations(long state) {
        return (int)((state & 0xFFFF0000L) >> 16);
    }

    private static long setReservations(long state, int reservations) {
        return state & 0xFFFFFFFF0000FFFFL | (long)(reservations << 16);
    }

    private static int getSize(long state) {
        return (int)((state & 0xFFFFFFFF00000000L) >> 32);
    }

    private static long setSize(long state, int size2) {
        return state & 0xFFFFFFFFL | (long)size2 << 32;
    }

    public void finalizeUpdateCountres() {
        this.store.finalizeUpdateCountres();
    }

    static {
        logRef = new AtomicReference();
    }

    class ClearFuture
    extends GridFutureAdapter<Boolean> {
        private volatile boolean evictionCbRegistered;
        private volatile boolean clearingCbRegistered;
        private volatile boolean finished;

        ClearFuture() {
            this.onDone();
            this.finished = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerEvictionCallback(boolean updateSeq) {
            if (this.evictionCbRegistered) {
                return;
            }
            ClearFuture clearFuture = this;
            synchronized (clearFuture) {
                if (this.evictionCbRegistered) {
                    return;
                }
                this.evictionCbRegistered = true;
                this.listen(f2 -> {
                    try {
                        f2.get();
                        GridDhtLocalPartition.this.finishEviction(updateSeq);
                    }
                    catch (Exception e) {
                        GridDhtLocalPartition.this.rent.onDone(e);
                    }
                    this.evictionCbRegistered = false;
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerClearingCallback() {
            if (this.clearingCbRegistered) {
                return;
            }
            ClearFuture clearFuture = this;
            synchronized (clearFuture) {
                if (this.clearingCbRegistered) {
                    return;
                }
                this.clearingCbRegistered = true;
                this.listen(f2 -> {
                    GridDhtLocalPartition.this.clear = false;
                    this.clearingCbRegistered = false;
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            ClearFuture clearFuture = this;
            synchronized (clearFuture) {
                this.onDone();
                this.finished = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish(Throwable t) {
            ClearFuture clearFuture = this;
            synchronized (clearFuture) {
                this.onDone(t);
                this.finished = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean initialize(boolean updateSeq, boolean evictionRequested) {
            if (!this.finished) {
                if (evictionRequested) {
                    this.registerEvictionCallback(updateSeq);
                } else {
                    this.registerClearingCallback();
                }
                return false;
            }
            ClearFuture clearFuture = this;
            synchronized (clearFuture) {
                boolean done = this.isDone();
                if (done) {
                    this.reset();
                    this.finished = false;
                    this.evictionCbRegistered = false;
                    this.clearingCbRegistered = false;
                }
                if (evictionRequested) {
                    this.registerEvictionCallback(updateSeq);
                } else {
                    this.registerClearingCallback();
                }
                return done;
            }
        }
    }

    private static class RemovedEntryHolder {
        private final int cacheId;
        private final KeyCacheObject key;
        private final GridCacheVersion ver;
        private final long expireTime;

        private RemovedEntryHolder(int cacheId, KeyCacheObject key, GridCacheVersion ver, long ttl) {
            this.cacheId = cacheId;
            this.key = key;
            this.ver = ver;
            this.expireTime = U.currentTimeMillis() + ttl;
        }

        int cacheId() {
            return this.cacheId;
        }

        KeyCacheObject key() {
            return this.key;
        }

        GridCacheVersion version() {
            return this.ver;
        }

        long expireTime() {
            return this.expireTime;
        }

        public String toString() {
            return S.toString(RemovedEntryHolder.class, this);
        }
    }
}

