/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.ExchangeDiscoveryEvents;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionFullCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinator;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.GridPartitionStateMap;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

@GridToStringExclude
public class GridClientPartitionTopology
implements GridDhtPartitionTopology {
    private static final GridDhtPartitionState[] MOVING_STATES = new GridDhtPartitionState[]{GridDhtPartitionState.MOVING};
    private static final boolean CONSISTENCY_CHECK = false;
    private static final boolean FULL_MAP_DEBUG = false;
    private GridCacheSharedContext cctx;
    private int grpId;
    private final IgniteLogger log;
    private GridDhtPartitionFullMap node2part;
    private final Map<Integer, Set<UUID>> part2node = new HashMap<Integer, Set<UUID>>();
    private AffinityTopologyVersion lastExchangeVer;
    private AffinityTopologyVersion topVer = AffinityTopologyVersion.NONE;
    private volatile boolean stopping;
    private volatile GridDhtTopologyFuture topReadyFut;
    private final GridAtomicLong updateSeq = new GridAtomicLong(1L);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private CachePartitionFullCountersMap cntrMap;
    private final Object similarAffKey;
    private volatile DiscoCache discoCache;
    private final int parts;
    private volatile Map<Integer, Long> globalPartSizes;

    public GridClientPartitionTopology(GridCacheSharedContext<?, ?> cctx, DiscoCache discoCache, int grpId, int parts, Object similarAffKey) {
        this.cctx = cctx;
        this.discoCache = discoCache;
        this.grpId = grpId;
        this.similarAffKey = similarAffKey;
        this.parts = parts;
        this.topVer = AffinityTopologyVersion.NONE;
        this.log = cctx.logger(this.getClass());
        this.node2part = new GridDhtPartitionFullMap(cctx.localNode().id(), cctx.localNode().order(), this.updateSeq.get());
        this.cntrMap = new CachePartitionFullCountersMap(parts);
    }

    @Override
    public int partitions() {
        return this.parts;
    }

    @Nullable
    public Object similarAffinityKey() {
        return this.similarAffKey;
    }

    private String fullMapString() {
        return this.node2part == null ? "null" : this.node2part.toString();
    }

    private String mapString(GridDhtPartitionMap map2) {
        return map2 == null ? "null" : map2.toString();
    }

    @Override
    public int groupId() {
        return this.grpId;
    }

    @Override
    public void readLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    @Override
    public MvccCoordinator mvccCoordinator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean holdsLock() {
        return this.lock.isWriteLockedByCurrentThread() || this.lock.getReadHoldCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTopologyVersion(GridDhtTopologyFuture exchFut, DiscoCache discoCache, MvccCoordinator mvccCrd, long updSeq, boolean stopping) throws IgniteInterruptedCheckedException {
        U.writeLock(this.lock);
        try {
            AffinityTopologyVersion exchTopVer = exchFut.initialVersion();
            assert (exchTopVer.compareTo(this.topVer) > 0) : "Invalid topology version [grp=" + this.grpId + ", topVer=" + this.topVer + ", exchVer=" + exchTopVer + ", discoCacheVer=" + (this.discoCache != null ? this.discoCache.version() : "None") + ", exchDiscoCacheVer=" + discoCache.version() + ']';
            this.stopping = stopping;
            this.topVer = exchTopVer;
            this.discoCache = discoCache;
            this.updateSeq.setIfGreater(updSeq);
            this.topReadyFut = exchFut;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public AffinityTopologyVersion readyTopologyVersion() {
        this.lock.readLock().lock();
        try {
            assert (this.topVer.topologyVersion() > 0L);
            AffinityTopologyVersion affinityTopologyVersion = this.topVer;
            return affinityTopologyVersion;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public AffinityTopologyVersion lastTopologyChangeVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GridDhtTopologyFuture topologyVersionFuture() {
        assert (this.topReadyFut != null);
        return this.topReadyFut;
    }

    @Override
    public boolean stopping() {
        return this.stopping;
    }

    @Override
    public boolean initPartitionsWhenAffinityReady(AffinityTopologyVersion affVer, GridDhtPartitionsExchangeFuture exchFut) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeExchange(GridDhtPartitionsExchangeFuture exchFut, boolean initParts, boolean updateMoving) throws IgniteCheckedException {
        ClusterNode loc = this.cctx.localNode();
        U.writeLock(this.lock);
        try {
            if (this.stopping) {
                return;
            }
            this.discoCache = exchFut.events().discoveryCache();
            this.beforeExchange0(loc, exchFut);
            if (updateMoving) {
                ExchangeDiscoveryEvents evts = exchFut.context().events();
                GridAffinityAssignmentCache aff = this.cctx.affinity().affinity(this.grpId);
                assert (aff.lastVersion().equals(evts.topologyVersion()));
                this.createMovingPartitions(aff.readyAffinity(evts.topologyVersion()));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void createMovingPartitions(AffinityAssignment aff) {
        for (Map.Entry e : this.node2part.entrySet()) {
            GridDhtPartitionMap map2 = (GridDhtPartitionMap)e.getValue();
            this.addMoving(map2, aff.backupPartitions((UUID)e.getKey()));
            this.addMoving(map2, aff.primaryPartitions((UUID)e.getKey()));
        }
    }

    private void addMoving(GridDhtPartitionMap map2, Set<Integer> parts) {
        if (F.isEmpty(parts)) {
            return;
        }
        for (Integer p : parts) {
            GridDhtPartitionState state = map2.get(p);
            if (state != null && state != GridDhtPartitionState.EVICTED) continue;
            map2.put(p, GridDhtPartitionState.MOVING);
        }
    }

    private void beforeExchange0(ClusterNode loc, GridDhtPartitionsExchangeFuture exchFut) {
        GridDhtPartitionExchangeId exchId = exchFut.exchangeId();
        if (exchFut.context().events().hasServerLeft()) {
            List<DiscoveryEvent> evts0 = exchFut.context().events().events();
            for (int i = 0; i < evts0.size(); ++i) {
                DiscoveryEvent evt = evts0.get(i);
                if (!ExchangeDiscoveryEvents.serverLeftEvent(evt)) continue;
                this.removeNode(evt.eventNode().id());
            }
        }
        ClusterNode oldest = this.discoCache.oldestAliveServerNode();
        assert (oldest != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Partition map beforeExchange [exchId=" + exchId + ", fullMap=" + this.fullMapString() + ']');
        }
        long updateSeq = this.updateSeq.incrementAndGet();
        if (oldest.id().equals(loc.id()) || exchFut.dynamicCacheGroupStarted(this.grpId)) {
            if (this.node2part == null) {
                this.node2part = new GridDhtPartitionFullMap(oldest.id(), oldest.order(), updateSeq);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Created brand new full topology map on oldest node [exchId=" + exchId + ", fullMap=" + this.fullMapString() + ']');
                }
            } else if (!this.node2part.valid()) {
                this.node2part = new GridDhtPartitionFullMap(oldest.id(), oldest.order(), updateSeq, this.node2part, false);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Created new full topology map on oldest node [exchId=" + exchId + ", fullMap=" + this.node2part + ']');
                }
            } else if (!this.node2part.nodeId().equals(loc.id())) {
                this.node2part = new GridDhtPartitionFullMap(oldest.id(), oldest.order(), updateSeq, this.node2part, false);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Copied old map into new map on oldest node (previous oldest node left) [exchId=" + exchId + ", fullMap=" + this.fullMapString() + ']');
                }
            }
        }
        this.consistencyCheck();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Partition map after beforeExchange [exchId=" + exchId + ", fullMap=" + this.fullMapString() + ']');
        }
    }

    @Override
    public void afterStateRestored(AffinityTopologyVersion topVer) {
    }

    @Override
    public boolean afterExchange(GridDhtPartitionsExchangeFuture exchFut) throws IgniteCheckedException {
        AffinityTopologyVersion topVer = exchFut.topologyVersion();
        this.lock.writeLock().lock();
        try {
            assert (topVer.equals(exchFut.topologyVersion())) : "Invalid topology version [topVer=" + topVer + ", exchId=" + exchFut.exchangeId() + ']';
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition map before afterExchange [exchId=" + exchFut.exchangeId() + ", fullMap=" + this.fullMapString() + ']');
            }
            this.updateSeq.incrementAndGet();
            this.consistencyCheck();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return false;
    }

    @Override
    @Nullable
    public GridDhtLocalPartition localPartition(int p, AffinityTopologyVersion topVer, boolean create) throws GridDhtInvalidPartitionException {
        if (!create) {
            return null;
        }
        throw new GridDhtInvalidPartitionException(p, "Adding entry to evicted partition (often may be caused by inconsistent 'key.hashCode()' implementation) [part=" + p + ", topVer=" + topVer + ", this.topVer=" + this.topVer + ']');
    }

    @Override
    @Nullable
    public GridDhtLocalPartition localPartition(int p, AffinityTopologyVersion topVer, boolean create, boolean showRenting) throws GridDhtInvalidPartitionException {
        return this.localPartition(p, topVer, create);
    }

    @Override
    public GridDhtLocalPartition forceCreatePartition(int p) throws IgniteCheckedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public GridDhtLocalPartition localPartition(int p) {
        return this.localPartition(p, AffinityTopologyVersion.NONE, false);
    }

    @Override
    public void releasePartitions(int ... parts) {
    }

    @Override
    public List<GridDhtLocalPartition> localPartitions() {
        return Collections.emptyList();
    }

    public Collection<GridDhtLocalPartition> currentLocalPartitions() {
        return Collections.emptyList();
    }

    @Override
    public void onRemoved(GridDhtCacheEntry e) {
        assert (false) : "Entry should not be removed from client topology: " + e;
    }

    @Override
    public GridDhtPartitionMap localPartitionMap() {
        this.lock.readLock().lock();
        try {
            GridDhtPartitionMap gridDhtPartitionMap = new GridDhtPartitionMap(this.cctx.localNodeId(), this.updateSeq.get(), this.topVer, GridPartitionStateMap.EMPTY, true);
            return gridDhtPartitionMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDhtPartitionState partitionState(UUID nodeId, int part) {
        this.lock.readLock().lock();
        try {
            GridDhtPartitionMap partMap = (GridDhtPartitionMap)this.node2part.get(nodeId);
            if (partMap != null) {
                GridDhtPartitionState state = partMap.get(part);
                GridDhtPartitionState gridDhtPartitionState = state == null ? GridDhtPartitionState.EVICTED : state;
                return gridDhtPartitionState;
            }
            GridDhtPartitionState gridDhtPartitionState = GridDhtPartitionState.EVICTED;
            return gridDhtPartitionState;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    @Nullable
    public List<ClusterNode> nodes(int p, AffinityAssignment affAssignment, List<ClusterNode> affNodes) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClusterNode> nodes(int p, AffinityTopologyVersion topVer) {
        this.lock.readLock().lock();
        try {
            assert (this.node2part != null && this.node2part.valid()) : "Invalid node-to-partitions map [topVer=" + topVer + ", node2part=" + this.node2part + ']';
            Object nodes2 = null;
            Collection nodeIds = this.part2node.get(p);
            if (!F.isEmpty(nodeIds)) {
                for (UUID nodeId : nodeIds) {
                    ClusterNode n = this.discoCache.node(nodeId);
                    if (n == null || topVer.topologyVersion() >= 0L && n.order() > topVer.topologyVersion()) continue;
                    if (nodes2 == null) {
                        nodes2 = new ArrayList(nodeIds.size());
                    }
                    nodes2.add((ClusterNode)n);
                }
            }
            Iterator<ClusterNode> iterator2 = nodes2;
            return iterator2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ClusterNode> nodes(int p, AffinityTopologyVersion topVer, GridDhtPartitionState state, GridDhtPartitionState ... states) {
        Collection<UUID> allIds = F.nodeIds(this.discoCache.cacheGroupAffinityNodes(this.grpId));
        this.lock.readLock().lock();
        try {
            int size2;
            assert (this.node2part != null && this.node2part.valid()) : "Invalid node-to-partitions map [topVer=" + topVer + ", allIds=" + allIds + ", node2part=" + this.node2part + ']';
            Collection nodeIds = this.part2node.get(p);
            int n = size2 = nodeIds == null ? 0 : nodeIds.size();
            if (size2 == 0) {
                List<ClusterNode> list2 = Collections.emptyList();
                return list2;
            }
            ArrayList<ClusterNode> nodes2 = new ArrayList<ClusterNode>(size2);
            for (UUID id : nodeIds) {
                ClusterNode n2;
                if (topVer.topologyVersion() > 0L && !F.contains(allIds, id) || !this.hasState(p, id, state, states) || (n2 = this.discoCache.node(id)) == null || topVer.topologyVersion() >= 0L && n2.order() > topVer.topologyVersion()) continue;
                nodes2.add(n2);
            }
            ArrayList<ClusterNode> arrayList = nodes2;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<ClusterNode> owners(int p, AffinityTopologyVersion topVer) {
        return this.nodes(p, topVer, GridDhtPartitionState.OWNING, null);
    }

    @Override
    public List<ClusterNode> owners(int p) {
        return this.owners(p, AffinityTopologyVersion.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<List<ClusterNode>> allOwners() {
        this.lock.readLock().lock();
        try {
            int parts = this.partitions();
            ArrayList<List<ClusterNode>> res = new ArrayList<List<ClusterNode>>(parts);
            for (int i = 0; i < parts; ++i) {
                res.add(new ArrayList());
            }
            List<ClusterNode> allNodes = this.discoCache.cacheGroupAffinityNodes(this.grpId);
            for (int i = 0; i < allNodes.size(); ++i) {
                ClusterNode node = allNodes.get(i);
                GridDhtPartitionMap nodeParts = (GridDhtPartitionMap)this.node2part.get(node.id());
                if (nodeParts == null) continue;
                for (Map.Entry<Integer, GridDhtPartitionState> e : nodeParts.map().entrySet()) {
                    if (e.getValue() != GridDhtPartitionState.OWNING) continue;
                    int part = e.getKey();
                    List owners = (List)res.get(part);
                    owners.add(node);
                }
            }
            ArrayList<List<ClusterNode>> arrayList = res;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<ClusterNode> moving(int p) {
        return this.nodes(p, AffinityTopologyVersion.NONE, GridDhtPartitionState.MOVING, null);
    }

    private List<ClusterNode> ownersAndMoving(int p, AffinityTopologyVersion topVer) {
        return this.nodes(p, topVer, GridDhtPartitionState.OWNING, MOVING_STATES);
    }

    @Override
    public long updateSequence() {
        return this.updateSeq.get();
    }

    public long lastUpdateSequence() {
        this.lock.writeLock().lock();
        try {
            long l = this.updateSeq.incrementAndGet();
            return l;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDhtPartitionFullMap partitionMap(boolean onlyActive) {
        this.lock.readLock().lock();
        try {
            if (this.stopping || this.node2part == null) {
                GridDhtPartitionFullMap gridDhtPartitionFullMap = null;
                return gridDhtPartitionFullMap;
            }
            assert (this.node2part.valid()) : "Invalid node2part [node2part: " + this.node2part + ", locNodeId=" + this.cctx.localNodeId() + ", igniteInstanceName=" + this.cctx.igniteInstanceName() + ']';
            GridDhtPartitionFullMap m = this.node2part;
            GridDhtPartitionFullMap gridDhtPartitionFullMap = new GridDhtPartitionFullMap(m.nodeId(), m.nodeOrder(), m.updateSequence(), m, onlyActive);
            return gridDhtPartitionFullMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean shouldOverridePartitionMap(GridDhtPartitionMap currentMap, GridDhtPartitionMap newMap) {
        return newMap != null && (newMap.topologyVersion().compareTo(currentMap.topologyVersion()) > 0 || newMap.topologyVersion().compareTo(currentMap.topologyVersion()) == 0 && newMap.updateSequence() > currentMap.updateSequence());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(@Nullable AffinityTopologyVersion exchangeVer, GridDhtPartitionFullMap partMap, @Nullable CachePartitionFullCountersMap cntrMap, Set<Integer> partsToReload, @Nullable Map<Integer, Long> partSizes, @Nullable AffinityTopologyVersion msgTopVer) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Updating full partition map [exchVer=" + exchangeVer + ", parts=" + this.fullMapString() + ']');
        }
        this.lock.writeLock().lock();
        try {
            boolean fullMapUpdated;
            if (exchangeVer != null && this.lastExchangeVer != null && this.lastExchangeVer.compareTo(exchangeVer) >= 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stale exchange id for full partition map update (will ignore) [lastExchId=" + this.lastExchangeVer + ", exchVer=" + exchangeVer + ']');
                }
                boolean bl = false;
                return bl;
            }
            if (msgTopVer != null && this.lastExchangeVer != null && this.lastExchangeVer.compareTo(msgTopVer) > 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stale topology version for full partition map update message (will ignore) [lastExchId=" + this.lastExchangeVer + ", topVersion=" + msgTopVer + ']');
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = fullMapUpdated = this.node2part == null;
            if (this.node2part != null) {
                for (GridDhtPartitionMap gridDhtPartitionMap : this.node2part.values()) {
                    GridDhtPartitionMap newPart;
                    if (this.shouldOverridePartitionMap(gridDhtPartitionMap, newPart = (GridDhtPartitionMap)partMap.get(gridDhtPartitionMap.nodeId()))) {
                        fullMapUpdated = true;
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Overriding partition map in full update map [exchId=" + exchangeVer + ", curPart=" + this.mapString(gridDhtPartitionMap) + ", newPart=" + this.mapString(newPart) + ']');
                        continue;
                    }
                    partMap.put(gridDhtPartitionMap.nodeId(), gridDhtPartitionMap);
                }
                for (GridDhtPartitionMap gridDhtPartitionMap : partMap.values()) {
                    if (fullMapUpdated) break;
                    fullMapUpdated = !this.node2part.containsKey(gridDhtPartitionMap.nodeId());
                }
                Iterator it = partMap.keySet().iterator();
                while (it.hasNext()) {
                    UUID uUID = (UUID)it.next();
                    if (this.cctx.discovery().alive(uUID)) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Removing left node from full map update [nodeId=" + uUID + ", partMap=" + partMap + ']');
                    }
                    it.remove();
                }
            }
            if (!fullMapUpdated) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("No updates for full partition map (will ignore) [lastExch=" + this.lastExchangeVer + ", exch=" + exchangeVer + ", curMap=" + this.node2part + ", newMap=" + partMap + ']');
                }
                boolean bl2 = false;
                return bl2;
            }
            if (exchangeVer != null) {
                this.lastExchangeVer = exchangeVer;
            }
            this.node2part = partMap;
            this.updateSeq.incrementAndGet();
            this.part2node.clear();
            for (Map.Entry entry2 : this.node2part.entrySet()) {
                for (Map.Entry<Integer, GridDhtPartitionState> e0 : ((GridDhtPartitionMap)entry2.getValue()).entrySet()) {
                    if (e0.getValue() != GridDhtPartitionState.MOVING && e0.getValue() != GridDhtPartitionState.OWNING) continue;
                    int p = e0.getKey();
                    Set<UUID> ids = this.part2node.get(p);
                    if (ids == null) {
                        ids = U.newHashSet(3);
                        this.part2node.put(p, ids);
                    }
                    ids.add((UUID)entry2.getKey());
                }
            }
            if (cntrMap != null) {
                this.cntrMap = new CachePartitionFullCountersMap(cntrMap);
            }
            if (partSizes != null) {
                this.globalPartSizes = partSizes;
            }
            this.consistencyCheck();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition map after full update: " + this.fullMapString());
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectUpdateCounters(CachePartitionPartialCountersMap cntrMap) {
        assert (cntrMap != null);
        this.lock.writeLock().lock();
        try {
            for (int i = 0; i < cntrMap.size(); ++i) {
                int pId = cntrMap.partitionAt(i);
                long initialUpdateCntr = cntrMap.initialUpdateCounterAt(i);
                long updateCntr = cntrMap.updateCounterAt(i);
                if (this.cntrMap.updateCounter(pId) >= updateCntr) continue;
                this.cntrMap.initialUpdateCounter(pId, initialUpdateCntr);
                this.cntrMap.updateCounter(pId, updateCntr);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void applyUpdateCounters() {
    }

    private boolean isStaleUpdate(GridDhtPartitionMap currentMap, GridDhtPartitionMap newMap) {
        return currentMap != null && newMap.compareTo(currentMap) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(@Nullable GridDhtPartitionExchangeId exchId, GridDhtPartitionMap parts, boolean force) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Updating single partition map [exchId=" + exchId + ", parts=" + this.mapString(parts) + ']');
        }
        if (!this.cctx.discovery().alive(parts.nodeId())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received partition update for non-existing node (will ignore) [exchId=" + exchId + ", parts=" + parts + ']');
            }
            return false;
        }
        this.lock.writeLock().lock();
        try {
            if (this.stopping) {
                boolean bl = false;
                return bl;
            }
            if (!force && this.lastExchangeVer != null && exchId != null && this.lastExchangeVer.compareTo(exchId.topologyVersion()) > 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stale exchange id for single partition map update (will ignore) [lastExchVer=" + this.lastExchangeVer + ", exchId=" + exchId + ']');
                }
                boolean bl = false;
                return bl;
            }
            if (exchId != null) {
                this.lastExchangeVer = exchId.topologyVersion();
            }
            if (this.node2part == null) {
                this.node2part = new GridDhtPartitionFullMap();
            }
            GridDhtPartitionMap cur = (GridDhtPartitionMap)this.node2part.get(parts.nodeId());
            if (force) {
                if (cur != null && cur.topologyVersion().initialized()) {
                    parts.updateSequence(cur.updateSequence(), cur.topologyVersion());
                }
            } else if (this.isStaleUpdate(cur, parts)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stale update for single partition map update (will ignore) [exchId=" + exchId + ", curMap=" + cur + ", newMap=" + parts + ']');
                }
                boolean bl = false;
                return bl;
            }
            long updateSeq = this.updateSeq.incrementAndGet();
            this.node2part = new GridDhtPartitionFullMap(this.node2part, updateSeq);
            boolean changed = false;
            if (cur == null || !cur.equals(parts)) {
                changed = true;
            }
            this.node2part.put(parts.nodeId(), parts);
            for (Map.Entry<Integer, GridDhtPartitionState> e : parts.entrySet()) {
                int p = e.getKey();
                Set<UUID> ids = this.part2node.get(p);
                if (e.getValue() == GridDhtPartitionState.MOVING || e.getValue() == GridDhtPartitionState.OWNING) {
                    if (ids == null) {
                        ids = U.newHashSet(3);
                        this.part2node.put(p, ids);
                    }
                    changed |= ids.add(parts.nodeId());
                    continue;
                }
                if (ids == null) continue;
                changed |= ids.remove(parts.nodeId());
            }
            if (cur != null) {
                for (Integer p : F.view(cur.keySet(), F0.notIn(parts.keySet()))) {
                    Set<UUID> ids = this.part2node.get(p);
                    if (ids == null) continue;
                    changed |= ids.remove(parts.nodeId());
                }
            }
            this.consistencyCheck();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition map after single update: " + this.fullMapString());
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void onExchangeDone(GridDhtPartitionsExchangeFuture fut, AffinityAssignment assignment, boolean updateRebalanceVer) {
    }

    @Override
    public boolean detectLostPartitions(AffinityTopologyVersion affVer, DiscoveryEvent discoEvt) {
        assert (false) : "detectLostPartitions should never be called on client topology";
        return false;
    }

    @Override
    public void resetLostPartitions(AffinityTopologyVersion affVer) {
        assert (false) : "resetLostPartitions should never be called on client topology";
    }

    @Override
    public Collection<Integer> lostPartitions() {
        assert (false) : "lostPartitions should never be called on client topology";
        return Collections.emptyList();
    }

    private void updateLocal(int p, UUID nodeId, GridDhtPartitionState state, long updateSeq) {
        GridDhtPartitionMap map2;
        long seq;
        assert (this.lock.isWriteLockedByCurrentThread());
        assert (nodeId.equals(this.cctx.localNodeId()));
        ClusterNode oldest = this.discoCache.oldestAliveServerNode();
        if (this.cctx.localNode().equals(oldest) && (seq = this.node2part.updateSequence()) != updateSeq) {
            if (seq > updateSeq) {
                if (this.updateSeq.get() < seq) {
                    boolean b = this.updateSeq.compareAndSet(this.updateSeq.get(), seq + 1L);
                    assert (b) : "Invalid update sequence [updateSeq=" + updateSeq + ", seq=" + seq + ", curUpdateSeq=" + this.updateSeq.get() + ", node2part=" + this.node2part.toFullString() + ']';
                    updateSeq = seq + 1L;
                } else {
                    updateSeq = seq;
                }
            }
            this.node2part.updateSequence(updateSeq);
        }
        if ((map2 = (GridDhtPartitionMap)this.node2part.get(nodeId)) == null) {
            map2 = new GridDhtPartitionMap(nodeId, updateSeq, this.topVer, GridPartitionStateMap.EMPTY, false);
            this.node2part.put(nodeId, map2);
        }
        map2.updateSequence(updateSeq, this.topVer);
        map2.put(p, state);
        Set<UUID> ids = this.part2node.get(p);
        if (ids == null) {
            ids = U.newHashSet(3);
            this.part2node.put(p, ids);
        }
        ids.add(nodeId);
    }

    private void removeNode(UUID nodeId) {
        assert (nodeId != null);
        assert (this.lock.writeLock().isHeldByCurrentThread());
        ClusterNode loc = this.cctx.localNode();
        if (this.node2part != null) {
            if (!this.node2part.nodeId().equals(loc.id())) {
                this.updateSeq.setIfGreater(this.node2part.updateSequence());
                this.node2part = new GridDhtPartitionFullMap(loc.id(), loc.order(), this.updateSeq.incrementAndGet(), this.node2part, false);
            } else {
                this.node2part = new GridDhtPartitionFullMap(this.node2part, this.node2part.updateSequence());
            }
            GridDhtPartitionMap parts = (GridDhtPartitionMap)this.node2part.remove(nodeId);
            if (parts != null) {
                for (Integer p : parts.keySet()) {
                    Set<UUID> nodeIds = this.part2node.get(p);
                    if (nodeIds == null) continue;
                    nodeIds.remove(nodeId);
                    if (!nodeIds.isEmpty()) continue;
                    this.part2node.remove(p);
                }
            }
            this.consistencyCheck();
        }
    }

    @Override
    public boolean own(GridDhtLocalPartition part) {
        assert (false) : "Client topology should never own a partition: " + part;
        return false;
    }

    @Override
    public void ownMoving(AffinityTopologyVersion topVer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvicted(GridDhtLocalPartition part, boolean updateSeq) {
        assert (updateSeq || this.lock.isWriteLockedByCurrentThread());
        this.lock.writeLock().lock();
        try {
            if (this.stopping) {
                return;
            }
            assert (part.state() == GridDhtPartitionState.EVICTED);
            long seq = updateSeq ? this.updateSeq.incrementAndGet() : this.updateSeq.get();
            this.updateLocal(part.id(), this.cctx.localNodeId(), part.state(), seq);
            this.consistencyCheck();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    @Nullable
    public GridDhtPartitionMap partitions(UUID nodeId) {
        this.lock.readLock().lock();
        try {
            GridDhtPartitionMap gridDhtPartitionMap = (GridDhtPartitionMap)this.node2part.get(nodeId);
            return gridDhtPartitionMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UUID, Set<Integer>> resetOwners(Map<Integer, Set<UUID>> ownersByUpdCounters, Set<Integer> haveHistory) {
        HashMap<UUID, Set<Integer>> result2 = new HashMap<UUID, Set<Integer>>();
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<Integer, Set<UUID>> entry2 : ownersByUpdCounters.entrySet()) {
                int part = entry2.getKey();
                Set<UUID> newOwners = entry2.getValue();
                for (Map.Entry remotes : this.node2part.entrySet()) {
                    UUID remoteNodeId = (UUID)remotes.getKey();
                    GridDhtPartitionMap partMap = (GridDhtPartitionMap)remotes.getValue();
                    GridDhtPartitionState state = partMap.get(part);
                    if (state == null || state != GridDhtPartitionState.OWNING || newOwners.contains(remoteNodeId)) continue;
                    partMap.put(part, GridDhtPartitionState.MOVING);
                    partMap.updateSequence(partMap.updateSequence() + 1L, partMap.topologyVersion());
                    result2.computeIfAbsent(remoteNodeId, n -> new HashSet());
                    ((Set)result2.get(remoteNodeId)).add(part);
                }
            }
            for (Map.Entry<Integer, Set<UUID>> entry3 : result2.entrySet()) {
                UUID nodeId = (UUID)((Object)entry3.getKey());
                Set<UUID> partsToRebalance = entry3.getValue();
                if (partsToRebalance.isEmpty()) continue;
                Set<Integer> historical = partsToRebalance.stream().filter(haveHistory::contains).collect(Collectors.toSet());
                partsToRebalance.removeAll(historical);
                U.warn(this.log, "Partitions have been scheduled for rebalancing due to outdated update counter [grpId=" + this.grpId + ", nodeId=" + nodeId + ", partsFull=" + S.compact(partsToRebalance) + ", partsHistorical=" + S.compact(historical) + "]");
            }
            for (Map.Entry<Integer, Set<UUID>> entry4 : ownersByUpdCounters.entrySet()) {
                this.part2node.put(entry4.getKey(), entry4.getValue());
            }
            this.updateSeq.incrementAndGet();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return result2;
    }

    @Override
    public CachePartitionFullCountersMap fullUpdateCounters() {
        this.lock.readLock().lock();
        try {
            CachePartitionFullCountersMap cachePartitionFullCountersMap = new CachePartitionFullCountersMap(this.cntrMap);
            return cachePartitionFullCountersMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public CachePartitionPartialCountersMap localUpdateCounters(boolean skipZeros, boolean finalizeCntrsBeforeCollecting) {
        return CachePartitionPartialCountersMap.EMPTY;
    }

    @Override
    public Map<Integer, Long> partitionSizes() {
        return Collections.emptyMap();
    }

    @Override
    @Nullable
    public Map<Integer, Long> globalPartSizes() {
        this.lock.readLock().lock();
        try {
            if (this.globalPartSizes == null) {
                Map<Integer, Long> map2 = Collections.emptyMap();
                return map2;
            }
            Map<Integer, Long> map3 = Collections.unmodifiableMap(this.globalPartSizes);
            return map3;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void globalPartSizes(@Nullable Map<Integer, Long> partSizes) {
        this.lock.writeLock().lock();
        try {
            this.globalPartSizes = partSizes;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean rebalanceFinished(AffinityTopologyVersion topVer) {
        assert (false) : "Should not be called on non-affinity node";
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMovingPartitions() {
        this.lock.readLock().lock();
        try {
            assert (this.node2part != null && this.node2part.valid()) : "Invalid node2part [node2part: " + this.node2part + ", locNodeId=" + this.cctx.localNodeId() + ", igniteInstanceName=" + this.cctx.igniteInstanceName() + ']';
            for (GridDhtPartitionMap map2 : this.node2part.values()) {
                if (!map2.hasMovingPartitions()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void printMemoryStats(int threshold) {
        X.println(">>>  Cache partition topology stats [igniteInstanceName=" + this.cctx.igniteInstanceName() + ", grpId=" + this.grpId + ']', new Object[0]);
    }

    private boolean hasState(int p, @Nullable UUID nodeId, GridDhtPartitionState match, GridDhtPartitionState ... matches) {
        if (nodeId == null) {
            return false;
        }
        GridDhtPartitionMap parts = (GridDhtPartitionMap)this.node2part.get(nodeId);
        if (parts != null) {
            GridDhtPartitionState state = parts.get(p);
            if (state == match) {
                return true;
            }
            if (matches != null && matches.length > 0) {
                for (GridDhtPartitionState s2 : matches) {
                    if (state != s2) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void consistencyCheck() {
    }
}

