/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.IgniteRebalanceIterator;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteHistoricalIterator;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.jetbrains.annotations.Nullable;

public class IgniteRebalanceIteratorImpl
implements IgniteRebalanceIterator {
    private static final long serialVersionUID = 0L;
    @Nullable
    private final NavigableMap<Integer, GridCloseableIterator<CacheDataRow>> fullIterators;
    @Nullable
    private final IgniteHistoricalIterator historicalIterator;
    private final Set<Integer> missingParts = new HashSet<Integer>();
    private Map.Entry<Integer, GridCloseableIterator<CacheDataRow>> current;
    private boolean reachedEnd;
    private boolean closed;

    public IgniteRebalanceIteratorImpl(NavigableMap<Integer, GridCloseableIterator<CacheDataRow>> fullIterators, IgniteHistoricalIterator historicalIterator) throws IgniteCheckedException {
        this.fullIterators = fullIterators;
        this.historicalIterator = historicalIterator;
        this.advance();
    }

    private synchronized void advance() throws IgniteCheckedException {
        if (this.fullIterators.isEmpty()) {
            this.reachedEnd = true;
        }
        while (!(this.reachedEnd || this.current != null && this.current.getValue().hasNextX() && !this.missingParts.contains(this.current.getKey()))) {
            if (this.current == null) {
                this.current = this.fullIterators.firstEntry();
                continue;
            }
            this.current = this.fullIterators.ceilingEntry(this.current.getKey() + 1);
            if (this.current != null) continue;
            this.reachedEnd = true;
        }
        assert (this.current != null || this.reachedEnd);
    }

    @Override
    public synchronized boolean historical(int partId) {
        return this.historicalIterator != null && this.historicalIterator.contains(partId);
    }

    @Override
    public synchronized boolean isPartitionDone(int partId) {
        if (this.missingParts.contains(partId)) {
            return false;
        }
        if (this.historical(partId)) {
            return this.historicalIterator.isDone(partId);
        }
        return this.current == null || this.current.getKey() > partId;
    }

    @Override
    public synchronized boolean isPartitionMissing(int partId) {
        return this.missingParts.contains(partId);
    }

    @Override
    public synchronized void setPartitionMissing(int partId) {
        this.missingParts.add(partId);
    }

    @Override
    public synchronized boolean hasNextX() throws IgniteCheckedException {
        if (this.historicalIterator != null && this.historicalIterator.hasNextX()) {
            return true;
        }
        return this.current != null && this.current.getValue().hasNextX();
    }

    @Override
    public synchronized CacheDataRow nextX() throws IgniteCheckedException {
        if (this.historicalIterator != null && this.historicalIterator.hasNextX()) {
            return (CacheDataRow)this.historicalIterator.nextX();
        }
        if (this.current == null || !this.current.getValue().hasNextX()) {
            throw new NoSuchElementException();
        }
        CacheDataRow result2 = (CacheDataRow)this.current.getValue().nextX();
        assert (result2.partition() == this.current.getKey().intValue());
        this.advance();
        return result2;
    }

    @Override
    public synchronized void removeX() throws IgniteCheckedException {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public synchronized void close() throws IgniteCheckedException {
        if (this.historicalIterator != null) {
            this.historicalIterator.close();
        }
        if (this.fullIterators != null) {
            for (GridCloseableIterator iter2 : this.fullIterators.values()) {
                iter2.close();
            }
        }
        this.closed = true;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized Iterator<CacheDataRow> iterator() {
        return this;
    }

    @Override
    public synchronized boolean hasNext() {
        try {
            return this.hasNextX();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public synchronized CacheDataRow next() {
        try {
            return this.nextX();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public synchronized void remove() {
        try {
            this.removeX();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }
}

