/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCachePreloaderAdapter;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionFullCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtForceKeysFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemander;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplier;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloaderAssignments;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class GridDhtPreloader
extends GridCachePreloaderAdapter {
    public static final long DFLT_PRELOAD_RESEND_TIMEOUT = 1500L;
    private GridDhtPartitionTopology top;
    private GridDhtPartitionSupplier supplier;
    private GridDhtPartitionDemander demander;
    private GridFutureAdapter<Object> startFut;
    private final ReadWriteLock busyLock = new ReentrantReadWriteLock();
    private final ReadWriteLock demandLock = new ReentrantReadWriteLock();
    private boolean stopped;

    public GridDhtPreloader(CacheGroupContext grp) {
        super(grp);
        this.top = grp.topology();
        this.startFut = new GridFutureAdapter();
    }

    @Override
    public void start() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting DHT rebalancer...");
        }
        this.supplier = new GridDhtPartitionSupplier(this.grp);
        this.demander = new GridDhtPartitionDemander(this.grp);
        this.demander.start();
    }

    @Override
    public void preloadPredicate(IgnitePredicate<GridCacheEntryInfo> preloadPred) {
        super.preloadPredicate(preloadPred);
        assert (this.supplier != null && this.demander != null) : "preloadPredicate may be called only after start()";
        this.supplier.preloadPredicate(preloadPred);
        this.demander.preloadPredicate(preloadPred);
    }

    @Override
    public void onKernalStop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DHT rebalancer onKernalStop callback.");
        }
        this.busyLock.writeLock().lock();
        try {
            if (this.supplier != null) {
                this.supplier.stop();
            }
            if (this.demander != null) {
                this.demander.stop();
            }
            this.top = null;
            this.stopped = true;
        }
        finally {
            this.busyLock.writeLock().unlock();
        }
    }

    private IgniteCheckedException stopError() {
        return new NodeStoppingException("Operation has been cancelled (cache or node is stopping).");
    }

    @Override
    public void onInitialExchangeComplete(@Nullable Throwable err2) {
        if (err2 == null) {
            this.startFut.onDone();
        } else {
            this.startFut.onDone(err2);
        }
    }

    @Override
    public void onTopologyChanged(GridDhtPartitionsExchangeFuture lastFut) {
        this.supplier.onTopologyChanged();
        this.demander.onTopologyChanged(lastFut);
    }

    @Override
    public boolean rebalanceRequired(AffinityTopologyVersion rebTopVer, GridDhtPartitionsExchangeFuture exchFut) {
        if (this.ctx.kernalContext().clientNode() || rebTopVer.equals(AffinityTopologyVersion.NONE)) {
            return false;
        }
        if (exchFut.localJoinExchange()) {
            return true;
        }
        if (!this.grp.affinity().cachedVersions().contains(rebTopVer)) {
            assert (rebTopVer.compareTo(this.grp.localStartVersion()) <= 0) : "Empty hisroty allowed only for newly started cache group [rebTopVer=" + rebTopVer + ", localStartTopVer=" + this.grp.localStartVersion() + ']';
            return true;
        }
        IgniteInternalFuture<Boolean> rebFut = this.rebalanceFuture();
        if (rebFut.isDone() && !rebFut.result().booleanValue()) {
            return true;
        }
        AffinityTopologyVersion exchTopVer = exchFut.context().events().topologyVersion();
        Collection aliveNodes = this.ctx.discovery().aliveServerNodes().stream().map(ClusterNode::id).collect(Collectors.toList());
        return this.assignmentsChanged(rebTopVer, exchTopVer) || !aliveNodes.containsAll(this.demander.remainingNodes());
    }

    private boolean assignmentsChanged(AffinityTopologyVersion oldTopVer, AffinityTopologyVersion newTopVer) {
        AffinityAssignment prevAff;
        AffinityAssignment aff = this.grp.affinity().readyAffinity(newTopVer);
        AffinityAssignment affinityAssignment = prevAff = this.grp.affinity().cachedVersions().contains(oldTopVer) ? this.grp.affinity().cachedAffinity(oldTopVer) : null;
        if (prevAff == null) {
            return false;
        }
        boolean assignsChanged = false;
        for (int p = 0; !assignsChanged && p < this.grp.affinity().partitions(); assignsChanged |= aff.get(p).contains(this.ctx.localNode()) != prevAff.get(p).contains(this.ctx.localNode()), ++p) {
        }
        return assignsChanged;
    }

    @Override
    public GridDhtPreloaderAssignments generateAssignments(GridDhtPartitionExchangeId exchId, GridDhtPartitionsExchangeFuture exchFut) {
        assert (exchFut == null || exchFut.isDone());
        GridDhtPartitionTopology top = this.grp.topology();
        if (!this.grp.rebalanceEnabled()) {
            return new GridDhtPreloaderAssignments(exchId, top.readyTopologyVersion());
        }
        int partitions = this.grp.affinity().partitions();
        AffinityTopologyVersion topVer = top.readyTopologyVersion();
        assert (exchFut == null || exchFut.context().events().topologyVersion().equals(top.readyTopologyVersion())) : "Topology version mismatch [exchId=" + exchId + ", grp=" + this.grp.name() + ", topVer=" + top.readyTopologyVersion() + ']';
        GridDhtPreloaderAssignments assignments = new GridDhtPreloaderAssignments(exchId, topVer);
        AffinityAssignment aff = this.grp.affinity().cachedAffinity(topVer);
        CachePartitionFullCountersMap countersMap = this.grp.topology().fullUpdateCounters();
        for (int p = 0; p < partitions; ++p) {
            UUID nodeId;
            if (this.ctx.exchange().hasPendingExchange()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Skipping assignments creation, exchange worker has pending assignments: " + exchId);
                }
                assignments.cancelled(true);
                return assignments;
            }
            if (!aff.get(p).contains(this.ctx.localNode())) continue;
            GridDhtLocalPartition part = top.localPartition(p);
            assert (part != null);
            assert (part.id() == p);
            if (part.state() == GridDhtPartitionState.OWNING || part.state() == GridDhtPartitionState.LOST) continue;
            if (part.state() == GridDhtPartitionState.RENTING && part.reserve()) {
                part.moving();
                part.clearAsync();
                part.release();
            }
            if (part.state() == GridDhtPartitionState.EVICTED) {
                part.awaitDestroy();
                part = top.localPartition(p, topVer, true);
            }
            assert (part.state() == GridDhtPartitionState.MOVING) : "Partition has invalid state for rebalance " + aff.topologyVersion() + " " + part;
            ClusterNode histSupplier = null;
            if (this.grp.persistenceEnabled() && exchFut != null && (nodeId = exchFut.partitionHistorySupplier(this.grp.groupId(), p, part.initialUpdateCounter())) != null) {
                histSupplier = this.ctx.discovery().node(nodeId);
            }
            if (histSupplier != null) {
                assert (this.grp.persistenceEnabled());
                assert (this.remoteOwners(p, topVer).contains(histSupplier)) : this.remoteOwners(p, topVer);
                GridDhtPartitionDemandMessage msg = (GridDhtPartitionDemandMessage)assignments.get(histSupplier);
                if (msg == null) {
                    msg = new GridDhtPartitionDemandMessage(top.updateSequence(), assignments.topologyVersion(), this.grp.groupId());
                    assignments.put(histSupplier, msg);
                }
                msg.partitions().addHistorical(p, part.initialUpdateCounter(), countersMap.updateCounter(p), partitions);
                continue;
            }
            List<ClusterNode> picked = this.remoteOwners(p, topVer);
            if (picked.isEmpty()) {
                top.own(part);
                if (this.grp.eventRecordable(86)) {
                    this.grp.addRebalanceEvent(p, 86, exchId.eventNode(), exchId.event(), exchId.eventTimestamp());
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Owning partition as there are no other owners: " + part);
                continue;
            }
            ClusterNode n = picked.get(0);
            GridDhtPartitionDemandMessage msg = (GridDhtPartitionDemandMessage)assignments.get(n);
            if (msg == null) {
                msg = new GridDhtPartitionDemandMessage(top.updateSequence(), assignments.topologyVersion(), this.grp.groupId());
                assignments.put(n, msg);
            }
            msg.partitions().addFull(p);
        }
        if (!assignments.isEmpty()) {
            this.ctx.database().lastCheckpointInapplicableForWalRebalance(this.grp.groupId());
        }
        return assignments;
    }

    @Override
    public void onReconnected() {
        this.startFut = new GridFutureAdapter();
    }

    private List<ClusterNode> remoteOwners(int p, AffinityTopologyVersion topVer) {
        List<ClusterNode> owners = this.grp.topology().owners(p, topVer);
        ArrayList<ClusterNode> res = new ArrayList<ClusterNode>(owners.size());
        for (ClusterNode owner2 : owners) {
            if (owner2.id().equals(this.ctx.localNodeId())) continue;
            res.add(owner2);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSupplyMessage(int idx, UUID id, GridDhtPartitionSupplyMessage s2) {
        if (!this.enterBusy()) {
            return;
        }
        try {
            this.demandLock.readLock().lock();
            try {
                this.demander.handleSupplyMessage(idx, id, s2);
            }
            finally {
                this.demandLock.readLock().unlock();
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDemandMessage(int idx, UUID id, GridDhtPartitionDemandMessage d) {
        if (!this.enterBusy()) {
            return;
        }
        try {
            this.supplier.handleDemandMessage(idx, id, d);
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public Runnable addAssignments(GridDhtPreloaderAssignments assignments, boolean forceRebalance, long rebalanceId, Runnable next2, @Nullable GridCompoundFuture<Boolean, Boolean> forcedRebFut) {
        return this.demander.addAssignments(assignments, forceRebalance, rebalanceId, next2, forcedRebFut);
    }

    @Override
    public IgniteInternalFuture<Object> startFuture() {
        return this.startFut;
    }

    @Override
    public IgniteInternalFuture<?> syncFuture() {
        return this.ctx.kernalContext().clientNode() ? this.startFut : this.demander.syncFuture();
    }

    @Override
    public IgniteInternalFuture<Boolean> rebalanceFuture() {
        return this.ctx.kernalContext().clientNode() ? new GridFinishedFuture<Boolean>(true) : this.demander.rebalanceFuture();
    }

    private boolean enterBusy() {
        if (!this.busyLock.readLock().tryLock()) {
            return false;
        }
        if (this.stopped) {
            this.busyLock.readLock().unlock();
            return false;
        }
        return true;
    }

    private void leaveBusy() {
        this.busyLock.readLock().unlock();
    }

    public void onPartitionEvicted(GridDhtLocalPartition part, boolean updateSeq) {
        if (!this.enterBusy()) {
            return;
        }
        try {
            this.top.onEvicted(part, updateSeq);
            if (this.grp.eventRecordable(83)) {
                this.grp.addUnloadEvent(part.id());
            }
            if (updateSeq) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partitions have been scheduled to resend [reason=Eviction [grp" + this.grp.cacheOrGroupName() + " " + part.id() + "]");
                }
                this.ctx.exchange().scheduleResendPartitions();
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public boolean needForceKeys() {
        IgniteInternalFuture<Boolean> rebalanceFut;
        return !this.grp.rebalanceEnabled() || !(rebalanceFut = this.rebalanceFuture()).isDone() || !Boolean.TRUE.equals(rebalanceFut.result());
    }

    @Override
    public GridDhtFuture<Object> request(GridCacheContext cctx, GridNearAtomicAbstractUpdateRequest req, AffinityTopologyVersion topVer) {
        if (!this.needForceKeys()) {
            return null;
        }
        return this.request0(cctx, req.keys(), topVer);
    }

    @Override
    public GridDhtFuture<Object> request(GridCacheContext cctx, Collection<KeyCacheObject> keys, AffinityTopologyVersion topVer) {
        if (!this.needForceKeys()) {
            return null;
        }
        return this.request0(cctx, keys, topVer);
    }

    private GridDhtFuture<Object> request0(GridCacheContext cctx, Collection<KeyCacheObject> keys, AffinityTopologyVersion topVer) {
        if (cctx.isNear()) {
            cctx = cctx.near().dht().context();
        }
        final GridDhtForceKeysFuture fut = new GridDhtForceKeysFuture(cctx, topVer, keys);
        IgniteInternalFuture<AffinityTopologyVersion> topReadyFut = cctx.affinity().affinityReadyFuturex(topVer);
        if (this.startFut.isDone() && topReadyFut == null) {
            fut.init();
        } else if (topReadyFut == null) {
            this.startFut.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> syncFut) {
                    GridDhtPreloader.this.ctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

                        @Override
                        public void run() {
                            fut.init();
                        }
                    });
                }
            });
        } else {
            GridCompoundFuture compound = new GridCompoundFuture();
            compound.add(this.startFut);
            compound.add(topReadyFut);
            compound.markInitialized();
            compound.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> syncFut) {
                    fut.init();
                }
            });
        }
        return fut;
    }

    @Override
    public IgniteInternalFuture<Boolean> forceRebalance() {
        return this.demander.forceRebalance();
    }

    @Override
    public void unwindUndeploys() {
        this.demandLock.writeLock().lock();
        try {
            this.grp.unwindUndeploys();
        }
        finally {
            this.demandLock.writeLock().unlock();
        }
    }

    @Override
    public void dumpDebugInfo() {
    }
}

