/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteDiagnosticAware;
import org.apache.ignite.internal.IgniteDiagnosticPrepareContext;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteNeedReconnectException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.pagemem.wal.record.ExchangeRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheAffinityChangeMessage;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CachePartitionExchangeWorkerTask;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeFailureMessage;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.ExchangeContext;
import org.apache.ignite.internal.processors.cache.ExchangeDiscoveryEvents;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.LocalJoinCachesContext;
import org.apache.ignite.internal.processors.cache.StateChangeRequest;
import org.apache.ignite.internal.processors.cache.WalStateAbstractMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CacheGroupAffinityMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionFullCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsAbstractMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsFullMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionHistorySuppliersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionsToReloadMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.InitNewCoordinatorFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.latch.Latch;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridClientPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionsStateValidator;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinator;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateFinishMessage;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteRunnable;
import org.jetbrains.annotations.Nullable;

public class GridDhtPartitionsExchangeFuture
extends GridDhtTopologyFutureAdapter
implements Comparable<GridDhtPartitionsExchangeFuture>,
CachePartitionExchangeWorkerTask,
IgniteDiagnosticAware {
    public static final String EXCHANGE_LOG = "org.apache.ignite.internal.exchange.time";
    private static final int RELEASE_FUTURE_DUMP_THRESHOLD = IgniteSystemProperties.getInteger("IGNITE_PARTITION_RELEASE_FUTURE_DUMP_THRESHOLD", 0);
    private static final IgniteProductVersion FORCE_AFF_REASSIGNMENT_SINCE = IgniteProductVersion.fromString("2.4.3");
    private static final boolean SKIP_PARTITION_SIZE_VALIDATION = Boolean.getBoolean("IGNITE_SKIP_PARTITION_SIZE_VALIDATION");
    private static final String DISTRIBUTED_LATCH_ID = "exchange";
    @GridToStringExclude
    private final Object mux = new Object();
    @GridToStringExclude
    private volatile DiscoCache firstEvtDiscoCache;
    private volatile DiscoveryEvent firstDiscoEvt;
    @GridToStringExclude
    private final Set<UUID> remaining = new HashSet<UUID>();
    @GridToStringExclude
    private int pendingSingleUpdates;
    @GridToStringExclude
    private List<ClusterNode> srvNodes;
    private volatile ClusterNode crd;
    private final GridDhtPartitionExchangeId exchId;
    private final GridCacheSharedContext<?, ?> cctx;
    private ReadWriteLock busyLock;
    private AtomicBoolean added = new AtomicBoolean(false);
    @GridToStringExclude
    private final CountDownLatch evtLatch = new CountDownLatch(1);
    private GridFutureAdapter<Boolean> initFut;
    @GridToStringExclude
    private final List<IgniteRunnable> discoEvts = new ArrayList<IgniteRunnable>();
    private boolean init;
    private AtomicReference<GridCacheVersion> lastVer = new AtomicReference();
    @GridToStringExclude
    private GridDhtPartitionsSingleMessage pendingJoinMsg;
    private final Map<UUID, GridDhtPartitionsSingleMessage> pendingSingleMsgs = new ConcurrentHashMap<UUID, GridDhtPartitionsSingleMessage>();
    private final Map<ClusterNode, GridDhtPartitionsFullMessage> fullMsgs = new ConcurrentHashMap<ClusterNode, GridDhtPartitionsFullMessage>();
    @GridToStringInclude
    private volatile IgniteInternalFuture<?> partReleaseFut;
    private final IgniteLogger log;
    private ExchangeActions exchActions;
    private final IgniteLogger exchLog;
    private CacheAffinityChangeMessage affChangeMsg;
    private long initTs;
    private boolean centralizedAff;
    private boolean forceAffReassignment;
    private Exception exchangeLocE;
    private final Map<UUID, Exception> exchangeGlobalExceptions = new ConcurrentHashMap<UUID, Exception>();
    private volatile boolean cacheChangeFailureMsgSent;
    private ConcurrentMap<UUID, GridDhtPartitionsSingleMessage> msgs = new ConcurrentHashMap<UUID, GridDhtPartitionsSingleMessage>();
    @GridToStringExclude
    private Map<UUID, GridDhtPartitionsSingleMessage> mergedJoinExchMsgs;
    @GridToStringExclude
    private int awaitMergedMsgs;
    @GridToStringExclude
    private volatile IgniteDhtPartitionHistorySuppliersMap partHistSuppliers = new IgniteDhtPartitionHistorySuppliersMap();
    private volatile Map<Integer, Map<Integer, Long>> partHistReserved;
    @GridToStringExclude
    private final IgniteDhtPartitionsToReloadMap partsToReload = new IgniteDhtPartitionsToReloadMap();
    private final AtomicBoolean done = new AtomicBoolean();
    private ExchangeLocalState state;
    @GridToStringExclude
    private ExchangeContext exchCtx;
    @GridToStringExclude
    private FinishState finishState;
    @GridToStringExclude
    private InitNewCoordinatorFuture newCrdFut;
    @GridToStringExclude
    private GridDhtPartitionsExchangeFuture mergedWith;
    @GridToStringExclude
    private final GridDhtPartitionsStateValidator validator;
    private IgniteInternalFuture<?> registerCachesFuture;
    private volatile boolean partitionsSent;
    private volatile boolean partitionsReceived;
    private GridDhtPartitionsFullMessage delayedLatestMsg;
    private final GridFutureAdapter<?> afterLsnrCompleteFut = new GridFutureAdapter();

    public GridDhtPartitionsExchangeFuture(GridCacheSharedContext cctx, ReadWriteLock busyLock, GridDhtPartitionExchangeId exchId, ExchangeActions exchActions, CacheAffinityChangeMessage affChangeMsg) {
        assert (busyLock != null);
        assert (exchId != null);
        assert (exchId.topologyVersion() != null);
        assert (exchActions == null || !exchActions.empty());
        this.cctx = cctx;
        this.busyLock = busyLock;
        this.exchId = exchId;
        this.exchActions = exchActions;
        this.affChangeMsg = affChangeMsg;
        this.validator = new GridDhtPartitionsStateValidator(cctx);
        if (exchActions != null && exchActions.deactivate()) {
            this.clusterIsActive = false;
        }
        this.log = cctx.logger(this.getClass());
        this.exchLog = cctx.logger(EXCHANGE_LOG);
        this.initFut = new GridFutureAdapter<Boolean>(){

            @Override
            public IgniteLogger logger() {
                return GridDhtPartitionsExchangeFuture.this.log;
            }
        };
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating exchange future [localNode=" + cctx.localNodeId() + ", fut=" + this + ']');
        }
    }

    public Object mutex() {
        return this.mux;
    }

    public GridCacheSharedContext sharedContext() {
        return this.cctx;
    }

    @Override
    public boolean skipForExchangeMerge() {
        return false;
    }

    public ExchangeContext context() {
        assert (this.exchCtx != null) : this;
        return this.exchCtx;
    }

    public void exchangeActions(ExchangeActions exchActions) {
        assert (exchActions == null || !exchActions.empty()) : exchActions;
        assert (this.evtLatch != null && this.evtLatch.getCount() == 1L) : this;
        this.exchActions = exchActions;
    }

    @Nullable
    public ExchangeActions exchangeActions() {
        return this.exchActions;
    }

    public void affinityChangeMessage(CacheAffinityChangeMessage affChangeMsg) {
        this.affChangeMsg = affChangeMsg;
    }

    @Override
    public AffinityTopologyVersion initialVersion() {
        return this.exchId.topologyVersion();
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        assert (this.exchangeDone()) : "Should not be called before exchange is finished";
        return this.isDone() ? (AffinityTopologyVersion)this.result() : this.exchCtx.events().topologyVersion();
    }

    @Nullable
    public UUID partitionHistorySupplier(int grpId, int partId, long cntrSince) {
        return this.partHistSuppliers.getSupplier(grpId, partId, cntrSince);
    }

    public boolean cacheAddedOnExchange(int cacheId, UUID rcvdFrom) {
        return this.dynamicCacheStarted(cacheId) || this.exchCtx.events().nodeJoined(rcvdFrom);
    }

    public boolean cacheGroupAddedOnExchange(int grpId, UUID rcvdFrom) {
        return this.dynamicCacheGroupStarted(grpId) || this.exchCtx.events().nodeJoined(rcvdFrom);
    }

    private boolean dynamicCacheStarted(int cacheId) {
        return this.exchActions != null && this.exchActions.cacheStarted(cacheId);
    }

    public boolean dynamicCacheGroupStarted(int grpId) {
        return this.exchActions != null && this.exchActions.cacheGroupStarting(grpId);
    }

    public boolean onAdded() {
        return this.added.compareAndSet(false, true);
    }

    public void onEvent(GridDhtPartitionExchangeId exchId, DiscoveryEvent discoEvt, DiscoCache discoCache) {
        assert (exchId.equals(this.exchId));
        this.exchId.discoveryEvent(discoEvt);
        this.firstDiscoEvt = discoEvt;
        this.firstEvtDiscoCache = discoCache;
        this.evtLatch.countDown();
    }

    private boolean stateChangeExchange() {
        return this.exchActions != null && this.exchActions.stateChangeRequest() != null;
    }

    private boolean dynamicCacheStartExchange() {
        return this.exchActions != null && !this.exchActions.cacheStartRequests().isEmpty() && this.exchActions.cacheStopRequests().isEmpty();
    }

    public boolean activateCluster() {
        return this.exchActions != null && this.exchActions.activate();
    }

    private boolean deactivateCluster() {
        return this.exchActions != null && this.exchActions.deactivate();
    }

    public boolean changedBaseline() {
        return this.exchActions != null && this.exchActions.changedBaseline();
    }

    public boolean hasCachesToStart() {
        return this.exchActions != null && !this.exchActions.cacheStartRequests().isEmpty();
    }

    public DiscoveryEvent firstEvent() {
        return this.firstDiscoEvt;
    }

    public DiscoCache firstEventCache() {
        return this.firstEvtDiscoCache;
    }

    public ExchangeDiscoveryEvents events() {
        return this.exchCtx.events();
    }

    public GridDhtPartitionExchangeId exchangeId() {
        return this.exchId;
    }

    private boolean enterBusy() {
        if (this.busyLock.readLock().tryLock()) {
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Failed to enter busy state (exchanger is stopping): " + this);
        }
        return false;
    }

    private void leaveBusy() {
        this.busyLock.readLock().unlock();
    }

    private void initCoordinatorCaches(boolean newCrd) throws IgniteCheckedException {
        if (newCrd) {
            IgniteInternalFuture<?> fut = this.cctx.affinity().initCoordinatorCaches(this, false);
            if (fut != null) {
                fut.get();
                this.cctx.exchange().exchangerUpdateHeartbeat();
            }
            this.cctx.exchange().onCoordinatorInitialized();
            this.cctx.exchange().exchangerUpdateHeartbeat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(boolean newCrd) throws IgniteInterruptedCheckedException {
        block62: {
            if (this.isDone()) {
                return;
            }
            assert (!this.cctx.kernalContext().isDaemon());
            this.initTs = U.currentTimeMillis();
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                U.await(this.evtLatch);
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
            assert (this.firstDiscoEvt != null) : this;
            assert (this.exchId.nodeId().equals(this.firstDiscoEvt.eventNode().id())) : this;
            try {
                ExchangeType exchange;
                AffinityTopologyVersion topVer = this.initialVersion();
                this.srvNodes = new ArrayList<ClusterNode>(this.firstEvtDiscoCache.serverNodes());
                this.remaining.addAll(F.nodeIds(F.view(this.srvNodes, F.remoteNodes(this.cctx.localNodeId()))));
                this.crd = this.srvNodes.isEmpty() ? null : this.srvNodes.get(0);
                boolean crdNode = this.crd != null && this.crd.isLocal();
                MvccCoordinator mvccCrd = this.firstEvtDiscoCache.mvccCoordinator();
                boolean mvccCrdChange = mvccCrd != null && (this.initialVersion().equals(mvccCrd.topologyVersion()) || this.activateCluster());
                this.cctx.kernalContext().coordinators().updateCoordinator(mvccCrd);
                this.exchCtx = new ExchangeContext(crdNode, mvccCrdChange, this);
                this.cctx.exchange().exchangerBlockingSectionBegin();
                try {
                    this.cctx.kernalContext().coordinators().onExchangeStart(mvccCrd, this.exchCtx, this.crd);
                }
                finally {
                    this.cctx.exchange().exchangerBlockingSectionEnd();
                }
                assert (this.state == null) : this.state;
                if (crdNode) {
                    this.state = ExchangeLocalState.CRD;
                } else {
                    ExchangeLocalState exchangeLocalState = this.state = this.cctx.kernalContext().clientNode() ? ExchangeLocalState.CLIENT : ExchangeLocalState.SRV;
                }
                if (this.exchLog.isInfoEnabled()) {
                    this.exchLog.info("Started exchange init [topVer=" + topVer + ", mvccCrd=" + mvccCrd + ", mvccCrdChange=" + mvccCrdChange + ", crd=" + crdNode + ", evt=" + IgniteUtils.gridEventName(this.firstDiscoEvt.type()) + ", evtNode=" + this.firstDiscoEvt.eventNode().id() + ", customEvt=" + (this.firstDiscoEvt.type() == 18 ? ((DiscoveryCustomEvent)this.firstDiscoEvt).customMessage() : null) + ", allowMerge=" + this.exchCtx.mergeExchanges() + ']');
                }
                if (this.firstDiscoEvt.type() == 18) {
                    assert (!this.exchCtx.mergeExchanges());
                    DiscoveryCustomMessage msg = ((DiscoveryCustomEvent)this.firstDiscoEvt).customMessage();
                    boolean bl = this.forceAffReassignment = DiscoveryCustomEvent.requiresCentralizedAffinityAssignment(msg) && this.firstEventCache().minimumNodeVersion().compareToIgnoreTimestamp(FORCE_AFF_REASSIGNMENT_SINCE) >= 0;
                    if (msg instanceof ChangeGlobalStateMessage) {
                        assert (this.exchActions != null && !this.exchActions.empty());
                        exchange = this.onClusterStateChangeRequest(crdNode);
                    } else if (msg instanceof DynamicCacheChangeBatch) {
                        assert (this.exchActions != null && !this.exchActions.empty());
                        exchange = this.onCacheChangeRequest(crdNode);
                    } else if (msg instanceof SnapshotDiscoveryMessage) {
                        exchange = this.onCustomMessageNoAffinityChange(crdNode);
                    } else if (msg instanceof WalStateAbstractMessage) {
                        exchange = this.onCustomMessageNoAffinityChange(crdNode);
                    } else {
                        assert (this.affChangeMsg != null) : this;
                        exchange = this.onAffinityChangeRequest(crdNode);
                    }
                    if (this.forceAffReassignment) {
                        this.cctx.affinity().onCentralizedAffinityChange(this, crdNode);
                    }
                    this.initCoordinatorCaches(newCrd);
                } else {
                    if (this.firstDiscoEvt.type() == 10) {
                        if (!this.firstDiscoEvt.eventNode().isLocal()) {
                            Collection<DynamicCacheDescriptor> receivedCaches = this.cctx.cache().startReceivedCaches(this.firstDiscoEvt.eventNode().id(), topVer);
                            this.registerCachesFuture = this.cctx.affinity().initStartedCaches(crdNode, this, receivedCaches);
                        } else {
                            this.registerCachesFuture = this.initCachesOnLocalJoin();
                        }
                    }
                    this.initCoordinatorCaches(newCrd);
                    if (this.exchCtx.mergeExchanges()) {
                        if (this.localJoinExchange()) {
                            if (this.cctx.kernalContext().clientNode()) {
                                this.onClientNodeEvent(crdNode);
                                exchange = ExchangeType.CLIENT;
                            } else {
                                this.onServerNodeEvent(crdNode);
                                exchange = ExchangeType.ALL;
                            }
                        } else if (this.firstDiscoEvt.eventNode().isClient()) {
                            exchange = this.onClientNodeEvent(crdNode);
                        } else {
                            ExchangeType exchangeType = exchange = this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
                        }
                        if (this.exchId.isLeft()) {
                            this.onLeft();
                        }
                    } else {
                        exchange = this.firstDiscoEvt.eventNode().isClient() ? this.onClientNodeEvent(crdNode) : this.onServerNodeEvent(crdNode);
                    }
                }
                this.cctx.cache().registrateProxyRestart(this.resolveCacheRequests(this.exchActions), this.afterLsnrCompleteFut);
                this.updateTopologies(crdNode, this.cctx.coordinators().currentCoordinator());
                switch (exchange) {
                    case ALL: {
                        this.distributedExchange();
                        break;
                    }
                    case CLIENT: {
                        if (!this.exchCtx.mergeExchanges() && this.exchCtx.fetchAffinityOnJoin()) {
                            this.initTopologies();
                        }
                        this.clientOnlyExchange();
                        break;
                    }
                    case NONE: {
                        this.initTopologies();
                        this.onDone(topVer);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (this.cctx.localNode().isClient()) {
                    this.cctx.exchange().exchangerBlockingSectionBegin();
                    try {
                        this.tryToPerformLocalSnapshotOperation();
                    }
                    finally {
                        this.cctx.exchange().exchangerBlockingSectionEnd();
                    }
                }
                if (this.exchLog.isInfoEnabled()) {
                    this.exchLog.info("Finished exchange init [topVer=" + topVer + ", crd=" + crdNode + ']');
                }
            }
            catch (IgniteInterruptedCheckedException e) {
                this.onDone(e);
                throw e;
            }
            catch (IgniteNeedReconnectException e) {
                this.onDone(e);
            }
            catch (Throwable e) {
                if (this.reconnectOnError(e)) {
                    this.onDone(new IgniteNeedReconnectException(this.cctx.localNode(), e));
                } else {
                    U.error(this.log, "Failed to reinitialize local partitions (rebalancing will be stopped): " + this.exchId, e);
                    this.onDone(e);
                }
                if (!(e instanceof Error)) break block62;
                throw (Error)e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<?> initCachesOnLocalJoin() throws IgniteCheckedException {
        List<T2<DynamicCacheDescriptor, NearCacheConfiguration>> caches;
        if (this.isLocalNodeNotInBaseline()) {
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                this.cctx.cache().cleanupCachesDirectories();
                this.cctx.database().cleanupCheckpointDirectory();
                if (this.cctx.wal() != null) {
                    this.cctx.wal().cleanupWalDirectories();
                }
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            this.cctx.activate();
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
        LocalJoinCachesContext locJoinCtx = this.exchActions == null ? null : this.exchActions.localJoinContext();
        List<T2<DynamicCacheDescriptor, NearCacheConfiguration>> list2 = caches = locJoinCtx == null ? null : locJoinCtx.caches();
        if (!this.cctx.kernalContext().clientNode()) {
            ArrayList<DynamicCacheDescriptor> startDescs = new ArrayList<DynamicCacheDescriptor>();
            if (caches != null) {
                for (T2<DynamicCacheDescriptor, NearCacheConfiguration> c : caches) {
                    DynamicCacheDescriptor startDesc = (DynamicCacheDescriptor)c.get1();
                    if (!CU.isPersistentCache(startDesc.cacheConfiguration(), this.cctx.gridConfig().getDataStorageConfiguration())) continue;
                    startDescs.add(startDesc);
                }
            }
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                this.cctx.database().readCheckpointAndRestoreMemory(startDescs);
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
        IgniteInternalFuture<?> cachesRegistrationFut = this.cctx.cache().startCachesOnLocalJoin(this.initialVersion(), locJoinCtx);
        this.ensureClientCachesStarted();
        return cachesRegistrationFut;
    }

    private void ensureClientCachesStarted() {
        GridCacheProcessor cacheProcessor = this.cctx.cache();
        HashSet<String> cacheNames = new HashSet<String>(cacheProcessor.cacheNames());
        ArrayList<CacheConfiguration> notStartedCacheConfigs = new ArrayList<CacheConfiguration>();
        for (CacheConfiguration cCfg : this.cctx.gridConfig().getCacheConfiguration()) {
            if (cacheNames.contains(cCfg.getName()) || GridCacheUtils.isCacheTemplateName(cCfg.getName())) continue;
            notStartedCacheConfigs.add(cCfg);
        }
        if (!notStartedCacheConfigs.isEmpty()) {
            cacheProcessor.dynamicStartCaches(notStartedCacheConfigs, false, false, false);
        }
    }

    private boolean isLocalNodeNotInBaseline() {
        BaselineTopology topology = this.cctx.discovery().discoCache().state().baselineTopology();
        return topology != null && !topology.consistentIds().contains(this.cctx.localNode().consistentId());
    }

    private void initTopologies() throws IgniteCheckedException {
        this.cctx.database().checkpointReadLock();
        try {
            if (this.crd != null) {
                for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                    if (grp.isLocal()) continue;
                    grp.topology().beforeExchange(this, !this.centralizedAff && !this.forceAffReassignment, false);
                    this.cctx.exchange().exchangerUpdateHeartbeat();
                }
            }
        }
        finally {
            this.cctx.database().checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTopologies(boolean crd, MvccCoordinator mvccCrd) throws IgniteCheckedException {
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            boolean updateTop;
            if (grp.isLocal()) continue;
            GridClientPartitionTopology clientTop = this.cctx.exchange().clearClientTopology(grp.groupId());
            long updSeq = clientTop == null ? -1L : clientTop.lastUpdateSequence();
            GridDhtPartitionTopology top = grp.topology();
            if (crd && (updateTop = this.exchId.topologyVersion().equals(grp.localStartVersion())) && clientTop != null) {
                this.cctx.exchange().exchangerBlockingSectionBegin();
                try {
                    top.update(null, clientTop.partitionMap(true), clientTop.fullUpdateCounters(), Collections.emptySet(), null, null);
                }
                finally {
                    this.cctx.exchange().exchangerBlockingSectionEnd();
                }
            }
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                top.updateTopologyVersion(this, this.events().discoveryCache(), mvccCrd, updSeq, this.cacheGroupStopping(grp.groupId()));
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            for (GridClientPartitionTopology top : this.cctx.exchange().clientTopologies()) {
                top.updateTopologyVersion(this, this.events().discoveryCache(), mvccCrd, -1L, this.cacheGroupStopping(top.groupId()));
            }
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExchangeType onClusterStateChangeRequest(boolean crd) {
        assert (this.exchActions != null && !this.exchActions.empty()) : this;
        StateChangeRequest req = this.exchActions.stateChangeRequest();
        assert (req != null) : this.exchActions;
        DiscoveryDataClusterState state = this.cctx.kernalContext().state().clusterState();
        if (state.transitionError() != null) {
            this.exchangeLocE = state.transitionError();
        }
        if (req.activeChanged()) {
            if (req.activate()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Start activation process [nodeId=" + this.cctx.localNodeId() + ", client=" + this.cctx.kernalContext().clientNode() + ", topVer=" + this.initialVersion() + "]");
                }
                try {
                    this.cctx.exchange().exchangerBlockingSectionBegin();
                    try {
                        this.cctx.activate();
                    }
                    finally {
                        this.cctx.exchange().exchangerBlockingSectionEnd();
                    }
                    if (!this.cctx.kernalContext().clientNode()) {
                        ArrayList<DynamicCacheDescriptor> startDescs = new ArrayList<DynamicCacheDescriptor>();
                        for (ExchangeActions.CacheActionData startReq : this.exchActions.cacheStartRequests()) {
                            DynamicCacheDescriptor desc = startReq.descriptor();
                            if (!CU.isPersistentCache(desc.cacheConfiguration(), this.cctx.gridConfig().getDataStorageConfiguration())) continue;
                            startDescs.add(desc);
                        }
                        this.cctx.exchange().exchangerBlockingSectionBegin();
                        try {
                            this.cctx.database().readCheckpointAndRestoreMemory(startDescs);
                        }
                        finally {
                            this.cctx.exchange().exchangerBlockingSectionEnd();
                        }
                    }
                    assert (this.registerCachesFuture == null) : "No caches registration should be scheduled before new caches have started.";
                    this.cctx.exchange().exchangerBlockingSectionBegin();
                    try {
                        this.registerCachesFuture = this.cctx.affinity().onCacheChangeRequest(this, crd, this.exchActions);
                    }
                    finally {
                        this.cctx.exchange().exchangerBlockingSectionEnd();
                    }
                    if (!this.log.isInfoEnabled()) return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
                    this.log.info("Successfully activated caches [nodeId=" + this.cctx.localNodeId() + ", client=" + this.cctx.kernalContext().clientNode() + ", topVer=" + this.initialVersion() + "]");
                    return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
                }
                catch (Exception e) {
                    U.error(this.log, "Failed to activate node components [nodeId=" + this.cctx.localNodeId() + ", client=" + this.cctx.kernalContext().clientNode() + ", topVer=" + this.initialVersion() + "]", e);
                    this.exchangeLocE = e;
                    if (!crd) return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
                    this.cctx.exchange().exchangerBlockingSectionBegin();
                    try {
                        Object object = this.mux;
                        synchronized (object) {
                            this.exchangeGlobalExceptions.put(this.cctx.localNodeId(), e);
                            return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
                        }
                    }
                    finally {
                        this.cctx.exchange().exchangerBlockingSectionEnd();
                    }
                }
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Start deactivation process [nodeId=" + this.cctx.localNodeId() + ", client=" + this.cctx.kernalContext().clientNode() + ", topVer=" + this.initialVersion() + "]");
            }
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                this.cctx.kernalContext().dataStructures().onDeActivate(this.cctx.kernalContext());
                this.cctx.kernalContext().service().onDeActivate(this.cctx.kernalContext());
                assert (this.registerCachesFuture == null) : "No caches registration should be scheduled before new caches have started.";
                this.registerCachesFuture = this.cctx.affinity().onCacheChangeRequest(this, crd, this.exchActions);
                this.cctx.kernalContext().encryption().onDeActivate(this.cctx.kernalContext());
                if (!this.log.isInfoEnabled()) return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
                this.log.info("Successfully deactivated data structures, services and caches [nodeId=" + this.cctx.localNodeId() + ", client=" + this.cctx.kernalContext().clientNode() + ", topVer=" + this.initialVersion() + "]");
                return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
            }
            catch (Exception e) {
                U.error(this.log, "Failed to deactivate node components [nodeId=" + this.cctx.localNodeId() + ", client=" + this.cctx.kernalContext().clientNode() + ", topVer=" + this.initialVersion() + "]", e);
                this.exchangeLocE = e;
                return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
        if (!req.activate()) return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            if (!this.forceAffReassignment) {
                assert (this.firstEventCache().minimumNodeVersion().compareToIgnoreTimestamp(FORCE_AFF_REASSIGNMENT_SINCE) < 0) : this.firstEventCache().minimumNodeVersion();
                this.cctx.affinity().onBaselineTopologyChanged(this, crd);
            }
            if (!CU.isPersistenceEnabled(this.cctx.kernalContext().config()) || this.cctx.kernalContext().clientNode()) return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
            this.cctx.kernalContext().state().onBaselineTopologyChanged(req.baselineTopology(), req.prevBaselineTopologyHistoryItem());
            return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
        }
        catch (Exception e) {
            U.error(this.log, "Failed to change baseline topology [nodeId=" + this.cctx.localNodeId() + ", client=" + this.cctx.kernalContext().clientNode() + ", topVer=" + this.initialVersion() + "]", e);
            this.exchangeLocE = e;
            return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
    }

    private ExchangeType onCacheChangeRequest(boolean crd) throws IgniteCheckedException {
        assert (this.exchActions != null && !this.exchActions.empty()) : this;
        assert (!this.exchActions.clientOnlyExchange()) : this.exchActions;
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            assert (this.registerCachesFuture == null) : "No caches registration should be scheduled before new caches have started.";
            this.registerCachesFuture = this.cctx.affinity().onCacheChangeRequest(this, crd, this.exchActions);
        }
        catch (Exception e) {
            if (this.reconnectOnError(e) || !this.isRollbackSupported()) {
                throw e;
            }
            U.error(this.log, "Failed to initialize cache(s) (will try to rollback). " + this.exchId, e);
            this.exchangeLocE = new IgniteCheckedException("Failed to initialize exchange locally [locNodeId=" + this.cctx.localNodeId() + "]", e);
            this.exchangeGlobalExceptions.put(this.cctx.localNodeId(), this.exchangeLocE);
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
        return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
    }

    private ExchangeType onCustomMessageNoAffinityChange(boolean crd) {
        if (!this.forceAffReassignment) {
            this.cctx.affinity().onCustomMessageNoAffinityChange(this, crd, this.exchActions);
        }
        return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
    }

    private ExchangeType onAffinityChangeRequest(boolean crd) throws IgniteCheckedException {
        assert (this.affChangeMsg != null) : this;
        this.cctx.affinity().onChangeAffinityMessage(this, crd, this.affChangeMsg);
        if (this.cctx.kernalContext().clientNode()) {
            return ExchangeType.CLIENT;
        }
        return ExchangeType.ALL;
    }

    private ExchangeType onClientNodeEvent(boolean crd) throws IgniteCheckedException {
        assert (this.firstDiscoEvt.eventNode().isClient()) : this;
        if (this.firstDiscoEvt.type() == 11 || this.firstDiscoEvt.type() == 12) {
            this.onLeft();
            assert (!this.firstDiscoEvt.eventNode().isLocal()) : this.firstDiscoEvt;
        } else assert (this.firstDiscoEvt.type() == 10 || this.firstDiscoEvt.type() == 18) : this.firstDiscoEvt;
        this.cctx.affinity().onClientEvent(this, crd);
        return this.firstDiscoEvt.eventNode().isLocal() ? ExchangeType.CLIENT : ExchangeType.NONE;
    }

    private ExchangeType onServerNodeEvent(boolean crd) throws IgniteCheckedException {
        assert (!this.firstDiscoEvt.eventNode().isClient()) : this;
        if (this.firstDiscoEvt.type() == 11 || this.firstDiscoEvt.type() == 12) {
            this.onLeft();
            this.exchCtx.events().warnNoAffinityNodes(this.cctx);
            this.centralizedAff = this.cctx.affinity().onCentralizedAffinityChange(this, crd);
        } else {
            this.cctx.affinity().onServerJoin(this, crd);
        }
        return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clientOnlyExchange() throws IgniteCheckedException {
        if (this.crd != null) {
            assert (!this.crd.isLocal()) : this.crd;
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                if (!this.centralizedAff) {
                    this.sendLocalPartitions(this.crd);
                }
                this.initDone();
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
            return;
        }
        if (this.centralizedAff) {
            for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                GridAffinityAssignmentCache aff = grp.affinity();
                aff.initialize(this.initialVersion(), aff.idealAssignment());
                this.cctx.exchange().exchangerUpdateHeartbeat();
            }
        } else {
            this.onAllServersLeft();
        }
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            this.onDone(this.initialVersion());
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void distributedExchange() throws IgniteCheckedException {
        boolean restored;
        boolean skipWaitOnLocalJoin;
        assert (this.crd != null);
        assert (!this.cctx.kernalContext().clientNode());
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            if (grp.isLocal()) continue;
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                grp.preloader().onTopologyChanged(this);
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            this.cctx.database().releaseHistoryForPreloading();
            this.partHistReserved = this.cctx.database().reserveHistoryForExchange();
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
        boolean bl = skipWaitOnLocalJoin = this.cctx.exchange().latch().canSkipJoiningNodes(this.initialVersion()) && this.localJoinExchange();
        if (!skipWaitOnLocalJoin) {
            boolean distributed = true;
            if (this.activateCluster()) {
                distributed = false;
            }
            this.waitPartitionRelease(distributed, true);
            if (distributed) {
                this.waitPartitionRelease(false, false);
            }
        } else if (this.log.isInfoEnabled()) {
            this.log.info("Skipped waiting for partitions release future (local node is joining) [topVer=" + this.initialVersion() + "]");
        }
        boolean topChanged = this.firstDiscoEvt.type() != 18 || this.affChangeMsg != null;
        for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
            if (cacheCtx.isLocal() || this.cacheStopping(cacheCtx.cacheId()) || !topChanged) continue;
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                cacheCtx.store().forceFlush();
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            restored = this.cctx.database().beforeExchange(this);
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
        if (!this.exchCtx.mergeExchanges()) {
            for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                if (grp.isLocal() || this.cacheGroupStopping(grp.groupId()) || grp.affinity().lastVersion().topologyVersion() <= 0L) continue;
                this.cctx.exchange().exchangerBlockingSectionBegin();
                try {
                    grp.topology().beforeExchange(this, !this.centralizedAff && !this.forceAffReassignment, false);
                }
                finally {
                    this.cctx.exchange().exchangerBlockingSectionEnd();
                }
            }
        }
        if (restored) {
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                this.cctx.database().onStateRestored();
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
        this.changeWalModeIfNeeded();
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            if (this.crd.isLocal()) {
                if (this.remaining.isEmpty()) {
                    this.onAllReceived(null);
                }
            } else {
                this.sendPartitions(this.crd);
            }
            this.initDone();
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
    }

    private void tryToPerformLocalSnapshotOperation() {
        try {
            long start = U.currentTimeMillis();
            IgniteInternalFuture fut = this.cctx.snapshot().tryStartLocalSnapshotOperation(this.firstDiscoEvt, this.exchId.topologyVersion());
            if (fut != null) {
                fut.get();
                long end = U.currentTimeMillis();
                if (this.log.isInfoEnabled()) {
                    this.log.info("Snapshot initialization completed [topVer=" + this.exchangeId().topologyVersion() + ", time=" + (end - start) + "ms]");
                }
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Error while starting snapshot operation", e);
        }
    }

    private void changeWalModeIfNeeded() {
        WalStateAbstractMessage msg = this.firstWalMessage();
        if (msg != null) {
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                this.cctx.walState().onProposeExchange(msg.exchangeMessage());
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
    }

    @Nullable
    private WalStateAbstractMessage firstWalMessage() {
        DiscoveryCustomMessage customMsg;
        if (this.firstDiscoEvt != null && this.firstDiscoEvt.type() == 18 && (customMsg = ((DiscoveryCustomEvent)this.firstDiscoEvt).customMessage()) instanceof WalStateAbstractMessage) {
            WalStateAbstractMessage msg0 = (WalStateAbstractMessage)customMsg;
            assert (msg0.needExchange());
            return msg0;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitPartitionRelease(boolean distributed, boolean doRollback) throws IgniteCheckedException {
        IgniteInternalFuture<?> partReleaseFut;
        Latch releaseLatch = null;
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            if (distributed) {
                releaseLatch = this.cctx.exchange().latch().getOrCreate(DISTRIBUTED_LATCH_ID, this.initialVersion());
            }
            partReleaseFut = this.cctx.partitionReleaseFuture(this.initialVersion());
            this.partReleaseFut = partReleaseFut;
            if (this.exchId.isLeft()) {
                this.cctx.mvcc().removeExplicitNodeLocks(this.exchId.nodeId(), this.exchId.topologyVersion());
            }
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Before waiting for partition release future: " + this);
        }
        int dumpCnt = 0;
        long nextDumpTime = 0L;
        IgniteConfiguration cfg = this.cctx.gridConfig();
        long waitStart = U.currentTimeMillis();
        long waitTimeout = 2L * cfg.getNetworkTimeout();
        boolean txRolledBack = !doRollback;
        while (true) {
            long curTimeout = cfg.getTransactionConfiguration().getTxTimeoutOnPartitionMapExchange();
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                partReleaseFut.get(curTimeout > 0L && !txRolledBack ? Math.min(curTimeout, waitTimeout) : waitTimeout, TimeUnit.MILLISECONDS);
            }
            catch (IgniteFutureTimeoutCheckedException ignored) {
                if (nextDumpTime <= U.currentTimeMillis()) {
                    this.dumpPendingObjects(partReleaseFut, curTimeout <= 0L && !txRolledBack);
                    nextDumpTime = U.currentTimeMillis() + GridDhtPartitionsExchangeFuture.nextDumpTimeout(dumpCnt++, waitTimeout);
                }
                if (txRolledBack || curTimeout <= 0L || U.currentTimeMillis() - waitStart < curTimeout) continue;
                txRolledBack = true;
                this.cctx.tm().rollbackOnTopologyChange(this.initialVersion());
                continue;
            }
            catch (IgniteCheckedException e) {
                U.warn(this.log, "Unable to await partitions release future", e);
                throw e;
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
                continue;
            }
            break;
        }
        long waitEnd = U.currentTimeMillis();
        if (this.log.isInfoEnabled()) {
            String mode;
            long waitTime = waitEnd - waitStart;
            Iterator<IgniteTxKey> futInfo = RELEASE_FUTURE_DUMP_THRESHOLD > 0 && waitTime > (long)RELEASE_FUTURE_DUMP_THRESHOLD ? partReleaseFut.toString() : "NA";
            String string2 = mode = distributed ? "DISTRIBUTED" : "LOCAL";
            if (this.log.isInfoEnabled()) {
                this.log.info("Finished waiting for partition release future [topVer=" + this.exchangeId().topologyVersion() + ", waitTime=" + (waitEnd - waitStart) + "ms, futInfo=" + (String)((Object)futInfo) + ", mode=" + mode + "]");
            }
        }
        IgniteInternalFuture<?> locksFut = this.cctx.mvcc().finishLocks(this.exchId.topologyVersion());
        nextDumpTime = 0L;
        dumpCnt = 0;
        while (true) {
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                locksFut.get(waitTimeout, TimeUnit.MILLISECONDS);
            }
            catch (IgniteFutureTimeoutCheckedException ignored) {
                if (nextDumpTime > U.currentTimeMillis()) continue;
                U.warn(this.log, "Failed to wait for locks release future. Dumping pending objects that might be the cause: " + this.cctx.localNodeId());
                U.warn(this.log, "Locked keys:");
                for (IgniteTxKey key : this.cctx.mvcc().lockedKeys()) {
                    U.warn(this.log, "Locked key: " + key);
                }
                for (IgniteTxKey key : this.cctx.mvcc().nearLockedKeys()) {
                    U.warn(this.log, "Locked near key: " + key);
                }
                Map<IgniteTxKey, Collection<GridCacheMvccCandidate>> locks = this.cctx.mvcc().unfinishedLocks(this.exchId.topologyVersion());
                for (Map.Entry<IgniteTxKey, Collection<GridCacheMvccCandidate>> e : locks.entrySet()) {
                    U.warn(this.log, "Awaited locked entry [key=" + e.getKey() + ", mvcc=" + e.getValue() + ']');
                }
                nextDumpTime = U.currentTimeMillis() + GridDhtPartitionsExchangeFuture.nextDumpTimeout(dumpCnt++, waitTimeout);
                if (!IgniteSystemProperties.getBoolean("IGNITE_THREAD_DUMP_ON_EXCHANGE_TIMEOUT", false)) continue;
                U.dumpThreads(this.log);
                continue;
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
                continue;
            }
            break;
        }
        if (releaseLatch == null) {
            assert (!distributed) : "Partitions release latch must be initialized in distributed mode.";
            return;
        }
        releaseLatch.countDown();
        if (this.localJoinExchange() && !this.cctx.exchange().latch().canSkipJoiningNodes(this.initialVersion())) {
            return;
        }
        try {
            while (true) {
                try {
                    this.cctx.exchange().exchangerBlockingSectionBegin();
                    try {
                        releaseLatch.await(waitTimeout, TimeUnit.MILLISECONDS);
                    }
                    finally {
                        this.cctx.exchange().exchangerBlockingSectionEnd();
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Finished waiting for partitions release latch: " + releaseLatch);
                    }
                }
                catch (IgniteFutureTimeoutCheckedException ignored) {
                    U.warn(this.log, "Unable to await partitions release latch within timeout: " + releaseLatch);
                    releaseLatch.countDown();
                    continue;
                }
                break;
            }
        }
        catch (IgniteCheckedException e) {
            U.warn(this.log, "Stop waiting for partitions release latch: " + e.getMessage());
        }
    }

    private void onLeft() {
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            if (grp.isLocal()) continue;
            grp.preloader().unwindUndeploys();
            this.cctx.exchange().exchangerUpdateHeartbeat();
        }
        this.cctx.mvcc().removeExplicitNodeLocks(this.exchId.nodeId(), this.exchId.topologyVersion());
    }

    private void dumpPendingObjects(IgniteInternalFuture<?> partReleaseFut, boolean txTimeoutNotifyFlag) {
        U.warn(this.cctx.kernalContext().cluster().diagnosticLog(), "Failed to wait for partition release future [topVer=" + this.initialVersion() + ", node=" + this.cctx.localNodeId() + "]");
        if (txTimeoutNotifyFlag) {
            U.warn(this.cctx.kernalContext().cluster().diagnosticLog(), "Consider changing TransactionConfiguration.txTimeoutOnPartitionMapExchange to non default value to avoid this message.");
        }
        U.warn(this.log, "Partition release future: " + partReleaseFut);
        U.warn(this.cctx.kernalContext().cluster().diagnosticLog(), "Dumping pending objects that might be the cause: ");
        try {
            this.cctx.exchange().dumpDebugInfo(this);
        }
        catch (Exception e) {
            U.error(this.cctx.kernalContext().cluster().diagnosticLog(), "Failed to dump debug information: " + e, e);
        }
    }

    private boolean cacheGroupStopping(int grpId) {
        return this.exchActions != null && this.exchActions.cacheGroupStopping(grpId);
    }

    private boolean cacheStopping(int cacheId) {
        return this.exchActions != null && this.exchActions.cacheStopped(cacheId);
    }

    public boolean localJoinExchange() {
        return this.firstDiscoEvt.type() == 10 && this.firstDiscoEvt.eventNode().isLocal();
    }

    private void sendLocalPartitions(ClusterNode node) throws IgniteCheckedException {
        long time;
        block13: {
            GridDhtPartitionsSingleMessage msg;
            Set<String> caches;
            assert (node != null);
            time = System.currentTimeMillis();
            if (this.exchActions != null && !F.isEmpty(caches = this.exchActions.cachesToResetLostPartitions())) {
                this.resetLostPartitions(caches);
            }
            if (this.cctx.kernalContext().clientNode() || this.dynamicCacheStartExchange() && this.exchangeLocE != null) {
                msg = new GridDhtPartitionsSingleMessage(this.exchangeId(), this.cctx.kernalContext().clientNode(), this.cctx.versions().last(), true);
            } else {
                msg = this.cctx.exchange().createPartitionsSingleMessage(this.exchangeId(), false, true, node.version().compareToIgnoreTimestamp(CachePartitionPartialCountersMap.PARTIAL_COUNTERS_MAP_SINCE) >= 0, this.exchActions);
                Map<Integer, Map<Integer, Long>> partHistReserved0 = this.partHistReserved;
                if (partHistReserved0 != null) {
                    msg.partitionHistoryCounters(partHistReserved0);
                }
            }
            if (this.exchCtx.newMvccCoordinator() && this.cctx.coordinators().currentCoordinatorId().equals(node.id())) {
                Map<UUID, GridLongList> activeQueries = this.exchCtx.activeQueries();
                msg.activeQueries(activeQueries != null ? activeQueries.get(this.cctx.localNodeId()) : null);
            }
            if ((this.stateChangeExchange() || this.dynamicCacheStartExchange()) && this.exchangeLocE != null) {
                msg.setError(this.exchangeLocE);
            } else if (this.localJoinExchange()) {
                msg.cacheGroupsAffinityRequest(this.exchCtx.groupsAffinityRequestOnJoin());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Sending local partitions [nodeId=" + node.id() + ", exchId=" + this.exchId + ", msg=" + msg + ']');
            }
            try {
                this.cctx.io().send(node, (GridCacheMessage)msg, (byte)2);
            }
            catch (ClusterTopologyCheckedException ignored) {
                if (!this.log.isDebugEnabled()) break block13;
                this.log.debug("Node left during partition exchange [nodeId=" + node.id() + ", exchId=" + this.exchId + ']');
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Sending Single Message performed in " + (System.currentTimeMillis() - time) + " ms.");
        }
    }

    private GridDhtPartitionsFullMessage createPartitionsMessage(boolean compress, boolean newCntrMap) {
        GridCacheVersion last2 = this.lastVer.get();
        GridDhtPartitionsFullMessage m = this.cctx.exchange().createPartitionsFullMessage(compress, newCntrMap, this.exchangeId(), last2 != null ? last2 : this.cctx.versions().last(), this.partHistSuppliers, this.partsToReload);
        if (this.stateChangeExchange() && !F.isEmpty(this.exchangeGlobalExceptions)) {
            m.setErrorsMap(this.exchangeGlobalExceptions);
        }
        return m;
    }

    private void sendAllPartitions(GridDhtPartitionsFullMessage fullMsg, Collection<ClusterNode> nodes2, Map<UUID, GridDhtPartitionsSingleMessage> mergedJoinExchMsgs, Map<Integer, CacheGroupAffinityMessage> affinityForJoinedNodes) {
        assert (!nodes2.contains(this.cctx.localNode()));
        if (this.log.isTraceEnabled()) {
            this.log.trace("Sending full partition map [nodeIds=" + F.viewReadOnly(nodes2, F.node2id(), new IgnitePredicate[0]) + ", exchId=" + this.exchId + ", msg=" + fullMsg + ']');
        }
        Optional singleMsgWithAffinityReq = nodes2.stream().flatMap(node -> Optional.ofNullable(this.msgs.get(node.id())).filter(singleMsg -> singleMsg.cacheGroupsAffinityRequest() != null).map(Stream::of).orElse(Stream.empty())).findAny();
        GridDhtPartitionsFullMessage fullMsgWithAffinity = singleMsgWithAffinityReq.filter(singleMessage -> affinityForJoinedNodes != null).map(singleMessage -> fullMsg.copy().joinedNodeAffinity(affinityForJoinedNodes)).orElse(null);
        long time = System.currentTimeMillis();
        nodes2.stream().map(node -> {
            if (fullMsgWithAffinity == null) {
                return new T2<ClusterNode, GridDhtPartitionsFullMessage>((ClusterNode)node, fullMsg);
            }
            return new T2<ClusterNode, GridDhtPartitionsFullMessage>((ClusterNode)node, Optional.ofNullable(this.msgs.get(node.id())).filter(singleMsg -> singleMsg.cacheGroupsAffinityRequest() != null).map(singleMsg -> fullMsgWithAffinity).orElse(fullMsg));
        }).map(nodeAndMsg -> {
            GridDhtPartitionExchangeId sndExchId;
            ClusterNode node = (ClusterNode)nodeAndMsg.get1();
            GridDhtPartitionsFullMessage fullMsgToSend = (GridDhtPartitionsFullMessage)nodeAndMsg.get2();
            GridDhtPartitionExchangeId gridDhtPartitionExchangeId = sndExchId = mergedJoinExchMsgs != null ? Optional.ofNullable(mergedJoinExchMsgs.get(node.id())).map(GridDhtPartitionsAbstractMessage::exchangeId).orElse(this.exchangeId()) : this.exchangeId();
            if (sndExchId != null && !sndExchId.equals(this.exchangeId())) {
                GridDhtPartitionsFullMessage fullMsgWithUpdatedExchangeId = fullMsgToSend.copy();
                fullMsgWithUpdatedExchangeId.exchangeId(sndExchId);
                return new T2<ClusterNode, GridDhtPartitionsFullMessage>(node, fullMsgWithUpdatedExchangeId);
            }
            return new T2<ClusterNode, GridDhtPartitionsFullMessage>(node, fullMsgToSend);
        }).forEach(nodeAndMsg -> {
            ClusterNode node = (ClusterNode)nodeAndMsg.get1();
            GridDhtPartitionsFullMessage fullMsgToSend = (GridDhtPartitionsFullMessage)nodeAndMsg.get2();
            try {
                this.cctx.io().send(node, (GridCacheMessage)fullMsgToSend, (byte)2);
            }
            catch (ClusterTopologyCheckedException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to send partitions, node failed: " + node);
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to send partitions [node=" + node + ']', e);
            }
        });
        if (this.log.isInfoEnabled()) {
            this.log.info("Sending Full Message performed in " + (System.currentTimeMillis() - time) + " ms.");
        }
    }

    private void sendPartitions(ClusterNode oldestNode) {
        try {
            this.sendLocalPartitions(oldestNode);
        }
        catch (ClusterTopologyCheckedException ignore) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Coordinator left during partition exchange [nodeId=" + oldestNode.id() + ", exchId=" + this.exchId + ']');
            }
        }
        catch (IgniteCheckedException e) {
            if (this.reconnectOnError(e)) {
                this.onDone(new IgniteNeedReconnectException(this.cctx.localNode(), (Throwable)e));
            }
            U.error(this.log, "Failed to send local partitions to coordinator [crd=" + oldestNode.id() + ", exchId=" + this.exchId + ']', e);
        }
    }

    public boolean serverNodeDiscoveryEvent() {
        assert (this.exchCtx != null);
        return this.exchCtx.events().hasServerJoin() || this.exchCtx.events().hasServerLeft();
    }

    @Override
    public boolean exchangeDone() {
        return this.done.get();
    }

    public void finishMerged() {
        super.onDone(null, null);
    }

    @Override
    public boolean onDone(@Nullable AffinityTopologyVersion res, @Nullable Throwable err2) {
        assert (res != null || err2 != null) : "TopVer=" + res + ", err=" + err2;
        if (this.isDone() || !this.done.compareAndSet(false, true)) {
            return false;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Finish exchange future [startVer=" + this.initialVersion() + ", resVer=" + res + ", err=" + err2 + ']');
        }
        assert (res != null || err2 != null);
        this.waitUntilNewCachesAreRegistered();
        if (err2 == null && !this.cctx.kernalContext().clientNode() && (this.serverNodeDiscoveryEvent() || this.affChangeMsg != null)) {
            for (GridCacheContext gridCacheContext : this.cctx.cacheContexts()) {
                if (!gridCacheContext.affinityNode() || gridCacheContext.isLocal()) continue;
                gridCacheContext.continuousQueries().flushBackupQueue(res);
            }
        }
        if (err2 == null) {
            if (this.centralizedAff || this.forceAffReassignment) {
                assert (!this.exchCtx.mergeExchanges());
                for (CacheGroupContext cacheGroupContext : this.cctx.cache().cacheGroups()) {
                    if (cacheGroupContext.isLocal()) continue;
                    boolean needRefresh = false;
                    try {
                        needRefresh = cacheGroupContext.topology().initPartitionsWhenAffinityReady(res, this);
                    }
                    catch (IgniteInterruptedCheckedException e) {
                        U.error(this.log, "Failed to initialize partitions.", e);
                    }
                    if (!needRefresh) continue;
                    this.cctx.exchange().refreshPartitions();
                }
            }
            for (GridCacheContext gridCacheContext : this.cctx.cacheContexts()) {
                GridCacheContext drCacheCtx = gridCacheContext.isNear() ? gridCacheContext.near().dht().context() : gridCacheContext;
                if (!drCacheCtx.isDrEnabled()) continue;
                try {
                    drCacheCtx.dr().onExchange(res, this.exchId.isLeft());
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to notify DR: " + e, e);
                }
            }
            if (this.serverNodeDiscoveryEvent()) {
                this.detectLostPartitions(res);
            }
            HashMap<Integer, GridDhtTopologyFutureAdapter.CacheValidation> m = U.newHashMap(this.cctx.cache().cacheGroups().size());
            for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                m.put(grp.groupId(), this.validateCacheGroup(grp, this.events().lastEvent().topologyNodes()));
            }
            this.grpValidRes = m;
        }
        if (!this.cctx.localNode().isClient()) {
            this.tryToPerformLocalSnapshotOperation();
        }
        if (err2 == null) {
            this.cctx.coordinators().onExchangeDone(this.exchCtx.newMvccCoordinator(), this.exchCtx.events().discoveryCache(), this.exchCtx.activeQueries());
        }
        this.cctx.cache().onExchangeDone(this.initialVersion(), this.exchActions, err2);
        this.cctx.kernalContext().authentication().onActivate();
        Map<T2<Integer, Integer>, Long> localReserved = this.partHistSuppliers.getReservations(this.cctx.localNodeId());
        if (localReserved != null) {
            for (Map.Entry<T2<Integer, Integer>, Long> e : localReserved.entrySet()) {
                boolean success2 = this.cctx.database().reserveHistoryForPreloading((Integer)e.getKey().get1(), (Integer)e.getKey().get2(), e.getValue());
                if (success2) continue;
                err2 = new IgniteCheckedException("Could not reserve history");
            }
        }
        this.cctx.database().releaseHistoryForExchange();
        this.cctx.database().rebuildIndexesIfNeeded(this);
        if (err2 == null) {
            for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                if (grp.isLocal()) continue;
                grp.topology().onExchangeDone(this, grp.affinity().readyAffinity(res), false);
            }
            this.cctx.walState().changeLocalStatesOnExchangeDone(res);
        }
        Throwable throwable2 = err2;
        this.listen(f2 -> {
            this.cctx.exchange().lastFinishedFuture(this);
            this.cctx.exchange().onExchangeDone(res, this.initialVersion(), err0);
            this.cctx.cache().completeProxyRestart(this.resolveCacheRequests(this.exchActions), this.initialVersion(), res);
            if (this.exchActions != null && err0 == null) {
                this.exchActions.completeRequestFutures(this.cctx, null);
            }
            if (this.stateChangeExchange() && err0 == null) {
                this.cctx.kernalContext().state().onStateChangeExchangeDone(this.exchActions.stateChangeRequest());
            }
        });
        if (super.onDone(res, err2)) {
            this.afterLsnrCompleteFut.onDone();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Completed partition exchange [localNode=" + this.cctx.localNodeId() + ", exchange= " + this + ", durationFromInit=" + (U.currentTimeMillis() - this.initTs) + ']');
            } else if (this.log.isInfoEnabled()) {
                this.log.info("Completed partition exchange [localNode=" + this.cctx.localNodeId() + ", exchange=" + this.shortInfo() + ", topVer=" + this.topologyVersion() + ", durationFromInit=" + (U.currentTimeMillis() - this.initTs) + ']');
            }
            this.initFut.onDone(err2 == null);
            if (this.exchCtx != null && this.exchCtx.events().hasServerLeft()) {
                ExchangeDiscoveryEvents evts = this.exchCtx.events();
                for (DiscoveryEvent evt : evts.events()) {
                    if (!ExchangeDiscoveryEvents.serverLeftEvent(evt)) continue;
                    for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                        grp.affinityFunction().removeNode(evt.eventNode().id());
                    }
                }
            }
            this.exchActions = null;
            if (this.firstDiscoEvt instanceof DiscoveryCustomEvent) {
                ((DiscoveryCustomEvent)this.firstDiscoEvt).customMessage(null);
            }
            if (err2 == null && this.exchCtx != null && (this.exchCtx.events().hasServerLeft() || this.exchCtx.events().hasServerJoin())) {
                ExchangeDiscoveryEvents evts = this.exchCtx.events();
                for (DiscoveryEvent evt : evts.events()) {
                    if (!ExchangeDiscoveryEvents.serverLeftEvent(evt) && !ExchangeDiscoveryEvents.serverJoinEvent(evt)) continue;
                    this.logExchange(evt);
                }
            }
            return true;
        }
        return false;
    }

    private Map<String, DynamicCacheChangeRequest> resolveCacheRequests(ExchangeActions exchangeActions) {
        if (exchangeActions == null) {
            return Collections.emptyMap();
        }
        return exchangeActions.cacheStartRequests().stream().map(ExchangeActions.CacheActionData::request).collect(Collectors.toMap(DynamicCacheChangeRequest::cacheName, r -> r));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilNewCachesAreRegistered() {
        block8: {
            try {
                IgniteInternalFuture<?> registerCachesFut = this.registerCachesFuture;
                if (registerCachesFut == null || registerCachesFut.isDone()) break block8;
                int timeout = Math.max(1000, (int)(this.cctx.kernalContext().config().getFailureDetectionTimeout() / 2L));
                while (true) {
                    this.cctx.exchange().exchangerBlockingSectionBegin();
                    try {
                        registerCachesFut.get(timeout, TimeUnit.SECONDS);
                    }
                    catch (IgniteFutureTimeoutCheckedException te) {
                        List cacheNames = this.exchActions.cacheStartRequests().stream().map(req -> req.descriptor().cacheName()).collect(Collectors.toList());
                        U.warn(this.log, "Failed to wait for caches configuration registration and saving within timeout. Probably disk is too busy or slow.[caches=" + cacheNames + "]");
                        continue;
                    }
                    finally {
                        this.cctx.exchange().exchangerBlockingSectionEnd();
                        continue;
                    }
                    break;
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to wait for caches registration and saving", e);
            }
        }
    }

    private void logExchange(DiscoveryEvent evt) {
        if (this.cctx.kernalContext().state().publicApiActiveState(false) && this.cctx.wal() != null && this.cctx.wal().serializerVersion() > 1) {
            try {
                Short constId;
                ExchangeRecord.Type type = null;
                if (evt.type() == 10) {
                    type = ExchangeRecord.Type.JOIN;
                } else if (evt.type() == 11 || evt.type() == 12) {
                    type = ExchangeRecord.Type.LEFT;
                }
                BaselineTopology blt = this.cctx.kernalContext().state().clusterState().baselineTopology();
                if (type != null && blt != null && (constId = blt.consistentIdMapping().get(evt.eventNode().consistentId())) != null) {
                    this.cctx.wal().log(new ExchangeRecord(constId, type));
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Fail during log exchange record.", e);
            }
        }
    }

    public void cleanUp() {
        this.pendingSingleMsgs.clear();
        this.fullMsgs.clear();
        this.msgs.clear();
        this.crd = null;
        this.partReleaseFut = null;
        this.exchActions = null;
        this.mergedJoinExchMsgs = null;
        this.pendingJoinMsg = null;
        this.exchCtx = null;
        this.newCrdFut = null;
        this.exchangeLocE = null;
        this.exchangeGlobalExceptions.clear();
        if (this.finishState != null) {
            this.finishState.cleanUp();
        }
    }

    private void updateLastVersion(GridCacheVersion ver) {
        GridCacheVersion old;
        assert (ver != null);
        while (!((old = this.lastVer.get()) != null && Long.compare(old.order(), ver.order()) >= 0 || this.lastVer.compareAndSet(old, ver))) {
        }
    }

    private boolean addMergedJoinExchange(ClusterNode node, @Nullable GridDhtPartitionsSingleMessage msg) {
        assert (Thread.holdsLock(this.mux));
        assert (node != null);
        assert (this.state == ExchangeLocalState.CRD) : this.state;
        if (msg == null && this.newCrdFut != null) {
            msg = this.newCrdFut.joinExchangeMessage(node.id());
        }
        UUID nodeId = node.id();
        boolean wait = false;
        if (node.isClient()) {
            if (msg != null) {
                this.waitAndReplyToNode(nodeId, msg);
            }
        } else {
            if (this.mergedJoinExchMsgs == null) {
                this.mergedJoinExchMsgs = new LinkedHashMap<UUID, GridDhtPartitionsSingleMessage>();
            }
            if (msg != null) {
                assert (msg.exchangeId().topologyVersion().equals(new AffinityTopologyVersion(node.order())));
                if (this.log.isInfoEnabled()) {
                    this.log.info("Merge server join exchange, message received [curFut=" + this.initialVersion() + ", node=" + nodeId + ']');
                }
                this.mergedJoinExchMsgs.put(nodeId, msg);
            } else if (this.cctx.discovery().alive(nodeId)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Merge server join exchange, wait for message [curFut=" + this.initialVersion() + ", node=" + nodeId + ']');
                }
                wait = true;
                this.mergedJoinExchMsgs.put(nodeId, null);
                ++this.awaitMergedMsgs;
            } else if (this.log.isInfoEnabled()) {
                this.log.info("Merge server join exchange, awaited node left [curFut=" + this.initialVersion() + ", node=" + nodeId + ']');
            }
        }
        return wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mergeJoinExchange(GridDhtPartitionsExchangeFuture fut) {
        boolean wait;
        Object object = this.mux;
        synchronized (object) {
            assert (!this.isDone() && !this.initFut.isDone() || this.cctx.kernalContext().isStopping()) : this;
            assert (this.mergedWith == null && this.state == null || this.cctx.kernalContext().isStopping()) : this;
            this.state = ExchangeLocalState.MERGED;
            this.mergedWith = fut;
            ClusterNode joinedNode = this.firstDiscoEvt.eventNode();
            wait = fut.addMergedJoinExchange(joinedNode, this.pendingJoinMsg);
        }
        return wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridDhtPartitionsSingleMessage mergeJoinExchangeOnDone(GridDhtPartitionsExchangeFuture fut) {
        Object object = this.mux;
        synchronized (object) {
            assert (!this.isDone());
            assert (!this.initFut.isDone());
            assert (this.mergedWith == null);
            assert (this.state == null);
            this.state = ExchangeLocalState.MERGED;
            this.mergedWith = fut;
            return this.pendingJoinMsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMergedMessage(ClusterNode node, GridDhtPartitionsSingleMessage msg) {
        if (msg.client()) {
            this.waitAndReplyToNode(node.id(), msg);
            return;
        }
        boolean done = false;
        FinishState finishState0 = null;
        Object object = this.mux;
        synchronized (object) {
            if (this.state == ExchangeLocalState.DONE) {
                assert (this.finishState != null);
                finishState0 = this.finishState;
            } else {
                boolean process2;
                boolean bl = process2 = this.mergedJoinExchMsgs != null && this.mergedJoinExchMsgs.containsKey(node.id()) && this.mergedJoinExchMsgs.get(node.id()) == null;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Merge server join exchange, received message [curFut=" + this.initialVersion() + ", node=" + node.id() + ", msgVer=" + msg.exchangeId().topologyVersion() + ", process=" + process2 + ", awaited=" + this.awaitMergedMsgs + ']');
                }
                if (process2) {
                    this.mergedJoinExchMsgs.put(node.id(), msg);
                    assert (this.awaitMergedMsgs > 0) : this.awaitMergedMsgs;
                    --this.awaitMergedMsgs;
                    done = this.awaitMergedMsgs == 0;
                }
            }
        }
        if (finishState0 != null) {
            this.sendAllPartitionsToNode(finishState0, msg, node.id());
            return;
        }
        if (done) {
            this.finishExchangeOnCoordinator(null);
        }
    }

    public void forceClientReconnect(ClusterNode node, GridDhtPartitionsSingleMessage msg) {
        IgniteNeedReconnectException reconnectException = new IgniteNeedReconnectException(node, null);
        this.exchangeGlobalExceptions.put(node.id(), reconnectException);
        this.onDone(null, (Throwable)reconnectException);
        GridDhtPartitionsFullMessage fullMsg = this.createPartitionsMessage(true, false);
        fullMsg.setErrorsMap(this.exchangeGlobalExceptions);
        try {
            this.cctx.io().send(node, (GridCacheMessage)fullMsg, (byte)2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Full message for reconnect client was sent to node: " + node + ", fullMsg: " + fullMsg);
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send reconnect client message [node=" + node + ']', e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceiveSingleMessage(final ClusterNode node, final GridDhtPartitionsSingleMessage msg) {
        assert (!node.isDaemon()) : node;
        assert (msg != null);
        assert (this.exchId.equals(msg.exchangeId())) : msg;
        assert (!this.cctx.kernalContext().clientNode());
        if (msg.restoreState()) {
            InitNewCoordinatorFuture newCrdFut0;
            Object object = this.mux;
            synchronized (object) {
                assert (this.newCrdFut != null);
                newCrdFut0 = this.newCrdFut;
            }
            newCrdFut0.onMessage(node, msg);
            return;
        }
        if (!msg.client()) {
            assert (msg.lastVersion() != null) : msg;
            this.updateLastVersion(msg.lastVersion());
        }
        GridDhtPartitionsExchangeFuture mergedWith0 = null;
        Object object = this.mux;
        synchronized (object) {
            if (this.state == ExchangeLocalState.MERGED) {
                assert (this.mergedWith != null);
                mergedWith0 = this.mergedWith;
            } else {
                assert (this.state != ExchangeLocalState.CLIENT);
                if (this.exchangeId().isJoined() && node.id().equals(this.exchId.nodeId())) {
                    this.pendingJoinMsg = msg;
                }
            }
        }
        if (mergedWith0 != null) {
            mergedWith0.processMergedMessage(node, msg);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Merged message processed, message handling finished: " + msg);
            }
            return;
        }
        this.initFut.listen((IgniteInClosure<IgniteInternalFuture<Boolean>>)new CI1<IgniteInternalFuture<Boolean>>(){

            @Override
            public void apply(IgniteInternalFuture<Boolean> f2) {
                try {
                    if (!f2.get().booleanValue()) {
                        return;
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(GridDhtPartitionsExchangeFuture.this.log, "Failed to initialize exchange future: " + this, e);
                    return;
                }
                GridDhtPartitionsExchangeFuture.this.processSingleMessage(node.id(), msg);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fastReplyOnSingleMessage(ClusterNode node, GridDhtPartitionsSingleMessage msg) {
        ExchangeLocalState currState;
        GridDhtPartitionsExchangeFuture futToFastReply = this;
        Object object = this.mux;
        synchronized (object) {
            currState = this.state;
            if (currState == ExchangeLocalState.MERGED) {
                futToFastReply = this.mergedWith;
            }
        }
        if (currState == ExchangeLocalState.DONE) {
            futToFastReply.processSingleMessage(node.id(), msg);
        } else if (currState == ExchangeLocalState.MERGED) {
            futToFastReply.processMergedMessage(node, msg);
        }
        return currState == ExchangeLocalState.MERGED || currState == ExchangeLocalState.DONE;
    }

    public void waitAndReplyToNode(final UUID nodeId, final GridDhtPartitionsSingleMessage msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Single message will be handled on completion of exchange future: " + this);
        }
        this.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                FinishState finishState0;
                if (GridDhtPartitionsExchangeFuture.this.cctx.kernalContext().isStopping()) {
                    return;
                }
                if (GridDhtPartitionsExchangeFuture.this.cacheChangeFailureMsgSent) {
                    return;
                }
                Object object = GridDhtPartitionsExchangeFuture.this.mux;
                synchronized (object) {
                    finishState0 = GridDhtPartitionsExchangeFuture.this.finishState;
                }
                if (finishState0 == null) {
                    assert (GridDhtPartitionsExchangeFuture.this.firstDiscoEvt.type() == 10 && GridDhtPartitionsExchangeFuture.this.firstDiscoEvt.eventNode().isClient()) : this;
                    ClusterNode node = GridDhtPartitionsExchangeFuture.this.cctx.node(nodeId);
                    if (node == null) {
                        if (GridDhtPartitionsExchangeFuture.this.log.isDebugEnabled()) {
                            GridDhtPartitionsExchangeFuture.this.log.debug("No node found for nodeId: " + nodeId + ", handling of single message will be stopped: " + msg);
                        }
                        return;
                    }
                    finishState0 = new FinishState(GridDhtPartitionsExchangeFuture.this.cctx.localNodeId(), GridDhtPartitionsExchangeFuture.this.initialVersion(), GridDhtPartitionsExchangeFuture.this.createPartitionsMessage(true, node.version().compareToIgnoreTimestamp(CachePartitionPartialCountersMap.PARTIAL_COUNTERS_MAP_SINCE) >= 0));
                }
                GridDhtPartitionsExchangeFuture.this.sendAllPartitionsToNode(finishState0, msg, nodeId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSingleMessage(UUID nodeId, GridDhtPartitionsSingleMessage msg) {
        if (msg.client()) {
            if (msg.activeQueries() != null) {
                this.cctx.coordinators().processClientActiveQueries(nodeId, msg.activeQueries());
            }
            this.waitAndReplyToNode(nodeId, msg);
            return;
        }
        boolean allReceived = false;
        boolean updateSingleMap = false;
        FinishState finishState0 = null;
        Object object = this.mux;
        synchronized (object) {
            assert (this.crd != null);
            switch (this.state) {
                case DONE: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Received single message, already done [ver=" + this.initialVersion() + ", node=" + nodeId + ']');
                    }
                    assert (this.finishState != null);
                    finishState0 = this.finishState;
                    break;
                }
                case CRD: {
                    assert (this.crd.isLocal()) : this.crd;
                    if (this.remaining.remove(nodeId)) {
                        updateSingleMap = true;
                        ++this.pendingSingleUpdates;
                        if ((this.stateChangeExchange() || this.dynamicCacheStartExchange()) && msg.getError() != null) {
                            this.exchangeGlobalExceptions.put(nodeId, msg.getError());
                        }
                        allReceived = this.remaining.isEmpty();
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info("Coordinator received single message [ver=" + this.initialVersion() + ", node=" + nodeId + ", allReceived=" + allReceived + ']');
                        break;
                    }
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Coordinator received single message it didn't expect to receive: " + msg);
                    break;
                }
                case SRV: 
                case BECOME_CRD: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Non-coordinator received single message [ver=" + this.initialVersion() + ", node=" + nodeId + ", state=" + (Object)((Object)this.state) + ']');
                    }
                    this.pendingSingleMsgs.put(nodeId, msg);
                    break;
                }
                default: {
                    assert (false) : this.state;
                    break;
                }
            }
        }
        if (finishState0 != null) {
            if (!this.cacheChangeFailureMsgSent) {
                this.sendAllPartitionsToNode(finishState0, msg, nodeId);
            }
            return;
        }
        if (updateSingleMap) {
            try {
                if (!this.deactivateCluster()) {
                    this.updatePartitionSingleMap(nodeId, msg);
                }
            }
            finally {
                object = this.mux;
                synchronized (object) {
                    assert (this.pendingSingleUpdates > 0);
                    --this.pendingSingleUpdates;
                    if (this.pendingSingleUpdates == 0) {
                        this.mux.notifyAll();
                    }
                }
            }
        }
        if (allReceived) {
            if (!this.awaitSingleMapUpdates()) {
                return;
            }
            this.onAllReceived(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean awaitSingleMapUpdates() {
        try {
            Object object = this.mux;
            synchronized (object) {
                while (this.pendingSingleUpdates > 0) {
                    U.wait(this.mux);
                }
            }
            return true;
        }
        catch (IgniteInterruptedCheckedException e) {
            U.warn(this.log, "Failed to wait for partition map updates, thread was interrupted: " + e);
            return false;
        }
    }

    private void onAffinityInitialized(IgniteInternalFuture<Map<Integer, Map<Integer, List<UUID>>>> fut) {
        try {
            assert (fut.isDone());
            Map<Integer, Map<Integer, List<UUID>>> assignmentChange = fut.get();
            GridDhtPartitionsFullMessage m = this.createPartitionsMessage(false, false);
            CacheAffinityChangeMessage msg = new CacheAffinityChangeMessage(this.exchId, m, assignmentChange);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Centralized affinity exchange, send affinity change message: " + msg);
            }
            this.cctx.discovery().sendCustomEvent(msg);
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
        }
    }

    private void assignPartitionSizes(GridDhtPartitionTopology top) {
        HashMap<Integer, Long> partSizes = new HashMap<Integer, Long>();
        for (Map.Entry e : this.msgs.entrySet()) {
            GridDhtPartitionsSingleMessage singleMsg = (GridDhtPartitionsSingleMessage)e.getValue();
            GridDhtPartitionMap partMap = singleMsg.partitions().get(top.groupId());
            if (partMap == null) continue;
            for (Map.Entry<Integer, GridDhtPartitionState> e0 : partMap.entrySet()) {
                int p = e0.getKey();
                GridDhtPartitionState state = e0.getValue();
                if (state != GridDhtPartitionState.OWNING) continue;
                partSizes.put(p, singleMsg.partitionSizes(top.groupId()).get(p));
            }
        }
        for (GridDhtLocalPartition locPart : top.currentLocalPartitions()) {
            if (locPart.state() != GridDhtPartitionState.OWNING) continue;
            partSizes.put(locPart.id(), locPart.fullSize());
        }
        top.globalPartSizes(partSizes);
    }

    private void assignPartitionStates(GridDhtPartitionTopology top) {
        HashMap<Integer, CounterWithNodes> maxCntrs = new HashMap<Integer, CounterWithNodes>();
        HashMap<Integer, Long> minCntrs = new HashMap<Integer, Long>();
        for (Map.Entry e : this.msgs.entrySet()) {
            CachePartitionPartialCountersMap nodeCntrs = ((GridDhtPartitionsSingleMessage)e.getValue()).partitionUpdateCounters(top.groupId(), top.partitions());
            assert (nodeCntrs != null);
            for (int i = 0; i < nodeCntrs.size(); ++i) {
                int p = nodeCntrs.partitionAt(i);
                UUID uuid = (UUID)e.getKey();
                GridDhtPartitionState state = top.partitionState(uuid, p);
                if (state != GridDhtPartitionState.OWNING && state != GridDhtPartitionState.MOVING) continue;
                long cntr = state == GridDhtPartitionState.MOVING ? nodeCntrs.initialUpdateCounterAt(i) : nodeCntrs.updateCounterAt(i);
                Long minCntr = (Long)minCntrs.get(p);
                if (minCntr == null || minCntr > cntr) {
                    minCntrs.put(p, cntr);
                }
                if (state != GridDhtPartitionState.OWNING) continue;
                CounterWithNodes maxCntr = (CounterWithNodes)maxCntrs.get(p);
                if (maxCntr == null || cntr > maxCntr.cnt) {
                    maxCntrs.put(p, new CounterWithNodes(cntr, ((GridDhtPartitionsSingleMessage)e.getValue()).partitionSizes(top.groupId()).get(p), uuid));
                    continue;
                }
                if (cntr != maxCntr.cnt) continue;
                maxCntr.nodes.add(uuid);
            }
        }
        for (GridDhtLocalPartition part : top.currentLocalPartitions()) {
            GridDhtPartitionState state = top.partitionState(this.cctx.localNodeId(), part.id());
            if (state != GridDhtPartitionState.OWNING && state != GridDhtPartitionState.MOVING) continue;
            long cntr = state == GridDhtPartitionState.MOVING ? part.initialUpdateCounter() : part.updateCounter();
            Long minCntr = (Long)minCntrs.get(part.id());
            if (minCntr == null || minCntr > cntr) {
                minCntrs.put(part.id(), cntr);
            }
            if (state != GridDhtPartitionState.OWNING) continue;
            CounterWithNodes maxCntr = (CounterWithNodes)maxCntrs.get(part.id());
            if (maxCntr == null && cntr == 0L) {
                CounterWithNodes cntrObj = new CounterWithNodes(0L, 0L, this.cctx.localNodeId());
                for (UUID nodeId : this.msgs.keySet()) {
                    if (top.partitionState(nodeId, part.id()) != GridDhtPartitionState.OWNING) continue;
                    cntrObj.nodes.add(nodeId);
                }
                maxCntrs.put(part.id(), cntrObj);
                continue;
            }
            if (maxCntr == null || cntr > maxCntr.cnt) {
                maxCntrs.put(part.id(), new CounterWithNodes(cntr, part.fullSize(), this.cctx.localNodeId()));
                continue;
            }
            if (cntr != maxCntr.cnt) continue;
            maxCntr.nodes.add(this.cctx.localNodeId());
        }
        Map<Integer, Map<Integer, Long>> partHistReserved0 = this.partHistReserved;
        Map<Integer, Long> localReserved = partHistReserved0 != null ? partHistReserved0.get(top.groupId()) : null;
        HashSet<Integer> haveHistory = new HashSet<Integer>();
        block4: for (Map.Entry e : minCntrs.entrySet()) {
            Object localCntr;
            long maxCntr;
            int p = (Integer)e.getKey();
            long minCntr = (Long)e.getValue();
            CounterWithNodes maxCntrObj = (CounterWithNodes)maxCntrs.get(p);
            long l = maxCntr = maxCntrObj != null ? maxCntrObj.cnt : 0L;
            if (minCntr == 0L || minCntr == maxCntr) continue;
            if (localReserved != null && (localCntr = localReserved.get(p)) != null && (Long)localCntr <= minCntr && maxCntrObj.nodes.contains(this.cctx.localNodeId())) {
                this.partHistSuppliers.put(this.cctx.localNodeId(), top.groupId(), p, (Long)localCntr);
                haveHistory.add(p);
                continue;
            }
            localCntr = this.msgs.entrySet().iterator();
            while (localCntr.hasNext()) {
                Map.Entry e0 = (Map.Entry)localCntr.next();
                Long histCntr = ((GridDhtPartitionsSingleMessage)e0.getValue()).partitionHistoryCounters(top.groupId()).get(p);
                if (histCntr == null || histCntr > minCntr || !maxCntrObj.nodes.contains(e0.getKey())) continue;
                this.partHistSuppliers.put((UUID)e0.getKey(), top.groupId(), p, histCntr);
                haveHistory.add(p);
                continue block4;
            }
        }
        HashMap<Integer, Set<UUID>> ownersByUpdCounters = new HashMap<Integer, Set<UUID>>(maxCntrs.size());
        for (Map.Entry e : maxCntrs.entrySet()) {
            ownersByUpdCounters.put((Integer)e.getKey(), ((CounterWithNodes)e.getValue()).nodes);
        }
        HashMap<Integer, Long> partSizes = new HashMap<Integer, Long>(maxCntrs.size());
        for (Map.Entry e : maxCntrs.entrySet()) {
            partSizes.put((Integer)e.getKey(), ((CounterWithNodes)e.getValue()).size);
        }
        top.globalPartSizes(partSizes);
        Map<UUID, Set<Integer>> partitionsToRebalance = top.resetOwners(ownersByUpdCounters, haveHistory);
        for (Map.Entry<UUID, Set<Integer>> e : partitionsToRebalance.entrySet()) {
            UUID nodeId = e.getKey();
            Set<Integer> parts = e.getValue();
            for (int part : parts) {
                this.partsToReload.put(nodeId, top.groupId(), part);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectLostPartitions(AffinityTopologyVersion resTopVer) {
        boolean detected = false;
        long time = System.currentTimeMillis();
        Object object = this.cctx.exchange().interruptLock();
        synchronized (object) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                if (grp.isLocal()) continue;
                boolean detectedOnGrp = grp.topology().detectLostPartitions(resTopVer, this.events().lastEvent());
                detected |= detectedOnGrp;
            }
        }
        if (detected) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partitions have been scheduled to resend [reason=Lost partitions detect on " + resTopVer + "]");
            }
            this.cctx.exchange().scheduleResendPartitions();
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Detecting lost partitions performed in " + (System.currentTimeMillis() - time) + " ms.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLostPartitions(Collection<String> cacheNames) {
        assert (!this.exchCtx.mergeExchanges());
        Object object = this.cctx.exchange().interruptLock();
        synchronized (object) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            block3: for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                if (grp.isLocal()) continue;
                for (String cacheName : cacheNames) {
                    if (!grp.hasCache(cacheName)) continue;
                    grp.topology().resetLostPartitions(this.initialVersion());
                    continue block3;
                }
            }
        }
    }

    private IgniteCheckedException createExchangeException(Map<UUID, Exception> globalExceptions) {
        IgniteCheckedException ex = new IgniteCheckedException("Failed to complete exchange process.");
        for (Map.Entry<UUID, Exception> entry2 : globalExceptions.entrySet()) {
            if (ex == entry2.getValue()) continue;
            ex.addSuppressed(entry2.getValue());
        }
        return ex;
    }

    private boolean isRollbackSupported() {
        if (!this.firstEvtDiscoCache.checkAttribute("org.apache.ignite.dynamic.cache.start.rollback.supported", Boolean.TRUE)) {
            return false;
        }
        return this.firstDiscoEvt.type() == 18 && this.dynamicCacheStartExchange();
    }

    private void sendExchangeFailureMessage() {
        assert (this.crd != null && this.crd.isLocal());
        try {
            IgniteCheckedException err2 = this.createExchangeException(this.exchangeGlobalExceptions);
            ArrayList<String> cacheNames = new ArrayList<String>(this.exchActions.cacheStartRequests().size());
            for (ExchangeActions.CacheActionData actionData : this.exchActions.cacheStartRequests()) {
                cacheNames.add(actionData.request().cacheName());
            }
            DynamicCacheChangeFailureMessage msg = new DynamicCacheChangeFailureMessage(this.cctx.localNode(), this.exchId, err2, cacheNames);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dynamic cache change failed (send message to all participating nodes): " + msg);
            }
            this.cacheChangeFailureMsgSent = true;
            this.cctx.discovery().sendCustomEvent(msg);
            return;
        }
        catch (IgniteCheckedException e) {
            if (this.reconnectOnError(e)) {
                this.onDone(new IgniteNeedReconnectException(this.cctx.localNode(), (Throwable)e));
            } else {
                this.onDone(e);
            }
            return;
        }
    }

    private void onAllReceived(@Nullable Collection<ClusterNode> sndResNodes) {
        try {
            assert (this.crd.isLocal());
            assert (this.partHistSuppliers.isEmpty()) : this.partHistSuppliers;
            if (!this.exchCtx.mergeExchanges() && !this.crd.equals(this.events().discoveryCache().serverNodes().get(0))) {
                for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                    if (grp.isLocal()) continue;
                    if (grp.affinity().lastVersion().topologyVersion() > 0L) {
                        grp.topology().beforeExchange(this, !this.centralizedAff && !this.forceAffReassignment, false);
                        continue;
                    }
                    assert (this.exchangeLocE != null) : "Affinity is not calculated for the cache group [groupName=" + grp.name() + "]";
                }
            }
            if (this.exchCtx.mergeExchanges()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Coordinator received all messages, try merge [ver=" + this.initialVersion() + ']');
                }
                long time = System.currentTimeMillis();
                boolean finish2 = this.cctx.exchange().mergeExchangesOnCoordinator(this);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Exchanges merging performed in " + (System.currentTimeMillis() - time) + " ms.");
                }
                if (!finish2) {
                    return;
                }
            }
            this.finishExchangeOnCoordinator(sndResNodes);
        }
        catch (IgniteCheckedException e) {
            if (this.reconnectOnError(e)) {
                this.onDone(new IgniteNeedReconnectException(this.cctx.localNode(), (Throwable)e));
            }
            this.onDone(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void finishExchangeOnCoordinator(@Nullable Collection<ClusterNode> sndResNodes) {
        if (this.isDone() || !this.enterBusy()) {
            return;
        }
        try {
            Object msg;
            if (!F.isEmpty(this.exchangeGlobalExceptions) && this.dynamicCacheStartExchange() && this.isRollbackSupported()) {
                this.sendExchangeFailureMessage();
                return;
            }
            AffinityTopologyVersion resTopVer = this.exchCtx.events().topologyVersion();
            if (this.log.isInfoEnabled()) {
                this.log.info("finishExchangeOnCoordinator [topVer=" + this.initialVersion() + ", resVer=" + resTopVer + ']');
            }
            Map<Integer, CacheGroupAffinityMessage> idealAffDiff = null;
            long time = System.currentTimeMillis();
            if (this.exchCtx.mergeExchanges()) {
                Iterator<CacheGroupDescriptor> iterator2 = this.mux;
                synchronized (iterator2) {
                    if (this.mergedJoinExchMsgs != null) {
                        for (Map.Entry<UUID, GridDhtPartitionsSingleMessage> entry2 : this.mergedJoinExchMsgs.entrySet()) {
                            this.msgs.put(entry2.getKey(), entry2.getValue());
                            this.updatePartitionSingleMap(entry2.getKey(), entry2.getValue());
                        }
                    }
                }
                assert (this.exchCtx.events().hasServerJoin() || this.exchCtx.events().hasServerLeft());
                this.exchCtx.events().processEvents(this);
                if (this.exchCtx.events().hasServerLeft()) {
                    idealAffDiff = this.cctx.affinity().onServerLeftWithExchangeMergeProtocol(this);
                } else {
                    this.cctx.affinity().onServerJoinWithExchangeMergeProtocol(this, true);
                }
                for (CacheGroupDescriptor cacheGroupDescriptor : this.cctx.affinity().cacheGroups().values()) {
                    if (cacheGroupDescriptor.config().getCacheMode() == CacheMode.LOCAL) continue;
                    CacheGroupContext cacheGroupContext = this.cctx.cache().cacheGroup(cacheGroupDescriptor.groupId());
                    GridDhtPartitionTopology top = cacheGroupContext != null ? cacheGroupContext.topology() : this.cctx.exchange().clientTopology(cacheGroupDescriptor.groupId(), this.events().discoveryCache());
                    top.beforeExchange(this, true, true);
                }
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Affinity changes (coordinator) applied in " + (System.currentTimeMillis() - time) + " ms.");
            }
            Map<Integer, CacheGroupAffinityMessage> joinedNodeAff = null;
            for (Map.Entry entry3 : this.msgs.entrySet()) {
                msg = (GridDhtPartitionsSingleMessage)entry3.getValue();
                if (this.exchCtx.newMvccCoordinator()) {
                    this.exchCtx.addActiveQueries((UUID)entry3.getKey(), ((GridDhtPartitionsSingleMessage)msg).activeQueries());
                }
                for (Map.Entry<Integer, GridDhtPartitionMap> entry4 : ((GridDhtPartitionsSingleMessage)msg).partitions().entrySet()) {
                    GridDhtPartitionTopology top;
                    Integer grpId = entry4.getKey();
                    CacheGroupContext cacheGroupContext = this.cctx.cache().cacheGroup(grpId);
                    GridDhtPartitionTopology gridDhtPartitionTopology = top = cacheGroupContext != null ? cacheGroupContext.topology() : this.cctx.exchange().clientTopology(grpId, this.events().discoveryCache());
                    CachePartitionPartialCountersMap cntrs = ((GridDhtPartitionsSingleMessage)msg).partitionUpdateCounters(grpId, top.partitions());
                    if (cntrs == null) continue;
                    top.collectUpdateCounters(cntrs);
                }
                Collection<Integer> affReq = ((GridDhtPartitionsSingleMessage)msg).cacheGroupsAffinityRequest();
                if (affReq == null) continue;
                joinedNodeAff = CacheGroupAffinityMessage.createAffinityMessages(this.cctx, resTopVer, affReq, joinedNodeAff);
            }
            this.validatePartitionsState();
            if (this.firstDiscoEvt.type() == 18) {
                DiscoveryCustomMessage discoveryCustomMessage;
                assert (this.firstDiscoEvt instanceof DiscoveryCustomEvent);
                if (this.activateCluster() || this.changedBaseline()) {
                    this.assignPartitionsStates();
                }
                if ((discoveryCustomMessage = ((DiscoveryCustomEvent)this.firstDiscoEvt).customMessage()) instanceof DynamicCacheChangeBatch) {
                    if (this.exchActions != null) {
                        this.assignPartitionsStates();
                        Set<String> set = this.exchActions.cachesToResetLostPartitions();
                        if (!F.isEmpty(set)) {
                            this.resetLostPartitions(set);
                        }
                    }
                } else if (discoveryCustomMessage instanceof SnapshotDiscoveryMessage && ((SnapshotDiscoveryMessage)discoveryCustomMessage).needAssignPartitions()) {
                    this.assignPartitionsStates();
                }
            } else {
                if (this.exchCtx.events().hasServerJoin()) {
                    this.assignPartitionsStates();
                }
                if (this.exchCtx.events().hasServerLeft()) {
                    this.detectLostPartitions(resTopVer);
                }
            }
            if (!this.exchCtx.mergeExchanges() && this.forceAffReassignment) {
                idealAffDiff = this.cctx.affinity().onCustomEventWithEnforcedAffinityReassignment(this);
            }
            for (CacheGroupContext cacheGroupContext : this.cctx.cache().cacheGroups()) {
                if (cacheGroupContext.isLocal()) continue;
                cacheGroupContext.topology().applyUpdateCounters();
            }
            this.updateLastVersion(this.cctx.versions().last());
            this.cctx.versions().onExchange(this.lastVer.get().order());
            IgniteProductVersion igniteProductVersion = this.exchCtx.events().discoveryCache().minimumNodeVersion();
            time = System.currentTimeMillis();
            GridDhtPartitionsFullMessage gridDhtPartitionsFullMessage = this.createPartitionsMessage(true, igniteProductVersion.compareToIgnoreTimestamp(CachePartitionPartialCountersMap.PARTIAL_COUNTERS_MAP_SINCE) >= 0);
            if (this.exchCtx.mergeExchanges()) {
                assert (!this.centralizedAff);
                gridDhtPartitionsFullMessage.resultTopologyVersion(resTopVer);
                if (this.exchCtx.events().hasServerLeft()) {
                    gridDhtPartitionsFullMessage.idealAffinityDiff(idealAffDiff);
                }
            } else if (this.forceAffReassignment) {
                gridDhtPartitionsFullMessage.idealAffinityDiff(idealAffDiff);
            }
            gridDhtPartitionsFullMessage.prepareMarshal(this.cctx);
            if (this.log.isInfoEnabled()) {
                this.log.info("Preparing Full Message performed in " + (System.currentTimeMillis() - time) + " ms.");
            }
            msg = this.mux;
            synchronized (msg) {
                this.finishState = new FinishState(this.crd.id(), resTopVer, gridDhtPartitionsFullMessage);
                this.state = ExchangeLocalState.DONE;
            }
            if (this.centralizedAff) {
                assert (!this.exchCtx.mergeExchanges());
                time = System.currentTimeMillis();
                IgniteInternalFuture<Map<Integer, Map<Integer, List<UUID>>>> fut = this.cctx.affinity().initAffinityOnNodeLeft(this);
                if (!fut.isDone()) {
                    fut.listen(new IgniteInClosure<IgniteInternalFuture<Map<Integer, Map<Integer, List<UUID>>>>>(){

                        @Override
                        public void apply(IgniteInternalFuture<Map<Integer, Map<Integer, List<UUID>>>> fut) {
                            GridDhtPartitionsExchangeFuture.this.onAffinityInitialized(fut);
                        }
                    });
                } else {
                    this.onAffinityInitialized(fut);
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info("Centralized affinity changes are performed in " + (System.currentTimeMillis() - time) + " ms.");
                }
            } else {
                void nodes2;
                Map<UUID, GridDhtPartitionsSingleMessage> mergedJoinExchMsgs0;
                Object object = this.mux;
                synchronized (object) {
                    this.srvNodes.remove(this.cctx.localNode());
                    LinkedHashSet<ClusterNode> nodes22 = new LinkedHashSet<ClusterNode>(this.srvNodes);
                    mergedJoinExchMsgs0 = this.mergedJoinExchMsgs;
                    if (this.mergedJoinExchMsgs != null) {
                        for (Map.Entry entry5 : this.mergedJoinExchMsgs.entrySet()) {
                            ClusterNode node;
                            if (entry5.getValue() == null || (node = this.cctx.discovery().node((UUID)entry5.getKey())) == null) continue;
                            nodes22.add(node);
                        }
                    }
                    if (!F.isEmpty(sndResNodes)) {
                        nodes22.addAll(sndResNodes);
                    }
                }
                time = System.currentTimeMillis();
                if (!nodes2.isEmpty()) {
                    this.sendAllPartitions(gridDhtPartitionsFullMessage, (Collection<ClusterNode>)nodes2, mergedJoinExchMsgs0, joinedNodeAff);
                }
                this.partitionsSent = true;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Sending Full Message to all nodes performed in " + (System.currentTimeMillis() - time) + " ms.");
                }
                if (!this.stateChangeExchange()) {
                    this.onDone(this.exchCtx.events().topologyVersion(), (Throwable)null);
                }
                for (Map.Entry<UUID, GridDhtPartitionsSingleMessage> e : this.pendingSingleMsgs.entrySet()) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Process pending message on coordinator [node=" + e.getKey() + ", ver=" + this.initialVersion() + ", resVer=" + resTopVer + ']');
                    }
                    this.processSingleMessage(e.getKey(), e.getValue());
                }
            }
            if (this.stateChangeExchange()) {
                boolean bl;
                IgniteCheckedException err2 = null;
                StateChangeRequest req = this.exchActions.stateChangeRequest();
                assert (req != null) : this.exchActions;
                boolean bl2 = false;
                if (!F.isEmpty(this.exchangeGlobalExceptions)) {
                    bl = true;
                    err2 = new IgniteCheckedException("Cluster state change failed.");
                    this.cctx.kernalContext().state().onStateChangeError(this.exchangeGlobalExceptions, req);
                } else {
                    boolean hasMoving = !this.partsToReload.isEmpty();
                    Set<Integer> set = this.cctx.affinity().waitGroups();
                    if (!hasMoving) {
                        for (CacheGroupContext grpCtx : this.cctx.cache().cacheGroups()) {
                            if (!set.contains(grpCtx.groupId()) || !grpCtx.topology().hasMovingPartitions()) continue;
                            hasMoving = true;
                            break;
                        }
                    }
                    this.cctx.kernalContext().state().onExchangeFinishedOnCoordinator(this, hasMoving);
                }
                boolean active = !bl && req.activate();
                ChangeGlobalStateFinishMessage changeGlobalStateFinishMessage = new ChangeGlobalStateFinishMessage(req.requestId(), active, !bl);
                this.cctx.discovery().sendCustomEvent(changeGlobalStateFinishMessage);
                if (!this.centralizedAff) {
                    this.onDone(this.exchCtx.events().topologyVersion(), (Throwable)err2);
                }
            }
        }
        catch (IgniteCheckedException e) {
            if (this.reconnectOnError(e)) {
                this.onDone(new IgniteNeedReconnectException(this.cctx.localNode(), (Throwable)e));
            } else {
                this.onDone(e);
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    private void validatePartitionsState() {
        long time = System.currentTimeMillis();
        for (Map.Entry<Integer, CacheGroupDescriptor> e : this.cctx.affinity().cacheGroups().entrySet()) {
            GridDhtPartitionTopology top;
            CacheGroupDescriptor grpDesc = e.getValue();
            if (grpDesc.config().getCacheMode() == CacheMode.LOCAL) continue;
            int grpId = e.getKey();
            CacheGroupContext grpCtx = this.cctx.cache().cacheGroup(grpId);
            GridDhtPartitionTopology gridDhtPartitionTopology = top = grpCtx != null ? grpCtx.topology() : this.cctx.exchange().clientTopology(grpId, this.events().discoveryCache());
            if (grpCtx == null || grpCtx.config().isReadThrough() || grpCtx.config().isWriteThrough() || grpCtx.config().getCacheStoreFactory() != null || grpCtx.config().getRebalanceDelay() == -1L || grpCtx.config().getRebalanceMode() == CacheRebalanceMode.NONE || grpCtx.config().getExpiryPolicyFactory() == null || SKIP_PARTITION_SIZE_VALIDATION) continue;
            try {
                this.validator.validatePartitionCountersAndSizes(this, top, this.msgs);
            }
            catch (IgniteCheckedException ex) {
                this.log.warning("Partition states validation has failed for group: " + grpDesc.cacheOrGroupName() + ". " + ex.getMessage());
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Partitions validation performed in " + (System.currentTimeMillis() - time) + " ms.");
        }
    }

    private void assignPartitionsStates() {
        long time = System.currentTimeMillis();
        for (Map.Entry<Integer, CacheGroupDescriptor> e : this.cctx.affinity().cacheGroups().entrySet()) {
            GridDhtPartitionTopology top;
            CacheGroupDescriptor grpDesc = e.getValue();
            if (grpDesc.config().getCacheMode() == CacheMode.LOCAL) continue;
            CacheGroupContext grpCtx = this.cctx.cache().cacheGroup(e.getKey());
            GridDhtPartitionTopology gridDhtPartitionTopology = top = grpCtx != null ? grpCtx.topology() : this.cctx.exchange().clientTopology(e.getKey(), this.events().discoveryCache());
            if (!CU.isPersistentCache(grpDesc.config(), this.cctx.gridConfig().getDataStorageConfiguration())) {
                this.assignPartitionSizes(top);
                continue;
            }
            this.assignPartitionStates(top);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Partitions assignment performed in " + (System.currentTimeMillis() - time) + " ms.");
        }
    }

    private void sendAllPartitionsToNode(FinishState finishState, GridDhtPartitionsSingleMessage msg, UUID nodeId) {
        ClusterNode node = this.cctx.node(nodeId);
        if (node == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send partitions, node failed: " + nodeId);
            }
            return;
        }
        GridDhtPartitionsFullMessage fullMsg = finishState.msg.copy();
        Collection<Integer> affReq = msg.cacheGroupsAffinityRequest();
        if (affReq != null) {
            Map<Integer, CacheGroupAffinityMessage> aff = CacheGroupAffinityMessage.createAffinityMessages(this.cctx, finishState.resTopVer, affReq, null);
            fullMsg.joinedNodeAffinity(aff);
        }
        if (!fullMsg.exchangeId().equals(msg.exchangeId())) {
            fullMsg = fullMsg.copy();
            fullMsg.exchangeId(msg.exchangeId());
        }
        try {
            this.cctx.io().send(node, (GridCacheMessage)fullMsg, (byte)2);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Full message was sent to node: " + node + ", fullMsg: " + fullMsg);
            }
        }
        catch (ClusterTopologyCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send partitions, node failed: " + node);
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send partitions [node=" + node + ']', e);
        }
    }

    public void onReceiveFullMessage(final ClusterNode node, final GridDhtPartitionsFullMessage msg) {
        assert (msg != null);
        assert (msg.exchangeId() != null) : msg;
        assert (!node.isDaemon()) : node;
        this.initFut.listen((IgniteInClosure<IgniteInternalFuture<Boolean>>)new CI1<IgniteInternalFuture<Boolean>>(){

            @Override
            public void apply(IgniteInternalFuture<Boolean> f2) {
                try {
                    if (!f2.get().booleanValue()) {
                        return;
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(GridDhtPartitionsExchangeFuture.this.log, "Failed to initialize exchange future: " + this, e);
                    return;
                }
                GridDhtPartitionsExchangeFuture.this.processFullMessage(true, node, msg);
            }
        });
    }

    public void onReceivePartitionRequest(final ClusterNode node, final GridDhtPartitionsSingleRequest msg) {
        assert (!this.cctx.kernalContext().clientNode() || msg.restoreState());
        assert (!node.isDaemon() && !node.isClient()) : node;
        this.initFut.listen((IgniteInClosure<IgniteInternalFuture<Boolean>>)new CI1<IgniteInternalFuture<Boolean>>(){

            @Override
            public void apply(IgniteInternalFuture<Boolean> fut) {
                GridDhtPartitionsExchangeFuture.this.processSinglePartitionRequest(node, msg);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSinglePartitionRequest(ClusterNode node, GridDhtPartitionsSingleRequest msg) {
        FinishState finishState0 = null;
        Object object = this.mux;
        synchronized (object) {
            if (this.crd == null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Ignore partitions request, no coordinator [node=" + node.id() + ']');
                }
                return;
            }
            switch (this.state) {
                case DONE: {
                    assert (this.finishState != null);
                    if (node.id().equals(this.finishState.crdId)) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Ignore partitions request, finished exchange with this coordinator: " + msg);
                        }
                        return;
                    }
                    finishState0 = this.finishState;
                    break;
                }
                case CRD: 
                case BECOME_CRD: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Ignore partitions request, node is coordinator: " + msg);
                    }
                    return;
                }
                case SRV: 
                case CLIENT: {
                    if (!this.cctx.discovery().alive(node)) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Ignore partitions request, node is not alive [node=" + node.id() + ']');
                        }
                        return;
                    }
                    if (!msg.restoreState() || node.equals(this.crd)) break;
                    if (node.order() > this.crd.order()) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Received partitions request, change coordinator [oldCrd=" + this.crd.id() + ", newCrd=" + node.id() + ']');
                        }
                        this.crd = node;
                        break;
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Ignore restore state request, coordinator changed [oldCrd=" + this.crd.id() + ", newCrd=" + node.id() + ']');
                    }
                    return;
                }
                default: {
                    assert (false) : this.state;
                    break;
                }
            }
        }
        if (msg.restoreState()) {
            try {
                GridDhtPartitionsSingleMessage res;
                assert (msg.restoreExchangeId() != null) : msg;
                if (this.dynamicCacheStartExchange() && this.exchangeLocE != null) {
                    res = new GridDhtPartitionsSingleMessage(msg.restoreExchangeId(), this.cctx.kernalContext().clientNode(), this.cctx.versions().last(), true);
                    res.setError(this.exchangeLocE);
                } else {
                    res = this.cctx.exchange().createPartitionsSingleMessage(msg.restoreExchangeId(), this.cctx.kernalContext().clientNode(), true, node.version().compareToIgnoreTimestamp(CachePartitionPartialCountersMap.PARTIAL_COUNTERS_MAP_SINCE) >= 0, this.exchActions);
                    if (this.localJoinExchange() && finishState0 == null) {
                        res.cacheGroupsAffinityRequest(this.exchCtx.groupsAffinityRequestOnJoin());
                    }
                }
                res.restoreState(true);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Send restore state response [node=" + node.id() + ", exchVer=" + msg.restoreExchangeId().topologyVersion() + ", hasState=" + (finishState0 != null) + ", affReq=" + !F.isEmpty(res.cacheGroupsAffinityRequest()) + ']');
                }
                res.finishMessage(finishState0 != null ? finishState0.msg : null);
                this.cctx.io().send(node, (GridCacheMessage)res, (byte)2);
            }
            catch (ClusterTopologyCheckedException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Node left during partition exchange [nodeId=" + node.id() + ", exchId=" + this.exchId + ']');
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to send partitions message [node=" + node + ", msg=" + msg + ']', e);
            }
            return;
        }
        try {
            this.sendLocalPartitions(node);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send message to coordinator: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFullMessage(boolean checkCrd, ClusterNode node, GridDhtPartitionsFullMessage msg) {
        try {
            assert (this.exchId.equals(msg.exchangeId())) : msg;
            assert (msg.lastVersion() != null) : msg;
            if (checkCrd) {
                assert (node != null);
                Object object = this.mux;
                synchronized (object) {
                    if (this.crd == null) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Ignore full message, all server nodes left: " + msg);
                        }
                        return;
                    }
                    switch (this.state) {
                        case CRD: 
                        case BECOME_CRD: {
                            if (this.log.isInfoEnabled()) {
                                this.log.info("Ignore full message, node is coordinator: " + msg);
                            }
                            return;
                        }
                        case DONE: {
                            if (this.log.isInfoEnabled()) {
                                this.log.info("Ignore full message, future is done: " + msg);
                            }
                            return;
                        }
                        case SRV: 
                        case CLIENT: {
                            AffinityTopologyVersion resVer;
                            Exception e;
                            if (!this.crd.equals(node)) {
                                if (this.log.isInfoEnabled()) {
                                    this.log.info("Received full message from non-coordinator [node=" + node.id() + ", nodeOrder=" + node.order() + ", crd=" + this.crd.id() + ", crdOrder=" + this.crd.order() + ']');
                                }
                                if (node.order() > this.crd.order()) {
                                    this.fullMsgs.put(node, msg);
                                }
                                return;
                            }
                            if (!F.isEmpty(msg.getErrorsMap()) && (e = msg.getErrorsMap().get(this.cctx.localNodeId())) instanceof IgniteNeedReconnectException) {
                                this.onDone(e);
                                return;
                            }
                            AffinityTopologyVersion affinityTopologyVersion = resVer = msg.resultTopologyVersion() != null ? msg.resultTopologyVersion() : this.initialVersion();
                            if (this.log.isInfoEnabled()) {
                                this.log.info("Received full message, will finish exchange [node=" + node.id() + ", resVer=" + resVer + ']');
                            }
                            this.finishState = new FinishState(this.crd.id(), resVer, msg);
                            this.state = ExchangeLocalState.DONE;
                            break;
                        }
                    }
                }
            } else assert (node == null) : node;
            AffinityTopologyVersion resTopVer = this.initialVersion();
            long time = System.currentTimeMillis();
            if (this.exchCtx.mergeExchanges()) {
                if (msg.resultTopologyVersion() != null && !this.initialVersion().equals(msg.resultTopologyVersion())) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Received full message, need merge [curFut=" + this.initialVersion() + ", resVer=" + msg.resultTopologyVersion() + ']');
                    }
                    resTopVer = msg.resultTopologyVersion();
                    if (this.cctx.exchange().mergeExchanges(this, msg)) {
                        assert (this.cctx.kernalContext().isStopping());
                        return;
                    }
                    assert (resTopVer.equals(this.exchCtx.events().topologyVersion())) : "Unexpected result version [msgVer=" + resTopVer + ", locVer=" + this.exchCtx.events().topologyVersion() + ']';
                }
                this.exchCtx.events().processEvents(this);
                if (this.localJoinExchange()) {
                    this.cctx.affinity().onLocalJoin(this, msg, resTopVer);
                } else {
                    if (this.exchCtx.events().hasServerLeft()) {
                        this.cctx.affinity().applyAffinityFromFullMessage(this, msg);
                    } else {
                        this.cctx.affinity().onServerJoinWithExchangeMergeProtocol(this, false);
                    }
                    for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                        if (grp.isLocal() || this.cacheGroupStopping(grp.groupId())) continue;
                        grp.topology().beforeExchange(this, true, false);
                    }
                }
            } else if (this.localJoinExchange() && !this.exchCtx.fetchAffinityOnJoin()) {
                this.cctx.affinity().onLocalJoin(this, msg, resTopVer);
            } else if (this.forceAffReassignment) {
                this.cctx.affinity().applyAffinityFromFullMessage(this, msg);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Affinity changes applied in " + (System.currentTimeMillis() - time) + " ms.");
            }
            if (this.dynamicCacheStartExchange() && !F.isEmpty(this.exchangeGlobalExceptions)) {
                assert (this.cctx.localNode().isClient());
                this.onDone(this.exchangeLocE);
                return;
            }
            this.updatePartitionFullMap(resTopVer, msg);
            IgniteCheckedException err2 = null;
            if (this.stateChangeExchange() && !F.isEmpty(msg.getErrorsMap())) {
                err2 = new IgniteCheckedException("Cluster state change failed");
                this.cctx.kernalContext().state().onStateChangeError(msg.getErrorsMap(), this.exchActions.stateChangeRequest());
            }
            this.onDone(resTopVer, (Throwable)err2);
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
        }
    }

    private void updatePartitionFullMap(AffinityTopologyVersion resTopVer, GridDhtPartitionsFullMessage msg) {
        this.cctx.versions().onExchange(msg.lastVersion().order());
        assert (this.partHistSuppliers.isEmpty());
        this.partHistSuppliers.putAll(msg.partitionHistorySuppliers());
        long time = System.currentTimeMillis();
        Map<Integer, Map<Integer, Long>> partsSizes = msg.partitionSizes(this.cctx);
        for (Map.Entry<Integer, GridDhtPartitionFullMap> entry2 : msg.partitions().entrySet()) {
            Integer grpId = entry2.getKey();
            CacheGroupContext grp = this.cctx.cache().cacheGroup(grpId);
            if (grp != null) {
                CachePartitionFullCountersMap cntrMap = msg.partitionUpdateCounters(grpId, grp.topology().partitions());
                grp.topology().update(resTopVer, entry2.getValue(), cntrMap, msg.partsToReload(this.cctx.localNodeId(), grpId), partsSizes.getOrDefault(grpId, Collections.emptyMap()), null);
                continue;
            }
            ClusterNode oldest = this.cctx.discovery().oldestAliveServerNode(AffinityTopologyVersion.NONE);
            if (oldest == null || !oldest.isLocal()) continue;
            GridDhtPartitionTopology top = this.cctx.exchange().clientTopology(grpId, this.events().discoveryCache());
            CachePartitionFullCountersMap cntrMap = msg.partitionUpdateCounters(grpId, top.partitions());
            top.update(resTopVer, entry2.getValue(), cntrMap, Collections.emptySet(), null, null);
        }
        this.partitionsReceived = true;
        if (this.log.isInfoEnabled()) {
            this.log.info("Full map updating for " + msg.partitions().size() + " groups performed in " + (System.currentTimeMillis() - time) + " ms.");
        }
    }

    private void updatePartitionSingleMap(UUID nodeId, GridDhtPartitionsSingleMessage msg) {
        this.msgs.put(nodeId, msg);
        for (Map.Entry<Integer, GridDhtPartitionMap> entry2 : msg.partitions().entrySet()) {
            Integer grpId = entry2.getKey();
            CacheGroupContext grp = this.cctx.cache().cacheGroup(grpId);
            GridDhtPartitionTopology top = grp != null ? grp.topology() : this.cctx.exchange().clientTopology(grpId, this.events().discoveryCache());
            top.update(this.exchId, entry2.getValue(), false);
        }
    }

    public void onDynamicCacheChangeFail(ClusterNode node, final DynamicCacheChangeFailureMessage msg) {
        assert (this.exchId.equals(msg.exchangeId())) : msg;
        assert (this.firstDiscoEvt.type() == 18 && this.dynamicCacheStartExchange());
        final ExchangeActions actions = this.exchangeActions();
        this.onDiscoveryEvent(new IgniteRunnable(){

            @Override
            public void run() {
                GridDhtPartitionsExchangeFuture.this.cctx.kernalContext().getSystemExecutorService().submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (GridDhtPartitionsExchangeFuture.this.isDone() || !GridDhtPartitionsExchangeFuture.this.enterBusy()) {
                            return;
                        }
                        try {
                            assert (msg.error() != null) : msg;
                            GridDhtPartitionsExchangeFuture.this.cctx.affinity().forceCloseCaches(GridDhtPartitionsExchangeFuture.this, GridDhtPartitionsExchangeFuture.this.crd.isLocal(), msg.exchangeActions());
                            Object object = GridDhtPartitionsExchangeFuture.this.mux;
                            synchronized (object) {
                                GridDhtPartitionsExchangeFuture.this.finishState = new FinishState(GridDhtPartitionsExchangeFuture.this.crd.id(), GridDhtPartitionsExchangeFuture.this.initialVersion(), null);
                                GridDhtPartitionsExchangeFuture.this.state = ExchangeLocalState.DONE;
                            }
                            if (actions != null) {
                                actions.completeRequestFutures(GridDhtPartitionsExchangeFuture.this.cctx, msg.error());
                            }
                            GridDhtPartitionsExchangeFuture.this.onDone(GridDhtPartitionsExchangeFuture.this.exchId.topologyVersion());
                        }
                        catch (Throwable e) {
                            GridDhtPartitionsExchangeFuture.this.onDone(e);
                        }
                        finally {
                            GridDhtPartitionsExchangeFuture.this.leaveBusy();
                        }
                    }
                });
            }
        });
    }

    public void onAffinityChangeMessage(final ClusterNode node, final CacheAffinityChangeMessage msg) {
        assert (this.exchId.equals(msg.exchangeId())) : msg;
        this.onDiscoveryEvent(new IgniteRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (GridDhtPartitionsExchangeFuture.this.isDone() || !GridDhtPartitionsExchangeFuture.this.enterBusy()) {
                    return;
                }
                try {
                    assert (GridDhtPartitionsExchangeFuture.this.centralizedAff);
                    if (GridDhtPartitionsExchangeFuture.this.crd.equals(node)) {
                        IgniteCheckedException err2;
                        AffinityTopologyVersion resTopVer = GridDhtPartitionsExchangeFuture.this.initialVersion();
                        GridDhtPartitionsExchangeFuture.this.cctx.affinity().onExchangeChangeAffinityMessage(GridDhtPartitionsExchangeFuture.this, GridDhtPartitionsExchangeFuture.this.crd.isLocal(), msg);
                        IgniteCheckedException igniteCheckedException = err2 = !F.isEmpty(msg.partitionsMessage().getErrorsMap()) ? new IgniteCheckedException("Cluster state change failed.") : null;
                        if (!GridDhtPartitionsExchangeFuture.this.crd.isLocal()) {
                            GridDhtPartitionsFullMessage partsMsg = msg.partitionsMessage();
                            assert (partsMsg != null) : msg;
                            assert (partsMsg.lastVersion() != null) : partsMsg;
                            GridDhtPartitionsExchangeFuture.this.updatePartitionFullMap(resTopVer, partsMsg);
                            if (GridDhtPartitionsExchangeFuture.this.exchActions != null && GridDhtPartitionsExchangeFuture.this.exchActions.stateChangeRequest() != null && err2 != null) {
                                GridDhtPartitionsExchangeFuture.this.cctx.kernalContext().state().onStateChangeError(msg.partitionsMessage().getErrorsMap(), GridDhtPartitionsExchangeFuture.this.exchActions.stateChangeRequest());
                            }
                        }
                        GridDhtPartitionsExchangeFuture.this.onDone(resTopVer, (Throwable)err2);
                    } else if (GridDhtPartitionsExchangeFuture.this.log.isDebugEnabled()) {
                        GridDhtPartitionsExchangeFuture.this.log.debug("Ignore affinity change message, coordinator changed [node=" + node.id() + ", crd=" + GridDhtPartitionsExchangeFuture.this.crd.id() + ", msg=" + msg + ']');
                    }
                }
                finally {
                    GridDhtPartitionsExchangeFuture.this.leaveBusy();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDiscoveryEvent(IgniteRunnable c) {
        List<IgniteRunnable> list2 = this.discoEvts;
        synchronized (list2) {
            if (!this.init) {
                this.discoEvts.add(c);
                return;
            }
            assert (this.discoEvts.isEmpty()) : this.discoEvts;
        }
        c.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDone() {
        while (!this.isDone()) {
            ArrayList<IgniteRunnable> evts;
            List<IgniteRunnable> list2 = this.discoEvts;
            synchronized (list2) {
                if (this.discoEvts.isEmpty()) {
                    this.init = true;
                    break;
                }
                evts = new ArrayList<IgniteRunnable>(this.discoEvts);
                this.discoEvts.clear();
            }
            for (IgniteRunnable c : evts) {
                c.run();
            }
        }
        this.initFut.onDone(true);
    }

    private void onAllServersLeft() {
        assert (this.cctx.kernalContext().clientNode()) : this.cctx.localNode();
        List empty = Collections.emptyList();
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            ArrayList<List<ClusterNode>> affAssignment = new ArrayList<List<ClusterNode>>(grp.affinity().partitions());
            for (int i = 0; i < grp.affinity().partitions(); ++i) {
                affAssignment.add(empty);
            }
            grp.affinity().idealAssignment(affAssignment);
            grp.affinity().initialize(this.initialVersion(), affAssignment);
            this.cctx.exchange().exchangerUpdateHeartbeat();
        }
    }

    public void onNodeLeft(final ClusterNode node) {
        if (this.isDone() || !this.enterBusy()) {
            return;
        }
        this.cctx.mvcc().removeExplicitNodeLocks(node.id(), this.initialVersion());
        try {
            this.onDiscoveryEvent(new IgniteRunnable(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBecomeCoordinator(InitNewCoordinatorFuture newCrdFut) {
        boolean allRcvd = false;
        this.cctx.exchange().onCoordinatorInitialized();
        if (newCrdFut.restoreState()) {
            GridDhtPartitionsFullMessage fullMsg = newCrdFut.fullMessage();
            assert (this.msgs.isEmpty()) : this.msgs;
            if (fullMsg != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("New coordinator restored state [ver=" + this.initialVersion() + ", resVer=" + fullMsg.resultTopologyVersion() + ']');
                }
                Object object = this.mux;
                synchronized (object) {
                    this.state = ExchangeLocalState.DONE;
                    this.finishState = new FinishState(this.crd.id(), fullMsg.resultTopologyVersion(), fullMsg);
                }
                fullMsg.exchangeId(this.exchId);
                this.processFullMessage(false, null, fullMsg);
                Map<ClusterNode, GridDhtPartitionsSingleMessage> msgs = newCrdFut.messages();
                if (!F.isEmpty(msgs)) {
                    Map<Integer, CacheGroupAffinityMessage> joinedNodeAff = null;
                    for (Map.Entry<ClusterNode, GridDhtPartitionsSingleMessage> e : msgs.entrySet()) {
                        this.msgs.put(e.getKey().id(), e.getValue());
                        GridDhtPartitionsSingleMessage msg = e.getValue();
                        Collection<Integer> affReq = msg.cacheGroupsAffinityRequest();
                        if (F.isEmpty(affReq)) continue;
                        joinedNodeAff = CacheGroupAffinityMessage.createAffinityMessages(this.cctx, fullMsg.resultTopologyVersion(), affReq, joinedNodeAff);
                    }
                    Map<UUID, GridDhtPartitionsSingleMessage> map2 = newCrdFut.mergedJoinExchangeMessages();
                    if (this.log.isInfoEnabled()) {
                        this.log.info("New coordinator sends full message [ver=" + this.initialVersion() + ", resVer=" + fullMsg.resultTopologyVersion() + ", nodes=" + F.nodeIds(msgs.keySet()) + ", mergedJoins=" + (map2 != null ? map2.keySet() : null) + ']');
                    }
                    this.sendAllPartitions(fullMsg, msgs.keySet(), map2, joinedNodeAff);
                }
                return;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("New coordinator restore state finished [ver=" + this.initialVersion() + ']');
            }
            for (Map.Entry<ClusterNode, GridDhtPartitionsSingleMessage> e : newCrdFut.messages().entrySet()) {
                GridDhtPartitionsSingleMessage gridDhtPartitionsSingleMessage = e.getValue();
                if (gridDhtPartitionsSingleMessage.client()) continue;
                this.msgs.put(e.getKey().id(), e.getValue());
                if (this.dynamicCacheStartExchange() && gridDhtPartitionsSingleMessage.getError() != null) {
                    this.exchangeGlobalExceptions.put(e.getKey().id(), gridDhtPartitionsSingleMessage.getError());
                }
                this.updatePartitionSingleMap(e.getKey().id(), gridDhtPartitionsSingleMessage);
            }
            allRcvd = true;
            Object msgs = this.mux;
            synchronized (msgs) {
                this.remaining.clear();
                assert (this.crd != null && this.crd.isLocal());
                this.state = ExchangeLocalState.CRD;
                assert (this.mergedJoinExchMsgs == null);
            }
        }
        HashSet<UUID> remaining0 = null;
        Object msgs = this.mux;
        synchronized (msgs) {
            assert (this.crd != null && this.crd.isLocal());
            this.state = ExchangeLocalState.CRD;
            assert (this.mergedJoinExchMsgs == null);
            if (this.log.isInfoEnabled()) {
                this.log.info("New coordinator initialization finished [ver=" + this.initialVersion() + ", remaining=" + this.remaining + ']');
            }
            if (!this.remaining.isEmpty()) {
                remaining0 = new HashSet<UUID>(this.remaining);
            }
        }
        if (remaining0 != null) {
            GridDhtPartitionsSingleRequest req = new GridDhtPartitionsSingleRequest(this.exchId);
            for (UUID uUID : remaining0) {
                try {
                    if (this.pendingSingleMsgs.containsKey(uUID)) continue;
                    if (this.log.isInfoEnabled()) {
                        this.log.info("New coordinator sends request [ver=" + this.initialVersion() + ", node=" + uUID + ']');
                    }
                    this.cctx.io().send(uUID, (GridCacheMessage)req, (byte)2);
                }
                catch (ClusterTopologyCheckedException ignored) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Node left during partition exchange [nodeId=" + uUID + ", exchId=" + this.exchId + ']');
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to request partitions from node: " + uUID, e);
                }
            }
            for (Map.Entry entry2 : this.pendingSingleMsgs.entrySet()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("New coordinator process pending message [ver=" + this.initialVersion() + ", node=" + entry2.getKey() + ']');
                }
                this.processSingleMessage((UUID)entry2.getKey(), (GridDhtPartitionsSingleMessage)entry2.getValue());
            }
        }
        if (allRcvd) {
            this.awaitSingleMapUpdates();
            this.onAllReceived(newCrdFut.messages().keySet());
        }
    }

    public boolean reconnectOnError(Throwable e) {
        return (e instanceof IgniteNeedReconnectException || X.hasCause(e, IOException.class, IgniteClientDisconnectedCheckedException.class)) && this.cctx.discovery().reconnectSupported();
    }

    public boolean partitionChangesInProgress() {
        ClusterNode crd0 = this.crd;
        if (crd0 == null) {
            return false;
        }
        return crd0.equals(this.cctx.localNode()) ? !this.partitionsSent : !this.partitionsReceived;
    }

    public synchronized boolean addOrMergeDelayedFullMessage(ClusterNode node, GridDhtPartitionsFullMessage fullMsg) {
        assert (fullMsg.exchangeId() == null) : fullMsg.exchangeId();
        if (this.isDone()) {
            return false;
        }
        GridDhtPartitionsFullMessage prev = this.delayedLatestMsg;
        if (prev == null) {
            this.delayedLatestMsg = fullMsg;
            this.listen(f2 -> {
                GridDhtPartitionsFullMessage msg;
                GridDhtPartitionsExchangeFuture gridDhtPartitionsExchangeFuture = this;
                synchronized (gridDhtPartitionsExchangeFuture) {
                    msg = this.delayedLatestMsg;
                    this.delayedLatestMsg = null;
                }
                if (msg != null) {
                    this.cctx.exchange().processFullPartitionUpdate(node, msg);
                }
            });
        } else {
            this.delayedLatestMsg.merge(fullMsg, this.cctx.discovery());
        }
        return true;
    }

    @Override
    public int compareTo(GridDhtPartitionsExchangeFuture fut) {
        return this.exchId.compareTo(fut.exchId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GridDhtPartitionsExchangeFuture fut = (GridDhtPartitionsExchangeFuture)o;
        return this.exchId.equals(fut.exchId);
    }

    public int hashCode() {
        return this.exchId.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiagnosticRequest(IgniteDiagnosticPrepareContext diagCtx) {
        if (!this.isDone()) {
            HashSet<UUID> remaining;
            ClusterNode crd;
            Object object = this.mux;
            synchronized (object) {
                crd = this.crd;
                remaining = new HashSet<UUID>(this.remaining);
            }
            if (crd != null) {
                if (!crd.isLocal()) {
                    diagCtx.exchangeInfo(crd.id(), this.initialVersion(), "Exchange future waiting for coordinator response [crd=" + crd.id() + ", topVer=" + this.initialVersion() + ']');
                } else if (!remaining.isEmpty()) {
                    UUID nodeId = (UUID)remaining.iterator().next();
                    diagCtx.exchangeInfo(nodeId, this.initialVersion(), "Exchange future on coordinator waiting for server response [node=" + nodeId + ", topVer=" + this.initialVersion() + ']');
                }
            }
        }
    }

    public String shortInfo() {
        return "GridDhtPartitionsExchangeFuture [topVer=" + this.initialVersion() + ", evt=" + (this.firstDiscoEvt != null ? IgniteUtils.gridEventName(this.firstDiscoEvt.type()) : Integer.valueOf(-1)) + ", evtNode=" + (this.firstDiscoEvt != null ? this.firstDiscoEvt.eventNode() : null) + ", done=" + this.isDone() + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        HashSet<UUID> remaining;
        Object object = this.mux;
        synchronized (object) {
            remaining = new HashSet<UUID>(this.remaining);
        }
        return S.toString(GridDhtPartitionsExchangeFuture.class, this, "evtLatch", this.evtLatch == null ? "null" : Long.valueOf(this.evtLatch.getCount()), "remaining", remaining, "super", super.toString());
    }

    public static long nextDumpTimeout(int step, long timeout) {
        long limit = IgniteSystemProperties.getLong("IGNITE_LONG_OPERATIONS_DUMP_TIMEOUT_LIMIT", 1800000L);
        if (limit <= 0L) {
            limit = 1800000L;
        }
        assert (step >= 0) : step;
        long dumpFactor = Math.round(Math.pow(2.0, step));
        long nextTimeout = timeout * dumpFactor;
        if (nextTimeout <= 0L) {
            return limit;
        }
        return nextTimeout <= limit ? nextTimeout : limit;
    }

    static /* synthetic */ List access$2800(GridDhtPartitionsExchangeFuture x0) {
        return x0.srvNodes;
    }

    static /* synthetic */ Set access$2900(GridDhtPartitionsExchangeFuture x0) {
        return x0.remaining;
    }

    static /* synthetic */ Map access$3000(GridDhtPartitionsExchangeFuture x0) {
        return x0.mergedJoinExchMsgs;
    }

    static /* synthetic */ ClusterNode access$2002(GridDhtPartitionsExchangeFuture x0, ClusterNode x1) {
        x0.crd = x1;
        return x0.crd;
    }

    static /* synthetic */ ExchangeLocalState access$2100(GridDhtPartitionsExchangeFuture x0) {
        return x0.state;
    }

    static /* synthetic */ InitNewCoordinatorFuture access$2702(GridDhtPartitionsExchangeFuture x0, InitNewCoordinatorFuture x1) {
        x0.newCrdFut = x1;
        return x0.newCrdFut;
    }

    static /* synthetic */ void access$3100(GridDhtPartitionsExchangeFuture x0) {
        x0.onAllServersLeft();
    }

    static /* synthetic */ boolean access$3200(GridDhtPartitionsExchangeFuture x0) {
        return x0.stateChangeExchange();
    }

    static /* synthetic */ Exception access$3300(GridDhtPartitionsExchangeFuture x0) {
        return x0.exchangeLocE;
    }

    static /* synthetic */ Map access$3400(GridDhtPartitionsExchangeFuture x0) {
        return x0.exchangeGlobalExceptions;
    }

    static /* synthetic */ Map access$3800(GridDhtPartitionsExchangeFuture x0) {
        return x0.fullMsgs;
    }

    private static enum ExchangeLocalState {
        CRD,
        SRV,
        CLIENT,
        BECOME_CRD,
        DONE,
        MERGED;

    }

    static enum ExchangeType {
        CLIENT,
        ALL,
        NONE;

    }

    private static class FinishState {
        private final UUID crdId;
        private final AffinityTopologyVersion resTopVer;
        private final GridDhtPartitionsFullMessage msg;

        FinishState(UUID crdId, AffinityTopologyVersion resTopVer, GridDhtPartitionsFullMessage msg) {
            this.crdId = crdId;
            this.resTopVer = resTopVer;
            this.msg = msg;
        }

        public void cleanUp() {
            if (this.msg != null) {
                this.msg.cleanUp();
            }
        }
    }

    private static class CounterWithNodes {
        private final long cnt;
        private final long size;
        private final Set<UUID> nodes = new HashSet<UUID>();

        private CounterWithNodes(long cnt, @Nullable Long size2, UUID firstNode) {
            this.cnt = cnt;
            this.size = size2 != null ? size2 : 0L;
            this.nodes.add(firstNode);
        }

        public String toString() {
            return S.toString(CounterWithNodes.class, this);
        }
    }
}

