/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheMvccEntryInfo;
import org.apache.ignite.internal.processors.cache.IgniteRebalanceIterator;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessageV2;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUpdateVersionAware;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersionAware;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.IgniteSpiException;

class GridDhtPartitionSupplier {
    private final CacheGroupContext grp;
    private final IgniteLogger log;
    private GridDhtPartitionTopology top;
    private IgnitePredicate<GridCacheEntryInfo> preloadPred;
    private final Map<T3<UUID, Integer, AffinityTopologyVersion>, SupplyContext> scMap = new HashMap<T3<UUID, Integer, AffinityTopologyVersion>, SupplyContext>();

    GridDhtPartitionSupplier(CacheGroupContext grp) {
        assert (grp != null);
        this.grp = grp;
        this.log = grp.shared().logger(this.getClass());
        this.top = grp.topology();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Map<T3<UUID, Integer, AffinityTopologyVersion>, SupplyContext> map2 = this.scMap;
        synchronized (map2) {
            Iterator<T3<UUID, Integer, AffinityTopologyVersion>> it = this.scMap.keySet().iterator();
            while (it.hasNext()) {
                T3<UUID, Integer, AffinityTopologyVersion> t = it.next();
                GridDhtPartitionSupplier.clearContext(this.scMap.get(t), this.log);
                it.remove();
            }
        }
    }

    private static void clearContext(SupplyContext sc, IgniteLogger log2) {
        IgniteRebalanceIterator it;
        if (sc != null && (it = sc.iterator) != null && !it.isClosed()) {
            try {
                it.close();
            }
            catch (IgniteCheckedException e) {
                U.error(log2, "Iterator close failed.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTopologyChanged() {
        Map<T3<UUID, Integer, AffinityTopologyVersion>, SupplyContext> map2 = this.scMap;
        synchronized (map2) {
            Iterator<T3<UUID, Integer, AffinityTopologyVersion>> it = this.scMap.keySet().iterator();
            Collection aliveNodes = this.grp.shared().discovery().aliveServerNodes().stream().map(ClusterNode::id).collect(Collectors.toList());
            while (it.hasNext()) {
                T3<UUID, Integer, AffinityTopologyVersion> t = it.next();
                if (aliveNodes.contains(t.get1())) continue;
                GridDhtPartitionSupplier.clearContext(this.scMap.get(t), this.log);
                it.remove();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Supply context removed [grp=" + this.grp.cacheOrGroupName() + ", demander=" + t.get1() + "]");
            }
        }
    }

    void preloadPredicate(IgnitePredicate<GridCacheEntryInfo> preloadPred) {
        this.preloadPred = preloadPred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDemandMessage(int topicId, UUID nodeId, GridDhtPartitionDemandMessage demandMsg) {
        assert (demandMsg != null);
        assert (nodeId != null);
        T3<UUID, Integer, AffinityTopologyVersion> contextId = new T3<UUID, Integer, AffinityTopologyVersion>(nodeId, topicId, demandMsg.topologyVersion());
        if (demandMsg.rebalanceId() < 0L) {
            Map<T3<UUID, Integer, AffinityTopologyVersion>, SupplyContext> map2 = this.scMap;
            synchronized (map2) {
                SupplyContext sctx = this.scMap.get(contextId);
                if (sctx != null && sctx.rebalanceId == -demandMsg.rebalanceId()) {
                    GridDhtPartitionSupplier.clearContext(this.scMap.remove(contextId), this.log);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Supply context cleaned [" + this.supplyRoutineInfo(topicId, nodeId, demandMsg) + ", supplyContext=" + sctx + "]");
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Stale supply context cleanup message [" + this.supplyRoutineInfo(topicId, nodeId, demandMsg) + ", supplyContext=" + sctx + "]");
                }
                return;
            }
        }
        ClusterNode demanderNode = this.grp.shared().discovery().node(nodeId);
        if (demanderNode == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Demand message rejected (demander left cluster) [" + this.supplyRoutineInfo(topicId, nodeId, demandMsg) + "]");
            }
            return;
        }
        GridCloseableIterator iter2 = null;
        SupplyContext sctx = null;
        try {
            GridDhtLocalPartition loc;
            HashSet<Integer> remainingParts;
            Map<T3<UUID, Integer, AffinityTopologyVersion>, SupplyContext> map3 = this.scMap;
            synchronized (map3) {
                sctx = this.scMap.remove(contextId);
                if (sctx != null && demandMsg.rebalanceId() < sctx.rebalanceId) {
                    this.scMap.put(contextId, sctx);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Stale demand message [" + this.supplyRoutineInfo(topicId, nodeId, demandMsg) + ", actualContext=" + sctx + "]");
                    }
                    return;
                }
            }
            if (sctx == null && (demandMsg.partitions() == null || demandMsg.partitions().isEmpty())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Empty demand message (no context and partitions) [" + this.supplyRoutineInfo(topicId, nodeId, demandMsg) + "]");
                }
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Demand message accepted [" + this.supplyRoutineInfo(topicId, nodeId, demandMsg) + "]");
            }
            assert (sctx == null || demandMsg.partitions().isEmpty());
            long maxBatchesCnt = this.grp.config().getRebalanceBatchesPrefetchCount();
            if (sctx == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Starting supplying rebalancing [" + this.supplyRoutineInfo(topicId, nodeId, demandMsg) + ", fullPartitions=" + S.compact(demandMsg.partitions().fullSet()) + ", histPartitions=" + S.compact(demandMsg.partitions().historicalSet()) + "]");
                }
            } else {
                maxBatchesCnt = 1L;
            }
            GridDhtPartitionSupplyMessage supplyMsg = new GridDhtPartitionSupplyMessage(demandMsg.rebalanceId(), this.grp.groupId(), demandMsg.topologyVersion(), this.grp.deploymentEnabled());
            if (sctx == null || sctx.iterator == null) {
                iter2 = this.grp.offheap().rebalanceIterator(demandMsg.partitions(), demandMsg.topologyVersion());
                remainingParts = new HashSet<Integer>(demandMsg.partitions().fullSet());
                CachePartitionPartialCountersMap histMap = demandMsg.partitions().historicalMap();
                for (int i = 0; i < histMap.size(); ++i) {
                    int p = histMap.partitionAt(i);
                    remainingParts.add(p);
                }
                for (Integer part : demandMsg.partitions().fullSet()) {
                    if (iter2.isPartitionMissing(part)) continue;
                    GridDhtLocalPartition loc2 = this.top.localPartition(part, demandMsg.topologyVersion(), false);
                    assert (loc2 != null && loc2.state() == GridDhtPartitionState.OWNING) : "Partition should be in OWNING state: " + loc2;
                    supplyMsg.addEstimatedKeysCount(this.grp.offheap().totalPartitionEntriesCount(part));
                }
                for (int i = 0; i < histMap.size(); ++i) {
                    int p = histMap.partitionAt(i);
                    if (iter2.isPartitionMissing(p)) continue;
                    supplyMsg.addEstimatedKeysCount(histMap.updateCounterAt(i) - histMap.initialUpdateCounterAt(i));
                }
            } else {
                iter2 = sctx.iterator;
                remainingParts = sctx.remainingParts;
            }
            int msgMaxSize = this.grp.config().getRebalanceBatchSize();
            long batchesCnt = 0L;
            while (iter2.hasNext()) {
                if (supplyMsg.messageSize() >= msgMaxSize) {
                    if (++batchesCnt >= maxBatchesCnt) {
                        this.saveSupplyContext(contextId, (IgniteRebalanceIterator)iter2, remainingParts, demandMsg.rebalanceId());
                        this.reply(topicId, demanderNode, demandMsg, supplyMsg, contextId);
                        return;
                    }
                    if (!this.reply(topicId, demanderNode, demandMsg, supplyMsg, contextId)) {
                        return;
                    }
                    supplyMsg = new GridDhtPartitionSupplyMessage(demandMsg.rebalanceId(), this.grp.groupId(), demandMsg.topologyVersion(), this.grp.deploymentEnabled());
                }
                CacheDataRow row = (CacheDataRow)iter2.next();
                int part = row.partition();
                loc = this.top.localPartition(part, demandMsg.topologyVersion(), false);
                assert (loc != null && loc.state() == GridDhtPartitionState.OWNING && loc.reservations() > 0 || iter2.isPartitionMissing(part)) : "Partition should be in OWNING state and has at least 1 reservation " + loc;
                if (iter2.isPartitionMissing(part) && remainingParts.contains(part)) {
                    supplyMsg.missed(part);
                    remainingParts.remove(part);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Requested partition is marked as missing [" + this.supplyRoutineInfo(topicId, nodeId, demandMsg) + ", p=" + part + "]");
                    continue;
                }
                if (!remainingParts.contains(part)) continue;
                GridCacheEntryInfo info2 = this.grp.mvccEnabled() ? new GridCacheMvccEntryInfo() : new GridCacheEntryInfo();
                info2.key(row.key());
                info2.cacheId(row.cacheId());
                if (this.grp.mvccEnabled()) {
                    byte newTxState;
                    byte txState;
                    byte by2 = txState = row.mvccTxState() != 0 ? row.mvccTxState() : MvccUtils.state(this.grp, row.mvccCoordinatorVersion(), row.mvccCounter(), row.mvccOperationCounter());
                    if (txState != 3) continue;
                    ((MvccVersionAware)((Object)info2)).mvccVersion(row);
                    ((GridCacheMvccEntryInfo)info2).mvccTxState((byte)3);
                    byte by3 = newTxState = row.newMvccTxState() != 0 ? row.newMvccTxState() : MvccUtils.state(this.grp, row.newMvccCoordinatorVersion(), row.newMvccCounter(), row.newMvccOperationCounter());
                    if (newTxState != 2) {
                        ((MvccUpdateVersionAware)((Object)info2)).newMvccVersion(row);
                        if (newTxState == 3) {
                            ((GridCacheMvccEntryInfo)info2).newMvccTxState((byte)3);
                        }
                    }
                }
                info2.value(row.value());
                info2.version(row.version());
                info2.expireTime(row.expireTime());
                if (this.preloadPred == null || this.preloadPred.apply(info2)) {
                    supplyMsg.addEntry0(part, iter2.historical(part), info2, this.grp.shared(), this.grp.cacheObjectContext());
                } else if (this.log.isTraceEnabled()) {
                    this.log.trace("Rebalance predicate evaluated to false (will not send cache entry): " + info2);
                }
                if (!iter2.isPartitionDone(part)) continue;
                supplyMsg.last(part, loc.updateCounter());
                remainingParts.remove(part);
            }
            Iterator remainingIter = remainingParts.iterator();
            while (remainingIter.hasNext()) {
                int p = (Integer)remainingIter.next();
                if (iter2.isPartitionDone(p)) {
                    loc = this.top.localPartition(p, demandMsg.topologyVersion(), false);
                    assert (loc != null) : "Supply partition is gone: grp=" + this.grp.cacheOrGroupName() + ", p=" + p;
                    supplyMsg.last(p, loc.updateCounter());
                    remainingIter.remove();
                    continue;
                }
                if (!iter2.isPartitionMissing(p)) continue;
                supplyMsg.missed(p);
                remainingIter.remove();
            }
            assert (remainingParts.isEmpty()) : "Partitions after rebalance should be either done or missing: " + remainingParts;
            if (sctx != null) {
                GridDhtPartitionSupplier.clearContext(sctx, this.log);
            } else {
                iter2.close();
            }
            this.reply(topicId, demanderNode, demandMsg, supplyMsg, contextId);
            if (this.log.isInfoEnabled()) {
                this.log.info("Finished supplying rebalancing [" + this.supplyRoutineInfo(topicId, nodeId, demandMsg) + "]");
            }
        }
        catch (Throwable t) {
            boolean sendErrMsg;
            if (this.grp.shared().kernalContext().isStopping()) {
                return;
            }
            boolean bl = sendErrMsg = demanderNode.version().compareTo(GridDhtPartitionSupplyMessageV2.AVAILABLE_SINCE) >= 0;
            if (t instanceof IgniteSpiException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to send message to node (current node is stopping?) [" + this.supplyRoutineInfo(topicId, nodeId, demandMsg) + ", msg=" + t.getMessage() + ']');
                }
                sendErrMsg = false;
            } else {
                U.error(this.log, "Failed to continue supplying [" + this.supplyRoutineInfo(topicId, nodeId, demandMsg) + "]", t);
            }
            try {
                if (sctx != null) {
                    GridDhtPartitionSupplier.clearContext(sctx, this.log);
                } else if (iter2 != null) {
                    iter2.close();
                }
            }
            catch (Throwable t1) {
                U.error(this.log, "Failed to cleanup supplying context [" + this.supplyRoutineInfo(topicId, nodeId, demandMsg) + "]", t1);
            }
            if (!sendErrMsg) {
                return;
            }
            try {
                GridDhtPartitionSupplyMessageV2 errMsg = new GridDhtPartitionSupplyMessageV2(demandMsg.rebalanceId(), this.grp.groupId(), demandMsg.topologyVersion(), this.grp.deploymentEnabled(), t);
                this.reply(topicId, demanderNode, demandMsg, errMsg, contextId);
            }
            catch (Throwable t1) {
                U.error(this.log, "Failed to send supply error message [" + this.supplyRoutineInfo(topicId, nodeId, demandMsg) + "]", t1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reply(int topicId, ClusterNode demander, GridDhtPartitionDemandMessage demandMsg, GridDhtPartitionSupplyMessage supplyMsg, T3<UUID, Integer, AffinityTopologyVersion> contextId) throws IgniteCheckedException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Send next supply message [" + this.supplyRoutineInfo(topicId, demander.id(), demandMsg) + "]");
            }
            this.grp.shared().io().sendOrderedMessage(demander, demandMsg.topic(), supplyMsg, this.grp.ioPolicy(), demandMsg.timeout());
            if (this.grp.config().getRebalanceThrottle() > 0L) {
                U.sleep(this.grp.config().getRebalanceThrottle());
            }
            return true;
        }
        catch (ClusterTopologyCheckedException ignore) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send supply message (demander left): [" + this.supplyRoutineInfo(topicId, demander.id(), demandMsg) + "]");
            }
            Map<T3<UUID, Integer, AffinityTopologyVersion>, SupplyContext> map2 = this.scMap;
            synchronized (map2) {
                GridDhtPartitionSupplier.clearContext(this.scMap.remove(contextId), this.log);
            }
            return false;
        }
    }

    private String supplyRoutineInfo(int topicId, UUID demander, GridDhtPartitionDemandMessage demandMsg) {
        return "grp=" + this.grp.cacheOrGroupName() + ", demander=" + demander + ", topVer=" + demandMsg.topologyVersion() + ", topic=" + topicId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSupplyContext(T3<UUID, Integer, AffinityTopologyVersion> contextId, IgniteRebalanceIterator entryIt, Set<Integer> remainingParts, long rebalanceId) {
        Map<T3<UUID, Integer, AffinityTopologyVersion>, SupplyContext> map2 = this.scMap;
        synchronized (map2) {
            assert (this.scMap.get(contextId) == null);
            this.scMap.put(contextId, new SupplyContext(entryIt, remainingParts, rebalanceId));
        }
    }

    private static class SupplyContext {
        @GridToStringExclude
        private final IgniteRebalanceIterator iterator;
        private final Set<Integer> remainingParts;
        private final long rebalanceId;

        SupplyContext(IgniteRebalanceIterator iterator2, Set<Integer> remainingParts, long rebalanceId) {
            this.iterator = iterator2;
            this.remainingParts = remainingParts;
            this.rebalanceId = rebalanceId;
        }

        public String toString() {
            return S.toString(SupplyContext.class, this);
        }
    }
}

