/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryInfoCollection;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheMetricsImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloaderAssignments;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtDemandedPartitionsMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUpdateVersionAware;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersionAware;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.IgniteSpiException;
import org.jetbrains.annotations.Nullable;

public class GridDhtPartitionDemander {
    private final GridCacheSharedContext<?, ?> ctx;
    private final CacheGroupContext grp;
    private final IgniteLogger log;
    private IgnitePredicate<GridCacheEntryInfo> preloadPred;
    @GridToStringInclude
    private final GridFutureAdapter syncFut = new GridFutureAdapter();
    @GridToStringInclude
    private volatile RebalanceFuture rebalanceFut;
    private AtomicReference<GridTimeoutObject> lastTimeoutObj = new AtomicReference();
    private volatile GridDhtPartitionsExchangeFuture lastExchangeFut;
    private final Map<Integer, Object> rebalanceTopics;

    public GridDhtPartitionDemander(CacheGroupContext grp) {
        assert (grp != null);
        this.grp = grp;
        this.ctx = grp.shared();
        this.log = this.ctx.logger(this.getClass());
        boolean enabled = grp.rebalanceEnabled() && !this.ctx.kernalContext().clientNode();
        this.rebalanceFut = new RebalanceFuture();
        if (!enabled) {
            this.rebalanceFut.onDone(true);
            this.syncFut.onDone();
        }
        HashMap<Integer, Object> tops = new HashMap<Integer, Object>();
        for (int idx = 0; idx < grp.shared().kernalContext().config().getRebalanceThreadPoolSize(); ++idx) {
            tops.put(idx, GridCachePartitionExchangeManager.rebalanceTopic(idx));
        }
        this.rebalanceTopics = tops;
    }

    void start() {
    }

    void stop() {
        try {
            this.rebalanceFut.cancel();
        }
        catch (Exception ignored) {
            this.rebalanceFut.onDone(false);
        }
        this.lastExchangeFut = null;
        this.lastTimeoutObj.set(null);
        this.syncFut.onDone();
    }

    IgniteInternalFuture<?> syncFuture() {
        return this.syncFut;
    }

    IgniteInternalFuture<Boolean> rebalanceFuture() {
        return this.rebalanceFut;
    }

    void preloadPredicate(IgnitePredicate<GridCacheEntryInfo> preloadPred) {
        this.preloadPred = preloadPred;
    }

    IgniteInternalFuture<Boolean> forceRebalance() {
        GridDhtPartitionsExchangeFuture exchFut;
        GridTimeoutObject obj = this.lastTimeoutObj.getAndSet(null);
        if (obj != null) {
            this.ctx.time().removeTimeoutObject(obj);
        }
        if ((exchFut = this.lastExchangeFut) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Forcing rebalance event for future: " + exchFut);
            }
            final GridFutureAdapter<Boolean> fut = new GridFutureAdapter<Boolean>();
            exchFut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                @Override
                public void apply(IgniteInternalFuture<AffinityTopologyVersion> t) {
                    IgniteInternalFuture<Boolean> fut0 = GridDhtPartitionDemander.this.ctx.exchange().forceRebalance(exchFut.exchangeId());
                    fut0.listen(new IgniteInClosure<IgniteInternalFuture<Boolean>>(){

                        @Override
                        public void apply(IgniteInternalFuture<Boolean> future) {
                            try {
                                fut.onDone(future.get());
                            }
                            catch (Exception e) {
                                fut.onDone(e);
                            }
                        }
                    });
                }
            });
            return fut;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Ignoring force rebalance request (no topology event happened yet).");
        }
        return new GridFinishedFuture<Boolean>(true);
    }

    private boolean topologyChanged(RebalanceFuture fut) {
        return !this.ctx.exchange().rebalanceTopologyVersion().equals(fut.topVer) || fut != this.rebalanceFut;
    }

    void onTopologyChanged(GridDhtPartitionsExchangeFuture lastFut) {
        this.lastExchangeFut = lastFut;
    }

    Collection<UUID> remainingNodes() {
        return this.rebalanceFut.remainingNodes();
    }

    Runnable addAssignments(final GridDhtPreloaderAssignments assignments, boolean force, long rebalanceId, Runnable next2, @Nullable GridCompoundFuture<Boolean, Boolean> forcedRebFut) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Adding partition assignments: " + assignments);
        }
        assert (force == (forcedRebFut != null));
        long delay = this.grp.config().getRebalanceDelay();
        if ((delay == 0L || force) && assignments != null) {
            RebalanceFuture oldFut = this.rebalanceFut;
            RebalanceFuture fut = new RebalanceFuture(this.grp, assignments, this.log, rebalanceId);
            if (!this.grp.localWalEnabled()) {
                fut.listen(new IgniteInClosureX<IgniteInternalFuture<Boolean>>(){

                    @Override
                    public void applyx(IgniteInternalFuture<Boolean> future) throws IgniteCheckedException {
                        if (future.get().booleanValue()) {
                            GridDhtPartitionDemander.this.ctx.walState().onGroupRebalanceFinished(GridDhtPartitionDemander.this.grp.groupId(), assignments.topologyVersion());
                        }
                    }
                });
            }
            if (!oldFut.isInitial()) {
                oldFut.cancel();
            } else {
                fut.listen(f2 -> oldFut.onDone(f2.result()));
            }
            if (forcedRebFut != null) {
                forcedRebFut.add(fut);
            }
            this.rebalanceFut = fut;
            for (GridCacheContext cctx : this.grp.caches()) {
                if (!cctx.statisticsEnabled()) continue;
                CacheMetricsImpl metrics = cctx.cache().metrics0();
                metrics.clearRebalanceCounters();
                for (GridDhtPartitionDemandMessage msg : assignments.values()) {
                    for (Integer partId : msg.partitions().fullSet()) {
                        metrics.onRebalancingKeysCountEstimateReceived(this.grp.topology().globalPartSizes().get(partId));
                    }
                    CachePartitionPartialCountersMap histMap = msg.partitions().historicalMap();
                    for (int i = 0; i < histMap.size(); ++i) {
                        long from2 = histMap.initialUpdateCounterAt(i);
                        long to2 = histMap.updateCounterAt(i);
                        metrics.onRebalancingKeysCountEstimateReceived(to2 - from2);
                    }
                }
                metrics.startRebalance(0L);
            }
            fut.sendRebalanceStartedEvent();
            if (assignments.cancelled()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rebalancing skipped due to cancelled assignments.");
                }
                fut.onDone(false);
                fut.sendRebalanceFinishedEvent();
                return null;
            }
            if (assignments.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rebalancing skipped due to empty assignments.");
                }
                fut.onDone(true);
                ((GridFutureAdapter)this.grp.preloader().syncFuture()).onDone();
                fut.sendRebalanceFinishedEvent();
                return null;
            }
            return () -> {
                if (next2 != null) {
                    fut.listen(f2 -> {
                        block3: {
                            try {
                                if (((Boolean)f2.get()).booleanValue()) {
                                    next2.run();
                                }
                            }
                            catch (IgniteCheckedException e) {
                                if (!this.log.isDebugEnabled()) break block3;
                                this.log.debug(e.getMessage());
                            }
                        }
                    });
                }
                this.requestPartitions(fut, assignments);
            };
        }
        if (delay > 0L) {
            for (GridCacheContext cctx : this.grp.caches()) {
                if (!cctx.statisticsEnabled()) continue;
                CacheMetricsImpl metrics = cctx.cache().metrics0();
                metrics.startRebalance(delay);
            }
            GridTimeoutObject obj = this.lastTimeoutObj.get();
            if (obj != null) {
                this.ctx.time().removeTimeoutObject(obj);
            }
            final GridDhtPartitionsExchangeFuture exchFut = this.lastExchangeFut;
            assert (exchFut != null) : "Delaying rebalance process without topology event.";
            obj = new GridTimeoutObjectAdapter(delay){

                @Override
                public void onTimeout() {
                    exchFut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                        @Override
                        public void apply(IgniteInternalFuture<AffinityTopologyVersion> f2) {
                            GridDhtPartitionDemander.this.ctx.exchange().forceRebalance(exchFut.exchangeId());
                        }
                    });
                }
            };
            this.lastTimeoutObj.set(obj);
            this.ctx.time().addTimeoutObject(obj);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestPartitions(RebalanceFuture fut, GridDhtPreloaderAssignments assignments) {
        assert (fut != null);
        if (this.topologyChanged(fut)) {
            fut.cancel();
            return;
        }
        if (!this.ctx.kernalContext().grid().isRebalanceEnabled()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Cancel partition demand because rebalance disabled on current node.");
            }
            fut.cancel();
            return;
        }
        RebalanceFuture rebalanceFuture = fut;
        synchronized (rebalanceFuture) {
            if (fut.isDone()) {
                return;
            }
            fut.remaining.forEach((key, value2) -> value2.set1(U.currentTimeMillis()));
        }
        CacheConfiguration cfg = this.grp.config();
        int totalStripes = this.ctx.gridConfig().getRebalanceThreadPoolSize();
        for (Map.Entry e : assignments.entrySet()) {
            IgniteDhtDemandedPartitionsMap parts;
            ClusterNode node = (ClusterNode)e.getKey();
            GridDhtPartitionDemandMessage d = (GridDhtPartitionDemandMessage)e.getValue();
            RebalanceFuture rebalanceFuture2 = fut;
            synchronized (rebalanceFuture2) {
                if (fut.isDone()) {
                    break;
                }
                parts = (IgniteDhtDemandedPartitionsMap)((T2)fut.remaining.get(node.id())).get2();
                U.log(this.log, "Prepared rebalancing [grp=" + this.grp.cacheOrGroupName() + ", mode=" + (Object)((Object)cfg.getRebalanceMode()) + ", supplier=" + node.id() + ", partitionsCount=" + parts.size() + ", topVer=" + fut.topologyVersion() + ", parallelism=" + totalStripes + "]");
            }
            int stripes = totalStripes;
            ArrayList<IgniteDhtDemandedPartitionsMap> stripePartitions = new ArrayList<IgniteDhtDemandedPartitionsMap>(stripes);
            for (int i = 0; i < stripes; ++i) {
                stripePartitions.add(new IgniteDhtDemandedPartitionsMap());
            }
            if (parts.hasHistorical()) {
                stripePartitions.set(stripes - 1, new IgniteDhtDemandedPartitionsMap(parts.historicalMap(), null));
                if (stripes > 1) {
                    --stripes;
                }
            }
            Iterator<Integer> it = parts.fullSet().iterator();
            int i = 0;
            while (it.hasNext()) {
                ((IgniteDhtDemandedPartitionsMap)stripePartitions.get(i % stripes)).addFull(it.next());
                ++i;
            }
            for (int stripe = 0; stripe < totalStripes; ++stripe) {
                if (((IgniteDhtDemandedPartitionsMap)stripePartitions.get(stripe)).isEmpty()) continue;
                GridDhtPartitionDemandMessage demandMsg = d.withNewPartitionsMap((IgniteDhtDemandedPartitionsMap)stripePartitions.get(stripe));
                demandMsg.topic(this.rebalanceTopics.get(stripe));
                demandMsg.rebalanceId(fut.rebalanceId);
                demandMsg.timeout(cfg.getRebalanceTimeout());
                int topicId = stripe;
                IgniteInternalFuture<?> clearAllFuture = this.clearFullPartitions(fut, demandMsg.partitions().fullSet());
                clearAllFuture.listen(f2 -> this.ctx.kernalContext().closure().runLocalSafe(() -> {
                    if (fut.isDone()) {
                        return;
                    }
                    try {
                        this.ctx.io().sendOrderedMessage(node, this.rebalanceTopics.get(topicId), demandMsg.convertIfNeeded(node.version()), this.grp.ioPolicy(), demandMsg.timeout());
                        RebalanceFuture rebalanceFuture = fut;
                        synchronized (rebalanceFuture) {
                            if (fut.isDone()) {
                                fut.cleanupRemoteContexts(node.id());
                            }
                        }
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Started rebalance routine [" + this.grp.cacheOrGroupName() + ", supplier=" + node.id() + ", topic=" + topicId + ", fullPartitions=" + S.compact(((IgniteDhtDemandedPartitionsMap)stripePartitions.get(topicId)).fullSet()) + ", histPartitions=" + S.compact(((IgniteDhtDemandedPartitionsMap)stripePartitions.get(topicId)).historicalSet()) + "]");
                        }
                    }
                    catch (IgniteCheckedException e1) {
                        ClusterTopologyCheckedException cause = e1.getCause(ClusterTopologyCheckedException.class);
                        if (cause != null) {
                            this.log.warning("Failed to send initial demand request to node. " + e1.getMessage());
                        } else {
                            this.log.error("Failed to send initial demand request to node.", e1);
                        }
                        fut.cancel();
                    }
                    catch (Throwable th) {
                        this.log.error("Runtime error caught during initial demand request sending.", th);
                        fut.cancel();
                    }
                }, true));
            }
        }
    }

    private IgniteInternalFuture<?> clearFullPartitions(RebalanceFuture fut, Set<Integer> fullPartitions) {
        GridFutureAdapter clearAllFuture = new GridFutureAdapter();
        if (fullPartitions.isEmpty()) {
            clearAllFuture.onDone();
            return clearAllFuture;
        }
        for (GridCacheContext cctx : this.grp.caches()) {
            if (!cctx.statisticsEnabled()) continue;
            CacheMetricsImpl metrics = cctx.cache().metrics0();
            metrics.rebalanceClearingPartitions(fullPartitions.size());
        }
        AtomicInteger clearingPartitions = new AtomicInteger(fullPartitions.size());
        for (int partId : fullPartitions) {
            if (fut.isDone()) {
                clearAllFuture.onDone();
                return clearAllFuture;
            }
            GridDhtLocalPartition part = this.grp.topology().localPartition(partId);
            if (part != null && part.state() == GridDhtPartitionState.MOVING) {
                part.onClearFinished(f2 -> {
                    if (!fut.isDone()) {
                        if (f2.error() != null) {
                            for (GridCacheContext cctx : this.grp.caches()) {
                                if (!cctx.statisticsEnabled()) continue;
                                CacheMetricsImpl metrics = cctx.cache().metrics0();
                                metrics.rebalanceClearingPartitions(0);
                            }
                            this.log.error("Unable to await partition clearing " + part, f2.error());
                            fut.cancel();
                            clearAllFuture.onDone(f2.error());
                        } else {
                            int remaining = clearingPartitions.decrementAndGet();
                            for (GridCacheContext cctx : this.grp.caches()) {
                                if (!cctx.statisticsEnabled()) continue;
                                CacheMetricsImpl metrics = cctx.cache().metrics0();
                                metrics.rebalanceClearingPartitions(remaining);
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Partition is ready for rebalance [grp=" + this.grp.cacheOrGroupName() + ", p=" + part.id() + ", remaining=" + remaining + "]");
                            }
                            if (remaining == 0) {
                                clearAllFuture.onDone();
                            }
                        }
                    } else {
                        clearAllFuture.onDone();
                    }
                });
                continue;
            }
            int remaining = clearingPartitions.decrementAndGet();
            for (GridCacheContext cctx : this.grp.caches()) {
                if (!cctx.statisticsEnabled()) continue;
                CacheMetricsImpl metrics = cctx.cache().metrics0();
                metrics.rebalanceClearingPartitions(remaining);
            }
            if (remaining != 0) continue;
            clearAllFuture.onDone();
        }
        return clearAllFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSupplyMessage(int topicId, UUID nodeId, GridDhtPartitionSupplyMessage supplyMsg) {
        block39: {
            AffinityTopologyVersion topVer = supplyMsg.topologyVersion();
            RebalanceFuture fut = this.rebalanceFut;
            ClusterNode node = this.ctx.node(nodeId);
            if (node == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Supply message ignored (supplier has left cluster) [" + this.demandRoutineInfo(topicId, nodeId, supplyMsg) + "]");
                }
                return;
            }
            if (this.topologyChanged(fut) || !fut.isActual(supplyMsg.rebalanceId())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Supply message ignored (topology changed) [" + this.demandRoutineInfo(topicId, nodeId, supplyMsg) + "]");
                }
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received supply message [" + this.demandRoutineInfo(topicId, nodeId, supplyMsg) + "]");
            }
            if (supplyMsg.classError() != null) {
                U.warn(this.log, "Rebalancing from node cancelled [" + this.demandRoutineInfo(topicId, nodeId, supplyMsg) + "]. Supply message couldn't be unmarshalled: " + supplyMsg.classError());
                fut.cancel(nodeId);
                return;
            }
            if (supplyMsg.error() != null) {
                U.warn(this.log, "Rebalancing from node cancelled [" + this.demandRoutineInfo(topicId, nodeId, supplyMsg) + "]]. Supplier has failed with error: " + supplyMsg.error());
                fut.cancel(nodeId);
                return;
            }
            GridDhtPartitionTopology top = this.grp.topology();
            if (this.grp.sharedGroup()) {
                for (GridCacheContext gridCacheContext : this.grp.caches()) {
                    if (!gridCacheContext.statisticsEnabled()) continue;
                    long l = supplyMsg.keysForCache(gridCacheContext.cacheId());
                    if (l != -1L) {
                        gridCacheContext.cache().metrics0().onRebalancingKeysCountEstimateReceived(l);
                    }
                    gridCacheContext.cache().metrics0().onRebalanceBatchReceived(supplyMsg.messageSize());
                }
            } else {
                GridCacheContext cctx = this.grp.singleCacheContext();
                if (cctx.statisticsEnabled()) {
                    if (supplyMsg.estimatedKeysCount() != -1L) {
                        cctx.cache().metrics0().onRebalancingKeysCountEstimateReceived(supplyMsg.estimatedKeysCount());
                    }
                    cctx.cache().metrics0().onRebalanceBatchReceived(supplyMsg.messageSize());
                }
            }
            try {
                AffinityAssignment aff = this.grp.affinity().cachedAffinity(topVer);
                for (Map.Entry<Integer, CacheEntryInfoCollection> entry2 : supplyMsg.infos().entrySet()) {
                    int p = entry2.getKey();
                    if (aff.get(p).contains(this.ctx.localNode())) {
                        GridDhtLocalPartition part = top.localPartition(p, topVer, true);
                        assert (part != null);
                        boolean last2 = supplyMsg.last().containsKey(p);
                        if (part.state() == GridDhtPartitionState.MOVING) {
                            boolean reserved = part.reserve();
                            assert (reserved) : "Failed to reserve partition [igniteInstanceName=" + this.ctx.igniteInstanceName() + ", grp=" + this.grp.cacheOrGroupName() + ", part=" + part + ']';
                            part.lock();
                            try {
                                Iterator<GridCacheEntryInfo> infos = entry2.getValue().infos().iterator();
                                block12: while (infos.hasNext()) {
                                    this.ctx.database().checkpointReadLock();
                                    try {
                                        for (int i = 0; i < 100 && infos.hasNext(); ++i) {
                                            GridCacheEntryInfo entry22 = infos.next();
                                            if (!this.preloadEntry(node, p, entry22, topVer)) {
                                                if (!this.log.isTraceEnabled()) continue block12;
                                                this.log.trace("Got entries for invalid partition during preloading (will skip) [p=" + p + ", entry=" + entry22 + ']');
                                                continue block12;
                                            }
                                            for (GridCacheContext cctx : this.grp.caches()) {
                                                if (!cctx.statisticsEnabled()) continue;
                                                cctx.cache().metrics0().onRebalanceKeyReceived();
                                            }
                                        }
                                    }
                                    finally {
                                        this.ctx.database().checkpointReadUnlock();
                                    }
                                }
                                if (!last2) continue;
                                fut.partitionDone(nodeId, p, true);
                                if (!this.log.isDebugEnabled()) continue;
                                this.log.debug("Finished rebalancing partition: [" + this.demandRoutineInfo(topicId, nodeId, supplyMsg) + ", p=" + p + "]");
                                continue;
                            }
                            finally {
                                part.unlock();
                                part.release();
                                continue;
                            }
                        }
                        if (last2) {
                            fut.partitionDone(nodeId, p, false);
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Skipping rebalancing partition (state is not MOVING): [" + this.demandRoutineInfo(topicId, nodeId, supplyMsg) + ", p=" + p + "]");
                        continue;
                    }
                    fut.partitionDone(nodeId, p, false);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Skipping rebalancing partition (affinity changed): [" + this.demandRoutineInfo(topicId, nodeId, supplyMsg) + ", p=" + p + "]");
                }
                for (Integer n : supplyMsg.missed()) {
                    if (!aff.get(n).contains(this.ctx.localNode())) continue;
                    fut.partitionMissed(nodeId, n);
                }
                for (Integer n : supplyMsg.missed()) {
                    fut.partitionDone(nodeId, n, false);
                }
                GridDhtPartitionDemandMessage gridDhtPartitionDemandMessage = new GridDhtPartitionDemandMessage(supplyMsg.rebalanceId(), supplyMsg.topologyVersion(), this.grp.groupId());
                gridDhtPartitionDemandMessage.timeout(this.grp.config().getRebalanceTimeout());
                gridDhtPartitionDemandMessage.topic(this.rebalanceTopics.get(topicId));
                if (!this.topologyChanged(fut) && !fut.isDone()) {
                    try {
                        this.ctx.io().sendOrderedMessage(node, this.rebalanceTopics.get(topicId), gridDhtPartitionDemandMessage.convertIfNeeded(node.version()), this.grp.ioPolicy(), this.grp.config().getRebalanceTimeout());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Send next demand message [" + this.demandRoutineInfo(topicId, nodeId, supplyMsg) + "]");
                        }
                        break block39;
                    }
                    catch (ClusterTopologyCheckedException clusterTopologyCheckedException) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Supplier has left [" + this.demandRoutineInfo(topicId, nodeId, supplyMsg) + ", errMsg=" + clusterTopologyCheckedException.getMessage() + ']');
                        }
                        break block39;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Will not request next demand message [" + this.demandRoutineInfo(topicId, nodeId, supplyMsg) + ", topChanged=" + this.topologyChanged(fut) + ", rebalanceFuture=" + fut + "]");
                }
            }
            catch (IgniteCheckedException | IgniteSpiException e) {
                LT.error(this.log, e, "Error during rebalancing [" + this.demandRoutineInfo(topicId, nodeId, supplyMsg) + ", err=" + e + ']');
            }
        }
    }

    private boolean preloadEntry(ClusterNode from2, int p, GridCacheEntryInfo entry2, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        assert (this.ctx.database().checkpointLockIsHeldByThread());
        try {
            GridCacheEntryEx cached = null;
            try {
                GridCacheContext<Object, Object> cctx;
                GridCacheContext<Object, Object> gridCacheContext = cctx = this.grp.sharedGroup() ? this.ctx.cacheContext(entry2.cacheId()) : this.grp.singleCacheContext();
                if (cctx.isNear()) {
                    cctx = cctx.dhtCache().context();
                }
                cached = cctx.cache().entryEx(entry2.key());
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Rebalancing key [key=" + entry2.key() + ", part=" + p + ", node=" + from2.id() + ']');
                }
                if (this.preloadPred == null || this.preloadPred.apply(entry2)) {
                    if (cached.initialValue(entry2.value(), entry2.version(), cctx.mvccEnabled() ? ((MvccVersionAware)((Object)entry2)).mvccVersion() : null, cctx.mvccEnabled() ? ((MvccUpdateVersionAware)((Object)entry2)).newMvccVersion() : null, cctx.mvccEnabled() ? ((MvccVersionAware)((Object)entry2)).mvccTxState() : (byte)0, cctx.mvccEnabled() ? ((MvccUpdateVersionAware)((Object)entry2)).newMvccTxState() : (byte)0, entry2.ttl(), entry2.expireTime(), true, topVer, cctx.isDrEnabled() ? GridDrType.DR_PRELOAD : GridDrType.DR_NONE, false)) {
                        cached.touch(topVer);
                        if (cctx.events().isRecordable(84) && !cached.isInternal()) {
                            cctx.events().addEvent(cached.partition(), cached.key(), cctx.localNodeId(), (IgniteUuid)null, null, 84, entry2.value(), true, null, false, null, null, null, true);
                        }
                    } else {
                        cached.touch(topVer);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Rebalancing entry is already in cache (will ignore) [key=" + cached.key() + ", part=" + p + ']');
                        }
                    }
                } else if (this.log.isTraceEnabled()) {
                    this.log.trace("Rebalance predicate evaluated to false for entry (will ignore): " + entry2);
                }
            }
            catch (GridCacheEntryRemovedException ignored) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Entry has been concurrently removed while rebalancing (will ignore) [key=" + cached.key() + ", part=" + p + ']');
                }
            }
            catch (GridDhtInvalidPartitionException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partition became invalid during rebalancing (will ignore): " + p);
                }
                return false;
            }
        }
        catch (IgniteInterruptedCheckedException e) {
            throw e;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Failed to cache rebalanced entry (will stop rebalancing) [local=" + this.ctx.localNode() + ", node=" + from2.id() + ", key=" + entry2.key() + ", part=" + p + ']', e);
        }
        return true;
    }

    private String demandRoutineInfo(int topicId, UUID supplier, GridDhtPartitionSupplyMessage supplyMsg) {
        return "grp=" + this.grp.cacheOrGroupName() + ", topVer=" + supplyMsg.topologyVersion() + ", supplier=" + supplier + ", topic=" + topicId;
    }

    public String toString() {
        return S.toString(GridDhtPartitionDemander.class, this);
    }

    public static class RebalanceFuture
    extends GridFutureAdapter<Boolean> {
        private final GridCacheSharedContext<?, ?> ctx;
        private final CacheGroupContext grp;
        private final IgniteLogger log;
        private final Map<UUID, T2<Long, IgniteDhtDemandedPartitionsMap>> remaining = new HashMap<UUID, T2<Long, IgniteDhtDemandedPartitionsMap>>();
        private final Map<UUID, Collection<Integer>> missed = new HashMap<UUID, Collection<Integer>>();
        @GridToStringExclude
        private final GridDhtPartitionExchangeId exchId;
        private final AffinityTopologyVersion topVer;
        private final long rebalanceId;
        private final long routines;

        RebalanceFuture(CacheGroupContext grp, GridDhtPreloaderAssignments assignments, IgniteLogger log2, long rebalanceId) {
            assert (assignments != null);
            this.exchId = assignments.exchangeId();
            this.topVer = assignments.topologyVersion();
            assignments.forEach((k, v) -> {
                assert (v.partitions() != null) : "Partitions are null [grp=" + grp.cacheOrGroupName() + ", fromNode=" + k.id() + "]";
                this.remaining.put(k.id(), new T2<Long, IgniteDhtDemandedPartitionsMap>(U.currentTimeMillis(), v.partitions()));
            });
            this.routines = this.remaining.size();
            this.grp = grp;
            this.log = log2;
            this.rebalanceId = rebalanceId;
            this.ctx = grp.shared();
        }

        RebalanceFuture() {
            this.exchId = null;
            this.topVer = null;
            this.ctx = null;
            this.grp = null;
            this.log = null;
            this.rebalanceId = -1L;
            this.routines = 0L;
        }

        public AffinityTopologyVersion topologyVersion() {
            return this.topVer;
        }

        private boolean isActual(long rebalanceId) {
            return this.rebalanceId == rebalanceId;
        }

        private boolean isInitial() {
            return this.topVer == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            RebalanceFuture rebalanceFuture = this;
            synchronized (rebalanceFuture) {
                if (this.isDone()) {
                    return true;
                }
                U.log(this.log, "Cancelled rebalancing from all nodes [grp=" + this.grp.cacheOrGroupName() + ", topVer=" + this.topologyVersion() + "]");
                if (!this.ctx.kernalContext().isStopping()) {
                    for (UUID nodeId : this.remaining.keySet()) {
                        this.cleanupRemoteContexts(nodeId);
                    }
                }
                this.remaining.clear();
                this.checkIsDone(true);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel(UUID nodeId) {
            RebalanceFuture rebalanceFuture = this;
            synchronized (rebalanceFuture) {
                if (this.isDone()) {
                    return;
                }
                U.log(this.log, "Cancelled rebalancing [grp=" + this.grp.cacheOrGroupName() + ", supplier=" + nodeId + ", topVer=" + this.topologyVersion() + ", time=" + (U.currentTimeMillis() - (Long)this.remaining.get(nodeId).get1()) + " ms]");
                this.cleanupRemoteContexts(nodeId);
                this.remaining.remove(nodeId);
                this.onDone(false);
                this.checkIsDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void partitionMissed(UUID nodeId, int p) {
            RebalanceFuture rebalanceFuture = this;
            synchronized (rebalanceFuture) {
                if (this.isDone()) {
                    return;
                }
                this.missed.computeIfAbsent(nodeId, k -> new HashSet());
                this.missed.get(nodeId).add(p);
            }
        }

        private void cleanupRemoteContexts(UUID nodeId) {
            block4: {
                ClusterNode node = this.ctx.discovery().node(nodeId);
                if (node == null) {
                    return;
                }
                GridDhtPartitionDemandMessage d = new GridDhtPartitionDemandMessage(-this.rebalanceId, this.topologyVersion(), this.grp.groupId());
                d.timeout(this.grp.config().getRebalanceTimeout());
                try {
                    for (int idx = 0; idx < this.ctx.gridConfig().getRebalanceThreadPoolSize(); ++idx) {
                        d.topic(GridCachePartitionExchangeManager.rebalanceTopic(idx));
                        this.ctx.io().sendOrderedMessage(node, GridCachePartitionExchangeManager.rebalanceTopic(idx), d.convertIfNeeded(node.version()), this.grp.ioPolicy(), this.grp.config().getRebalanceTimeout());
                    }
                }
                catch (IgniteCheckedException ignored) {
                    if (!this.log.isDebugEnabled()) break block4;
                    this.log.debug("Failed to send failover context cleanup request to node " + nodeId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void partitionDone(UUID nodeId, int p, boolean updateState) {
            RebalanceFuture rebalanceFuture = this;
            synchronized (rebalanceFuture) {
                if (updateState && this.grp.localWalEnabled()) {
                    this.grp.topology().own(this.grp.topology().localPartition(p));
                }
                if (this.isDone()) {
                    return;
                }
                if (this.grp.eventRecordable(82)) {
                    this.rebalanceEvent(p, 82, this.exchId.discoveryEvent());
                }
                T2<Long, IgniteDhtDemandedPartitionsMap> t = this.remaining.get(nodeId);
                assert (t != null) : "Remaining not found [grp=" + this.grp.cacheOrGroupName() + ", fromNode=" + nodeId + ", part=" + p + "]";
                IgniteDhtDemandedPartitionsMap parts = (IgniteDhtDemandedPartitionsMap)t.get2();
                boolean rmvd = parts.remove(p);
                assert (rmvd) : "Partition already done [grp=" + this.grp.cacheOrGroupName() + ", fromNode=" + nodeId + ", part=" + p + ", left=" + parts + "]";
                if (parts.isEmpty()) {
                    int remainingRoutines = this.remaining.size() - 1;
                    U.log(this.log, "Completed " + (remainingRoutines == 0 ? "(final) " : "") + "rebalancing [grp=" + this.grp.cacheOrGroupName() + ", supplier=" + nodeId + ", topVer=" + this.topologyVersion() + ", progress=" + (this.routines - (long)remainingRoutines) + "/" + this.routines + ", time=" + (U.currentTimeMillis() - (Long)t.get1()) + " ms]");
                    this.remaining.remove(nodeId);
                }
                this.checkIsDone();
            }
        }

        private void rebalanceEvent(int part, int type, DiscoveryEvent discoEvt) {
            assert (discoEvt != null);
            this.grp.addRebalanceEvent(part, type, discoEvt.eventNode(), discoEvt.type(), discoEvt.timestamp());
        }

        private void rebalanceEvent(int type, DiscoveryEvent discoEvt) {
            this.rebalanceEvent(-1, type, discoEvt);
        }

        private void checkIsDone() {
            this.checkIsDone(false);
        }

        private void checkIsDone(boolean cancelled) {
            if (this.remaining.isEmpty()) {
                this.sendRebalanceFinishedEvent();
                if (this.log.isInfoEnabled()) {
                    this.log.info("Completed rebalance future: " + this);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partitions have been scheduled to resend [reason=Rebalance is done [grp=" + this.grp.cacheOrGroupName() + "]");
                }
                this.ctx.exchange().scheduleResendPartitions();
                HashSet<Integer> m = new HashSet<Integer>();
                for (Map.Entry<UUID, Collection<Integer>> e : this.missed.entrySet()) {
                    if (e.getValue() == null || e.getValue().isEmpty()) continue;
                    m.addAll(e.getValue());
                }
                if (!m.isEmpty()) {
                    U.log(this.log, "Reassigning partitions that were missed: " + m);
                    this.onDone(false);
                    this.ctx.exchange().forceReassign(this.exchId);
                    return;
                }
                if (!cancelled && !this.grp.preloader().syncFuture().isDone()) {
                    ((GridFutureAdapter)this.grp.preloader().syncFuture()).onDone();
                }
                this.onDone(!cancelled);
            }
        }

        private synchronized Collection<UUID> remainingNodes() {
            return this.remaining.keySet();
        }

        private void sendRebalanceStartedEvent() {
            if (this.grp.eventRecordable(80)) {
                this.rebalanceEvent(80, this.exchId.discoveryEvent());
            }
        }

        private void sendRebalanceFinishedEvent() {
            if (this.grp.eventRecordable(81)) {
                this.rebalanceEvent(81, this.exchId.discoveryEvent());
            }
        }

        @Override
        public String toString() {
            return S.toString(RebalanceFuture.class, this);
        }
    }
}

