/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;

public class CachePartitionPartialCountersMap
implements Serializable {
    private static final long serialVersionUID = 0L;
    static final IgniteProductVersion PARTIAL_COUNTERS_MAP_SINCE = IgniteProductVersion.fromString("2.1.4");
    public static final CachePartitionPartialCountersMap EMPTY = new CachePartitionPartialCountersMap();
    private int[] partIds;
    private long[] initialUpdCntrs;
    private long[] updCntrs;
    private int curIdx;

    private CachePartitionPartialCountersMap() {
    }

    public CachePartitionPartialCountersMap(int partsCnt) {
        this.partIds = new int[partsCnt];
        this.initialUpdCntrs = new long[partsCnt];
        this.updCntrs = new long[partsCnt];
    }

    public int size() {
        return this.curIdx;
    }

    public boolean isEmpty() {
        return this.curIdx == 0;
    }

    public void add(int partId, long initialUpdCntr, long updCntr) {
        if (this.curIdx > 0 && this.partIds[this.curIdx - 1] >= partId) {
            throw new IllegalArgumentException("Adding a partition in the wrong order [prevPart=" + this.partIds[this.curIdx - 1] + ", partId=" + partId + ']');
        }
        if (this.curIdx == this.partIds.length) {
            throw new IllegalStateException("Adding more partitions than reserved: " + this.partIds.length);
        }
        this.partIds[this.curIdx] = partId;
        this.initialUpdCntrs[this.curIdx] = initialUpdCntr;
        this.updCntrs[this.curIdx] = updCntr;
        ++this.curIdx;
    }

    public boolean remove(int partId) {
        int removedIdx = this.partitionIndex(partId);
        if (removedIdx < 0) {
            return false;
        }
        int lastIdx = --this.curIdx;
        for (int i = removedIdx; i < lastIdx; ++i) {
            this.partIds[i] = this.partIds[i + 1];
            this.initialUpdCntrs[i] = this.initialUpdCntrs[i + 1];
            this.updCntrs[i] = this.updCntrs[i + 1];
        }
        this.partIds[lastIdx] = 0;
        this.initialUpdCntrs[lastIdx] = 0L;
        this.updCntrs[lastIdx] = 0L;
        return true;
    }

    public void trim() {
        if (this.partIds != null && this.curIdx < this.partIds.length) {
            this.partIds = Arrays.copyOf(this.partIds, this.curIdx);
            this.initialUpdCntrs = Arrays.copyOf(this.initialUpdCntrs, this.curIdx);
            this.updCntrs = Arrays.copyOf(this.updCntrs, this.curIdx);
        }
    }

    public int partitionIndex(int partId) {
        return Arrays.binarySearch(this.partIds, 0, this.curIdx, partId);
    }

    public boolean contains(int partId) {
        return this.partitionIndex(partId) >= 0;
    }

    public int partitionAt(int idx) {
        return this.partIds[idx];
    }

    public long initialUpdateCounterAt(int idx) {
        return this.initialUpdCntrs[idx];
    }

    public long updateCounterAt(int idx) {
        return this.updCntrs[idx];
    }

    public static Map<Integer, T2<Long, Long>> toCountersMap(CachePartitionPartialCountersMap cntrsMap) {
        if (cntrsMap.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<Integer, T2<Long, Long>> res = U.newHashMap(cntrsMap.size());
        for (int idx = 0; idx < cntrsMap.size(); ++idx) {
            res.put(cntrsMap.partitionAt(idx), new T2<Long, Long>(cntrsMap.initialUpdateCounterAt(idx), cntrsMap.updateCounterAt(idx)));
        }
        return res;
    }

    static CachePartitionPartialCountersMap fromCountersMap(Map<Integer, T2<Long, Long>> map2, int partsCnt) {
        CachePartitionPartialCountersMap map0 = new CachePartitionPartialCountersMap(partsCnt);
        TreeMap<Integer, T2<Long, Long>> sorted2 = new TreeMap<Integer, T2<Long, Long>>(map2);
        for (Map.Entry<Integer, T2<Long, Long>> e : sorted2.entrySet()) {
            map0.add(e.getKey(), (Long)e.getValue().get1(), (Long)e.getValue().get2());
        }
        map0.trim();
        return map0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CachePartitionPartialCountersMap {");
        for (int i = 0; i < this.partIds.length; ++i) {
            sb.append(this.partIds[i]).append("=(").append(this.initialUpdCntrs[i]).append(",").append(this.updCntrs[i]).append(")");
            if (i == this.partIds.length - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

