/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class UpdateErrors
implements Message {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> failedKeys;
    @GridDirectTransient
    @GridToStringInclude
    private IgniteCheckedException err;
    private byte[] errBytes;

    public UpdateErrors() {
    }

    public UpdateErrors(IgniteCheckedException err2) {
        assert (err2 != null);
        this.err = err2;
    }

    public void onError(IgniteCheckedException err2) {
        this.err = err2;
    }

    public IgniteCheckedException error() {
        return this.err;
    }

    public Collection<KeyCacheObject> failedKeys() {
        return this.failedKeys;
    }

    void addFailedKey(KeyCacheObject key, Throwable e) {
        if (this.failedKeys == null) {
            this.failedKeys = new ArrayList<KeyCacheObject>();
        }
        this.failedKeys.add(key);
        if (this.err == null) {
            this.err = new IgniteCheckedException("Failed to update keys.");
        }
        this.err.addSuppressed(e);
    }

    void addFailedKeys(Collection<KeyCacheObject> keys, Throwable e) {
        if (this.failedKeys == null) {
            this.failedKeys = new ArrayList<KeyCacheObject>(keys.size());
        }
        this.failedKeys.addAll(keys);
        if (this.err == null) {
            this.err = new IgniteCheckedException("Failed to update keys on primary node.");
        }
        this.err.addSuppressed(e);
    }

    void prepareMarshal(GridCacheMessage msg, GridCacheContext cctx) throws IgniteCheckedException {
        msg.prepareMarshalCacheObjects(this.failedKeys, cctx);
        if (this.errBytes == null) {
            this.errBytes = U.marshal(cctx.marshaller(), (Object)this.err);
        }
    }

    void finishUnmarshal(GridCacheMessage msg, GridCacheContext cctx, ClassLoader ldr) throws IgniteCheckedException {
        msg.finishUnmarshalCacheObjects(this.failedKeys, cctx, ldr);
        if (this.errBytes != null && this.err == null) {
            this.err = (IgniteCheckedException)U.unmarshal(cctx.marshaller(), this.errBytes, U.resolveClassLoader(ldr, cctx.gridConfig()));
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeCollection("failedKeys", this.failedKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.failedKeys = (List)reader.readCollection("failedKeys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(UpdateErrors.class);
    }

    @Override
    public short directType() {
        return -49;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(UpdateErrors.class, this);
    }
}

