/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.CacheDistributedGetFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetResponse;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTrackerImpl;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotResponseListener;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridPartitionedGetFuture<K, V>
extends CacheDistributedGetFutureAdapter<K, V>
implements MvccSnapshotResponseListener {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    protected final MvccSnapshot mvccSnapshot;
    private MvccQueryTracker mvccTracker;

    public GridPartitionedGetFuture(GridCacheContext<K, V> cctx, Collection<KeyCacheObject> keys, boolean readThrough, boolean forcePrimary, @Nullable UUID subjId, String taskName, boolean deserializeBinary, boolean recovery, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObjects, @Nullable MvccSnapshot mvccSnapshot) {
        super(cctx, keys, readThrough, forcePrimary, subjId, taskName, deserializeBinary, expiryPlc, skipVals, needVer, keepCacheObjects, recovery);
        assert (mvccSnapshot == null || cctx.mvccEnabled());
        this.mvccSnapshot = mvccSnapshot;
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridPartitionedGetFuture.class);
        }
    }

    @Nullable
    private MvccSnapshot mvccSnapshot() {
        if (!this.cctx.mvccEnabled()) {
            return null;
        }
        if (this.mvccSnapshot != null) {
            return this.mvccSnapshot;
        }
        MvccSnapshot snapshot2 = this.mvccTracker.snapshot();
        assert (snapshot2 != null) : "[fut=" + this + ", mvccTracker=" + this.mvccTracker + "]";
        return snapshot2;
    }

    public void init(AffinityTopologyVersion topVer) {
        AffinityTopologyVersion lockedTopVer = this.cctx.shared().lockedTopologyVersion(null);
        if (lockedTopVer != null) {
            topVer = lockedTopVer;
            this.canRemap = false;
        } else {
            AffinityTopologyVersion affinityTopologyVersion = topVer.topologyVersion() > 0L ? topVer : (topVer = this.canRemap ? this.cctx.affinity().affinityTopologyVersion() : this.cctx.shared().exchange().readyAffinityVersion());
        }
        if (!this.cctx.mvccEnabled() || this.mvccSnapshot != null) {
            this.initialMap(topVer);
        } else {
            this.mvccTracker = new MvccQueryTrackerImpl(this.cctx, this.canRemap);
            this.trackable = true;
            this.cctx.mvcc().addFuture(this, this.futId);
            this.mvccTracker.requestSnapshot(topVer, this);
        }
    }

    @Override
    public void onResponse(MvccSnapshot res) {
        AffinityTopologyVersion topVer = this.mvccTracker.topologyVersion();
        assert (topVer != null);
        this.initialMap(topVer);
    }

    @Override
    public void onError(IgniteCheckedException e) {
        this.onDone(e);
    }

    private void initialMap(AffinityTopologyVersion topVer) {
        this.map(this.keys, Collections.emptyMap(), topVer);
        this.markInitialized();
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f2;
            if (!this.isMini(fut) || !(f2 = (MiniFuture)fut).node().id().equals(nodeId)) continue;
            found = true;
            f2.onNodeLeft(new ClusterTopologyCheckedException("Remote node left grid (will retry): " + nodeId));
        }
        return found;
    }

    @Override
    public void onResult(UUID nodeId, GridNearGetResponse res) {
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f2;
            if (!this.isMini(fut) || !(f2 = (MiniFuture)fut).futureId().equals(res.miniId())) continue;
            assert (f2.node().id().equals(nodeId));
            f2.onResult(res);
        }
    }

    @Override
    public boolean onDone(Map<K, V> res, Throwable err2) {
        if (super.onDone(res, err2)) {
            if (this.trackable) {
                this.cctx.mvcc().removeFuture(this.futId);
            }
            if (this.mvccTracker != null) {
                this.mvccTracker.onDone();
            }
            this.cache().sendTtlUpdateRequest(this.expiryPlc);
            return true;
        }
        return false;
    }

    private boolean isMini(IgniteInternalFuture<?> f2) {
        return f2.getClass().equals(MiniFuture.class);
    }

    private void map(Collection<KeyCacheObject> keys, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mapped, AffinityTopologyVersion topVer) {
        Throwable err2;
        Collection<ClusterNode> cacheNodes = CU.affinityNodes(this.cctx, topVer);
        if (cacheNodes.isEmpty()) {
            this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid) [topVer=" + topVer + ", cache=" + this.cctx.name() + ']'));
            return;
        }
        GridDhtTopologyFuture topFut = this.cctx.shared().exchange().lastFinishedFuture();
        Throwable throwable2 = err2 = topFut != null ? topFut.validateCache(this.cctx, this.recovery, true, null, keys) : null;
        if (err2 != null) {
            this.onDone(err2);
            return;
        }
        HashMap<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mappings = U.newHashMap(cacheNodes.size());
        int keysSize = keys.size();
        HashMap locVals = U.newHashMap(keysSize);
        boolean hasRmtNodes = false;
        for (KeyCacheObject keyCacheObject : keys) {
            hasRmtNodes |= this.map(keyCacheObject, mappings, locVals, topVer, mapped);
        }
        if (this.isDone()) {
            return;
        }
        if (!locVals.isEmpty()) {
            this.add(new GridFinishedFuture(locVals));
        }
        if (hasRmtNodes && !this.trackable) {
            this.trackable = true;
            this.cctx.mvcc().addFuture(this, this.futId);
        }
        for (Map.Entry entry2 : mappings.entrySet()) {
            IgniteInternalFuture fut;
            ClusterNode n = (ClusterNode)entry2.getKey();
            LinkedHashMap mappedKeys = (LinkedHashMap)entry2.getValue();
            assert (!mappedKeys.isEmpty());
            if (n.isLocal()) {
                fut = this.cache().getDhtAsync(n.id(), -1L, mappedKeys, false, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc, this.skipVals, this.recovery, this.mvccSnapshot());
                Collection<Integer> invalidParts = fut.invalidPartitions();
                if (!F.isEmpty(invalidParts)) {
                    ArrayList<KeyCacheObject> remapKeys = new ArrayList<KeyCacheObject>(keysSize);
                    for (KeyCacheObject key : keys) {
                        if (key == null || !invalidParts.contains(this.cctx.affinity().partition(key))) continue;
                        remapKeys.add(key);
                    }
                    AffinityTopologyVersion updTopVer = this.cctx.shared().exchange().readyAffinityVersion();
                    assert (updTopVer.compareTo(topVer) > 0) : "Got invalid partitions for local node but topology version did not change [topVer=" + topVer + ", updTopVer=" + updTopVer + ", invalidParts=" + invalidParts + ']';
                    this.map(remapKeys, mappings, updTopVer);
                }
                this.add(fut.chain(new C1<IgniteInternalFuture<Collection<GridCacheEntryInfo>>, Map<K, V>>(){

                    @Override
                    public Map<K, V> apply(IgniteInternalFuture<Collection<GridCacheEntryInfo>> fut) {
                        try {
                            return GridPartitionedGetFuture.this.createResultMap(fut.get());
                        }
                        catch (Exception e) {
                            U.error(log, "Failed to get values from dht cache [fut=" + fut + "]", e);
                            GridPartitionedGetFuture.this.onDone(e);
                            return Collections.emptyMap();
                        }
                    }
                }));
                continue;
            }
            fut = new MiniFuture(n, mappedKeys, topVer, CU.createBackupPostProcessingClosure(topVer, log, this.cctx, null, this.expiryPlc, this.readThrough, this.skipVals));
            GridNearGetRequest req = new GridNearGetRequest(this.cctx.cacheId(), this.futId, ((MiniFuture)fut).futureId(), null, mappedKeys, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc != null ? this.expiryPlc.forCreate() : -1L, this.expiryPlc != null ? this.expiryPlc.forAccess() : -1L, false, this.skipVals, this.cctx.deploymentEnabled(), this.recovery, this.mvccSnapshot());
            this.add(fut);
            try {
                this.cctx.io().send(n, (GridCacheMessage)req, this.cctx.ioPolicy());
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    ((MiniFuture)fut).onNodeLeft((ClusterTopologyCheckedException)e);
                    continue;
                }
                ((MiniFuture)fut).onResult(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean map(KeyCacheObject key, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mappings, Map<K, V> locVals, AffinityTopologyVersion topVer, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mapped) {
        ClusterNode node;
        boolean fastLocGet;
        int part = this.cctx.affinity().partition(key);
        List<ClusterNode> affNodes = this.cctx.affinity().nodesByPartition(part, topVer);
        if (affNodes.isEmpty()) {
            this.onDone(this.serverNotFoundError(topVer));
            return false;
        }
        boolean bl = fastLocGet = !this.cctx.mvccEnabled() && (!this.forcePrimary || affNodes.get(0).isLocal()) && this.cctx.reserveForFastLocalGet(part, topVer);
        if (fastLocGet) {
            try {
                if (this.localGet(topVer, key, part, locVals)) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
            finally {
                this.cctx.releaseForFastLocalGet(part, topVer);
            }
        }
        if ((node = this.cctx.selectAffinityNodeBalanced(affNodes, this.canRemap)) == null) {
            this.onDone(this.serverNotFoundError(topVer));
            return false;
        }
        boolean remote2 = !node.isLocal();
        LinkedHashMap<KeyCacheObject, Boolean> keys = mapped.get(node);
        if (keys != null && keys.containsKey(key) && REMAP_CNT_UPD.incrementAndGet(this) > MAX_REMAP_CNT) {
            this.onDone(new ClusterTopologyCheckedException("Failed to remap key to a new node after " + MAX_REMAP_CNT + " attempts (key got remapped to the same node) [key=" + key + ", node=" + U.toShortString(node) + ", mappings=" + mapped + ']'));
            return false;
        }
        LinkedHashMap<KeyCacheObject, Boolean> old = mappings.get(node);
        if (old == null) {
            old = new LinkedHashMap(3, 1.0f);
            mappings.put(node, old);
        }
        old.put(key, false);
        return remote2;
    }

    private boolean localGet(AffinityTopologyVersion topVer, KeyCacheObject key, int part, Map<K, V> locVals) {
        assert (this.cctx.affinityNode()) : this;
        GridDhtCacheAdapter<K, V> cache = this.cache();
        boolean readNoEntry = this.cctx.readNoEntry(this.expiryPlc, false);
        boolean evt = !this.skipVals;
        while (true) {
            try {
                boolean topStable;
                GridCacheEntryEx entry2;
                boolean skipEntry = readNoEntry;
                EntryGetResult getRes = null;
                CacheObject v = null;
                GridCacheVersion ver = null;
                if (readNoEntry) {
                    CacheDataRow row;
                    CacheDataRow cacheDataRow = row = this.cctx.mvccEnabled() ? this.cctx.offheap().mvccRead(this.cctx, key, this.mvccSnapshot()) : this.cctx.offheap().read(this.cctx, key);
                    if (row != null) {
                        long expireTime = row.expireTime();
                        if (expireTime == 0L || expireTime > U.currentTimeMillis()) {
                            v = row.value();
                            if (this.needVer) {
                                ver = row.version();
                            }
                            if (evt) {
                                this.cctx.events().readEvent(key, null, row.value(), this.subjId, this.taskName, !this.deserializeBinary);
                            }
                        } else {
                            skipEntry = false;
                        }
                    }
                }
                if (!skipEntry && (entry2 = cache.entryEx(key)) != null) {
                    boolean isNew = entry2.isNewLocked();
                    if (this.needVer) {
                        getRes = entry2.innerGetVersioned(null, null, false, evt, this.subjId, null, this.taskName, this.expiryPlc, !this.deserializeBinary, this.mvccSnapshot(), null);
                        if (getRes != null) {
                            v = (CacheObject)getRes.value();
                            ver = getRes.version();
                        }
                    } else {
                        v = entry2.innerGet(null, null, false, false, evt, this.subjId, null, this.taskName, this.expiryPlc, !this.deserializeBinary, this.mvccSnapshot());
                    }
                    entry2.touch(topVer);
                    if (v == null && isNew && entry2.markObsoleteIfEmpty(ver)) {
                        cache.removeEntry(entry2);
                    }
                }
                if (v != null) {
                    this.cctx.addResult(locVals, key, v, this.skipVals, this.keepCacheObjects, this.deserializeBinary, true, getRes, ver, 0L, 0L, this.needVer);
                    return true;
                }
                boolean bl = topStable = this.cctx.isReplicated() || topVer.equals(this.cctx.topology().lastTopologyChangeVersion());
                if (!this.cctx.readThroughConfigured() && (topStable || this.partitionOwned(part))) {
                    if (!this.skipVals && this.cctx.statisticsEnabled()) {
                        cache.metrics0().onRead(false);
                    }
                    return true;
                }
                return false;
            }
            catch (GridCacheEntryRemovedException skipEntry) {
                continue;
            }
            catch (GridDhtInvalidPartitionException ignored) {
                return false;
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
                return true;
            }
            break;
        }
    }

    private GridDhtCacheAdapter<K, V> cache() {
        return this.cctx.dht();
    }

    private Map<K, V> createResultMap(Collection<GridCacheEntryInfo> infos) {
        int keysSize = infos.size();
        if (keysSize != 0) {
            GridLeanMap map2 = new GridLeanMap(keysSize);
            for (GridCacheEntryInfo info2 : infos) {
                assert (this.skipVals == (info2.value() == null));
                this.cctx.addResult(map2, info2.key(), info2.value(), this.skipVals, this.keepCacheObjects, this.deserializeBinary, false, this.needVer ? info2.version() : null, 0L, 0L);
            }
            return map2;
        }
        return Collections.emptyMap();
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f2) {
                if (GridPartitionedGetFuture.this.isMini(f2)) {
                    return "[node=" + ((MiniFuture)f2).node().id() + ", loc=" + ((MiniFuture)f2).node().isLocal() + ", done=" + f2.isDone() + "]";
                }
                return "[loc=true, done=" + f2.isDone() + "]";
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridPartitionedGetFuture.class, this, "innerFuts", futs, "super", super.toString());
    }

    private class MiniFuture
    extends GridFutureAdapter<Map<K, V>> {
        private final IgniteUuid futId = IgniteUuid.randomUuid();
        private final ClusterNode node;
        @GridToStringInclude
        private final LinkedHashMap<KeyCacheObject, Boolean> keys;
        private final AffinityTopologyVersion topVer;
        private final IgniteInClosure<Collection<GridCacheEntryInfo>> postProcessingClos;
        private boolean remapped;

        MiniFuture(ClusterNode node, LinkedHashMap<KeyCacheObject, Boolean> keys, @Nullable AffinityTopologyVersion topVer, IgniteInClosure<Collection<GridCacheEntryInfo>> postProcessingClos) {
            this.node = node;
            this.keys = keys;
            this.topVer = topVer;
            this.postProcessingClos = postProcessingClos;
        }

        IgniteUuid futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.node;
        }

        public Collection<KeyCacheObject> keys() {
            return this.keys.keySet();
        }

        void onResult(Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get future result [fut=" + this + ", err=" + e + ']');
            }
            this.onDone(e);
        }

        synchronized void onNodeLeft(ClusterTopologyCheckedException e) {
            if (this.remapped) {
                return;
            }
            this.remapped = true;
            if (log.isDebugEnabled()) {
                log.debug("Remote node left grid while sending or waiting for reply (will retry): " + this);
            }
            if (!GridPartitionedGetFuture.this.canRemap) {
                GridPartitionedGetFuture.this.map(this.keys.keySet(), F.t(this.node, this.keys), this.topVer);
                this.onDone(Collections.emptyMap());
            } else {
                AffinityTopologyVersion updTopVer = new AffinityTopologyVersion(Math.max(this.topVer.topologyVersion() + 1L, GridPartitionedGetFuture.this.cctx.discovery().topologyVersion()));
                GridPartitionedGetFuture.this.cctx.shared().exchange().affinityReadyFuture(updTopVer).listen((IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>)new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                    @Override
                    public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                        try {
                            GridPartitionedGetFuture.this.map(MiniFuture.this.keys.keySet(), F.t(MiniFuture.this.node, MiniFuture.this.keys), fut.get());
                            MiniFuture.this.onDone(Collections.emptyMap());
                        }
                        catch (IgniteCheckedException e) {
                            GridPartitionedGetFuture.this.onDone(e);
                        }
                    }
                });
            }
        }

        void onResult(final GridNearGetResponse res) {
            final Collection<Integer> invalidParts = res.invalidPartitions();
            if (res.error() != null) {
                this.onDone(res.error());
                return;
            }
            if (!F.isEmpty(invalidParts)) {
                AffinityTopologyVersion rmtTopVer = res.topologyVersion();
                assert (!rmtTopVer.equals(AffinityTopologyVersion.ZERO));
                if (rmtTopVer.compareTo(this.topVer) <= 0) {
                    this.onDone(new IgniteCheckedException("Failed to process invalid partitions response (remote node reported invalid partitions but remote topology version does not differ from local) [topVer=" + this.topVer + ", rmtTopVer=" + rmtTopVer + ", invalidParts=" + invalidParts + ", nodeId=" + this.node.id() + ']'));
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Remapping mini get future [invalidParts=" + invalidParts + ", fut=" + this + ']');
                }
                if (!GridPartitionedGetFuture.this.canRemap) {
                    GridPartitionedGetFuture.this.map(F.view(this.keys.keySet(), new P1<KeyCacheObject>(){

                        @Override
                        public boolean apply(KeyCacheObject key) {
                            return invalidParts.contains(GridPartitionedGetFuture.this.cctx.affinity().partition(key));
                        }
                    }), F.t(this.node, this.keys), this.topVer);
                    this.postProcessResult(res);
                    this.onDone(GridPartitionedGetFuture.this.createResultMap(res.entries()));
                    return;
                }
                IgniteInternalFuture<AffinityTopologyVersion> topFut = GridPartitionedGetFuture.this.cctx.shared().exchange().affinityReadyFuture(rmtTopVer);
                topFut.listen((IgniteInClosure<IgniteInternalFuture<AffinityTopologyVersion>>)new CIX1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                    @Override
                    public void applyx(IgniteInternalFuture<AffinityTopologyVersion> fut) throws IgniteCheckedException {
                        AffinityTopologyVersion topVer = fut.get();
                        GridPartitionedGetFuture.this.map(F.view(MiniFuture.this.keys.keySet(), new P1<KeyCacheObject>(){

                            @Override
                            public boolean apply(KeyCacheObject key) {
                                return invalidParts.contains(GridPartitionedGetFuture.this.cctx.affinity().partition(key));
                            }
                        }), F.t(MiniFuture.this.node, MiniFuture.this.keys), topVer);
                        MiniFuture.this.postProcessResult(res);
                        MiniFuture.this.onDone(GridPartitionedGetFuture.this.createResultMap(res.entries()));
                    }
                });
            } else {
                try {
                    this.postProcessResult(res);
                    this.onDone(GridPartitionedGetFuture.this.createResultMap(res.entries()));
                }
                catch (Exception e) {
                    this.onDone(e);
                }
            }
        }

        private void postProcessResult(GridNearGetResponse res) {
            if (this.postProcessingClos != null) {
                this.postProcessingClos.apply(res.entries());
            }
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this);
        }
    }
}

