/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxQueryEnlistRequest;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotWithoutTxs;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtTxQueryFirstEnlistRequest
extends GridDhtTxQueryEnlistRequest {
    private static final long serialVersionUID = -7494735627739420176L;
    private UUID subjId;
    private AffinityTopologyVersion topVer;
    private long crdVer;
    private long cntr;
    private long cleanupVer;
    private long timeout;
    private int taskNameHash;
    private UUID nearNodeId;
    private GridCacheVersion nearXidVer;

    public GridDhtTxQueryFirstEnlistRequest() {
    }

    GridDhtTxQueryFirstEnlistRequest(int cacheId, IgniteUuid dhtFutId, UUID subjId, AffinityTopologyVersion topVer, GridCacheVersion lockVer, MvccSnapshot snapshot2, long timeout, int taskNameHash, UUID nearNodeId, GridCacheVersion nearXidVer, EnlistOperation op, int batchId, List<KeyCacheObject> keys, List<Message> vals) {
        super(cacheId, dhtFutId, lockVer, op, batchId, snapshot2.operationCounter(), keys, vals);
        this.cacheId = cacheId;
        this.subjId = subjId;
        this.topVer = topVer;
        this.crdVer = snapshot2.coordinatorVersion();
        this.cntr = snapshot2.counter();
        this.cleanupVer = snapshot2.cleanupVersion();
        this.timeout = timeout;
        this.taskNameHash = taskNameHash;
        this.nearNodeId = nearNodeId;
        this.nearXidVer = nearXidVer;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public UUID nearNodeId() {
        return this.nearNodeId;
    }

    public GridCacheVersion nearXidVersion() {
        return this.nearXidVer;
    }

    public long timeout() {
        return this.timeout;
    }

    public UUID subjectId() {
        return this.subjId;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    public MvccSnapshot mvccSnapshot() {
        return new MvccSnapshotWithoutTxs(this.crdVer, this.cntr, this.operationCounter(), this.cleanupVer);
    }

    public long coordinatorVersion() {
        return this.crdVer;
    }

    public long counter() {
        return this.cntr;
    }

    public long cleanupVersion() {
        return this.cleanupVer;
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public short directType() {
        return 156;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 10: {
                if (!writer.writeLong("cleanupVer", this.cleanupVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeLong("cntr", this.cntr)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeLong("crdVer", this.crdVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeUuid("nearNodeId", this.nearNodeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeMessage("nearXidVer", this.nearXidVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 17: {
                if (!writer.writeLong("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 18: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 10: {
                this.cleanupVer = reader.readLong("cleanupVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.cntr = reader.readLong("cntr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.crdVer = reader.readLong("crdVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.nearNodeId = reader.readUuid("nearNodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.nearXidVer = (GridCacheVersion)reader.readMessage("nearXidVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 17: {
                this.timeout = reader.readLong("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 18: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtTxQueryFirstEnlistRequest.class);
    }

    @Override
    public byte fieldsCount() {
        return 19;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtTxQueryFirstEnlistRequest.class, this);
    }
}

