/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtTxQueryEnlistResponse
extends GridCacheIdMessage {
    private static final long serialVersionUID = -1510546400896574705L;
    private IgniteUuid futId;
    private int batchId;
    @GridDirectTransient
    private Throwable err;
    private byte[] errBytes;

    public GridDhtTxQueryEnlistResponse() {
    }

    GridDhtTxQueryEnlistResponse(int cacheId, IgniteUuid futId, int batchId, Throwable err2) {
        this.cacheId = cacheId;
        this.futId = futId;
        this.batchId = batchId;
        this.err = err2;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public int batchId() {
        return this.batchId;
    }

    @Override
    public Throwable error() {
        return this.err;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.err != null && this.errBytes == null) {
            this.errBytes = U.marshal(ctx.marshaller(), (Object)this.err);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.errBytes != null) {
            this.err = (Throwable)U.unmarshal(ctx, this.errBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public short directType() {
        return 144;
    }

    @Override
    public byte fieldsCount() {
        return 6;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeInt("batchId", this.batchId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.batchId = reader.readInt("batchId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtTxQueryEnlistResponse.class);
    }

    @Override
    public String toString() {
        return S.toString(GridDhtTxQueryEnlistResponse.class, this);
    }
}

