/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridDhtTxMapping {
    private final Map<UUID, Collection<UUID>> txNodes = new GridLeanMap<UUID, Collection<UUID>>();

    public void addMapping(List<ClusterNode> nodes2) {
        assert (!F.isEmpty(nodes2)) : nodes2;
        ClusterNode primary = nodes2.get(0);
        int size2 = nodes2.size();
        if (size2 > 1) {
            Collection<UUID> backups = this.txNodes.get(primary.id());
            if (backups == null) {
                backups = U.newHashSet(size2 - 1);
                this.txNodes.put(primary.id(), backups);
            }
            for (int i = 1; i < size2; ++i) {
                backups.add(nodes2.get(i).id());
            }
        } else {
            this.txNodes.put(primary.id(), new GridLeanSet());
        }
    }

    public Map<UUID, Collection<UUID>> transactionNodes() {
        return this.txNodes;
    }
}

