/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.cache.CacheEntryInfoCollection;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheFutureAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheUpdateTxResult;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.CompoundLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.DhtLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxQueryEnlistRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxQueryEnlistResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxQueryFirstEnlistRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridInvokeValue;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxAbstractEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxSelectForUpdateFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccLinkAwareSearchRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.UpdateSourceIterator;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridDhtTxAbstractEnlistFuture<T>
extends GridCacheFutureAdapter<T>
implements DhtLockFuture<T> {
    private static final AtomicIntegerFieldUpdater<GridDhtTxAbstractEnlistFuture> DONE_UPD = AtomicIntegerFieldUpdater.newUpdater(GridDhtTxAbstractEnlistFuture.class, "done");
    private static final AtomicIntegerFieldUpdater<GridDhtTxAbstractEnlistFuture> SKIP_UPD = AtomicIntegerFieldUpdater.newUpdater(GridDhtTxAbstractEnlistFuture.class, "skipCntr");
    private static final Object FINISHED = new Object();
    private static final int BATCH_SIZE = 1024;
    private static final int BATCHES_PER_NODE = 5;
    private static final int FIRST_BATCH_ID = 0;
    protected final IgniteUuid futId;
    @GridToStringExclude
    protected final GridCacheContext<?, ?> cctx;
    @GridToStringExclude
    protected final IgniteLogger log;
    protected final long threadId;
    protected final IgniteUuid nearFutId;
    protected final int nearMiniId;
    protected final int[] parts;
    protected final GridDhtTxLocalAdapter tx;
    protected final GridCacheVersion lockVer;
    protected final MvccSnapshot mvccSnapshot;
    protected Set<UUID> newDhtNodes = new HashSet<UUID>();
    protected final UUID nearNodeId;
    protected final GridCacheVersion nearLockVer;
    private final CacheEntryPredicate filter;
    @GridToStringExclude
    protected LockTimeoutObject timeoutObj;
    protected final long timeout;
    private UpdateSourceIterator<?> it;
    private Object peek;
    @GridToStringExclude
    private volatile int skipCntr;
    @GridToStringExclude
    private volatile int done;
    @GridToStringExclude
    private int batchIdCntr;
    private Map<UUID, Batch> batches;
    private ConcurrentMap<UUID, ConcurrentMap<Integer, Batch>> pending;
    protected boolean skipNearNodeUpdates;
    protected boolean hasNearNodeUpdates;
    private Map<Integer, Boolean> movingParts;
    private final Set<ClusterNode> firstReqSent = new HashSet<ClusterNode>();

    protected GridDhtTxAbstractEnlistFuture(UUID nearNodeId, GridCacheVersion nearLockVer, MvccSnapshot mvccSnapshot, long threadId, IgniteUuid nearFutId, int nearMiniId, @Nullable int[] parts, GridDhtTxLocalAdapter tx, long timeout, GridCacheContext<?, ?> cctx, @Nullable CacheEntryPredicate filter2) {
        assert (tx != null);
        assert (timeout >= 0L);
        assert (nearNodeId != null);
        assert (nearLockVer != null);
        assert (threadId == tx.threadId());
        this.threadId = threadId;
        this.cctx = cctx;
        this.nearNodeId = nearNodeId;
        this.nearLockVer = nearLockVer;
        this.nearFutId = nearFutId;
        this.nearMiniId = nearMiniId;
        this.mvccSnapshot = mvccSnapshot;
        this.timeout = timeout;
        this.tx = tx;
        this.parts = parts;
        this.filter = filter2;
        this.lockVer = tx.xidVersion();
        this.futId = IgniteUuid.randomUuid();
        this.log = cctx.logger(GridDhtTxAbstractEnlistFuture.class);
    }

    protected abstract UpdateSourceIterator<?> createIterator() throws IgniteCheckedException;

    protected abstract T result0();

    public boolean needResult() {
        return false;
    }

    protected abstract void onEntryProcessed(KeyCacheObject var1, GridCacheUpdateTxResult var2);

    public void init() {
        if (this.timeout < 0L) {
            this.onDone(this.timeoutException());
            return;
        }
        if (this.timeout > 0L) {
            this.timeoutObj = new LockTimeoutObject();
        }
        do {
            IgniteInternalFuture<?> fut;
            if ((fut = this.tx.lockFut) == GridDhtTxLocalAdapter.ROLLBACK_FUT) {
                this.onDone(this.tx.timedOut() ? this.tx.timeoutException() : this.tx.rollbackException());
                return;
            }
            if (fut == null) continue;
            assert (fut instanceof GridNearTxAbstractEnlistFuture || fut instanceof GridDhtTxAbstractEnlistFuture || fut instanceof CompoundLockFuture || fut instanceof GridNearTxSelectForUpdateFuture) : fut;
            if (!fut.isDone()) {
                fut.listen(new IgniteInClosure<IgniteInternalFuture>(){

                    @Override
                    public void apply(IgniteInternalFuture fut) {
                        if (fut.error() != null) {
                            GridDhtTxAbstractEnlistFuture.this.onDone(fut.error());
                        }
                    }
                });
            } else if (fut.error() != null) {
                this.onDone(fut.error());
            }
            break;
        } while (!this.tx.updateLockFuture(null, this));
        boolean added = this.cctx.mvcc().addFuture(this, this.futId);
        if (this.isDone()) {
            this.cctx.mvcc().removeFuture(this.futId);
            return;
        }
        assert (added);
        if (this.timeoutObj != null) {
            this.cctx.time().addTimeoutObject(this.timeoutObj);
        }
        try {
            this.checkPartitions(this.parts);
            UpdateSourceIterator<?> it = this.createIterator();
            if (!it.hasNext()) {
                U.close(it, this.log);
                this.onDone(this.result0());
                return;
            }
            if (!this.tx.implicitSingle()) {
                this.tx.addActiveCache(this.cctx, false);
            } else assert (this.tx.txState().cacheIds().contains(this.cctx.cacheId()) && this.tx.txState().cacheIds().size() == 1);
            this.it = it;
        }
        catch (Throwable e) {
            this.onDone(e);
            if (e instanceof Error) {
                throw (Error)e;
            }
            return;
        }
        this.continueLoop(false);
    }

    protected void clearLockFuture() {
        this.tx.clearLockFuture(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void continueLoop(boolean ignoreCntr) {
        block31: {
            if (this.isDone() || !ignoreCntr && GridDhtTxAbstractEnlistFuture.SKIP_UPD.getAndIncrement(this) != 0) {
                return;
            }
            cache = this.cctx.dhtCache();
            op = this.it.operation();
            topVer = this.tx.topologyVersionSnapshot();
            try {
                while (true) {
                    if (this.hasNext0()) {
                        cur = this.next0();
                        key = this.cctx.toCacheKeyObject(op.isDeleteOrLock() != false ? cur : ((IgniteBiTuple)cur).getKey());
                        if (!this.ensureFreeSlot(key)) {
                            this.peek = cur;
                            this.it.beforeDetach();
                        } else {
                            entry = cache.entryExx(key);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Adding entry: " + entry);
                            }
                            if (!GridDhtTxAbstractEnlistFuture.$assertionsDisabled && entry.detached()) {
                                throw new AssertionError();
                            }
                            val = op.isDeleteOrLock() != false || op.isInvoke() != false ? null : this.cctx.toCacheObject(((IgniteBiTuple)cur).getValue());
                            invokeVal = null;
                            entryProc = null;
                            invokeArgs = null;
                            if (op.isInvoke()) {
                                if (!GridDhtTxAbstractEnlistFuture.$assertionsDisabled && !this.needResult()) {
                                    throw new AssertionError();
                                }
                                invokeVal = (GridInvokeValue)((IgniteBiTuple)cur).getValue();
                                entryProc = invokeVal.entryProcessor();
                                invokeArgs = invokeVal.invokeArgs();
                            }
                            if (!GridDhtTxAbstractEnlistFuture.$assertionsDisabled && entryProc == null && op.isInvoke()) {
                                throw new AssertionError();
                            }
                            this.tx.markQueryEnlisted(this.mvccSnapshot);
                            needOldVal = this.cctx.shared().mvccCaching().continuousQueryListeners(this.cctx, this.tx, key) != null;
                            block13: while (true) {
                                this.cctx.shared().database().checkpointReadLock();
                                try {
                                    switch (3.$SwitchMap$org$apache$ignite$internal$processors$query$EnlistOperation[op.ordinal()]) {
                                        case 1: {
                                            res = entry.mvccRemove(this.tx, this.cctx.localNodeId(), topVer, this.mvccSnapshot, this.isMoving(key.partition()), needOldVal, this.filter, this.needResult());
                                            ** break;
lbl41:
                                            // 1 sources

                                            break block13;
                                        }
                                        case 2: 
                                        case 3: 
                                        case 4: 
                                        case 5: {
                                            res = entry.mvccSet(this.tx, this.cctx.localNodeId(), val, entryProc, invokeArgs, 0L, topVer, this.mvccSnapshot, op.cacheOperation(), this.isMoving(key.partition()), op.noCreate(), needOldVal, this.filter, this.needResult());
                                            ** break;
lbl45:
                                            // 1 sources

                                            break block13;
                                        }
                                        case 6: {
                                            res = entry.mvccLock(this.tx, this.mvccSnapshot);
                                            ** break;
lbl49:
                                            // 1 sources

                                            break block13;
                                        }
                                        default: {
                                            throw new IgniteSQLException("Cannot acquire lock for operation [op= " + (Object)op + "]Operation is unsupported at the moment ", 1002);
                                        }
                                    }
                                }
                                catch (GridCacheEntryRemovedException ignored) {
                                    entry = cache.entryExx(entry.key(), topVer);
                                    continue;
                                }
                                finally {
                                    this.cctx.shared().database().checkpointReadUnlock();
                                    continue;
                                }
                                break;
                            }
                            updateFut = res.updateFuture();
                            v0 /* !! */  = val0 /* !! */  = invokeVal != null ? invokeVal : val;
                            if (updateFut != null) {
                                if (updateFut.isDone()) {
                                    res = updateFut.get();
                                } else {
                                    entry0 = entry;
                                    this.it.beforeDetach();
                                    updateFut.listen((IgniteInClosure<IgniteInternalFuture<GridCacheUpdateTxResult>>)new CI1<IgniteInternalFuture<GridCacheUpdateTxResult>>(){

                                        @Override
                                        public void apply(IgniteInternalFuture<GridCacheUpdateTxResult> fut) {
                                            try {
                                                GridDhtTxAbstractEnlistFuture.this.processEntry(entry0, op, fut.get(), val0);
                                                GridDhtTxAbstractEnlistFuture.this.continueLoop(true);
                                            }
                                            catch (Throwable e) {
                                                GridDhtTxAbstractEnlistFuture.this.onDone(e);
                                            }
                                        }
                                    });
                                    return;
                                }
                            }
                            this.processEntry(entry, op, res, val0 /* !! */ );
                            continue;
                        }
                    }
                    if (!this.hasNext0()) {
                        if (!F.isEmpty(this.batches)) {
                            it = this.batches.entrySet().iterator();
                            while (it.hasNext()) {
                                e = it.next();
                                v1 = pending0 = this.pending == null ? null : (ConcurrentMap)this.pending.get(e.getKey());
                                if (pending0 != null && pending0.containsKey(0)) continue;
                                it.remove();
                                this.sendBatch(e.getValue());
                            }
                        }
                        if (this.noPendingRequests()) {
                            this.onDone(this.result0());
                            return;
                        }
                    }
                    if (GridDhtTxAbstractEnlistFuture.SKIP_UPD.decrementAndGet(this) != 0) {
                        this.skipCntr = 1;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                this.onDone(e);
                if (!(e instanceof Error)) break block31;
                throw (Error)e;
            }
        }
    }

    private Object next0() {
        if (!this.hasNext0()) {
            throw new NoSuchElementException();
        }
        Object cur = this.peek;
        if (cur != null) {
            this.peek = null;
        } else {
            cur = this.it.next();
        }
        return cur;
    }

    private boolean hasNext0() {
        if (this.peek == null && !this.it.hasNext()) {
            this.peek = FINISHED;
        }
        return this.peek != FINISHED;
    }

    private boolean noPendingRequests() {
        if (F.isEmpty(this.pending)) {
            return true;
        }
        for (ConcurrentMap e : this.pending.values()) {
            if (e.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void processEntry(GridDhtCacheEntry entry2, EnlistOperation op, GridCacheUpdateTxResult updRes, Message val) throws IgniteCheckedException {
        this.checkCompleted();
        assert (updRes != null && updRes.updateFuture() == null);
        this.onEntryProcessed(entry2.key(), updRes);
        if (!updRes.success()) {
            return;
        }
        if (!updRes.filtered()) {
            this.cctx.shared().mvccCaching().addEnlisted(entry2.key(), updRes.newValue(), 0L, 0L, this.lockVer, updRes.oldValue(), this.tx.local(), this.tx.topologyVersion(), this.mvccSnapshot, this.cctx.cacheId(), this.tx, null, -1);
        }
        if (op != EnlistOperation.LOCK) {
            this.addToBatch(entry2.key(), val, updRes.mvccHistory(), entry2.context().cacheId());
        }
    }

    private void addToBatch(KeyCacheObject key, Message val, List<MvccLinkAwareSearchRow> hist, int cacheId) throws IgniteCheckedException {
        List<ClusterNode> backups = this.backupNodes(key);
        int part = this.cctx.affinity().partition(key);
        this.tx.touchPartition(cacheId, part);
        if (F.isEmpty(backups)) {
            return;
        }
        Message hist0 = null;
        for (ClusterNode node : backups) {
            assert (!node.isLocal());
            boolean moving = this.isMoving(node, part);
            if (this.skipNearNodeUpdates && node.id().equals(this.nearNodeId) && !moving) {
                this.updateMappings(node);
                if (this.newRemoteTx(node)) {
                    this.addNewRemoteTxNode(node);
                }
                this.hasNearNodeUpdates = true;
                continue;
            }
            Batch batch = null;
            if (this.batches == null) {
                this.batches = new HashMap<UUID, Batch>();
            } else {
                batch = this.batches.get(node.id());
            }
            if (batch == null) {
                batch = new Batch(node);
                this.batches.put(node.id(), batch);
            }
            if (moving && hist0 == null) {
                assert (!F.isEmpty(hist));
                hist0 = this.fetchHistoryInfo(key, hist);
            }
            batch.add(key, moving ? hist0 : val);
            if (batch.size() != 1024) continue;
            assert (this.batches != null);
            this.batches.remove(node.id());
            this.sendBatch(batch);
        }
    }

    private CacheEntryInfoCollection fetchHistoryInfo(KeyCacheObject key, List<MvccLinkAwareSearchRow> hist) throws IgniteCheckedException {
        ArrayList<GridCacheEntryInfo> res = new ArrayList<GridCacheEntryInfo>();
        for (int i = 0; i < hist.size(); ++i) {
            MvccLinkAwareSearchRow row0 = hist.get(i);
            MvccDataRow row = new MvccDataRow(this.cctx.group(), row0.hash(), row0.link(), key.partition(), CacheDataRowAdapter.RowData.NO_KEY, row0.mvccCoordinatorVersion(), row0.mvccCounter(), row0.mvccOperationCounter());
            GridCacheMvccEntryInfo entry2 = new GridCacheMvccEntryInfo();
            entry2.version(row.version());
            entry2.mvccVersion(row);
            entry2.newMvccVersion(row);
            entry2.value(row.value());
            entry2.expireTime(row.expireTime());
            if (MvccUtils.compare(this.mvccSnapshot, row.mvccCoordinatorVersion(), row.mvccCounter()) != 0) {
                entry2.mvccTxState(row.mvccTxState() != 0 ? row.mvccTxState() : MvccUtils.state(this.cctx, row.mvccCoordinatorVersion(), row.mvccCounter(), row.mvccOperationCounter()));
            }
            if (MvccUtils.compare(this.mvccSnapshot, row.newMvccCoordinatorVersion(), row.newMvccCounter()) != 0) {
                entry2.newMvccTxState(row.newMvccTxState() != 0 ? row.newMvccTxState() : MvccUtils.state(this.cctx, row.newMvccCoordinatorVersion(), row.newMvccCounter(), row.newMvccOperationCounter()));
            }
            res.add(entry2);
        }
        return new CacheEntryInfoCollection(res);
    }

    private boolean newRemoteTx(ClusterNode node) {
        Set<ClusterNode> nodes2 = this.tx.lockTransactionNodes();
        return nodes2 == null || !nodes2.contains(node);
    }

    private void addNewRemoteTxNode(ClusterNode node) {
        this.tx.addLockTransactionNode(node);
        this.newDhtNodes.add(node.id());
    }

    private boolean ensureFreeSlot(KeyCacheObject key) {
        if (F.isEmpty(this.batches) || F.isEmpty(this.pending)) {
            return true;
        }
        for (ClusterNode node : this.backupNodes(key)) {
            Batch batch;
            if (this.skipNearNodeUpdates && node.id().equals(this.nearNodeId) && !this.isMoving(node, key.partition()) || (batch = this.batches.get(node.id())) == null || batch.size() < 1023) continue;
            ConcurrentMap pending0 = (ConcurrentMap)this.pending.get(node.id());
            assert (pending0 == null || pending0.size() <= 5);
            if (pending0 == null || !pending0.containsKey(0) && pending0.size() != 5) continue;
            return false;
        }
        return true;
    }

    private void sendBatch(Batch batch) throws IgniteCheckedException {
        GridDhtTxQueryEnlistRequest req;
        assert (batch != null && !batch.node().isLocal());
        ClusterNode node = batch.node();
        this.updateMappings(node);
        if (this.newRemoteTx(node)) {
            this.addNewRemoteTxNode(node);
        }
        if (!this.firstReqSent.contains(node)) {
            this.firstReqSent.add(node);
            req = new GridDhtTxQueryFirstEnlistRequest(this.cctx.cacheId(), this.futId, this.cctx.localNodeId(), this.tx.topologyVersionSnapshot(), this.lockVer, this.mvccSnapshot, this.tx.remainingTime(), this.tx.taskNameHash(), this.nearNodeId, this.nearLockVer, this.it.operation(), 0, batch.keys(), batch.values());
        } else {
            req = new GridDhtTxQueryEnlistRequest(this.cctx.cacheId(), this.futId, this.lockVer, this.it.operation(), ++this.batchIdCntr, this.mvccSnapshot.operationCounter(), batch.keys(), batch.values());
        }
        ConcurrentHashMap<Integer, Batch> pending0 = null;
        if (this.pending == null) {
            this.pending = new ConcurrentHashMap<UUID, ConcurrentMap<Integer, Batch>>();
        } else {
            pending0 = (ConcurrentHashMap<Integer, Batch>)this.pending.get(node.id());
        }
        if (pending0 == null) {
            pending0 = new ConcurrentHashMap<Integer, Batch>();
            this.pending.put(node.id(), pending0);
        }
        Batch prev = pending0.put(req.batchId(), batch);
        assert (prev == null);
        this.cctx.io().send(node, (GridCacheMessage)req, this.cctx.ioPolicy());
    }

    private synchronized void updateMappings(ClusterNode node) throws IgniteCheckedException {
        this.checkCompleted();
        Map<UUID, GridDistributedTxMapping> m = this.tx.dhtMap;
        GridDistributedTxMapping mapping = m.get(node.id());
        if (mapping == null) {
            mapping = new GridDistributedTxMapping(node);
            m.put(node.id(), mapping);
        }
        mapping.markQueryUpdate();
    }

    @NotNull
    private List<ClusterNode> backupNodes(KeyCacheObject key) {
        List<ClusterNode> dhtNodes = this.cctx.affinity().nodesByKey(key, this.tx.topologyVersion());
        assert (!dhtNodes.isEmpty() && dhtNodes.get(0).id().equals(this.cctx.localNodeId())) : "localNode = " + this.cctx.localNodeId() + ", dhtNodes = " + dhtNodes;
        if (dhtNodes.size() == 1) {
            return Collections.emptyList();
        }
        return dhtNodes.subList(1, dhtNodes.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPartitions(@Nullable int[] parts) throws ClusterTopologyCheckedException {
        if (this.cctx.isLocal() || !this.cctx.rebalanceEnabled()) {
            return;
        }
        if (parts == null) {
            parts = U.toIntArray(this.cctx.affinity().primaryPartitions(this.cctx.localNodeId(), this.tx.topologyVersionSnapshot()));
        }
        GridDhtPartitionTopology top = this.cctx.topology();
        try {
            top.readLock();
            for (int i = 0; i < parts.length; ++i) {
                GridDhtLocalPartition p = top.localPartition(parts[i]);
                if (p != null && p.state() == GridDhtPartitionState.OWNING) continue;
                throw new ClusterTopologyCheckedException("Cannot run update query. Node must own all the necessary partitions.");
            }
        }
        finally {
            top.readUnlock();
        }
    }

    private boolean isMoving(int part) {
        Boolean res;
        if (this.movingParts == null) {
            this.movingParts = new HashMap<Integer, Boolean>();
        }
        if ((res = this.movingParts.get(part)) != null) {
            return res;
        }
        List<ClusterNode> dhtNodes = this.cctx.affinity().nodesByPartition(part, this.tx.topologyVersion());
        for (int i = 1; i < dhtNodes.size(); ++i) {
            ClusterNode node = dhtNodes.get(i);
            if (!this.isMoving(node, part)) continue;
            this.movingParts.put(part, Boolean.TRUE);
            return true;
        }
        this.movingParts.put(part, Boolean.FALSE);
        return false;
    }

    private boolean isMoving(ClusterNode node, int part) {
        GridDhtPartitionState partState = this.cctx.topology().partitionState(node.id(), part);
        return partState != GridDhtPartitionState.OWNING && partState != GridDhtPartitionState.EVICTED;
    }

    private void checkCompleted() throws IgniteCheckedException {
        if (this.isDone()) {
            throw new IgniteCheckedException("Future is done.");
        }
    }

    public void onResult(UUID nodeId, GridDhtTxQueryEnlistResponse res) {
        if (res.error() != null) {
            this.onDone(new IgniteCheckedException("Failed to update backup node: [localNodeId=" + this.cctx.localNodeId() + ", remoteNodeId=" + nodeId + ']', res.error()));
            return;
        }
        assert (this.pending != null);
        ConcurrentMap pending0 = (ConcurrentMap)this.pending.get(nodeId);
        assert (pending0 != null);
        Batch rmv = (Batch)pending0.remove(res.batchId());
        assert (rmv != null);
        this.continueLoop(false);
    }

    @Override
    public boolean trackable() {
        return true;
    }

    @Override
    public void markNotTrackable() {
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean backupLeft = false;
        Set<ClusterNode> nodes2 = this.tx.lockTransactionNodes();
        if (!F.isEmpty(nodes2)) {
            for (ClusterNode node : nodes2) {
                if (!node.id().equals(nodeId)) continue;
                backupLeft = true;
                break;
            }
        }
        return (backupLeft || this.nearNodeId.equals(nodeId)) && this.onDone(new ClusterTopologyCheckedException((backupLeft ? "Backup" : "Requesting") + " node left the grid [nodeId=" + nodeId + ']'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onDone(@Nullable T res, @Nullable Throwable err2) {
        assert (res != null || err2 != null);
        if (!DONE_UPD.compareAndSet(this, 0, 1)) {
            return false;
        }
        if (err2 == null) {
            this.clearLockFuture();
        }
        GridDhtTxAbstractEnlistFuture gridDhtTxAbstractEnlistFuture = this;
        synchronized (gridDhtTxAbstractEnlistFuture) {
            boolean done = super.onDone(res, err2);
            assert (done);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Completing future: " + this);
            }
            this.cctx.mvcc().removeFuture(this.futId);
            if (this.timeoutObj != null) {
                this.cctx.time().removeTimeoutObject(this.timeoutObj);
            }
            U.close(this.it, this.log);
            return true;
        }
    }

    @Override
    public void onError(Throwable error2) {
        this.onDone(error2);
    }

    @NotNull
    protected IgniteTxTimeoutCheckedException timeoutException() {
        return new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + this.timeout + ", tx=" + this.tx + ']');
    }

    protected class LockTimeoutObject
    extends GridTimeoutObjectAdapter {
        LockTimeoutObject() {
            super(GridDhtTxAbstractEnlistFuture.this.timeout);
        }

        @Override
        public void onTimeout() {
            if (GridDhtTxAbstractEnlistFuture.this.log.isDebugEnabled()) {
                GridDhtTxAbstractEnlistFuture.this.log.debug("Timed out waiting for lock response: " + this);
            }
            GridDhtTxAbstractEnlistFuture.this.onDone(GridDhtTxAbstractEnlistFuture.this.timeoutException());
        }

        public String toString() {
            return S.toString(LockTimeoutObject.class, this);
        }
    }

    private static class Batch {
        @GridToStringExclude
        private final ClusterNode node;
        private List<KeyCacheObject> keys;
        private List<Message> vals;

        private Batch(ClusterNode node) {
            this.node = node;
        }

        public ClusterNode node() {
            return this.node;
        }

        public void add(KeyCacheObject key, Message val) {
            assert (val == null || val instanceof GridInvokeValue || val instanceof CacheObject || val instanceof CacheEntryInfoCollection);
            if (this.keys == null) {
                this.keys = new ArrayList<KeyCacheObject>();
            }
            this.keys.add(key);
            if (val != null) {
                if (this.vals == null) {
                    this.vals = new ArrayList<Message>();
                }
                this.vals.add(val);
            }
            assert (this.vals == null || this.keys.size() == this.vals.size());
        }

        public int size() {
            return this.keys == null ? 0 : this.keys.size();
        }

        public List<KeyCacheObject> keys() {
            return this.keys;
        }

        public List<Message> values() {
            return this.vals;
        }
    }
}

