/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.TopologyValidator;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheInvalidStateException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.jetbrains.annotations.Nullable;

public abstract class GridDhtTopologyFutureAdapter
extends GridFutureAdapter<AffinityTopologyVersion>
implements GridDhtTopologyFuture {
    protected volatile Map<Integer, CacheValidation> grpValidRes;
    protected volatile boolean clusterIsActive = true;

    protected final CacheValidation validateCacheGroup(CacheGroupContext grp, Collection<ClusterNode> topNodes) {
        TopologyValidator validator;
        List lostParts = grp.isLocal() ? Collections.emptyList() : grp.topology().lostPartitions();
        boolean valid = true;
        if (!grp.systemCache() && (validator = grp.topologyValidator()) != null) {
            valid = validator.validate(topNodes);
        }
        return new CacheValidation(valid, lostParts);
    }

    @Override
    @Nullable
    public final Throwable validateCache(GridCacheContext cctx, boolean recovery, boolean read, @Nullable Object key, @Nullable Collection<?> keys) {
        assert (this.isDone()) : this;
        Throwable err2 = this.error();
        if (err2 != null) {
            return err2;
        }
        if (!this.clusterIsActive) {
            return new CacheInvalidStateException("Failed to perform cache operation (cluster is not activated): " + cctx.name());
        }
        CacheGroupContext grp = cctx.group();
        PartitionLossPolicy partLossPlc = grp.config().getPartitionLossPolicy();
        if (!(!grp.needsRecovery() || recovery || read || partLossPlc != PartitionLossPolicy.READ_ONLY_SAFE && partLossPlc != PartitionLossPolicy.READ_ONLY_ALL)) {
            return new IgniteCheckedException("Failed to write to cache (cache is moved to a read-only state): " + cctx.name());
        }
        if (grp.needsRecovery() || grp.topologyValidator() != null) {
            CacheValidation validation = this.grpValidRes.get(grp.groupId());
            if (validation == null) {
                return null;
            }
            if (!validation.valid && !read) {
                return new IgniteCheckedException("Failed to perform cache operation (cache topology is not valid): " + cctx.name());
            }
            if (recovery || !grp.needsRecovery()) {
                return null;
            }
            if (key != null) {
                int p = cctx.affinity().partition(key);
                CacheInvalidStateException ex = this.validatePartitionOperation(cctx.name(), read, key, p, validation.lostParts, partLossPlc);
                if (ex != null) {
                    return ex;
                }
            }
            if (keys != null) {
                for (Object k : keys) {
                    int p = cctx.affinity().partition(k);
                    CacheInvalidStateException ex = this.validatePartitionOperation(cctx.name(), read, k, p, validation.lostParts, partLossPlc);
                    if (ex == null) continue;
                    return ex;
                }
            }
        }
        return null;
    }

    private CacheInvalidStateException validatePartitionOperation(String cacheName, boolean read, Object key, int part, Collection<Integer> lostParts, PartitionLossPolicy plc) {
        if (lostParts.contains(part)) {
            if (!read) {
                assert (plc == PartitionLossPolicy.READ_WRITE_ALL || plc == PartitionLossPolicy.READ_WRITE_SAFE);
                if (plc == PartitionLossPolicy.READ_WRITE_SAFE) {
                    return new CacheInvalidStateException("Failed to execute cache operation (all partition owners have left the grid, partition data has been lost) [cacheName=" + cacheName + ", part=" + part + ", key=" + key + ']');
                }
            } else if (plc == PartitionLossPolicy.READ_ONLY_SAFE || plc == PartitionLossPolicy.READ_WRITE_SAFE) {
                return new CacheInvalidStateException("Failed to execute cache operation (all partition owners have left the grid, partition data has been lost) [cacheName=" + cacheName + ", part=" + part + ", key=" + key + ']');
            }
        }
        return null;
    }

    protected static class CacheValidation {
        private boolean valid;
        private Collection<Integer> lostParts;

        private CacheValidation(boolean valid, Collection<Integer> lostParts) {
            this.valid = valid;
            this.lostParts = lostParts;
        }
    }
}

