/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockRequest;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDhtLockRequest
extends GridDistributedLockRequest {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> nearKeys;
    private BitSet invalidateEntries;
    private IgniteUuid miniId;
    @GridToStringInclude
    @GridDirectTransient
    private Map<KeyCacheObject, GridCacheVersion> owned;
    @GridToStringExclude
    private KeyCacheObject[] ownedKeys;
    @GridToStringExclude
    private GridCacheVersion[] ownedValues;
    private AffinityTopologyVersion topVer;
    private UUID subjId;
    private int taskNameHash;
    private BitSet preloadKeys;
    private long accessTtl;

    public GridDhtLockRequest() {
    }

    public GridDhtLockRequest(int cacheId, UUID nodeId, GridCacheVersion nearXidVer, long threadId, IgniteUuid futId, IgniteUuid miniId, GridCacheVersion lockVer, @NotNull AffinityTopologyVersion topVer, boolean isInTx, boolean isRead, TransactionIsolation isolation, boolean isInvalidate, long timeout, int dhtCnt, int nearCnt, int txSize, @Nullable UUID subjId, int taskNameHash, long accessTtl, boolean skipStore, boolean storeUsed, boolean keepBinary, boolean addDepInfo) {
        super(cacheId, nodeId, nearXidVer, threadId, futId, lockVer, isInTx, isRead, isolation, isInvalidate, timeout, dhtCnt == 0 ? nearCnt : dhtCnt, txSize, skipStore, keepBinary, addDepInfo);
        this.topVer = topVer;
        this.storeUsed(storeUsed);
        this.nearKeys = nearCnt == 0 ? Collections.emptyList() : new ArrayList(nearCnt);
        this.invalidateEntries = new BitSet(dhtCnt == 0 ? nearCnt : dhtCnt);
        assert (miniId != null);
        this.miniId = miniId;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.accessTtl = accessTtl;
    }

    public UUID nearNodeId() {
        return this.nodeId();
    }

    public UUID subjectId() {
        return this.subjId;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public void addNearKey(KeyCacheObject key, GridCacheSharedContext ctx) throws IgniteCheckedException {
        this.nearKeys.add(key);
    }

    public List<KeyCacheObject> nearKeys() {
        return this.nearKeys == null ? Collections.emptyList() : this.nearKeys;
    }

    public void addDhtKey(KeyCacheObject key, boolean invalidateEntry, GridCacheContext ctx) throws IgniteCheckedException {
        this.invalidateEntries.set(this.idx, invalidateEntry);
        this.addKeyBytes(key, false, ctx);
    }

    public void markLastKeyForPreload() {
        assert (this.idx > 0);
        if (this.preloadKeys == null) {
            this.preloadKeys = new BitSet();
        }
        this.preloadKeys.set(this.idx - 1, true);
    }

    public boolean needPreloadKey(int idx) {
        return this.preloadKeys != null && this.preloadKeys.get(idx);
    }

    public void owned(KeyCacheObject key, GridCacheVersion ownerMapped) {
        if (this.owned == null) {
            this.owned = new GridLeanMap<KeyCacheObject, GridCacheVersion>(3);
        }
        this.owned.put(key, ownerMapped);
    }

    @Nullable
    public GridCacheVersion owned(KeyCacheObject key) {
        return this.owned == null ? null : this.owned.get(key);
    }

    public boolean invalidateNearEntry(int idx) {
        return this.invalidateEntries.get(idx);
    }

    public IgniteUuid miniId() {
        return this.miniId;
    }

    public long accessTtl() {
        return this.accessTtl;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        this.prepareMarshalCacheObjects(this.nearKeys, ctx.cacheContext(this.cacheId));
        if (this.owned != null && this.ownedKeys == null) {
            this.ownedKeys = new KeyCacheObject[this.owned.size()];
            this.ownedValues = new GridCacheVersion[this.ownedKeys.length];
            int i = 0;
            for (Map.Entry<KeyCacheObject, GridCacheVersion> entry2 : this.owned.entrySet()) {
                this.ownedKeys[i] = entry2.getKey();
                this.ownedValues[i] = entry2.getValue();
                ++i;
            }
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        this.finishUnmarshalCacheObjects(this.nearKeys, ctx.cacheContext(this.cacheId), ldr);
        if (this.ownedKeys != null) {
            this.owned = new GridLeanMap<KeyCacheObject, GridCacheVersion>(this.ownedKeys.length);
            for (int i = 0; i < this.ownedKeys.length; ++i) {
                this.ownedKeys[i].finishUnmarshal(ctx.cacheContext(this.cacheId).cacheObjectContext(), ldr);
                this.owned.put(this.ownedKeys[i], this.ownedValues[i]);
            }
            this.ownedKeys = null;
            this.ownedValues = null;
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 20: {
                if (!writer.writeLong("accessTtl", this.accessTtl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 21: {
                if (!writer.writeBitSet("invalidateEntries", this.invalidateEntries)) {
                    return false;
                }
                writer.incrementState();
            }
            case 22: {
                if (!writer.writeIgniteUuid("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 23: {
                if (!writer.writeCollection("nearKeys", this.nearKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 24: {
                if (!writer.writeObjectArray("ownedKeys", this.ownedKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 25: {
                if (!writer.writeObjectArray("ownedValues", this.ownedValues, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 26: {
                if (!writer.writeBitSet("preloadKeys", this.preloadKeys)) {
                    return false;
                }
                writer.incrementState();
            }
            case 27: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 28: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 29: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 20: {
                this.accessTtl = reader.readLong("accessTtl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 21: {
                this.invalidateEntries = reader.readBitSet("invalidateEntries");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 22: {
                this.miniId = reader.readIgniteUuid("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 23: {
                this.nearKeys = (List)reader.readCollection("nearKeys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 24: {
                this.ownedKeys = reader.readObjectArray("ownedKeys", MessageCollectionItemType.MSG, KeyCacheObject.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 25: {
                this.ownedValues = reader.readObjectArray("ownedValues", MessageCollectionItemType.MSG, GridCacheVersion.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 26: {
                this.preloadKeys = reader.readBitSet("preloadKeys");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 27: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 28: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 29: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtLockRequest.class);
    }

    @Override
    public short directType() {
        return 30;
    }

    @Override
    public byte fieldsCount() {
        return 30;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtLockRequest.class, this, "super", super.toString());
    }
}

