/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheLockCandidates;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundIdentityFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheVersionedFuture;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheMappedVersion;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockCancelledException;
import org.apache.ignite.internal.processors.cache.distributed.dht.DhtLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLockRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLockResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.colocated.GridDhtColocatedLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUpdateVersionAware;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersionAware;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GridDhtLockFuture
extends GridCacheCompoundIdentityFuture<Boolean>
implements GridCacheVersionedFuture<Boolean>,
GridDhtFuture<Boolean>,
GridCacheMappedVersion,
DhtLockFuture<Boolean> {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private static IgniteLogger msgLog;
    @GridToStringExclude
    private GridCacheContext<?, ?> cctx;
    private UUID nearNodeId;
    private GridCacheVersion nearLockVer;
    private AffinityTopologyVersion topVer;
    private long threadId;
    @GridToStringExclude
    private List<GridDhtCacheEntry> entries;
    private Map<ClusterNode, List<GridDhtCacheEntry>> dhtMap = new ConcurrentHashMap<ClusterNode, List<GridDhtCacheEntry>>();
    private IgniteUuid futId;
    private GridCacheVersion lockVer;
    private boolean read;
    private Throwable err;
    private volatile boolean timedOut;
    @GridToStringExclude
    private LockTimeoutObject timeoutObj;
    private final long timeout;
    private CacheEntryPredicate[] filter;
    private GridDhtTxLocalAdapter tx;
    private boolean mapped;
    private Collection<Integer> invalidParts;
    private boolean trackable = true;
    private final Collection<KeyCacheObject> pendingLocks;
    private long createTtl;
    private long accessTtl;
    private boolean needReturnVal;
    private final boolean skipStore;
    private final boolean keepBinary;

    public GridDhtLockFuture(GridCacheContext<?, ?> cctx, UUID nearNodeId, GridCacheVersion nearLockVer, @NotNull AffinityTopologyVersion topVer, int cnt, boolean read, boolean needReturnVal, long timeout, GridDhtTxLocalAdapter tx, long threadId, long createTtl, long accessTtl, CacheEntryPredicate[] filter2, boolean skipStore, boolean keepBinary) {
        super(CU.boolReducer());
        assert (nearNodeId != null);
        assert (nearLockVer != null);
        assert (topVer.topologyVersion() > 0L);
        assert (tx != null && timeout >= 0L || tx == null);
        this.cctx = cctx;
        this.nearNodeId = nearNodeId;
        this.nearLockVer = nearLockVer;
        this.topVer = topVer;
        this.read = read;
        this.needReturnVal = needReturnVal;
        this.timeout = timeout;
        this.filter = filter2;
        this.tx = tx;
        this.createTtl = createTtl;
        this.accessTtl = accessTtl;
        this.skipStore = skipStore;
        this.keepBinary = keepBinary;
        if (tx != null) {
            tx.topologyVersion(topVer);
        }
        assert (tx == null || threadId == tx.threadId());
        this.threadId = threadId;
        if (tx != null) {
            this.lockVer = tx.xidVersion();
        } else {
            this.lockVer = cctx.mvcc().mappedVersion(nearLockVer);
            if (this.lockVer == null) {
                this.lockVer = nearLockVer;
            }
        }
        this.futId = IgniteUuid.randomUuid();
        this.entries = new ArrayList<GridDhtCacheEntry>(cnt);
        this.pendingLocks = U.newHashSet(cnt);
        if (log == null) {
            msgLog = cctx.shared().txLockMessageLogger();
            log = U.logger(cctx.kernalContext(), logRef, GridDhtLockFuture.class);
        }
        if (tx != null) {
            do {
                IgniteInternalFuture<?> fut;
                if ((fut = tx.lockFut) == null) continue;
                if (fut == GridDhtTxLocalAdapter.ROLLBACK_FUT) {
                    this.onError(tx.timedOut() ? tx.timeoutException() : tx.rollbackException());
                } else {
                    assert (fut instanceof GridDhtColocatedLockFuture) : fut;
                    fut.listen(new IgniteInClosure<IgniteInternalFuture>(){

                        @Override
                        public void apply(IgniteInternalFuture fut) {
                            try {
                                fut.get();
                            }
                            catch (IgniteCheckedException e) {
                                GridDhtLockFuture.this.onError(e);
                            }
                        }
                    });
                }
                return;
            } while (!tx.updateLockFuture(null, this));
            return;
        }
    }

    @Override
    public Collection<Integer> invalidPartitions() {
        return this.invalidParts == null ? Collections.emptyList() : this.invalidParts;
    }

    void addInvalidPartition(GridCacheContext<?, ?> cacheCtx, int invalidPart) {
        if (this.invalidParts == null) {
            this.invalidParts = new HashSet<Integer>();
        }
        this.invalidParts.add(invalidPart);
        if (this.tx != null) {
            this.tx.addInvalidPartition((GridCacheContext)cacheCtx, invalidPart);
        }
        if (log.isDebugEnabled()) {
            log.debug("Added invalid partition to future [invalidPart=" + invalidPart + ", fut=" + this + ']');
        }
    }

    @Override
    public GridCacheVersion version() {
        return this.lockVer;
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
        this.trackable = false;
    }

    public Collection<GridDhtCacheEntry> entries() {
        return F.view(this.entries, F.notNull());
    }

    private synchronized Collection<GridDhtCacheEntry> entriesCopy() {
        return new ArrayList<GridDhtCacheEntry>(this.entries());
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    public GridCacheVersion nearLockVersion() {
        return this.nearLockVer;
    }

    @Override
    @Nullable
    public GridCacheVersion mappedVersion() {
        return this.tx == null ? this.nearLockVer : null;
    }

    private boolean inTx() {
        return this.tx != null;
    }

    private boolean implicitSingle() {
        return this.tx != null && this.tx.implicitSingle();
    }

    private boolean isInvalidate() {
        return this.tx != null && this.tx.isInvalidate();
    }

    @Nullable
    private TransactionIsolation isolation() {
        return this.tx == null ? null : this.tx.isolation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridCacheMvccCandidate addEntry(GridDhtCacheEntry entry2) throws GridCacheEntryRemovedException, GridDistributedLockCancelledException {
        if (log.isDebugEnabled()) {
            log.debug("Adding entry: " + entry2);
        }
        if (entry2 == null) {
            return null;
        }
        if (this.timedOut) {
            return null;
        }
        GridCacheMvccCandidate c = entry2.addDhtLocal(this.nearNodeId, this.nearLockVer, this.topVer, this.threadId, this.lockVer, null, this.timeout, false, this.inTx(), this.implicitSingle(), false);
        if (c == null && this.timeout < 0L) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to acquire lock with negative timeout: " + entry2);
            }
            this.onFailed(false);
            return null;
        }
        GridDhtLockFuture gridDhtLockFuture = this;
        synchronized (gridDhtLockFuture) {
            this.entries.add(c == null || c.reentry() ? null : entry2);
            if (c != null && !c.reentry()) {
                this.pendingLocks.add(entry2.key());
            }
        }
        if (this.timedOut) {
            entry2.removeLock(this.lockVer);
            return null;
        }
        return c;
    }

    private void undoLocks(boolean dist) {
        Collection<GridDhtCacheEntry> entriesCp = this.entriesCopy();
        if (dist && this.tx == null) {
            this.cctx.dhtTx().removeLocks(this.nearNodeId, this.lockVer, F.viewReadOnly(entriesCp, new C1<GridDhtCacheEntry, KeyCacheObject>(){

                @Override
                public KeyCacheObject apply(GridDhtCacheEntry e) {
                    return e.key();
                }
            }, new IgnitePredicate[0]), false);
        } else {
            if (this.tx != null) {
                if (this.tx.setRollbackOnly()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Marked transaction as rollback only because locks could not be acquired: " + this.tx);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Transaction was not marked rollback-only while locks were not acquired: " + this.tx);
                }
            }
            block4: for (GridCacheEntryEx gridCacheEntryEx : entriesCp) {
                try {
                    gridCacheEntryEx.removeLock(this.lockVer);
                }
                catch (GridCacheEntryRemovedException ignored) {
                    while (true) {
                        try {
                            GridCacheEntryEx gridCacheEntryEx2 = this.cctx.cache().peekEx(gridCacheEntryEx.key());
                            if (gridCacheEntryEx2 == null) continue block4;
                            gridCacheEntryEx2.removeLock(this.lockVer);
                            continue block4;
                        }
                        catch (GridCacheEntryRemovedException ignore) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Attempted to remove lock on removed entry (will retry) [ver=" + this.lockVer + ", entry=" + gridCacheEntryEx + ']');
                            continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    private void onFailed(boolean dist) {
        this.undoLocks(dist);
        this.onComplete(false, false, true);
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        boolean found = false;
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f2 = (MiniFuture)fut;
            if (!f2.node().id().equals(nodeId)) continue;
            f2.onResult();
            found = true;
        }
        return found;
    }

    void onResult(UUID nodeId, GridDhtLockResponse res) {
        if (!this.isDone()) {
            MiniFuture mini = this.miniFuture(res.miniId());
            if (mini != null) {
                assert (mini.node().id().equals(nodeId));
                mini.onResult(res);
                return;
            }
            U.warn(msgLog, "DHT lock fut, failed to find mini future [txId=" + this.nearLockVer + ", dhtTxId=" + this.lockVer + ", inTx=" + this.inTx() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(IgniteUuid miniId) {
        GridDhtLockFuture gridDhtLockFuture = this;
        synchronized (gridDhtLockFuture) {
            int size2 = this.futuresCountNoLock();
            for (int i = 0; i < size2; ++i) {
                MiniFuture mini = (MiniFuture)this.future(i);
                if (!mini.futureId().equals(miniId)) continue;
                if (!mini.isDone()) {
                    return mini;
                }
                return null;
            }
        }
        return null;
    }

    private void readyLocks() {
        if (log.isDebugEnabled()) {
            log.debug("Marking local locks as ready for DHT lock future: " + this);
        }
        block2: for (int i = 0; i < this.entries.size(); ++i) {
            GridDistributedCacheEntry entry2;
            while ((entry2 = (GridDistributedCacheEntry)this.entries.get(i)) != null) {
                try {
                    CacheLockCandidates owners = entry2.readyLock(this.lockVer);
                    if (!(this.timeout >= 0L || owners != null && owners.hasCandidate(this.lockVer))) {
                        this.onFailed(false);
                        return;
                    }
                    if (!log.isDebugEnabled()) continue block2;
                    log.debug("Current lock owners [entry=" + entry2 + ", owners=" + owners + ", fut=" + this + ']');
                    continue block2;
                }
                catch (GridCacheEntryRemovedException ignored) {
                    if (log.isDebugEnabled()) {
                        log.debug("Failed to ready lock because entry was removed (will renew).");
                    }
                    this.entries.set(i, (GridDhtCacheEntry)this.cctx.cache().entryEx(entry2.key(), this.topVer));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t) {
        GridDhtLockFuture gridDhtLockFuture = this;
        synchronized (gridDhtLockFuture) {
            if (this.err != null) {
                return;
            }
            this.err = t;
        }
        this.onComplete(false, false, true);
    }

    private boolean filter(GridCacheEntryEx cached) {
        try {
            if (!this.cctx.isAll(cached, this.filter)) {
                if (log.isDebugEnabled()) {
                    log.debug("Filter didn't pass for entry (will fail lock): " + cached);
                }
                this.onFailed(true);
                return false;
            }
            return true;
        }
        catch (IgniteCheckedException e) {
            this.onError(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry2, GridCacheMvccCandidate owner2) {
        if (this.isDone() || this.inTx() && (this.tx.remainingTime() == -1L || this.tx.isRollbackOnly())) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Received onOwnerChanged() callback [entry=" + entry2 + ", owner=" + owner2 + "]");
        }
        if (owner2 != null && owner2.version().equals(this.lockVer)) {
            boolean isEmpty2;
            GridDhtLockFuture gridDhtLockFuture = this;
            synchronized (gridDhtLockFuture) {
                if (!this.pendingLocks.remove(entry2.key())) {
                    return false;
                }
                isEmpty2 = this.pendingLocks.isEmpty();
            }
            if (isEmpty2) {
                this.map(this.entries());
            }
            return true;
        }
        return false;
    }

    private synchronized boolean checkLocks() {
        return this.pendingLocks.isEmpty();
    }

    @Override
    public boolean cancel() {
        if (this.onCancelled()) {
            this.onComplete(false, false, true);
        }
        return this.isCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onDone(@Nullable Boolean success2, @Nullable Throwable err2) {
        if (success2 == null) {
            assert (err2 != null);
            success2 = false;
        }
        assert (err2 == null || !success2.booleanValue());
        assert (!success2.booleanValue() || this.initialized() && !this.hasPending()) : "Invalid done callback [success=" + success2 + ", fut=" + this + ']';
        if (log.isDebugEnabled()) {
            log.debug("Received onDone(..) callback [success=" + success2 + ", err=" + err2 + ", fut=" + this + ']');
        }
        if (this.isDone() || err2 == null && success2.booleanValue() && !this.checkLocks()) {
            return false;
        }
        GridDhtLockFuture gridDhtLockFuture = this;
        synchronized (gridDhtLockFuture) {
            if (this.err == null) {
                this.err = err2;
            }
        }
        return this.onComplete(success2, err2 instanceof NodeStoppingException, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean onComplete(boolean success2, boolean stopping, boolean unlock) {
        if (log.isDebugEnabled()) {
            log.debug("Received onComplete(..) callback [success=" + success2 + ", fut=" + this + ']');
        }
        if (!success2 && !stopping && unlock) {
            this.undoLocks(true);
        }
        boolean set = false;
        if (this.tx != null) {
            this.cctx.tm().txContext(this.tx);
            set = this.cctx.tm().setTxTopologyHint(this.tx.topologyVersionSnapshot());
            if (success2) {
                this.tx.clearLockFuture(this);
            }
        }
        try {
            if (this.err == null && !stopping) {
                this.loadMissingFromStore();
            }
        }
        finally {
            if (set) {
                this.cctx.tm().setTxTopologyHint(null);
            }
        }
        if (super.onDone(success2, this.err)) {
            if (log.isDebugEnabled()) {
                log.debug("Completing future: " + this);
            }
            this.cctx.mvcc().removeVersionedFuture(this);
            if (this.timeoutObj != null) {
                this.cctx.time().removeTimeoutObject(this.timeoutObj);
            }
            return true;
        }
        return false;
    }

    public void map() {
        if (F.isEmpty(this.entries)) {
            this.onComplete(true, false, true);
            return;
        }
        this.readyLocks();
        if (this.timeout > 0L && !this.isDone()) {
            this.timeoutObj = new LockTimeoutObject();
            this.cctx.time().addTimeoutObject(this.timeoutObj);
        }
    }

    private boolean checkDone() {
        if (this.isDone()) {
            if (log.isDebugEnabled()) {
                log.debug("Mapping won't proceed because future is done: " + this);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void map(Iterable<GridDhtCacheEntry> entries) {
        Iterator<Map.Entry<ClusterNode, List<GridDhtCacheEntry>>> iterator2;
        long timeout;
        Object object = this;
        // MONITORENTER : object
        if (this.mapped) {
            // MONITOREXIT : object
            return;
        }
        this.mapped = true;
        // MONITOREXIT : object
        try {
            if (log.isDebugEnabled()) {
                log.debug("Mapping entry for DHT lock future: " + this);
            }
            object = entries.iterator();
            block19: while (true) {
                if (!object.hasNext()) {
                    block41: {
                        if (this.checkDone()) {
                            this.markInitialized();
                            return;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Mapped DHT lock future [dhtMap=" + F.nodeIds(this.dhtMap.keySet()) + ", dhtLockFut=" + this + ']');
                        }
                        timeout = this.inTx() ? this.tx.remainingTime() : this.timeout;
                        GridDhtLockFuture gridDhtLockFuture = this;
                        // MONITORENTER : gridDhtLockFuture
                        if (!this.checkDone()) break block41;
                        // MONITOREXIT : gridDhtLockFuture
                        this.markInitialized();
                        return;
                    }
                    iterator2 = this.dhtMap.entrySet().iterator();
                    break;
                }
                GridDhtCacheEntry entry2 = (GridDhtCacheEntry)object.next();
                while (true) {
                    block42: {
                        this.cctx.dhtMap(this.nearNodeId, this.topVer, entry2, this.tx == null ? this.lockVer : null, log, this.dhtMap, null);
                        GridCacheMvccCandidate cand = entry2.candidate(this.lockVer);
                        if (cand != null) break block42;
                        this.onFailed(false);
                        this.markInitialized();
                        return;
                    }
                    try {
                        continue block19;
                        catch (GridCacheEntryRemovedException ignore) {
                            if (log.isDebugEnabled()) {
                                log.debug("Got removed entry when mapping DHT lock future (will retry): " + entry2);
                            }
                            entry2 = this.cctx.dht().entryExx(entry2.key(), this.topVer);
                            continue;
                        }
                    }
                    catch (GridDhtInvalidPartitionException e) {
                        assert (false) : "DHT lock should never get invalid partition [err=" + e + ", fut=" + this + ']';
                        continue block19;
                    }
                    break;
                }
                break;
            }
        }
        catch (Throwable throwable2) {
            this.markInitialized();
            throw throwable2;
        }
        while (true) {
            if (!iterator2.hasNext()) {
                this.markInitialized();
                return;
            }
            Map.Entry<ClusterNode, List<GridDhtCacheEntry>> mapped = iterator2.next();
            ClusterNode n = mapped.getKey();
            List<GridDhtCacheEntry> dhtMapping = mapped.getValue();
            int cnt = F.size(dhtMapping, new IgnitePredicate[0]);
            if (cnt <= 0) continue;
            assert (!n.id().equals(this.cctx.localNodeId()));
            if (this.inTx() && this.tx.remainingTime() == -1L) {
                // MONITOREXIT : gridDhtLockFuture
                this.markInitialized();
                return;
            }
            MiniFuture fut = new MiniFuture(n, dhtMapping);
            GridDhtLockRequest req = new GridDhtLockRequest(this.cctx.cacheId(), this.nearNodeId, this.inTx() ? this.tx.nearXidVersion() : null, this.threadId, this.futId, fut.futureId(), this.lockVer, this.topVer, this.inTx(), this.read, this.isolation(), this.isInvalidate(), timeout, cnt, 0, this.inTx() ? this.tx.size() : cnt, this.inTx() ? this.tx.subjectId() : null, this.inTx() ? this.tx.taskNameHash() : 0, this.read ? this.accessTtl : -1L, this.skipStore, this.cctx.store().configured(), this.keepBinary, this.cctx.deploymentEnabled());
            try {
                ListIterator<GridDhtCacheEntry> it = dhtMapping.listIterator();
                while (it.hasNext()) {
                    GridDhtCacheEntry e = it.next();
                    boolean needVal = false;
                    try {
                        List<ClusterNode> owners;
                        e.unswap(false);
                        needVal = e.isNewLocked();
                        if (needVal && (owners = this.cctx.topology().owners(e.partition(), this.tx != null ? this.tx.topologyVersion() : this.cctx.affinity().affinityTopologyVersion())).contains(this.cctx.localNode())) {
                            needVal = false;
                        }
                        if (this.tx != null && !needVal) continue;
                        boolean invalidateRdr = e.readerId(n.id()) != null;
                        req.addDhtKey(e.key(), invalidateRdr, this.cctx);
                        if (needVal) {
                            IgniteTxEntry txEntry;
                            req.markLastKeyForPreload();
                            if (this.tx != null && (txEntry = this.tx.entry(e.txKey())).op() == GridCacheOperation.READ) {
                                txEntry.op(GridCacheOperation.NOOP);
                            }
                        }
                        GridCacheMvccCandidate added = e.candidate(this.lockVer);
                        assert (added != null);
                        assert (added.dhtLocal());
                        if (added.ownerVersion() == null) continue;
                        req.owned(e.key(), added.ownerVersion());
                    }
                    catch (GridCacheEntryRemovedException ex) {
                        assert (false) : "Entry cannot become obsolete when DHT local candidate is added [e=" + e + ", ex=" + ex + ']';
                    }
                }
                if (F.isEmpty(req.keys())) continue;
                if (this.tx != null) {
                    this.tx.addLockTransactionNode(n);
                }
                this.add(fut);
                this.cctx.io().send(n, (GridCacheMessage)req, this.cctx.ioPolicy());
                if (!msgLog.isDebugEnabled()) continue;
                msgLog.debug("DHT lock fut, sent request [txId=" + this.nearLockVer + ", dhtTxId=" + this.lockVer + ", inTx=" + this.inTx() + ", nodeId=" + n.id() + ']');
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    fut.onResult();
                    continue;
                }
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT lock fut, failed to send request [txId=" + this.nearLockVer + ", dhtTxId=" + this.lockVer + ", inTx=" + this.inTx() + ", node=" + n.id() + ", err=" + e + ']');
                }
                fut.onResult(e);
            }
            continue;
            break;
        }
    }

    public int hashCode() {
        return this.futId.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        HashSet<KeyCacheObject> locks;
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f2) {
                MiniFuture m = (MiniFuture)f2;
                return "[node=" + m.node().id() + ", loc=" + m.node().isLocal() + ", done=" + f2.isDone() + "]";
            }
        }, new IgnitePredicate[0]);
        GridDhtLockFuture gridDhtLockFuture = this;
        synchronized (gridDhtLockFuture) {
            locks = new HashSet<KeyCacheObject>(this.pendingLocks);
        }
        return S.toString(GridDhtLockFuture.class, this, "innerFuts", futs, "pendingLocks", locks, "super", super.toString());
    }

    private void loadMissingFromStore() {
        if (!this.skipStore && (this.read || this.cctx.loadPreviousValue()) && this.cctx.readThrough() && (this.needReturnVal || this.read)) {
            final LinkedHashMap<KeyCacheObject, GridDhtCacheEntry> loadMap = new LinkedHashMap<KeyCacheObject, GridDhtCacheEntry>();
            final GridCacheVersion ver = this.version();
            for (GridDhtCacheEntry entry2 : this.entries) {
                try {
                    entry2.unswap(false);
                    if (entry2.hasValue()) continue;
                    loadMap.put(entry2.key(), entry2);
                }
                catch (GridCacheEntryRemovedException e) {
                    assert (false) : "Should not get removed exception while holding lock on entry [entry=" + entry2 + ", e=" + e + ']';
                }
                catch (IgniteCheckedException e) {
                    this.onDone(e);
                    return;
                }
            }
            try {
                this.cctx.store().loadAll(null, loadMap.keySet(), (IgniteBiInClosure<KeyCacheObject, Object>)new CI2<KeyCacheObject, Object>(){

                    @Override
                    public void apply(KeyCacheObject key, Object val) {
                        if (val == null) {
                            return;
                        }
                        GridDhtCacheEntry entry0 = (GridDhtCacheEntry)loadMap.get(key);
                        try {
                            long expireTime;
                            CacheObject val0 = GridDhtLockFuture.this.cctx.toCacheObject(val);
                            long ttl = GridDhtLockFuture.this.createTtl;
                            if (ttl == -2L) {
                                expireTime = CU.expireTimeInPast();
                            } else {
                                if (ttl == -1L) {
                                    ttl = 0L;
                                }
                                expireTime = CU.toExpireTime(ttl);
                            }
                            entry0.initialValue(val0, ver, ttl, expireTime, false, GridDhtLockFuture.this.topVer, GridDrType.DR_LOAD, true);
                        }
                        catch (GridCacheEntryRemovedException e) {
                            assert (false) : "Should not get removed exception while holding lock on entry [entry=" + entry0 + ", e=" + e + ']';
                        }
                        catch (IgniteCheckedException e) {
                            GridDhtLockFuture.this.onDone(e);
                        }
                    }
                });
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
            }
        }
    }

    private class MiniFuture
    extends GridFutureAdapter<Boolean> {
        private final IgniteUuid futId = IgniteUuid.randomUuid();
        @GridToStringExclude
        private ClusterNode node;
        @GridToStringInclude
        private List<GridDhtCacheEntry> dhtMapping;

        MiniFuture(ClusterNode node, List<GridDhtCacheEntry> dhtMapping) {
            assert (node != null);
            this.node = node;
            this.dhtMapping = dhtMapping;
        }

        IgniteUuid futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.node;
        }

        void onResult(Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get future result [fut=" + this + ", err=" + e + ']');
            }
            this.onDone(e);
        }

        void onResult() {
            if (msgLog.isDebugEnabled()) {
                msgLog.debug("DHT lock fut, mini future node left [txId=" + GridDhtLockFuture.this.nearLockVer + ", dhtTxId=" + GridDhtLockFuture.this.lockVer + ", inTx=" + GridDhtLockFuture.this.inTx() + ", node=" + this.node.id() + ']');
            }
            if (GridDhtLockFuture.this.tx != null) {
                GridDhtLockFuture.this.tx.removeMapping(this.node.id());
            }
            this.onDone(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onResult(GridDhtLockResponse res) {
            if (res.error() != null) {
                GridDhtLockFuture.this.onError(res.error());
            } else {
                Collection<Integer> invalidParts = res.invalidPartitions();
                if (!F.isEmpty(invalidParts)) {
                    Iterator<GridDhtCacheEntry> it = this.dhtMapping.iterator();
                    while (it.hasNext()) {
                        GridDhtCacheEntry entry2 = it.next();
                        if (!invalidParts.contains(entry2.partition())) continue;
                        it.remove();
                        if (log.isDebugEnabled()) {
                            log.debug("Removed mapping for entry [nodeId=" + this.node.id() + ", entry=" + entry2 + ", fut=" + GridDhtLockFuture.this + ']');
                        }
                        if (GridDhtLockFuture.this.tx != null) {
                            GridDhtLockFuture.this.tx.removeDhtMapping(this.node.id(), entry2);
                            continue;
                        }
                        entry2.removeMapping(GridDhtLockFuture.this.lockVer, this.node);
                    }
                    if (this.dhtMapping.isEmpty()) {
                        GridDhtLockFuture.this.dhtMap.remove(this.node);
                    }
                }
                boolean replicate = GridDhtLockFuture.this.cctx.isDrEnabled();
                boolean rec = GridDhtLockFuture.this.cctx.events().isRecordable(84);
                GridCacheAdapter cache0 = GridDhtLockFuture.this.cctx.cache();
                if (cache0.isNear()) {
                    cache0 = ((GridNearCacheAdapter)cache0).dht();
                }
                GridDhtLockFuture gridDhtLockFuture = GridDhtLockFuture.this;
                synchronized (gridDhtLockFuture) {
                    if (GridDhtLockFuture.this.checkDone()) {
                        return;
                    }
                    for (GridCacheEntryInfo info2 : res.preloadEntries()) {
                        try {
                            GridCacheEntryEx entry3 = cache0.entryEx(info2.key(), GridDhtLockFuture.this.topVer);
                            GridDhtLockFuture.this.cctx.shared().database().checkpointReadLock();
                            try {
                                if (!entry3.initialValue(info2.value(), info2.version(), GridDhtLockFuture.this.cctx.mvccEnabled() ? ((MvccVersionAware)((Object)info2)).mvccVersion() : null, GridDhtLockFuture.this.cctx.mvccEnabled() ? ((MvccUpdateVersionAware)((Object)info2)).newMvccVersion() : null, GridDhtLockFuture.this.cctx.mvccEnabled() ? ((MvccVersionAware)((Object)entry3)).mvccTxState() : (byte)0, GridDhtLockFuture.this.cctx.mvccEnabled() ? ((MvccUpdateVersionAware)((Object)entry3)).newMvccTxState() : (byte)0, info2.ttl(), info2.expireTime(), true, GridDhtLockFuture.this.topVer, replicate ? GridDrType.DR_PRELOAD : GridDrType.DR_NONE, false) || !rec || entry3.isInternal()) continue;
                                GridDhtLockFuture.this.cctx.events().addEvent(entry3.partition(), entry3.key(), GridDhtLockFuture.this.cctx.localNodeId(), (IgniteUuid)null, null, 84, info2.value(), true, null, false, null, null, null, false);
                            }
                            finally {
                                GridDhtLockFuture.this.cctx.shared().database().checkpointReadUnlock();
                            }
                        }
                        catch (IgniteCheckedException e) {
                            this.onDone(e);
                            return;
                        }
                        catch (GridCacheEntryRemovedException e) {
                            assert (false) : "Entry cannot become obsolete when DHT local candidate is added [e=" + e + ", ex=" + e + ']';
                        }
                    }
                }
                this.onDone(true);
            }
        }

        private void evictReaders(GridCacheContext<?, ?> cacheCtx, Collection<IgniteTxKey> keys, UUID nodeId, long msgId, @Nullable List<GridDhtCacheEntry> entries) {
            if (entries == null || keys == null || entries.isEmpty() || keys.isEmpty()) {
                return;
            }
            ListIterator<GridDhtCacheEntry> it = entries.listIterator();
            block2: while (it.hasNext()) {
                GridDhtCacheEntry cached = it.next();
                if (!keys.contains(cached.txKey())) continue;
                while (true) {
                    try {
                        cached.removeReader(nodeId, msgId);
                        if (GridDhtLockFuture.this.tx == null) continue block2;
                        GridDhtLockFuture.this.tx.removeNearMapping(nodeId, cached);
                        continue block2;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        GridDhtCacheEntry e = cacheCtx.dht().peekExx(cached.key());
                        if (e == null) continue block2;
                        it.set(e);
                        continue;
                    }
                    break;
                }
            }
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "nodeId", this.node.id(), "super", super.toString());
        }
    }

    private class LockTimeoutObject
    extends GridTimeoutObjectAdapter {
        LockTimeoutObject() {
            super(GridDhtLockFuture.this.timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTimeout() {
            if (log.isDebugEnabled()) {
                log.debug("Timed out waiting for lock response: " + this);
            }
            GridDhtLockFuture gridDhtLockFuture = GridDhtLockFuture.this;
            synchronized (gridDhtLockFuture) {
                GridDhtLockFuture.this.timedOut = true;
                GridDhtLockFuture.this.pendingLocks.clear();
                GridDhtLockFuture.this.clear();
            }
            boolean releaseLocks = !GridDhtLockFuture.this.inTx() || !GridDhtLockFuture.this.cctx.tm().deadlockDetectionEnabled();
            GridDhtLockFuture.this.onComplete(false, false, releaseLocks);
        }

        public String toString() {
            return S.toString(LockTimeoutObject.class, this);
        }
    }
}

