/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.DhtLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxAbstractEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxAbstractEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxSelectForUpdateFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.lang.IgniteInClosure;

public class CompoundLockFuture
extends GridFutureAdapter<Void>
implements DhtLockFuture<Void>,
IgniteInClosure<IgniteInternalFuture<?>> {
    private static final long serialVersionUID = 4644646033267042131L;
    private static final AtomicIntegerFieldUpdater<CompoundLockFuture> CNT_UPD = AtomicIntegerFieldUpdater.newUpdater(CompoundLockFuture.class, "cnt");
    private volatile int cnt;
    private final GridDhtTxLocalAdapter tx;

    public CompoundLockFuture(int cnt, GridDhtTxLocalAdapter tx) {
        this.cnt = cnt;
        this.tx = tx;
    }

    public void register(IgniteInternalFuture<?> fut) {
        fut.listen(this);
    }

    public void init() {
        do {
            IgniteInternalFuture<?> fut;
            if ((fut = this.tx.lockFuture()) == GridDhtTxLocalAdapter.ROLLBACK_FUT) {
                this.onDone(this.tx.timedOut() ? this.tx.timeoutException() : this.tx.rollbackException());
                break;
            }
            if (fut == null) continue;
            assert (fut instanceof GridNearTxAbstractEnlistFuture || fut instanceof GridDhtTxAbstractEnlistFuture || fut instanceof CompoundLockFuture || fut instanceof GridNearTxSelectForUpdateFuture) : fut;
            if (!fut.isDone()) {
                fut.listen(new IgniteInClosure<IgniteInternalFuture>(){

                    @Override
                    public void apply(IgniteInternalFuture fut) {
                        if (fut.error() != null) {
                            CompoundLockFuture.this.onDone(fut.error());
                        }
                    }
                });
                break;
            }
            if (fut.error() == null) break;
            this.onDone(fut.error());
            break;
        } while (!this.tx.updateLockFuture(null, this));
    }

    @Override
    public void apply(IgniteInternalFuture<?> future) {
        if (!(this.isDone() || future.error() == null && CNT_UPD.decrementAndGet(this) != 0)) {
            Throwable err2 = future.error();
            if (err2 == null) {
                this.tx.clearLockFuture(this);
            }
            this.onDone(err2);
        }
    }

    @Override
    public void onError(Throwable error2) {
        assert (error2 != null);
        this.onDone(error2);
    }
}

