/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridDistributedTxMapping {
    private static final AtomicReferenceFieldUpdater<GridDistributedTxMapping, Set> BACKUPS_FIELD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(GridDistributedTxMapping.class, Set.class, "backups");
    @GridToStringExclude
    private ClusterNode primary;
    private volatile Set<UUID> backups;
    @GridToStringInclude
    private final Collection<IgniteTxEntry> entries;
    private boolean explicitLock;
    private boolean queryUpdate;
    private GridCacheVersion dhtVer;
    private boolean last;
    private int nearEntries;
    private boolean clientFirst;

    public GridDistributedTxMapping(ClusterNode primary) {
        this.primary = primary;
        this.entries = new LinkedHashSet<IgniteTxEntry>();
    }

    public boolean last() {
        return this.last;
    }

    public void last(boolean last2) {
        this.last = last2;
    }

    public boolean clientFirst() {
        return this.clientFirst;
    }

    public void clientFirst(boolean clientFirst) {
        this.clientFirst = clientFirst;
    }

    public boolean hasColocatedCacheEntries() {
        return this.entries.size() > this.nearEntries;
    }

    public boolean hasNearCacheEntries() {
        return this.nearEntries > 0;
    }

    public ClusterNode primary() {
        return this.primary;
    }

    public Collection<IgniteTxEntry> entries() {
        return this.entries;
    }

    @Nullable
    public Collection<IgniteTxEntry> nearCacheEntries() {
        assert (this.nearEntries > 0);
        return F.view(this.entries, CU.FILTER_NEAR_CACHE_ENTRY);
    }

    public boolean queryUpdate() {
        return this.queryUpdate;
    }

    public void markQueryUpdate() {
        this.queryUpdate = true;
    }

    public boolean explicitLock() {
        return this.explicitLock;
    }

    public void markExplicitLock() {
        this.explicitLock = true;
    }

    public GridCacheVersion dhtVersion() {
        return this.dhtVer;
    }

    public void dhtVersion(GridCacheVersion dhtVer, GridCacheVersion writeVer) {
        this.dhtVer = dhtVer;
        for (IgniteTxEntry e : this.entries) {
            e.dhtVersion(writeVer);
        }
    }

    public Collection<IgniteTxEntry> reads() {
        return F.view(this.entries, CU.READ_FILTER);
    }

    public Collection<IgniteTxEntry> writes() {
        return F.view(this.entries, CU.WRITE_FILTER);
    }

    public Collection<IgniteTxEntry> nearEntriesReads() {
        assert (this.hasNearCacheEntries());
        return F.view(this.entries, CU.READ_FILTER_NEAR);
    }

    public Collection<IgniteTxEntry> nearEntriesWrites() {
        assert (this.hasNearCacheEntries());
        return F.view(this.entries, CU.WRITE_FILTER_NEAR);
    }

    public Collection<IgniteTxEntry> colocatedEntriesReads() {
        assert (this.hasColocatedCacheEntries());
        return F.view(this.entries, CU.READ_FILTER_COLOCATED);
    }

    public Collection<IgniteTxEntry> colocatedEntriesWrites() {
        assert (this.hasColocatedCacheEntries());
        return F.view(this.entries, CU.WRITE_FILTER_COLOCATED);
    }

    public void add(IgniteTxEntry entry2) {
        if (this.entries.add(entry2) && entry2.context().isNear()) {
            ++this.nearEntries;
        }
    }

    public boolean removeEntry(IgniteTxEntry entry2) {
        return this.entries.remove(entry2);
    }

    public void evictReaders(@Nullable Collection<IgniteTxKey> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        this.evictReaders(keys, this.entries);
    }

    private void evictReaders(Collection<IgniteTxKey> keys, @Nullable Collection<IgniteTxEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        Iterator<IgniteTxEntry> it = entries.iterator();
        while (it.hasNext()) {
            IgniteTxEntry entry2 = it.next();
            if (!keys.contains(entry2.txKey())) continue;
            it.remove();
        }
    }

    public boolean empty() {
        return this.entries.isEmpty();
    }

    public void addBackups(Collection<UUID> newBackups) {
        if (newBackups == null) {
            return;
        }
        if (this.backups == null) {
            BACKUPS_FIELD_UPDATER.compareAndSet(this, null, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.backups.addAll(newBackups);
    }

    public Set<UUID> backups() {
        return this.backups != null ? this.backups : Collections.emptySet();
    }

    public String toString() {
        return S.toString(GridDistributedTxMapping.class, this, "node", this.primary.id());
    }
}

