/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundIdentityFuture;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheTxRecoveryRequest;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheTxRecoveryResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class GridCacheTxRecoveryFuture
extends GridCacheCompoundIdentityFuture<Boolean> {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private static IgniteLogger msgLog;
    private boolean trackable = true;
    private final GridCacheSharedContext<?, ?> cctx;
    private final IgniteUuid futId = IgniteUuid.randomUuid();
    private final IgniteInternalTx tx;
    private final Map<UUID, ClusterNode> nodes;
    @GridToStringInclude
    private final Set<UUID> failedNodeIds;
    private final Map<UUID, Collection<UUID>> txNodes;
    private final boolean nearTxCheck;

    public GridCacheTxRecoveryFuture(GridCacheSharedContext<?, ?> cctx, IgniteInternalTx tx, Set<UUID> failedNodeIds, Map<UUID, Collection<UUID>> txNodes) {
        super(CU.boolReducer());
        this.cctx = cctx;
        this.tx = tx;
        this.txNodes = txNodes;
        this.failedNodeIds = failedNodeIds;
        if (log == null) {
            msgLog = cctx.txRecoveryMessageLogger();
            log = U.logger(cctx.kernalContext(), logRef, GridCacheTxRecoveryFuture.class);
        }
        this.nodes = new GridLeanMap<UUID, ClusterNode>();
        UUID locNodeId = cctx.localNodeId();
        for (Map.Entry<UUID, Collection<UUID>> e : tx.transactionNodes().entrySet()) {
            if (!(locNodeId.equals(e.getKey()) || failedNodeIds.contains(e.getKey()) || this.nodes.containsKey(e.getKey()))) {
                ClusterNode node = cctx.discovery().node(e.getKey());
                if (node != null) {
                    this.nodes.put(node.id(), node);
                } else if (log.isInfoEnabled()) {
                    log.info("Transaction node left (will ignore) " + e.getKey());
                }
            }
            for (UUID nodeId : e.getValue()) {
                if (locNodeId.equals(nodeId) || failedNodeIds.contains(nodeId) || this.nodes.containsKey(nodeId)) continue;
                ClusterNode node = cctx.discovery().node(nodeId);
                if (node != null) {
                    this.nodes.put(node.id(), node);
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info("Transaction node left (will ignore) " + e.getKey());
            }
        }
        UUID nearNodeId = tx.eventNodeId();
        this.nearTxCheck = !failedNodeIds.contains(nearNodeId) && cctx.discovery().alive(nearNodeId);
    }

    public void prepare() {
        if (this.nearTxCheck) {
            UUID nearNodeId = this.tx.eventNodeId();
            if (this.cctx.localNodeId().equals(nearNodeId)) {
                IgniteInternalFuture<Boolean> fut = this.cctx.tm().txCommitted(this.tx.nearXidVersion());
                fut.listen((IgniteInClosure<IgniteInternalFuture<Boolean>>)new CI1<IgniteInternalFuture<Boolean>>(){

                    @Override
                    public void apply(IgniteInternalFuture<Boolean> fut) {
                        try {
                            GridCacheTxRecoveryFuture.this.onDone(fut.get());
                        }
                        catch (IgniteCheckedException e) {
                            GridCacheTxRecoveryFuture.this.onDone(e);
                        }
                    }
                });
            } else {
                MiniFuture fut = new MiniFuture(this.tx.eventNodeId());
                this.add(fut);
                GridCacheTxRecoveryRequest req = new GridCacheTxRecoveryRequest(this.tx, 0, true, this.futureId(), fut.futureId(), this.tx.activeCachesDeploymentEnabled());
                try {
                    this.cctx.io().send(nearNodeId, (GridCacheMessage)req, this.tx.ioPolicy());
                    if (msgLog.isInfoEnabled()) {
                        msgLog.info("Recovery fut, sent request near tx [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nearNodeId + ']');
                    }
                }
                catch (ClusterTopologyCheckedException ignore) {
                    fut.onNodeLeft(nearNodeId);
                }
                catch (IgniteCheckedException e) {
                    if (msgLog.isInfoEnabled()) {
                        msgLog.info("Recovery fut, failed to send request near tx [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nearNodeId + ", err=" + e + ']');
                    }
                    fut.onError(e);
                }
                this.markInitialized();
            }
            return;
        }
        int locTxNum = this.nodeTransactions(this.cctx.localNodeId());
        if (locTxNum > 1) {
            IgniteInternalFuture<Boolean> fut = this.cctx.tm().txsPreparedOrCommitted(this.tx.nearXidVersion(), locTxNum);
            if (fut == null || fut.isDone()) {
                boolean prepared;
                try {
                    prepared = fut == null ? true : fut.get();
                }
                catch (IgniteCheckedException e) {
                    U.error(log, "Check prepared transaction future failed: " + e, e);
                    prepared = false;
                }
                if (!prepared) {
                    this.onDone(false);
                    this.markInitialized();
                    return;
                }
            } else {
                fut.listen((IgniteInClosure<IgniteInternalFuture<Boolean>>)new CI1<IgniteInternalFuture<Boolean>>(){

                    @Override
                    public void apply(IgniteInternalFuture<Boolean> fut) {
                        boolean prepared;
                        try {
                            prepared = fut.get();
                        }
                        catch (IgniteCheckedException e) {
                            U.error(log, "Check prepared transaction future failed: " + e, e);
                            prepared = false;
                        }
                        if (!prepared) {
                            GridCacheTxRecoveryFuture.this.onDone(false);
                            GridCacheTxRecoveryFuture.this.markInitialized();
                        } else {
                            GridCacheTxRecoveryFuture.this.proceedPrepare();
                        }
                    }
                });
                return;
            }
        }
        this.proceedPrepare();
    }

    private void proceedPrepare() {
        block6: for (Map.Entry<UUID, Collection<UUID>> entry2 : this.txNodes.entrySet()) {
            UUID nodeId = entry2.getKey();
            if (!this.nodes.containsKey(nodeId) && nodeId.equals(this.cctx.localNodeId())) continue;
            if (this.failedNodeIds.contains(nodeId)) {
                for (UUID id : entry2.getValue()) {
                    if (this.txNodes.containsKey(id) || id.equals(this.cctx.localNodeId())) continue;
                    MiniFuture fut = new MiniFuture(id);
                    this.add(fut);
                    GridCacheTxRecoveryRequest req = new GridCacheTxRecoveryRequest(this.tx, this.nodeTransactions(id), false, this.futureId(), fut.futureId(), this.tx.activeCachesDeploymentEnabled());
                    try {
                        this.cctx.io().send(id, (GridCacheMessage)req, this.tx.ioPolicy());
                        if (!msgLog.isInfoEnabled()) continue;
                        msgLog.info("Recovery fut, sent request to backup [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + id + ']');
                    }
                    catch (ClusterTopologyCheckedException ignored) {
                        fut.onNodeLeft(id);
                    }
                    catch (IgniteCheckedException e) {
                        if (msgLog.isInfoEnabled()) {
                            msgLog.info("Recovery fut, failed to send request to backup [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + id + ", err=" + e + ']');
                        }
                        fut.onError(e);
                        continue block6;
                    }
                }
                continue;
            }
            MiniFuture fut = new MiniFuture(nodeId);
            this.add(fut);
            GridCacheTxRecoveryRequest req = new GridCacheTxRecoveryRequest(this.tx, this.nodeTransactions(nodeId), false, this.futureId(), fut.futureId(), this.tx.activeCachesDeploymentEnabled());
            try {
                this.cctx.io().send(nodeId, (GridCacheMessage)req, this.tx.ioPolicy());
                if (!msgLog.isInfoEnabled()) continue;
                msgLog.info("Recovery fut, sent request to primary [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nodeId + ']');
            }
            catch (ClusterTopologyCheckedException ignored) {
                fut.onNodeLeft(nodeId);
            }
            catch (IgniteCheckedException e) {
                if (msgLog.isInfoEnabled()) {
                    msgLog.info("Recovery fut, failed to send request to primary [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nodeId + ", err=" + e + ']');
                }
                fut.onError(e);
                break;
            }
        }
        this.markInitialized();
    }

    private int nodeTransactions(UUID nodeId) {
        int cnt = this.txNodes.containsKey(nodeId) ? 1 : 0;
        block0: for (Collection<UUID> backups : this.txNodes.values()) {
            for (UUID backup : backups) {
                if (!backup.equals(nodeId)) continue;
                ++cnt;
                continue block0;
            }
        }
        return cnt;
    }

    public void onResult(UUID nodeId, GridCacheTxRecoveryResponse res) {
        if (!this.isDone()) {
            MiniFuture mini = this.miniFuture(res.miniId());
            if (mini != null) {
                assert (mini.nodeId().equals(nodeId));
                mini.onResult(res);
            } else if (msgLog.isInfoEnabled()) {
                msgLog.info("Tx recovery fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
        } else if (msgLog.isInfoEnabled()) {
            msgLog.info("Tx recovery fut, response for finished future [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MiniFuture miniFuture(IgniteUuid miniId) {
        GridCacheTxRecoveryFuture gridCacheTxRecoveryFuture = this;
        synchronized (gridCacheTxRecoveryFuture) {
            int size2 = this.futuresCountNoLock();
            for (int i = 0; i < size2; ++i) {
                MiniFuture mini;
                IgniteInternalFuture fut = this.future(i);
                if (!this.isMini(fut) || !(mini = (MiniFuture)fut).futureId().equals(miniId)) continue;
                if (!mini.isDone()) {
                    return mini;
                }
                return null;
            }
        }
        return null;
    }

    public IgniteInternalTx tx() {
        return this.tx;
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean onNodeLeft(final UUID nodeId) {
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f2;
            if (!this.isMini(fut) || !(f2 = (MiniFuture)fut).nodeId().equals(nodeId)) continue;
            this.cctx.kernalContext().closure().runLocalSafe(new Runnable(){

                @Override
                public void run() {
                    f2.onNodeLeft(nodeId);
                }
            });
        }
        return true;
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
        this.trackable = false;
    }

    @Override
    public boolean onDone(@Nullable Boolean res, @Nullable Throwable err2) {
        if (super.onDone(res, err2)) {
            this.cctx.mvcc().removeFuture(this.futId);
            if (err2 == null) {
                assert (res != null);
                this.cctx.tm().finishTxOnRecovery(this.tx, res);
            } else if (err2 instanceof ClusterTopologyCheckedException && this.nearTxCheck) {
                if (log.isInfoEnabled()) {
                    log.info("Failed to check transaction on near node, ignoring [err=" + err2 + ", tx=" + this.tx + ']');
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info("Failed to check prepared transactions, invalidating transaction [err=" + err2 + ", tx=" + this.tx + ']');
                }
                this.cctx.tm().salvageTx(this.tx);
            }
        }
        return false;
    }

    private boolean isMini(IgniteInternalFuture<?> f2) {
        return f2.getClass().equals(MiniFuture.class);
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f2) {
                return "[node=" + ((MiniFuture)f2).nodeId + ", done=" + f2.isDone() + "]";
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridCacheTxRecoveryFuture.class, this, "innerFuts", futs, "super", super.toString());
    }

    private class MiniFuture
    extends GridFutureAdapter<Boolean> {
        private final IgniteUuid futId = IgniteUuid.randomUuid();
        private UUID nodeId;

        private MiniFuture(UUID nodeId) {
            this.nodeId = nodeId;
        }

        private UUID nodeId() {
            return this.nodeId;
        }

        private IgniteUuid futureId() {
            return this.futId;
        }

        private void onError(Throwable e) {
            if (log.isInfoEnabled()) {
                log.info("Failed to get future result [fut=" + this + ", err=" + e + ']');
            }
            this.onDone(e);
        }

        private void onNodeLeft(UUID nodeId) {
            if (msgLog.isInfoEnabled()) {
                msgLog.info("Tx recovery fut, mini future node left [txId=" + GridCacheTxRecoveryFuture.this.tx.nearXidVersion() + ", dhtTxId=" + GridCacheTxRecoveryFuture.this.tx.xidVersion() + ", node=" + nodeId + ", nearTxCheck=" + GridCacheTxRecoveryFuture.this.nearTxCheck + ']');
            }
            if (GridCacheTxRecoveryFuture.this.nearTxCheck) {
                if (GridCacheTxRecoveryFuture.this.tx.state() == TransactionState.PREPARED) {
                    HashSet<UUID> failedNodeIds0 = new HashSet<UUID>(GridCacheTxRecoveryFuture.this.failedNodeIds);
                    failedNodeIds0.add(nodeId);
                    GridCacheTxRecoveryFuture.this.cctx.tm().commitIfPrepared(GridCacheTxRecoveryFuture.this.tx, failedNodeIds0);
                }
                this.onDone(new ClusterTopologyCheckedException("Transaction node left grid (will ignore)."));
            } else {
                this.onDone(true);
            }
        }

        private void onResult(GridCacheTxRecoveryResponse res) {
            this.onDone(res.success());
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "done", this.isDone(), "err", this.error());
        }
    }
}

