/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import java.util.UUID;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.binary.MetadataUpdateAcceptedMessage;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public final class MetadataUpdateProposedMessage
implements DiscoveryCustomMessage {
    private static final long serialVersionUID = 0L;
    private final IgniteUuid id = IgniteUuid.randomUuid();
    private final UUID origNodeId;
    private BinaryMetadata metadata;
    private final int typeId;
    private int pendingVer;
    private int acceptedVer;
    private ProposalStatus status = ProposalStatus.SUCCESSFUL;
    private BinaryObjectException err;

    public MetadataUpdateProposedMessage(BinaryMetadata metadata, UUID origNodeId) {
        assert (origNodeId != null);
        assert (metadata != null);
        this.origNodeId = origNodeId;
        this.metadata = metadata;
        this.typeId = metadata.typeId();
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    @Override
    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        return this.status == ProposalStatus.SUCCESSFUL ? new MetadataUpdateAcceptedMessage(this.typeId, this.pendingVer) : null;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean stopProcess() {
        return false;
    }

    @Override
    @Nullable
    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        throw new UnsupportedOperationException();
    }

    void markRejected(BinaryObjectException err2) {
        this.status = ProposalStatus.REJECTED;
        this.err = err2;
    }

    boolean rejected() {
        return this.status == ProposalStatus.REJECTED;
    }

    BinaryObjectException rejectionError() {
        return this.err;
    }

    int pendingVersion() {
        return this.pendingVer;
    }

    void pendingVersion(int pendingVer) {
        this.pendingVer = pendingVer;
    }

    int acceptedVersion() {
        return this.acceptedVer;
    }

    void acceptedVersion(int acceptedVer) {
        this.acceptedVer = acceptedVer;
    }

    UUID origNodeId() {
        return this.origNodeId;
    }

    public BinaryMetadata metadata() {
        return this.metadata;
    }

    public void metadata(BinaryMetadata metadata) {
        this.metadata = metadata;
    }

    public int typeId() {
        return this.typeId;
    }

    public String toString() {
        return S.toString(MetadataUpdateProposedMessage.class, this);
    }

    private static enum ProposalStatus {
        SUCCESSFUL,
        REJECTED;

    }
}

