/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class MetadataResponseMessage
implements Message {
    private static final long serialVersionUID = 0L;
    private int typeId;
    private byte[] binaryMetadataBytes;
    private ClientResponseStatus status;

    public MetadataResponseMessage() {
    }

    MetadataResponseMessage(int typeId) {
        this.typeId = typeId;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("binaryMetadataBytes", this.binaryMetadataBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByte("status", this.status != null ? (byte)this.status.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeInt("typeId", this.typeId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.binaryMetadataBytes = reader.readByteArray("binaryMetadataBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                byte statusOrd = reader.readByte("status");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.status = ClientResponseStatus.fromOrdinal(statusOrd);
                reader.incrementState();
            }
            case 2: {
                this.typeId = reader.readInt("typeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(MetadataResponseMessage.class);
    }

    @Override
    public short directType() {
        return 81;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    @Override
    public void onAckReceived() {
    }

    void binaryMetadataBytes(byte[] bytes2) {
        this.status = bytes2 != null ? ClientResponseStatus.METADATA_FOUND : ClientResponseStatus.METADATA_NOT_FOUND;
        this.binaryMetadataBytes = bytes2;
    }

    void markErrorOnRequest() {
        this.status = ClientResponseStatus.ERROR;
    }

    int typeId() {
        return this.typeId;
    }

    byte[] binaryMetadataBytes() {
        return this.binaryMetadataBytes;
    }

    boolean metadataNotFound() {
        return this.status == ClientResponseStatus.METADATA_NOT_FOUND;
    }

    public String toString() {
        return S.toString(MetadataResponseMessage.class, this);
    }

    private static enum ClientResponseStatus {
        METADATA_FOUND,
        METADATA_NOT_FOUND,
        ERROR;

        private static final ClientResponseStatus[] VALS;

        public static ClientResponseStatus fromOrdinal(byte ord) {
            return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
        }

        static {
            VALS = ClientResponseStatus.values();
        }
    }
}

