/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.affinity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Map;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheGateway;
import org.jetbrains.annotations.Nullable;

public class GridCacheAffinityProxy<K, V>
implements Affinity<K>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private GridCacheGateway<K, V> gate;
    private Affinity<K> delegate;
    private GridCacheContext<K, V> cctx;

    public GridCacheAffinityProxy() {
    }

    public GridCacheAffinityProxy(GridCacheContext<K, V> cctx, Affinity<K> delegate) {
        this.gate = cctx.gate();
        this.delegate = delegate;
        this.cctx = cctx;
    }

    @Override
    public int partitions() {
        CacheOperationContext old = this.gate.enter(null);
        try {
            int n = this.delegate.partitions();
            return n;
        }
        finally {
            this.gate.leave(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int partition(K key) {
        CacheOperationContext old = this.gate.enter(null);
        try {
            int n = this.delegate.partition(key);
            return n;
        }
        finally {
            this.gate.leave(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPrimary(ClusterNode n, K key) {
        CacheOperationContext old = this.gate.enter(null);
        try {
            boolean bl = this.delegate.isPrimary(n, key);
            return bl;
        }
        finally {
            this.gate.leave(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBackup(ClusterNode n, K key) {
        CacheOperationContext old = this.gate.enter(null);
        try {
            boolean bl = this.delegate.isBackup(n, key);
            return bl;
        }
        finally {
            this.gate.leave(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPrimaryOrBackup(ClusterNode n, K key) {
        CacheOperationContext old = this.gate.enter(null);
        try {
            boolean bl = this.delegate.isPrimaryOrBackup(n, key);
            return bl;
        }
        finally {
            this.gate.leave(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] primaryPartitions(ClusterNode n) {
        CacheOperationContext old = this.gate.enter(null);
        try {
            int[] nArray = this.delegate.primaryPartitions(n);
            return nArray;
        }
        finally {
            this.gate.leave(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] backupPartitions(ClusterNode n) {
        CacheOperationContext old = this.gate.enter(null);
        try {
            int[] nArray = this.delegate.backupPartitions(n);
            return nArray;
        }
        finally {
            this.gate.leave(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] allPartitions(ClusterNode n) {
        CacheOperationContext old = this.gate.enter(null);
        try {
            int[] nArray = this.delegate.allPartitions(n);
            return nArray;
        }
        finally {
            this.gate.leave(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterNode mapPartitionToNode(int part) {
        CacheOperationContext old = this.gate.enter(null);
        try {
            ClusterNode clusterNode = this.delegate.mapPartitionToNode(part);
            return clusterNode;
        }
        finally {
            this.gate.leave(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, ClusterNode> mapPartitionsToNodes(Collection<Integer> parts) {
        CacheOperationContext old = this.gate.enter(null);
        try {
            Map<Integer, ClusterNode> map2 = this.delegate.mapPartitionsToNodes(parts);
            return map2;
        }
        finally {
            this.gate.leave(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object affinityKey(K key) {
        CacheOperationContext old = this.gate.enter(null);
        try {
            Object object = this.delegate.affinityKey(key);
            return object;
        }
        finally {
            this.gate.leave(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ClusterNode mapKeyToNode(K key) {
        CacheOperationContext old = this.gate.enter(null);
        try {
            ClusterNode clusterNode = this.delegate.mapKeyToNode(key);
            return clusterNode;
        }
        finally {
            this.gate.leave(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ClusterNode, Collection<K>> mapKeysToNodes(@Nullable Collection<? extends K> keys) {
        CacheOperationContext old = this.gate.enter(null);
        try {
            Map<ClusterNode, Collection<K>> map2 = this.delegate.mapKeysToNodes(keys);
            return map2;
        }
        finally {
            this.gate.leave(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ClusterNode> mapKeyToPrimaryAndBackups(K key) {
        CacheOperationContext old = this.gate.enter(null);
        try {
            Collection<ClusterNode> collection = this.delegate.mapKeyToPrimaryAndBackups(key);
            return collection;
        }
        finally {
            this.gate.leave(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ClusterNode> mapPartitionToPrimaryAndBackups(int part) {
        CacheOperationContext old = this.gate.enter(null);
        try {
            Collection<ClusterNode> collection = this.delegate.mapPartitionToPrimaryAndBackups(part);
            return collection;
        }
        finally {
            this.gate.leave(old);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cctx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cctx = (GridCacheContext)in.readObject();
    }

    private Object readResolve() throws ObjectStreamException {
        return this.cctx.grid().affinity(this.cctx.cache().name());
    }
}

