/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.affinity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridCacheAffinityImpl<K, V>
implements Affinity<K> {
    public static final String FAILED_TO_FIND_CACHE_ERR_MSG = "Failed to find cache (cache was not started yet or cache was already stopped): ";
    private GridCacheContext<K, V> cctx;
    private IgniteLogger log;

    public GridCacheAffinityImpl(GridCacheContext<K, V> cctx) {
        this.cctx = cctx;
        this.log = cctx.logger(this.getClass());
    }

    @Override
    public int partitions() {
        return this.cctx.group().affinityFunction().partitions();
    }

    @Override
    public int partition(K key) {
        A.notNull(key, "key");
        return this.cctx.affinity().partition(key);
    }

    @Override
    public boolean isPrimary(ClusterNode n, K key) {
        A.notNull(n, "n", key, "key");
        return this.cctx.affinity().primaryByKey(n, key, this.topologyVersion());
    }

    @Override
    public boolean isBackup(ClusterNode n, K key) {
        A.notNull(n, "n", key, "key");
        return this.cctx.affinity().backupsByKey(key, this.topologyVersion()).contains(n);
    }

    @Override
    public boolean isPrimaryOrBackup(ClusterNode n, K key) {
        A.notNull(n, "n", key, "key");
        return this.cctx.affinity().partitionBelongs(n, this.cctx.affinity().partition(key), this.topologyVersion());
    }

    @Override
    public int[] primaryPartitions(ClusterNode n) {
        A.notNull(n, "n");
        Set<Integer> parts = this.cctx.affinity().primaryPartitions(n.id(), this.topologyVersion());
        return U.toIntArray(parts);
    }

    @Override
    public int[] backupPartitions(ClusterNode n) {
        A.notNull(n, "n");
        Set<Integer> parts = this.cctx.affinity().backupPartitions(n.id(), this.topologyVersion());
        return U.toIntArray(parts);
    }

    @Override
    public int[] allPartitions(ClusterNode n) {
        A.notNull(n, "p");
        HashSet<Integer> parts = new HashSet<Integer>();
        AffinityTopologyVersion topVer = this.topologyVersion();
        int partsCnt = this.partitions();
        block0: for (int part = 0; part < partsCnt; ++part) {
            for (ClusterNode affNode : this.cctx.affinity().nodesByPartition(part, topVer)) {
                if (!n.id().equals(affNode.id())) continue;
                parts.add(part);
                continue block0;
            }
        }
        return U.toIntArray(parts);
    }

    @Override
    public ClusterNode mapPartitionToNode(int part) {
        A.ensure(part >= 0 && part < this.partitions(), "part >= 0 && part < total partitions");
        return F.first(this.cctx.affinity().nodesByPartition(part, this.topologyVersion()));
    }

    @Override
    public Map<Integer, ClusterNode> mapPartitionsToNodes(Collection<Integer> parts) {
        A.notNull(parts, "parts");
        HashMap<Integer, ClusterNode> map2 = new HashMap<Integer, ClusterNode>();
        if (!F.isEmpty(parts)) {
            for (int p : parts) {
                map2.put(p, this.mapPartitionToNode(p));
            }
        }
        return map2;
    }

    @Override
    public Object affinityKey(K key) {
        CacheConfiguration ccfg;
        A.notNull(key, "key");
        if (key instanceof CacheObject && !(key instanceof BinaryObject)) {
            CacheObjectContext ctx = this.cctx.cacheObjectContext();
            if (ctx == null) {
                throw new IgniteException(FAILED_TO_FIND_CACHE_ERR_MSG + this.cctx.name());
            }
            key = ((CacheObject)key).value(ctx, false);
        }
        if ((ccfg = this.cctx.config()) == null) {
            throw new IgniteException(FAILED_TO_FIND_CACHE_ERR_MSG + this.cctx.name());
        }
        return ccfg.getAffinityMapper().affinityKey(key);
    }

    @Override
    @Nullable
    public ClusterNode mapKeyToNode(K key) {
        A.notNull(key, "key");
        return F.first(this.mapKeysToNodes(F.asList(key)).keySet());
    }

    @Override
    public Map<ClusterNode, Collection<K>> mapKeysToNodes(@Nullable Collection<? extends K> keys) {
        A.notNull(keys, "keys");
        AffinityTopologyVersion topVer = this.topologyVersion();
        int nodesCnt = !this.cctx.isLocal() ? this.cctx.discovery().cacheGroupAffinityNodes(this.cctx.groupId(), topVer).size() : 1;
        HashMap<ClusterNode, Collection<ClusterNode>> res = new HashMap<ClusterNode, Collection<ClusterNode>>(nodesCnt, 1.0f);
        for (K key : keys) {
            ClusterNode primary = this.cctx.affinity().primaryByKey(key, topVer);
            if (primary == null) {
                throw new IgniteException("Failed to get primary node [topVer=" + topVer + ", key=" + key + ']');
            }
            ArrayList<K> mapped = (ArrayList<K>)res.get(primary);
            if (mapped == null) {
                mapped = new ArrayList<K>(Math.max(keys.size() / nodesCnt, 16));
                res.put(primary, mapped);
            }
            mapped.add(key);
        }
        return res;
    }

    @Override
    public Collection<ClusterNode> mapKeyToPrimaryAndBackups(K key) {
        A.notNull(key, "key");
        return this.cctx.affinity().nodesByPartition(this.partition(key), this.topologyVersion());
    }

    @Override
    public Collection<ClusterNode> mapPartitionToPrimaryAndBackups(int part) {
        A.ensure(part >= 0 && part < this.partitions(), "part >= 0 && part < total partitions");
        return this.cctx.affinity().nodesByPartition(part, this.topologyVersion());
    }

    private AffinityTopologyVersion topologyVersion() {
        return this.cctx.affinity().affinityTopologyVersion();
    }
}

